'\"
'\" Copyright (c) 1998-2000 by Ajuba Solutions.
'\" All rights reserved.
'\" 
'\" RCS: @(#) $Id: tree.n,v 1.9 2000/05/31 00:00:03 ericm Exp $
'\" 
.so man.macros
.TH tree n 1.0 Struct "Tcl Data Structures"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::struct::tree \- Create and manipulate tree objects
.SH SYNOPSIS
\fBpackage require struct ?1.0?\fR
.sp
\fB::struct::tree\fR \fItreeName\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fB::struct::tree\fR command creates a new tree object with an
associated global Tcl command whose name is \fItreeName\fR.  This command
may be used to invoke various operations on the tree.  It has the
following general form:
.CS
\fItreeName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  
.PP
A tree is a collection of elements, called nodes, one of which is
distinguished as a root, along with a relation ("parenthood") that
places a hierarchical structure on the nodes. (\fIData Structures and
Algorithms\fR; Aho, Hopcroft and Ullman; Addison-Wesley, 1987).  In
addition to maintaining the node relationships, this tree
implementation allows any number of keyed values to be associated with
each node.
.PP
The following commands are possible for tree objects:
.TP
\fItreeName\fR \fBchildren\fR \fInode\fR
Return a list of the children of \fInode\fR.
.TP
\fItreeName\fR \fBcut\fR \fInode\fR
Removes the node specified by \fInode\fR from the tree, but not its
children.  The children of \fInode\fR are made children of the parent of
the \fInode\fR, at the index at which \fInode\fR was located.
.TP
\fItreeName\fR \fBdelete\fR \fInode\fR ?\fInode\fR ...?
Remove the specified nodes from the tree.  All of the nodes' children
will be removed as well to prevent orphaned nodes.
.TP
\fItreeName \fBdepth\fR \fInode\fR
Return the number of steps from node \fInode\fR to the root node.
.TP
\fItreeName \fBdestroy\fR
Destroy the tree, including its storage space and associated command.
.TP
\fItreeName\fR \fBexists\fR \fInode\fR
Remove true if the specified node exists in the tree.
.TP
\fItreeName\fR \fBget\fR \fInode\fR ?\fI-key key\fR?
Return the value associated with the key \fIkey\fR for the node
\fInode\fR.  If no key is specified, the key \fBdata\fR is assumed.
.TP
\fItreeName \fBindex\fR \fInode\fR
Returns the index of \fInode\fR in its parent's list of children.  For
example, if a node has \fBnodeFoo\fR, \fBnodeBar\fR, and \fBnodeBaz\fR as
children, in that order, the index of \fBnodeBar\fR is 1.
.TP
\fItreeName\fR \fBinsert\fR \fIparent\fR \fIindex\fR ?\fIchild\fR ?\fIchild ...\fR??
Insert one or more nodes into the tree as children of the node
\fIparent\fR.  The nodes will be added in the order they are given.
If \fIparent\fR is \fBroot\fR, it refers to the root of the tree.  The
new nodes will be added to the \fIparent\fR node's child list at the
index given by \fIindex\fR.

If any of the specified children already exist in \fItreeName\fR,
those nodes will be moved from their original location to the new
location indicated by this command.

If no \fIchild\fR is specified, a single node will be added, and a
name will be generated for the new node. The generated name is of the
form \fBnode\fR\fIx\fR, where \fIx\fR is a number.

The return result from this command is a list of nodes added.
.TP
\fItreeName \fBisleaf\fR \fInode\fR
Returns true if \fInode\fR is a leaf of the tree (if \fInode\fR has no
children), false otherwise.
.TP
\fItreeName\fR \fBmove\fR \fIparent\fR \fIindex\fR \fInode\fR ?\fInode ...\fR?
Make the specified nodes children of \fIparent\fR, inserting them
into the parent's child list at the index given by \fIindex\fR.
.TP
\fItreeName\fR \fBnext\fR \fInode\fR 
Return the right sibling of \fInode\fR, or the empty string if
\fInode\fR was the last child of its parent.
.TP
\fItreeName\fR \fBnumchildren\fR \fInode\fR
Return the number of immediate children of \fInode\fR.
.TP
\fItreeName\fR \fBparent\fR \fInode\fR
Return the parent of \fInode\fR.
.TP
\fItreeName\fR \fBprevious\fR \fInode\fR 
Return the left sibling of \fInode\fR, or the empty string if
\fInode\fR was the first child of its parent.
.TP
\fItreeName\fR \fBset\fR \fInode\fR ?\fI-key key\fR? ?\fIvalue\fR?
Set or get one of the keyed values associated with a node.  If no key
is specified, the key \fBdata\fR is assumed.  Each node that is added
to a tree has the value "" assigned to the key \fBdata\fR
automatically.  A node may have any number of keyed values associated
with it.  If \fIvalue\fR is not specified, this command returns the
current value assigned to the key; if \fIvalue\fR is specified, this
command assigns that value to the key.
.TP
\fItreeName\fR \fBsize\fR ?\fInode\fR?
Return a count of the number of descendants of the node \fInode\fR; if
no node is specified, \fBroot\fR is assumed.
.TP
\fItreeName\fR \fBsplice\fR \fIparent\fR \fIfrom\fR ?\fIto\fR? ?\fIchild\fR?
Insert a node named \fIchild\fR into the tree as a child of the node
\fIparent\fR. If \fIparent\fR is \fBroot\fR, it refers to the root of
the tree. The new node will be added to the parent node's child list
at the index given by \fIfrom\fR.  The children of \fIparent\fR which
are in the range of the indices \fIfrom\fR and \fIto\fR are made
children of \fIchild\fR.  If the value of \fIto\fR is not specified it
defaults to \fBend\fR.  If no name is given for \fIchild\fR, a name
will be generated for the new node.  The generated name is of the form
\fBnode\fR\fIx\fR, where \fIx\fR is a number.  The return result from
this command is the name of the new node.
.TP
\fItreeName\fR \fBswap\fR \fInode1\fR \fInode2\fR
Swap the position of \fInode1\fR and \fInode2\fR in the tree.
.TP
\fItreeName\fR \fBunset\fR \fInode\fR ?\fI-key key\fR?
Remove a keyed value from the node \fInode\fR.  If no key is
specified, the key \fBdata\fR is assumed.
.TP
\fItreeName\fR \fBwalk\fR \fInode\fR ?\fI-order order\fR? ?\fI-type type\fR? \fI-command cmd\fR

Perform a breadth-first or depth-first walk of the tree starting at
the node \fInode\fR.  The type of walk, breadth-first or depth-first,
is determined by the value of \fItype\fR; \fBbfs\fR indicates
breadth-first, \fBdfs\fR indicates depth-first.  Depth-first is the
default. The order of the walk, pre-, post-, both- or in-order is
determined by the value of \fIorder\fR; \fBpre\fR indicates pre-order,
\fBpost\fR indicates post-order, \fBboth\fR indicates both-order and
\fBin\fR indicates in-order. Pre-order is the default.

Pre-order walking means that a parent node is visited before any of
its children.  For example, a breadth-first search starting from the
root will visit the root, followed by all of the root's children,
followed by all of the root's grandchildren. Post-order walking means
that a parent node is visited after any of its children. Both-order
walking means that a parent node is visited before \fBand\fR after any
of its children. In-order walking means that a parent node is visited
after its first child and before the second. This is a generalization
of in-order walking for binary trees and will do the right thing if a
binary is walked. The combination of a breadth-first walk with
in-order is illegal.

As the walk progresses, the command \fIcmd\fR will be evaluated at
each node.  Percent substitution will be performed on \fIcmd\fR before
evaluation, just as in a \fBbind\fR script.  The following
substitutions are recognized:
.RS
.IP \fB%%\fR
Insert the literal % character.
.IP \fB%t\fR
Name of the tree object.
.IP \fB%n\fR
Name of the current node.
.IP \fB%a\fR
Name of the action occuring; one of \fBenter\fR, \fBleave\fR, or
\fBvisit\fR.  \fBenter\fR actions occur during pre-order walks;
\fBleave\fR actions occur during post-order walks; \fBvisit\fR actions
occur during in-order walks.  In a both-order walk, the command will
be evaluated twice for each node; the action is \fBenter\fR for the
first evaluation, and \fBleave\fR for the second.
.RE

.SH KEYWORDS
tree
