'\"
'\" Copyright (c) 1998-2000 by nobody :-)
'\" All rights not reserved.
'\" 
'\" RCS: @(#) $Id: textutil.n,v 1.2 2000/11/02 19:38:14 ericm Exp $
'\" 
.so man.macros
.TH textutil n 1.0 Textutil "Texts and strings utils"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
::textutil \- Procedures to manipulate texts and strings..
.SH SYNOPSIS
.BS
.sp
\fBtextutil::adjust\fR \fIstring args\fR
.sp
\fBtextutil::splitx\fR \fIstring {regexp [\t \r\n\]+}\fR
.sp
\fBtextutil::tabify\fR \fIstring {num 8}\fR
.sp
\fBtextutil::trim\fR \fIstring {regexp [ \t]+}\fR
.sp
\fBtextutil::trimleft\fR \fIstring {regexp [ \t]+}\fR
.sp
\fBtextutil::trimright\fR \fIstring {regexp [ \t]+}\fR
.sp
\fBtextutil::untabify\fR \fIstring {num 8}\fR
.BE
.SH DESCRIPTION
.PP
The \fB::textutil\fR package provides commands that manipulate
strings or texts (a.k.a. long strings or string with embedded
newlines or paragraphs).

.PP
The complete set of procedures is described below.

.TP
\fBtextutil::adjust\fR \fIstring args\fR
Do a justification on the \fIstring\fP according to \fIargs\fP.
The string is taken as one big paragraphe, ignoring any newlines.
Then the line is formatted according to the options used, and the
command return a new string with enough lines to contain all the
printable chars in the input string. A line is a set of chars
between the beginning of the string and a newline, or between 2
newlines, or between a newline and the end of the string. If the
input string is small enough, the returned string won't contain
any newlines.
.TP
By default, any occurrence of spaces characters or tabulation are
replaced by a single space so each word in a line is separated from
the next one by exactly one space char, and this forms a \fIreal\fR
line. Each \fIreal\fR line is placed in a \fIlogical\fR line, which
have exactly a given length (see \fI-length\fR option below). The
\fIreal\fR line may have a lesser length. Again by default, any trailing
spaces are ignored before returning the string (see \fI-full\fR option
below). The following options may be used after the \fIstring\fP
parameter, and change the way the command place a \fIreal\fR line in
a \fIlogical\fR line. 
.TP
\fI-full boolean\fR
if set to \fIfalse\fR, any trailing space chars are deleted before
returning the string. If set to \fItrue\fR, any trailing space chars are
left in the string. Default to \fIfalse\fR.
.TP
\fI-justify (center|left|plain|right)\fR
set the justification of the returned string to \fIcenter\fR, \fIleft\fR,
\fIplain\fR or \fIright\fR. By default, it is set to \fIleft\fR.
The justification means that any line in the returned string but the last
one is build according to the value. If the justification is set to
\fIplain\fR and the number of printable chars in the last line is less
than 90% of the length of a line (see \fI-length\fR), then this
line is justified with the \fIleft\fR value, avoiding the expansion of
this line when it is too small. The meaning of each value is:
.RS
.TP
\fIcenter\R
the real line is centered in the logical line. If needed, a set of space
char are added at the beginning (half of the needed set) and at the end
(half of the needed set) of the line if required (see \fI-full\fR option).
.TP
\fIleft\fR
the real line is set on the left of the logical line. It means that
there are no space chars at the beginning of this line. If required, all
needed space chars are added at the end of the line (see \fI-full\fR
option).
.TP
\fIplain\fR
the real line is exactly set in the logical line. It means that there
are no leading or trailing space chars. All the needed space chars are
added in the \fIreal\fR line, between 2 (or more) words.
.TP
\fIright\fR
the real line is set on the right of the logical line. It means that
there are no space chars at the end of this line, and there may be some
space chars at the beginning, despite of the \fI-full\fR option.
.RE
.TP
\fI-length integer\fR
set the length of the \fIlogical\fR line in the string to \fIinteger\fR.
\fIinteger\fR must be a positive integer value. Default to \fI72\fR.

.TP
\fBtextutil::splitx\fR \fIstring {regexp [\t \r\n\]+}\fR
Split the \fIstring\fP and return a list. The string is splitted
according to the regular expression \fIregexp\fR instead of a simple
list of chars. Note that if you add parenthesis into the \fIregexp\fR,
the parenthesed part of separator would be added into list as additional
element.

.TP
\fBtextutil::tabify\fR \fIstring {num 8}\fR
Tabify the \fIstring\fP by replacing any substring of \fInum\fP space
chars by a tabulation and return the result as a new string.

.TP
\fBtextutil::trim\fR \fIstring {regexp [ \t]+}\fR
Remove in \fIstring\fP any leading and trailing substring according to
the regular expression \fIregexp\fR and return the result as a new string.
This apply on any \fIline\fR in the string, that is any substring between
2 newline chars, or between the beginning of the string and a newline, or
between a newline and the end of the string, or, if the string contain no
newline, between the beginning and the end of the string.

.TP
\fBtextutil::trimleft\fR \fIstring {regexp [ \t]+}\fR
Remove in \fIstring\fP any leading substring according to the regular
expression \fIregexp\fR and return the result as a new string. This apply
on any \fIline\fR in the string, that is any substring between 2 newline
chars, or between the beginning of the string and a newline, or between a
newline and the end of the string, or, if the string contain no newline,
between the beginning and the end of the string.

.TP
\fBtextutil::trimright\fR \fIstring {regexp [ \t]+}\fR
Remove in \fIstring\fP any trailing substring according to the regular
expression \fIregexp\fR and return the result as a new string. This apply
on any \fIline\fR in the string, that is any substring between 2 newline
chars, or between the beginning of the string and a newline, or between a
newline and the end of the string, or, if the string contain no newline,
between the beginning and the end of the string.

.TP
\fBtextutil::untabify\fR \fIstring {num 8}\fR
Untabify the \fIstring\fP by replacing any tabulation char by a substring
of \fInum\fP space chars and return the result as a new string.

.SH SEE ALSO
regexp, split, string

.SH KEYWORDS
string, regular expression
