[comment {-*- tcl -*- doctools manpage}]
[manpage_begin inifile n 0.1]
[moddesc   {Parsing of Windows INI files}]
[titledesc {Parsing of Windows INI files}]
[require Tcl 8.2]
[require inifile [opt 0.1]]
[description]

This package provides an interface for easy manipulation of Windows INI files.

[para]

[list_begin definitions]

[call [cmd ::ini::open] [arg file] [opt [arg mode]]]

Opens an INI file and returns a handle that is used by other commands.
Mode has the same types as the [const open] command. The default mode is [const r+].

[call [cmd ::ini::close] [arg ini]]

Close the specified handle. If any changes were made and not written by
[const commit] they are lost.

[call [cmd ::ini::commit] [arg ini]]

Writes the file and all changes to disk. The sections are written in
arbitrary order. The keys in a section are written in alphabetical
order.


[call [cmd ::ini::revert] [arg ini]]

Rolls all changes made to the inifile object back to the last
committed state.


[call [cmd ::ini::filename] [arg ini]]

Returns the name of the file the [arg ini] object is associated with.


[call [cmd ::ini::sections] [arg ini]]

Returns a list of all the names of the existing sections in the file handle
specified.

[call [cmd ::ini::keys] [arg ini] [arg section]]

Returns a list of all they key names in the section and file specified.

[call [cmd ::ini::get] [arg ini] [arg section]]

Returns a list of key value pairs that exist in the section and file specified.

[call [cmd ::ini::exists] [arg ini] [arg section] [opt [arg key]]]

Returns a boolean value indicating the existance of the specified section as a
whole or the specified key within that section.

[call [cmd ::ini::value] [arg ini] [arg section] [arg key]]

Returns the value of the named key from the specified section.

[call [cmd ::ini::set] [arg ini] [arg section] [arg key] [arg value]]

Sets the value of the key in the specified section. If the section does not
exist then a new one is created.

[call [cmd ::ini::delete] [arg ini] [arg section] [opt [arg key]]]

Removes the key or the entire section and all its keys.


[call [cmd ::ini::comment] [arg ini] [arg section] [opt [arg key]] [opt [arg text]...]]

Reads and modifies comments for sections and keys.


[list_end]

[manpage_end]
