'\" -*- tcl -*- doctools manpage
'\"
'\" Generated from ../tcllib/modules/mime/smtp.man by mpexpand with fmt.nroff
'\"
.so man.macros
.TH "smtp" n 1.3.2 mime "smtp client"
.BS
.SH NAME
smtp \- Client-side tcl implementation of the smtp protocol
.SH "SYNOPSIS"
package require \fBTcl\fR
.sp
package require \fBmime ?1.3.2?\fR
.sp
package require \fBsmtp ?1.3.2?\fR
.sp
\fB::smtp::sendmessage\fR \fItoken\fR \fIoption\fR...\fR
.sp
.BE
.SH "DESCRIPTION"
.PP
The \fBsmtp\fR library package provides the client side of the
smtp protocol.
.TP
\fB::smtp::sendmessage\fR \fItoken\fR \fIoption\fR...\fR
This command sends the MIME part (see package \fBmime\fR)
represented by \fItoken\fR to an SMTP server. \fIoptions\fR is a list
of options and their associated values.  The recognized options are:
.RS
.TP
\fB-servers\fR
A list of SMTP servers. The default is \fBlocalhost\fR.
.TP
\fB-ports\fR
A list of SMTP ports. The default is \fB25\fR.
.TP
\fB-queue\fR
Indicates that the SMTP server should be asked to queue the message
for later processing. A boolean value.
.TP
\fB-atleastone\fR
Indicates that the SMTP server must find at least one recipient
acceptable for the message to be sent. A boolean value.
.TP
\fB-originator\fR
A string containing an 822-style address specification. If present the
header isn't examined for an originator address.
.TP
\fB-recipients\fR
A string containing one or more 822-style address specifications. If
present the header isn't examined for recipient addresses). If the
string contains more than one address they will be separated by
commas.
.TP
\fB-header\fR
A list of keywords and their values (may occur zero or more times).
.RE
.sp
If the \fB-originator\fR option is not present, the originator
address is taken from \fBFrom\fR (or \fBResent-From\fR);
similarly, if the \fB-recipients\fR option is not present,
recipient addresses are taken from \fBTo\fR, \fBcc\fR, and
\fBBcc\fR (or \fBResent-To\fR, and so on). Note that the header
key/values supplied by the \fB-header\fR option (not those present
in the MIME part) are consulted. Regardless, header key/values are
added to the outgoing message as necessary to ensure that a valid
822-style message is sent.
.sp
The command returns a list indicating which recipients were
unacceptable to the SMTP server. Each element of the list is another
list, containing the address, an SMTP error code, and a textual
diagnostic. Depending on the \fB-atleastone\fR option and the
intended recipients, a non-empty list may still indicate that the
message was accepted by the server.
.SH "SEE ALSO"
mime, pop3, ftp, http
.SH "KEYWORDS"
mail, mail, email, smtp, mime, rfc821, rfc822, internet, net
