[manpage_begin queue n 1.2.1]
[moddesc   {Tcl Data Structures}]
[titledesc {Create and manipulate queue objects}]
[require Tcl 8.2]
[require struct [opt 1.2.1]]
[description]

The [cmd ::struct::queue] command creates a new queue object with an
associated global Tcl command whose name is [emph queueName].  This
command may be used to invoke various operations on the queue.  It has
the following general form:

[list_begin definitions]

[call [arg queueName] [cmd option] [opt [arg "arg arg ..."]]]

[arg Option] and the [arg arg]s determine the exact behavior of the
command.  The following commands are possible for queue objects:


[call [arg queueName] [cmd clear]]

Remove all items from the queue.


[call [arg queueName] [cmd destroy]]

Destroy the queue, including its storage space and associated command.


[call [arg queueName] [cmd get] [opt "[arg count]"]]

Return the front [arg count] items of the queue and remove them from
the queue.  If [arg count] is not specified, it defaults to 1.  If
[arg count] is 1, the result is a simple string; otherwise, it is a
list.  If specified, [arg count] must be greater than or equal to 1.
If there are no items in the queue, this command will return

[arg count] empty strings.


[call [arg queueName] [cmd peek] [opt "[arg count]"]]

Return the front [arg count] items of the queue, without removing them
from the queue.  If [arg count] is not specified, it defaults to 1.
If [arg count] is 1, the result is a simple string; otherwise, it is a
list.  If specified, [arg count] must be greater than or equal to 1.
If there are no items in the queue, this command will return

[arg count] empty strings.


[call [arg queueName] [cmd put] [arg item] [opt "[arg "item ..."]"]]

Put the [arg item] or items specified into the queue.  If more than
one [arg item] is given, they will be added in the order they are
listed.


[call [arg queueName] [cmd size]]

Return the number of items in the queue.


[list_end]

[keywords stack matrix tree graph]
[manpage_end]
