'\" -*- nroff -*-
'\" Copyright (C) 2001 Pat Thoyts <patthoyts@users.sourceforge.net>
'\" 
'\" RCS: @(#) $Id: smtpd.n,v 1.2 2002/01/18 21:03:34 patthoyts Exp $
'\" 
.TH smtpd n 1.0 smtpd "Tcl SMTP Server Package"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
smtpd \- Tcl SMTP server implementation
.SH SYNOPSIS
.B package require Tcl 8.3
.sp
.B package require smtpd ?1.0?
.sp
\fB::smtpd::start\fR \fR?\fImyaddr\fR?\fR \fR?\fIport\fR?\fR
.sp
\fB::smtpd::stop\fR
.sp
\fB::smptd::configure\fR \fR?\fIoption\fR \fIvalue\fR?\fR \fR?\fIoption\fR \fIvalue\fR \fI...\fR?\fR
.sp
\fB::smtpd::cget\fR \fR?\fIoption\fR
.sp
.BE
.SH DESCRIPTION
.PP
The \fBsmtpd\fR package provides a simple Tcl-only server library for
the Simple Mail Transfer Protocol as described in RFC 821 and RFC 2821.
By default the server will bind to the default network address and the
standard SMTP port (25). 
.sp
This package was designed to permit testing of Mail User Agent code
from a developers workstation. In particular, on Unix platforms
binding to the SMTP port requires root privileges. I would not
recommend running any script-based server as root unless there is
some method for dropping root privileges immediately after the socket
is bound. Under Windows platforms, it is not necessary to have root or
administrator privileges to bind low numbered sockets. However,
security on these platforms is weak anyway. In short, this code should
probably not be used as a permanently running MTA on an Internet
connected server, even though we are careful not to evaluate remote user
input.
.SH COMMANDS
.TP
\fB::smtpd::start\fR \fR?\fImyaddr\fR?\fR \fR?\fIport\fR?\fR
Start the service listening on \fIport\fR or the default port 25. If
\fImyaddr\fR is given as a domain-style name or numerical dotted-quad
IP address then the server socket will be bound to that network
interface. By default the server is bound to all network
interfaces. For example:
.br
.CS
set sock [smtpd::start [info hostname] 0]
.CE
.br
will bind to the hosts internet interface on the first available
port.
.br
At present the package only supports a single instance of a SMTP
server. This could be changed if required at the cost of making the
package a little more complicated to read. If there is a good reason
for running multiple SMTP services then it will only be necessary to
fix the \fIoptions\fR array and the \fBsmtpd::stopped\fR variable usage.
.sp
As the server code uses \fIfileevent\fR(n) handlers to process the
input on sockets you will need to run the event loop. This means
either you should be running from within \fIwish\fR(1) or you should 
\fIvwait\fR(n) on the \fBsmtpd::stopped\fR
variable which is set when the server is stopped.
.TP
.B ::smtpd::stop
Halt the server and release the listening socket. If the server has
not been started then this command does nothing. The
.B smtpd::stopped
variable is set for use with \fIvwait\fR(n).
.br
It should be noted that stopping the server does not disconnect any
currently active sessions as these are operating over an independant
channel. Only explicitly tracking and closing these sessions, or
exiting the server process will close down all the running
sessions. This is similar to the ususal unix daemon practice where the
server performs a \fIfork\fR(2) and the client session continues on
the child process.
.TP
\fB::smptd::configure\fR \fR?\fIoption\fR \fIvalue\fR?\fR
\fR?\fIoption\fR \fIvalue\fR \fI...\fR?\fR
Set configuration options for the SMTP server. Most values are the
name of a callback procedure to be called at various points in the
SMTP protocol. See the CALLBACKS section for details of the procedures.
.RS
.TP
\fB-validate_host proc\fR
Callback to authenticate new connections based on the ip-address of the
client.
.TP
\fB-validate_sender proc\fR
Callback to authenticate new connections based on the senders email address.
.TP
\fB-validate_recipient proc\fR
Callback to validate and authorize a recipient email address
.TP
\fB-deliver proc\fR
Callback used to deliver email.
.RE
.TP
.SH CALLBACKS
.TP
.B validate_host callback
This procedure is called with the clients ip address as soon as a
connection request has been accepted and before any protocol commands
are processed. If you wish to deny access to a specific host then an
error should be returned by this callback. For example:
.PP
.CS
 proc validate_host {ipnum} {
    if {[string match "192.168.1.*" $ipnum]} {
       error "go away!"
    }
 }
.CE
.PP
If access is denied the client will receive a standard message that
includes the text of your error, such as:
.br
.B 550 Access denied: I hate you.
.br
As per the SMTP protocol, the connection is not closed but we wait for
the client to send a QUIT command. Any other commands cause a \fB503
Bad Sequence\fR error.
.TP
.B validate_sender callback
The validate_sender callback is called with the senders mail address
during processing of a MAIL command to allow you to accept or reject
mail based upon the declared sender. To reject mail you should throw
an error. For example, to reject mail from user "denied":
.br
.CS
 proc validate_sender {address} {
    eval array set addr \\
         [mime::parseaddress $address]
    if {[string match "denied" $addr(local)]} {
         error "mailbox $addr(local) denied"
    }
    return    
 }
.CE
.PP
The content of any error message will not be passed back to the client.
.TP
.B validate_recipient callback
The validate_recipient callback is similar to the validate_sender
callback and permits you to verify a local mailbox and accept mail for
a local user address during RCPT command handling. To reject mail,
throw an error as above. The error message is ignored.
.TP
.B deliver callback
The deliver callback is called once a mail message has been
successfully passed to the server. The procedure is called with the
sender, a list of recipients and the text of the mail as a list of
lines. For example:
.CS
 proc deliver {sender recipients data} {
    set mail "From $saddr(address) \\
               [clock format [clock seconds]]"
    append mail "\\n" [join $data "\\n"]
    puts "$mail"
 }
.CE
.PP
Note that the DATA command will return an error if no sender or
recipient has yet been defined.
.RE
.TP
.SH VARIABLES
.TP
.B ::smtpd::stopped
This variable is set to \fItrue\fR during the ::smtpd::stop command to
permit the use of the \fIvwait\fR(n) command.
'\".B::smtpd::postmaster\fR
'\"The e-mail address of the person that is the contact for the server.
.SH AUTHOR
Written by Pat Thoyts 
.RE <patthoyts@users.sourceforge.net>
.SH COPYRIGHT
This software is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the file 'license.terms' for
more details.
.SH KEYWORDS
smtpd, smtp, services, RFC 821, RFC 2821, vwait, socket
