# template.tcl
#
# Support for generating HTML inside templates.
#
# Laurent Demailly / Brent Welch (c) 1997 Sun Microsystems
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

package provide template 1.0

proc Head {} {
    global page
    set page(head) 1

    return \
"<!Doctype HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">
<Html>
<Head>"
}
proc Body {args} {
    global page
    set html ""
    if {[info exists page(head)]} {
	append html "</Head>\n"
    }
    append html "<Body [join $args]>\n"
    return $html
}

proc Title {str} {
    global page
    set page(title) $str
    return "<Title>$str</Title>\n"
}
proc Author {who} {
    global page
    set page(author) $who
    return "<!-- Author: $who -->\n"
}
proc Keywords {args} {
    return "<Meta Name=\"keywords\" Content=\"[join $args]\">\n"
}
