# Canvas chapter
proc ShowBitmap { parent name width } {
    frame $parent.$name
    label $parent.$name.l -text $name -width $width -anchor w
    label $parent.$name.b -bitmap $name
    pack $parent.$name.l -side right
    pack $parent.$name.b -side top
    pack $parent.$name -side top -expand true -fill x
}

proc ShowBitmapTest {} {
    catch {destroy .bitmaps}
    toplevel .bitmaps -bd 10
    frame .bitmaps.f -bd 4; frame .bitmaps.g -bd 4
    pack .bitmaps.f .bitmaps.g -side left
    set F .bitmaps.f ; set next .bitmaps.g
    foreach f {error gray25 gray50 hourglass info questhead question warning} {
	ShowBitmap $F $f [string length questhead]
	set tmp $F ; set F $next ; set next $tmp
    }
}
proc ShowBitmaps { list {width 100} } {
    catch {destroy .f .g}
    frame .f -bd 4; frame .g -bd 4 ; pack .f .g -side left
    set parent .f ; set next .g
    foreach name $list {
	    frame $parent.$name
	    label $parent.$name.l -text $name -width $width -anchor w
	    label $parent.$name.b -bitmap $name
	    pack $parent.$name.l -side right
	    pack $parent.$name.b -side top
	    pack $parent.$name -side top -expand true -fill x
	    set tmp $parent ; set parent $next ; set next $tmp
    }

}
ShowBitmapTest
