'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_SetVar.man,v 1.3 89/03/24 15:15:17 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_SetVar tcl
.BS
.SH NAME
Tcl_SetVar \- change the value of a Tcl variable
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
\fBTcl_SetVar\fR(\fIinterp, varName, newValue, global\fR)
.SH ARGUMENTS
.AS Tcl_Interp *interp
.AP Tcl_Interp *interp in
Interpreter in which to change variable.
.AP char *varName in
Name of variable.
.AP char *newValue in
New value for \fIvarName\fR
.AP int global in
If non-zero, then insist on interpreting \fIvarName\fR as a global
variable, regardless of whether a procedure invocation is in
progress.
.BE

.SH DESCRIPTION
.PP
This is a utility procedure used by many of the Tcl commands.
It changes the value of variable \fIvarName\fR in
interpreter \fIinterp\fR, such that future calls to \fBTcl_GetVar\fR
will return \fInewValue\fR as the value of \fIvarName\fR.
\fBTcl_SetVar\fR uses the same rules for selecting
a global or local variable as \fBTcl_GetVar\fR.  If \fIvarName\fR
doesn't already exist, then a new variable is created.
\fBTcl_SetVar\fR copies both \fIvarName\fR and \fInewValue\fR into
its own private storage, so the caller may change the contents
of these strings after \fBTcl_SetVar\fR returns without affecting
the variable's value.

.SH KEYWORDS
interpreter, variable
