/*
 * sxInt.h --
 *
 *	This file contains declarations for things used internally by
 *	several files in the sx module, but not exported outside the
 *	module.
 *
 * Copyright (C) 1986, 1988 Regents of the University of California.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting
 * documentation.  The University of California makes no
 * representations about the suitability of this software for
 * any purpose.  It is provided "as is" without express or
 * implied warranty.
 *
 *
 * $Header: sxInt.h,v 1.2 88/07/15 14:16:12 ouster Exp $ SPRITE (Berkeley)
 */

#ifndef _SXINT
#define _SXINT

#ifndef _XLIB_H_
#include <X11/Xlib.h>
#endif

/*
 * The defines below determine the amount of extra space required on
 * each side of a shadowed box, as drawn by SxDrawShadow.  This space
 * includes both the box border and the shadow.
 */

#define SHADOW_BORDER 2
#define SHADOW_WIDTH 6
#define SHADOW_LEFT 2
#define SHADOW_TOP 2
#define SHADOW_RIGHT 8
#define SHADOW_BOTTOM 8

/*
 * Procedures exported by one sx file and used by another:
 */

extern void		SxFlashWait();
extern void		SxDrawShadow();
extern void		SxUnmapCarefully();

/*
 * Variables exported from one sx file to another:
 */

extern char *		sxPrefixName;

#endif _SXINT
