/* Release 4.0  */
/* Fri Feb 27 09:06:50 EST 1998 */
/* 
Changes:
Support update of text and blob with
<BYTE> and <TEXT> tags in the data field
Added sql error msg and isam error msg fields to sqlca
Store sqltype after describe and use it for sql_sqlda printout
Add rtypname to sqltype and sqlitype in sql_sqlda printouts
Save collen too in array 
sql database dbname [exclusive]
sql connect to_name [as connect_name] [with_concurrent_transaction] 
	[user username] [using|password passcode]
sql setconnection [current|default|as_connect_name] [dormant];
sql disconnect [current|default|all|as_connect_name]
sql sqlbreak
sql sqldetach
sql sqlexit
sql sqldone
sql readblob table column "rowid = NUM" intofilename [append]
	if success (0) returns NULL or SIZE of blob written
	else returns ERROR (-1)
sql writeblob table column "rowid = NUM" [fromfilename | null] [size|-1]
	if success (0) returns SIZE of blob written
	else returns ERROR (-1)
sql begin
sql rollback
sql commit

Need:
sql convert [ascii|bcd] str
sql colnames fd in
sql coltypes fd in
sql coldblen fd in
sql colcharlen fd in

inf commands to mirror ora commands in tcl and C
Add integrated support for RPC, SQL.TCL
WISQL port


Expose convert_ascii method to sql (add sql convert [ascii|bcd] str)
 
Add sql colnames fd in
Add sql coltypes fd in
Add support for <BYTE FILE> and <TEXT FILE> tag support
Add support for <BYTE FD> and <TEXT FD> tag support
(use readlong/writelong functions?)
sql readblob table column "rowid = NUM" intofilename [append]
sql writeblob table column "rowid = NUM" fromfilename
sql read text table column "rowid = NUM" intofilename [append]
sql read byte table column "rowid = NUM" intofilename [append]
sql write text table column "rowid = NUM" fromfilename
sql write byte table column "rowid = NUM" fromfilename
*/

#include "stdio.h"
#define loc_t system_loc_t
#include "ctype.h"
#undef loc_t
char *getenv();
$include sqlca;
$include sqlda;
$include locator;
$include sqltypes;

/*

Functions provided by this interface

    int sql_database(char *dbname, int exclusive)
    int sql_connect(char *dbname, char *uid, char *pw, char *cname, int with_concurrent_transaction)
    int sql_disconnect(char *arg)
    int sql_finish()
    char *sql_getdatabase()
    int sql_exists(char *table, char *field, char *value, char *where)
    int sql_open(char *stmt, int argc, char **argv)
    int sql_close(int)
    int sql_fetch(int)
    int sql_run(char *stmt, int argc, char **argv)
        calls sql_open, sql_fetch and then sql_close
    int sql_explain(int)
    int sql_reopen(fd, argc, argv)
    char *sql_geterror()
    char **sql_values(fd, &numvalues, dostrip)
    char **sql_sqlca(&numvalues)
        do not free the char ** returned !
    int sql_sqld(fd, in)
    char **sql_sqlda(fd, in, num, &numvalues)

    int sql_database(char *dbname, char *uid, char *pw)
        connects to the database specified by dbname
        or if dbname is "" or cannot be opened uses
        the DATABASE environ variable
    int sql_finish()
        closes the database opened earlier
    char *sql_getdatabase()
        returns the database name opened by sql_database
    int sql_exists(char *table, char *field, char *value, char *where)
        check for existence of field in table optionally with value and
        optionally with a where clause where
    int sql_open(char *stmt, int argc, char **argv)
        open the query specified by statement and substitute all ? with
        parameters specified
        compiles the query and allocates space for return values
    int sql_close(int)
        close the compiled query and release all memory allocated for it
    int sql_fetch(int)
        fetch a single row into the allocated space
        use sql_values to retrieve it
        (there is no need to free the sql_values return value!
        the program manages this space efficiently by reallocating more 
        space if needed and does not do repeated malloc and free.)
    int sql_run(char *stmt, int argc, char **argv)
        calls sql_open, sql_fetch and then sql_close
    int sql_explain(int)
        sets debug on for all queries if int is not 0 else turns off
    int sql_reopen(fd, argc, argv)
        reopen the cursor so that fetches may be done from the 
        start again. uses the old parameters for the open
        if argc is specified bind the variables again
    char *sql_geterror()
    char **sql_values(fd, &numvalues, dostrip)
        if dostrip is 1, it will strip all trailing blanks
*/
        
#define MAXFD 20
typedef struct {
	int type;
	char *byte_ptr;
} BLOBENV;
typedef struct {
    char *cmd;
    unsigned int opened:1;
    unsigned int is_select:1;
    struct sqlda *in;
    struct sqlda *out;
    struct sqlda *exec;
	int *arr_sqltype;
	int arr_sqltype_len;
	int *arr_sqllen;
} SSQL;
static SSQL ssql[MAXFD+1];
static char *database_name;
static char *connection_name;

#ifndef BUFSIZ
#define BUFSIZ 4096
#endif
#ifdef DEBUG
#define debug(s)    s
#else
#define debug(s)
#endif

static char errmsg[1024+1];
#define chk_status(p1, p2)  if (sqlca.sqlcode < 0) {\
    return print_status(p1, p2);}

/* removes trailing white spaces */
char * strip (s) char *s; {
  int i;
  for (i = strlen(s) - 1; i >=0 ; i--)
    if (!isspace(s[i])) break;
  s[i+1] = 0;
  return s;
} 
    
/* Using the previous sql error code print the informix error message */
print_status(p1, p2) char *p1, *p2; {
    int retcode = sqlca.sqlcode;
    if (retcode < 0) {
        int len;
        struct sqlca_s save;
        errmsg[0] = '\0';
        memcpy(&save, &sqlca, sizeof(sqlca));
        rgetmsg(save.sqlcode, errmsg, 1024);
        len = strlen(errmsg);
        if (save.sqlerrd[1]) {
            /*errmsg[len++] = '\n';*/
            errmsg[len] = '\0';
            rgetmsg(save.sqlerrd[1], &errmsg[len], 1024-len);
        }
		strip(save.sqlerrp);
		strip(save.sqlerrm);
        sprintf(&errmsg[strlen(errmsg)], 
            "%d:%d:%s %s %s %s\n", 
            save.sqlcode, save.sqlerrd[1], save.sqlerrp, save.sqlerrm, p1, p2);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return retcode;
    }
    return retcode;
}

/* Set explain on or off */
int sql_explain(n) {
    if (n) 
        $set explain on;
    else 
        $set explain off;
    return sqlca.sqlcode;
}

/* Return the error message stored in the buffer */
char *sql_geterror() {
    return errmsg;
}

/* if select is there and into temp not there then is select */
/* returns 1 if select 0 otherwise */
static is_select(stmt) char *stmt;
{
    char s1[12];
    if (sscanf(stmt, "%8s", s1) == 1 && (strcmp(s1, "select") == 0 ||
		strcmp(s1, "SELECT") == 0 || strcmp(s1, "execute") == 0 ||
		strcmp(s1, "EXECUTE") == 0) &&
        strstr(stmt, "into temp") == 0L) return 1;
    return 0;
}

/* returns 
    0 if field exists in table, 
    sqlca.sqlcode otherwise
*/
int sql_exists(table, field, value, where)
char *table, *field, *where;
$char *value;
{
    $char stmt[BUFSIZ+1];
    int fetch_code = 0; /* NOTUSED */

    if (value && *value != '\0') {
        sprintf(stmt, "select '1' from %s where %s = ?", 
            table, field);
        if (where && *where != '\0')
            sprintf(&stmt[strlen(stmt)], " and %s", where);
    }
    else {
        sprintf(stmt, "select '1' from %s", 
            table, field);
        if (where && *where != '\0')
            sprintf(&stmt[strlen(stmt)], " where %s", where);
    }
    
    $prepare pexist from $stmt;
    chk_status("PREPARE(EXISTS)", stmt);
    $declare pexist_cur cursor for pexist;
    chk_status("DECLARE(EXISTS)", stmt);
    if (value && *value != '\0')
        $open pexist_cur using $value;
    else
        $open pexist_cur;
    chk_status("OPEN(EXISTS)", stmt);
    $fetch pexist_cur into $stmt;
    fetch_code = sqlca.sqlcode;
    $close pexist_cur;
    return fetch_code;
}

#define toomany(maxfd) {\
        sprintf(errmsg, \
            "Too many open internal fds (> %d) for sql operations\n", maxfd);\
        debug(fprintf(stderr, "%s\n", errmsg);)\
        return -1;\
    }
#define errmalloc(pointer, func, len)   \
    if (!pointer) {\
        sprintf(errmsg, "Cannot malloc for %d in %s errno %d",len,func,errno);\
        debug(fprintf(stderr, "%s\n", errmsg);)\
        return -1;\
    }
extern int errno;

/* Returns 
    0 on successful execution
    sqlca.sqlcode otherwise
*/
int sql_run(stmt, argc, argv)
    char *stmt;
    int argc;
    char **argv;
{
    int fd;
    int ret;
	if (isdigit(stmt[0])) {
		fd = atoi(stmt);
    	if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        	sprintf(errmsg, "Invalid fd %d passed to sql_run", fd);
        	debug(fprintf(stderr, "%s\n", errmsg);)
        	return -1;
    	}
    	if (sql_set_values(fd, argc, argv) != 0)
        	return -1;
		ret = sql_fetch(fd);
		return ret;
	}
	fd = sql_open(stmt, argc, argv);
    if (fd < 0) return fd;
    ret = sql_fetch(fd);
    sql_close(fd);
    return ret;
}

int sql_open(stmt, argc, argv) 
    $char *stmt;
    int argc;
    char **argv;
{
    struct sqlvar_struct *col = 0L;
    struct sqlda *udesc = 0L;
    int i, fd, len, ret;
    char *save;


    for (i = 0; i < MAXFD; i++) 
        if (!ssql[i].cmd) break;
    if (i >= MAXFD) toomany(i);

    fd = i;

    len = strlen(stmt);
    save = (char *)calloc(len+1, 1);
    errmalloc(save, "OPEN", len);
    strcpy(save, stmt);
    memset(&ssql[fd], 0, sizeof(SSQL));
    ssql[fd].cmd = save;

    switch (fd) {
            case 0:
                $prepare p0 from $stmt; 
                break;
            case 1:
                $prepare p1 from $stmt; 
                break;
            case 2:
                $prepare p2 from $stmt; 
                break;
            case 3:
                $prepare p3 from $stmt; 
                break;
            case 4:
                $prepare p4 from $stmt; 
                break;
            case 5:
                $prepare p5 from $stmt; 
                break;
            case 6:
                $prepare p6 from $stmt; 
                break;
            case 7:
                $prepare p7 from $stmt; 
                break;
            case 8:
                $prepare p8 from $stmt; 
                break;
            case 9:
                $prepare p9 from $stmt; 
                break;
            case 10:
                $prepare p10 from $stmt; 
                break;
            case 11:
                $prepare p11 from $stmt; 
                break;
            case 12:
                $prepare p12 from $stmt; 
                break;
            case 13:
                $prepare p13 from $stmt; 
                break;
            case 14:
                $prepare p14 from $stmt; 
                break;
            case 15:
                $prepare p15 from $stmt; 
                break;
            case 16:
                $prepare p16 from $stmt; 
                break;
            case 17:
                $prepare p17 from $stmt; 
                break;
            case 18:
                $prepare p18 from $stmt; 
                break;
            case 19:
                $prepare p19 from $stmt; 
                break;
            case 20:
                $prepare p20 from $stmt; 
                break;
            default: sql_close(fd); toomany(fd);
    }
    if (sqlca.sqlcode < 0) sql_close(fd);
    chk_status("PREPARE(OPEN)", stmt);

    switch (fd) {
        case 0: 
            $describe p0 into udesc; 
            break;
        case 1: 
            $describe p1 into udesc; 
            break;
        case 2: 
            $describe p2 into udesc; 
            break;
        case 3: 
            $describe p3 into udesc; 
            break;
        case 4: 
            $describe p4 into udesc; 
            break;
        case 5: 
            $describe p5 into udesc; 
            break;
        case 6: 
            $describe p6 into udesc; 
            break;
        case 7: 
            $describe p7 into udesc; 
            break;
        case 8: 
            $describe p8 into udesc; 
            break;
        case 9: 
            $describe p9 into udesc; 
            break;
        case 10:    
            $describe p10 into udesc; 
            break;
        case 11:    
            $describe p11 into udesc; 
            break;
        case 12:    
            $describe p12 into udesc; 
            break;
        case 13:    
            $describe p13 into udesc; 
            break;
        case 14:    
            $describe p14 into udesc; 
            break;
        case 15:    
            $describe p15 into udesc; 
            break;
        case 16:    
            $describe p16 into udesc; 
            break;
        case 17:    
            $describe p17 into udesc; 
            break;
        case 18:    
            $describe p18 into udesc; 
            break;
        case 19:    
            $describe p19 into udesc; 
            break;
        case 20:    
            $describe p20 into udesc; 
            break;
        default: sql_close(fd); toomany(fd);
    }
    if (sqlca.sqlcode < 0) sql_close(fd);
    chk_status("DESCRIBE(OPEN)", stmt);

    if (!is_select(stmt)) {
        ssql[fd].is_select = 0;
		ssql[fd].exec = udesc;
        if (sql_set_values(fd, argc, argv) != 0)
            return sql_close(fd), -1;
        return fd;
    }

    ssql[fd].is_select = 1;

    ssql[fd].out = udesc;

    udesc = ssql[fd].out;
    if (!udesc) {
        sprintf(errmsg, "No columns selected !\n");
        fprintf(stderr, "No columns selected !\n");
        return -1;
    }

	if (udesc->sqld > 0) {
		ssql[fd].arr_sqltype = (int *)calloc(udesc->sqld+1, sizeof(int));
		if (!ssql[fd].arr_sqltype) sql_close(fd);
		errmalloc(ssql[fd].arr_sqltype, "OPEN:DESCRIBE", sizeof(int));
		ssql[fd].arr_sqllen = (int *)calloc(udesc->sqld+1, sizeof(int));
		if (!ssql[fd].arr_sqllen) sql_close(fd);
		errmalloc(ssql[fd].arr_sqllen, "OPEN:DESCRIBE", sizeof(int));
		ssql[fd].arr_sqltype_len = udesc->sqld;
	}

    for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
		int blob = 0;
		ssql[fd].arr_sqltype[i] = col->sqltype;
		ssql[fd].arr_sqllen[i] = col->sqllen;
        if ((col->sqltype&SQLTYPE) != SQLCHAR &&
            (col->sqltype&SQLTYPE) != SQLVCHAR) {
			if ((col->sqltype&SQLTYPE) == SQLBYTES) {
				col->sqldata = (char *)calloc(1, sizeof(loc_t));
				blob = 1;
			} else if ((col->sqltype&SQLTYPE) == SQLTEXT) {
				col->sqldata = (char *)calloc(1, sizeof(loc_t));
				blob = 2;
			} else {
            	col->sqllen = rtypwidth(col->sqltype, col->sqllen);
			}
            /* Should allocate atleast 12 characters for backward compat. ! */
            if (col->sqllen < 12) col->sqllen = 12;
        }
		if (blob) {
			loc_t *loc;
			BLOBENV *benv;
			if (!col->sqldata) sql_close(fd);
			errmalloc(col->sqldata, "OPEN LOC", sizeof(loc_t));
			loc = (loc_t *)col->sqldata;
			loc->loc_loctype = LOCMEMORY;
			loc->loc_bufsize = -1;
			loc->loc_oflags = loc->loc_mflags = 0;
			col->sqltype = CLOCATORTYPE;
			benv = (BLOBENV *)calloc(1, sizeof(BLOBENV));
			if (!benv) sql_close(fd);
			errmalloc(benv, "OPEN BLOBENV", sizeof(BLOBENV));
			loc->loc_user_env = (char *)benv;
			if (blob == 1) benv->type = 'B';
			else benv->type = 'T';
		} else {
        	col->sqllen++;
        	col->sqldata = (char *)calloc(col->sqllen + 1, 1);
        	if (!col->sqldata) sql_close(fd);
        	errmalloc(col->sqldata, "OPEN", col->sqllen + 1);
        	memset(col->sqldata, 0, col->sqllen + 1);
        	col->sqltype = CCHARTYPE; 
		}
        col->sqlind = (short *)calloc(1, sizeof(short));
        if (!col->sqlind) sql_close(fd);
        errmalloc(col->sqlind, "OPEN", sizeof(short));
        *(col->sqlind) = 0;
    }

    switch (fd) {
        case 0:
            $declare c0 cursor for p0; 
            break;
        case 1:
            $declare c1 cursor for p1; 
            break;
        case 2:
            $declare c2 cursor for p2; 
            break;
        case 3:
            $declare c3 cursor for p3; 
            break;
        case 4:
            $declare c4 cursor for p4; 
            break;
        case 5:
            $declare c5 cursor for p5; 
            break;
        case 6:
            $declare c6 cursor for p6; 
            break;
        case 7:
            $declare c7 cursor for p7; 
            break;
        case 8:
            $declare c8 cursor for p8; 
            break;
        case 9:
            $declare c9 cursor for p9; 
            break;
        case 10:
            $declare c10 cursor for p10; 
            break;
        case 11:
            $declare c11 cursor for p11; 
            break;
        case 12:
            $declare c12 cursor for p12; 
            break;
        case 13:
            $declare c13 cursor for p13; 
            break;
        case 14:
            $declare c14 cursor for p14; 
            break;
        case 15:
            $declare c15 cursor for p15; 
            break;
        case 16:
            $declare c16 cursor for p16; 
            break;
        case 17:
            $declare c17 cursor for p17; 
            break;
        case 18:
            $declare c18 cursor for p18; 
            break;
        case 19:
            $declare c19 cursor for p19; 
            break;
        case 20:
            $declare c20 cursor for p20; 
            break;
        default: sql_close(fd); toomany(fd);
    }
    if (sqlca.sqlcode < 0) sql_close(fd);
    chk_status("DECLARE(OPEN)", stmt); 

    ret = sql_reopen(fd, argc, argv);
    if (ret < 0) sql_close(fd);
    chk_status("OPEN(OPEN)", stmt);

    ssql[fd].opened = 1;

    return fd;
}

#define make_into_char(arg)	\
	(((arg) >= 'A' && (arg) <= 'F')?((arg) - 'A' + 10):\
	(((arg) >= 'a' && (arg) <= 'f')?((arg) - 'a' + 10):(arg)))
static convert_byte(char *tgt, char *src, int len) {
	int i, j;
	
	for (i = j = 0; i < len; i += 2) {
		tgt[j++] = make_into_char(src[i])*16 + make_into_char(src[i+1]);
	}
	tgt[j] = '\0';
	return j-1;
}

sql_set_values(fd, argc, argv) char **argv; {
    struct sqlvar_struct *col, *ecol;
    struct sqlda *udesc, *edesc;
    int i;
    
    udesc = ssql[fd].in;
    edesc = ssql[fd].exec;
    if (argc > 0) {
        if (udesc && argc != udesc->sqld) {
            sprintf(errmsg, 
            "Incorrect number of bind variables specified - %d", argc);
            debug(fprintf(stderr, "%s\n", errmsg);)
            return -1;
        }
        if (udesc) {
            int i;
            for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
				if (col->sqltype == CLOCATORTYPE) {
					loc_t *loc = (loc_t *)col->sqldata;
					if (loc && loc->loc_buffer) 
						free(loc->loc_buffer), loc->loc_buffer = NULL;
					if (loc && loc->loc_user_env) {
						BLOBENV *benv = (BLOBENV *)loc->loc_user_env;
						if (benv->byte_ptr) free(benv->byte_ptr);
						benv->byte_ptr = NULL;
						free(loc->loc_user_env), loc->loc_user_env = NULL;
					}
				}
                free(col->sqldata);
				col->sqldata = NULL;
            }
            free(udesc->sqlvar);
            free(udesc);
        }
        ssql[fd].in = (struct sqlda *)calloc(1, sizeof(struct sqlda));
        if (!ssql[fd].in) sql_close(fd);
        errmalloc(ssql[fd].in, "SETVALUES", sizeof(struct sqlda));
        memset(ssql[fd].in, 0, sizeof(struct sqlda));
        (ssql[fd].in)->sqld = argc;
        udesc = (ssql[fd].in);
        udesc->sqlvar = (struct sqlvar_struct *)
                        calloc(argc, sizeof(struct sqlvar_struct));
        if (!udesc->sqlvar) 
            sql_close(fd);
        errmalloc(udesc->sqlvar, "SETVALUES", 
            argc * sizeof(struct sqlvar_struct));
        memset(udesc->sqlvar, 0, argc * sizeof(struct sqlvar_struct));
		if (edesc && edesc->sqld <= 0) edesc = NULL;
		if (edesc && edesc->sqlvar) ecol = edesc->sqlvar;
		else ecol = NULL;
        for (i = 0, col = udesc->sqlvar; i < argc; i++, col++) {
			int blob = 0;
			if (ecol) {
				if ((ecol->sqltype&SQLTYPE) == SQLBYTES) blob = 1;
				if ((ecol->sqltype&SQLTYPE) == SQLTEXT) blob = 2;
				if (blob) col->sqldata = (char *)calloc(1, sizeof(loc_t));
			}
			/* Allow <BYTE> and <TEXT> tags in values */
			if (strncmp(argv[i], "<BYTE>", 6) == 0) {
				blob = 1;
				argv[i] = argv[i] + 6; /* Skip over the tag */
            	col->sqllen = sizeof(loc_t);
            	col->sqldata = (char *)calloc(1, sizeof(loc_t));
			}
			else if (strncmp(argv[i], "<TEXT>", 6) == 0) {
				blob = 2;
				argv[i] = argv[i] + 6; /* Skip over the tag */
            	col->sqllen = sizeof(loc_t);
            	col->sqldata = (char *)calloc(1, sizeof(loc_t));
			}
			if (blob) {
				loc_t *loc;
				BLOBENV *benv;
				if (!col->sqldata) sql_close(fd);
				errmalloc(col->sqldata, "SETVALUES LOC", sizeof(loc_t));
				loc = (loc_t *)col->sqldata;
				loc->loc_loctype = LOCMEMORY;
				loc->loc_buffer = argv[i];
				loc->loc_bufsize = loc->loc_size = strlen(argv[i])+1;
				loc->loc_oflags = loc->loc_mflags = 0;
				col->sqltype = CLOCATORTYPE;
				benv = (BLOBENV *)calloc(1, sizeof(BLOBENV));
				if (!benv) sql_close(fd);
				errmalloc(benv, "SETVALUES BLOBENV", sizeof(BLOBENV));
				loc->loc_user_env = (char *)benv;
				if (blob == 1) {
					int byte_size;;
					benv->type = 'B';
					benv->byte_ptr =
						(char *)calloc(loc->loc_size, sizeof(char));
					if (!benv->byte_ptr) sql_close(fd);
					errmalloc(benv->byte_ptr, "SETVALUES BENV", 
						sizeof(BLOBENV));
					byte_size = convert_byte(benv->byte_ptr, loc->loc_buffer, 
						loc->loc_size);
					loc->loc_buffer = benv->byte_ptr;
					loc->loc_bufsize = loc->loc_size = byte_size;
				}
				else {
					benv->type = 'T';
					loc->loc_buffer = (char *)calloc(loc->loc_bufsize,1);
					if (!loc->loc_buffer)
						sql_close(fd);
					errmalloc(loc->loc_buffer, "SETVALUES", loc->loc_bufsize);
					strcpy(loc->loc_buffer, argv[i]);
				}
			} else {
            	col->sqllen = strlen(argv[i]);
            	col->sqldata = (char *)calloc(col->sqllen+1, 1);
            	if (!col->sqldata)
                	sql_close(fd);
            	errmalloc(col->sqldata, "SETVALUES", col->sqllen+1);
            	strcpy(col->sqldata, argv[i]);
            	col->sqltype = CCHARTYPE; 
			}
            col->sqlname = 0;
            col->sqlind = 0;
			if (ecol) ecol++;
        }
    }
    return 0;
}

sql_reopen(fd, argc, argv) char **argv; {
    struct sqlvar_struct *col;
    struct sqlda *udesc;
    int i;

    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_reopen", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
    }

    if (sql_set_values(fd, argc, argv) != 0)
        return -1;

    udesc = ssql[fd].in;
        
    switch (fd) {
        case 0:
            if (udesc && udesc->sqld) 
                $open c0 using descriptor udesc;
            else
                $open c0;
            break;
        case 1:
            if (udesc && udesc->sqld)
                $open c1 using descriptor udesc;
            else
                $open c1;
            break;
        case 2:
            if (udesc && udesc->sqld)
                $open c2 using descriptor udesc;
            else
                $open c2;
            break;
        case 3:
            if (udesc && udesc->sqld)
                $open c3 using descriptor udesc;
            else
                $open c3;
            break;
        case 4:
            if (udesc && udesc->sqld)
                $open c4 using descriptor udesc;
            else
                $open c4;
            break;
        case 5:
            if (udesc && udesc->sqld)
                $open c5 using descriptor udesc;
            else
                $open c5;
            break;
        case 6:
            if (udesc && udesc->sqld)
                $open c6 using descriptor udesc;
            else
                $open c6;
            break;
        case 7:
            if (udesc && udesc->sqld)
                $open c7 using descriptor udesc;
            else
                $open c7;
            break;
        case 8:
            if (udesc && udesc->sqld)
                $open c8 using descriptor udesc;
            else
                $open c8;
            break;
        case 9:
            if (udesc && udesc->sqld)
                $open c9 using descriptor udesc;
            else
                $open c9;
            break;
        case 10:
            if (udesc && udesc->sqld)
                $open c10 using descriptor udesc;
            else
                $open c10;
            break;
        case 11:
            if (udesc && udesc->sqld)
                $open c11 using descriptor udesc;
            else
                $open c11;
            break;
        case 12:
            if (udesc && udesc->sqld)
                $open c12 using descriptor udesc;
            else
                $open c12;
            break;
        case 13:
            if (udesc && udesc->sqld)
                $open c13 using descriptor udesc;
            else
                $open c13;
            break;
        case 14:
            if (udesc && udesc->sqld)
                $open c14 using descriptor udesc;
            else
                $open c14;
            break;
        case 15:
            if (udesc && udesc->sqld)
                $open c15 using descriptor udesc;
            else
                $open c15;
            break;
        case 16:
            if (udesc && udesc->sqld)
                $open c16 using descriptor udesc;
            else
                $open c16;
            break;
        case 17:
            if (udesc && udesc->sqld)
                $open c17 using descriptor udesc;
            else
                $open c17;
            break;
        case 18:
            if (udesc && udesc->sqld)
                $open c18 using descriptor udesc;
            else
                $open c18;
            break;
        case 19:
            if (udesc && udesc->sqld)
                $open c19 using descriptor udesc;
            else
                $open c19;
            break;
        case 20:
            if (udesc && udesc->sqld)
                $open c20 using descriptor udesc;
            else
                $open c20;
            break;
        default: toomany(fd);
    }

    return sqlca.sqlcode;
}

int sql_fetch(fd)
{

    int ret;
    struct sqlda *udesc;
    
    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_fetch", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
    }
    if (!ssql[fd].is_select) {
        udesc = ssql[fd].in;
        switch (fd) {
            case 0:
                if (udesc)
                    $execute p0 using descriptor udesc;
                else
                    $execute p0;
                break;
            case 1:
                if (udesc)
                    $execute p1 using descriptor udesc;
                else
                    $execute p1;
                break;
            case 2:
                if (udesc)
                    $execute p2 using descriptor udesc;
                else
                    $execute p2;
                break;
            case 3:
                if (udesc)
                    $execute p3 using descriptor udesc;
                else
                    $execute p3;
                break;
            case 4:
                if (udesc)
                    $execute p4 using descriptor udesc;
                else
                    $execute p4;
                break;
            case 5:
                if (udesc)
                    $execute p5 using descriptor udesc;
                else
                    $execute p5;
                break;
            case 6:
                if (udesc)
                    $execute p6 using descriptor udesc;
                else
                    $execute p6;
                break;
            case 7:
                if (udesc)
                    $execute p7 using descriptor udesc;
                else
                    $execute p7;
                break;
            case 8:
                if (udesc)
                    $execute p8 using descriptor udesc;
                else
                    $execute p8;
                break;
            case 9:
                if (udesc)
                    $execute p9 using descriptor udesc;
                else
                    $execute p9;
                break;
            case 10:
                if (udesc)
                    $execute p10 using descriptor udesc;
                else
                    $execute p10;
                break;
            case 11:
                if (udesc)
                    $execute p11 using descriptor udesc;
                else
                    $execute p11;
                break;
            case 12:
                if (udesc)
                    $execute p12 using descriptor udesc;
                else
                    $execute p12;
                break;
            case 13:
                if (udesc)
                    $execute p13 using descriptor udesc;
                else
                    $execute p13;
                break;
            case 14:
                if (udesc)
                    $execute p14 using descriptor udesc;
                else
                    $execute p14;
                break;
            case 15:
                if (udesc)
                    $execute p15 using descriptor udesc;
                else
                    $execute p15;
                break;
            case 16:
                if (udesc)
                    $execute p16 using descriptor udesc;
                else
                    $execute p16;
                break;
            case 17:
                if (udesc)
                    $execute p17 using descriptor udesc;
                else
                    $execute p17;
                break;
            case 18:
                if (udesc)
                    $execute p18 using descriptor udesc;
                else
                    $execute p18;
                break;
            case 19:
                if (udesc)
                    $execute p19 using descriptor udesc;
                else
                    $execute p19;
                break;
            case 20:
                if (udesc)
                    $execute p20 using descriptor udesc;
                else
                    $execute p20;
                break;
            default: toomany(fd);
        }
        ret = sqlca.sqlcode;
        chk_status("EXECUTE(RUN)", ssql[fd].cmd); 
        return ret;
    }
    udesc = ssql[fd].out;
    switch (fd) {
        case 0:
            if (udesc && udesc->sqld)
                $fetch c0 using descriptor udesc;
            else
                $fetch c0;
            break;
        case 1:
            if (udesc && udesc->sqld)
                $fetch c1 using descriptor udesc;
            else
                $fetch c1;
            break;
        case 2:
            if (udesc && udesc->sqld)
                $fetch c2 using descriptor udesc;
            else
                $fetch c2;
            break;
        case 3:
            if (udesc && udesc->sqld)
                $fetch c3 using descriptor udesc;
            else
                $fetch c3;
            break;
        case 4:
            if (udesc && udesc->sqld)
                $fetch c4 using descriptor udesc;
            else
                $fetch c4;
            break;
        case 5:
            if (udesc && udesc->sqld)
                $fetch c5 using descriptor udesc;
            else
                $fetch c5;
            break;
        case 6:
            if (udesc && udesc->sqld)
                $fetch c6 using descriptor udesc;
            else
                $fetch c6;
            break;
        case 7:
            if (udesc && udesc->sqld)
                $fetch c7 using descriptor udesc;
            else
                $fetch c7;
            break;
        case 8:
            if (udesc && udesc->sqld)
                $fetch c8 using descriptor udesc;
            else
                $fetch c8;
            break;
        case 9:
            if (udesc && udesc->sqld)
                $fetch c9 using descriptor udesc;
            else
                $fetch c9;
            break;
        case 10:
            if (udesc && udesc->sqld)
                $fetch c10 using descriptor udesc;
            else
                $fetch c10;
            break;
        case 11:
            if (udesc && udesc->sqld)
                $fetch c11 using descriptor udesc;
            else
                $fetch c11;
            break;
        case 12:
            if (udesc && udesc->sqld)
                $fetch c12 using descriptor udesc;
            else
                $fetch c12;
            break;
        case 13:
            if (udesc && udesc->sqld)
                $fetch c13 using descriptor udesc;
            else
                $fetch c13;
            break;
        case 14:
            if (udesc && udesc->sqld)
                $fetch c14 using descriptor udesc;
            else
                $fetch c14;
            break;
        case 15:
            if (udesc && udesc->sqld)
                $fetch c15 using descriptor udesc;
            else
                $fetch c15;
            break;
        case 16:
            if (udesc && udesc->sqld)
                $fetch c16 using descriptor udesc;
            else
                $fetch c16;
            break;
        case 17:
            if (udesc && udesc->sqld)
                $fetch c17 using descriptor udesc;
            else
                $fetch c17;
            break;
        case 18:
            if (udesc && udesc->sqld)
                $fetch c18 using descriptor udesc;
            else
                $fetch c18;
            break;
        case 19:
            if (udesc && udesc->sqld)
                $fetch c19 using descriptor udesc;
            else
                $fetch c19;
            break;
        case 20:
            if (udesc && udesc->sqld)
                $fetch c20 using descriptor udesc;
            else
                $fetch c20;
            break;
        default: toomany(fd);
    }
    ret = sqlca.sqlcode;
    chk_status("FETCH(OPEN)", ssql[fd].cmd);
    return ret;
}

static char *convert_ascii(char *str, int len) {
    int i, j;
    char *hex = "0123456789ABCDEF";
	char *p;
	
	p = (char *)calloc(len*2+1, sizeof(char));
	if (!p) return p;

    /* BCD to ascii legible ! */
    for (i = j = 0; i < len; i++) {
		p[j++] = hex[((str[i] & 0xF0) >> 4)];
		p[j++] = hex[(str[i] & 0x0F)];
    }
    p[j] = '\0';
	return p;
}

/* NOTUSED */
static char *convert_text(char *str, int len) {
	int i, j;
    char *hex = "0123456789ABCDEF";
	char *p;
	
	p = (char *)calloc(len+1, sizeof(char));
	if (!p) return p;

	/* Convert HEX to Text */
	for (i = j = 0; i < len; i++) {
		if (str[j] == '\0' || str[j+1] == '\0') break;
		p[i++] = 
			(toupper(str[j+1]) - 'A' + 10)*16 + (toupper(str[j]) - 'A' + 10);
		j += 2;
	}
	p[i] = '\0';
	return p;
}


char **sql_values(fd, num, dostrip) int *num;
{
    static char **argv;
    static int maxnum;
    struct sqlda *udesc;
    struct sqlvar_struct *col;
    int i;

    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd || !ssql[fd].is_select ||
        !ssql[fd].opened) {
        sprintf(errmsg, 
            "Cannot get values for a non-select/non-opened statement\
            (fd %d) passed to sql_values", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }
    udesc = ssql[fd].out;
    if (!udesc) return NULL;
    if (udesc->sqld > maxnum) {
        if (argv) { free(argv); argv = NULL; }
        argv = (char **)calloc(udesc->sqld , sizeof(char *));
        if (!argv) {
            sprintf(errmsg, "Cannot malloc for %d in VALUES errno %d", 
                udesc->sqld * sizeof(char *), errno);
            debug(fprintf(stderr, "%s\n", errmsg);)
            return NULL;
        }
        maxnum = udesc->sqld;
        memset(argv, 0, udesc->sqld * sizeof(char *));
    }
    for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
		if (col->sqltype == CLOCATORTYPE) {
			loc_t *loc = (loc_t *)col->sqldata;
			/* loc->loc_user_env contains T or B */
			if (loc && loc->loc_buffer) {
				BLOBENV *benv;
				benv = (BLOBENV *)loc->loc_user_env;
				if (benv && benv->type == 'B') {
					char *oldptr;
					oldptr = benv->byte_ptr;
					benv->byte_ptr = 
						convert_ascii(loc->loc_buffer, loc->loc_size);
					if (!benv->byte_ptr) argv[i] = "";
					else argv[i] = benv->byte_ptr;
					if (oldptr) free(oldptr);
				} else {
					argv[i] = loc->loc_buffer;
					if (loc->loc_size >= 0) argv[i][loc->loc_size] = '\0';
				}
			}
			else argv[i] = "";
		} else argv[i] = (col->sqldata)?col->sqldata:"";
        if (dostrip == 1) strip(argv[i]);
    }
    if (num) *num = udesc->sqld;
    return argv;
}

char **sql_sqlca(num) int *num; {
    static char **argv;
    static char sqlcode[15], sqlerrd[15*6], sqlwarn[25];
	static char sqlmsg[1024+1], isammsg[1024+1];
	int sqlmsg_len, isammsg_len;

    if (!argv) {
        argv = (char **)calloc(8 , sizeof(char *));
        if (!argv) {
            sprintf(errmsg, "Cannot malloc for %d in SQLCA errno %d", 
                8 * sizeof(char *), errno);
            debug(fprintf(stderr, "%s\n", errmsg);)
            return NULL;
        }
    }
    sprintf(argv[0] = sqlcode, "%d", sqlca.sqlcode);
    argv[1] = sqlca.sqlerrm;
    argv[2] = sqlca.sqlerrp;
    sprintf(argv[3] = sqlerrd, "%d %d %d %d %d %d", 
        sqlca.sqlerrd[0], sqlca.sqlerrd[1], sqlca.sqlerrd[2], 
        sqlca.sqlerrd[3], sqlca.sqlerrd[4], sqlca.sqlerrd[5]);
    sprintf(argv[4] = sqlwarn, "%c %c %c %c %c %c %c %c",
        sqlca.sqlwarn.sqlwarn0, sqlca.sqlwarn.sqlwarn1, 
        sqlca.sqlwarn.sqlwarn2, sqlca.sqlwarn.sqlwarn3,
        sqlca.sqlwarn.sqlwarn4, sqlca.sqlwarn.sqlwarn5, 
        sqlca.sqlwarn.sqlwarn6, sqlca.sqlwarn.sqlwarn7);

	if (sqlca.sqlcode == SQLNOTFOUND) {
		sprintf(sqlmsg, "Record not found.\n");
		sqlmsg_len = strlen(sqlmsg);
	} else if (sqlca.sqlcode == 0) {
		sqlmsg[0] = '\0';
		sqlmsg_len = 0;
	} else {
		rgetlmsg(sqlca.sqlcode, sqlmsg, 1024, &sqlmsg_len);
	}
	strip(sqlmsg);
	if (sqlca.sqlerrd[1] == 0) {
		isammsg[0] = '\0';
		isammsg_len = 0;
	} else {
		rgetlmsg(sqlca.sqlerrd[1], isammsg, 1024, &isammsg_len);
	}
	strip(isammsg);
	argv[5] = sqlmsg;
	argv[6] = isammsg;
    if (num) *num = 7;
    return argv;
}

int sql_sqld(fd, in) {
    struct sqlda *udesc;
    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_sqld", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -2;
    }
    if (in == 1) udesc = ssql[fd].in;
    else if (in == 2) udesc = ssql[fd].exec;
	else udesc = ssql[fd].out;

    if (udesc) return udesc->sqld;
    return -1;
}

/*
sql_sqlcols fd in colnames
sql_sqlcols fd in coltypes
sql_sqlcols fd in colcharlen
sql_sqlcols fd in coldblen
*/

char **sql_sqlcols(int fd, int in, char *arg, int *numvalues)
{
	struct sqlda *udesc;
	struct sqlvar_struct *col;
	static char **argv_names, **argv_types, **argv_charlen;
	static char **argv_dblen, ***argv;
	static int argv_len;
	char namebuf[255];
	int use_savedtypes = 0;
	int i, colcmd = 0;


	if (!arg || *arg == '\0') {
		sprintf(errmsg,
		"Need argument: colnames,coltypes,colcharlen or coldblen");
		strcat(errmsg, "to sql_sqlcols");
        debug(fprintf(stderr, "%s\n", errmsg);)
		return NULL;
	}
	if (strcmp(arg, "colnames") == 0) argv = &argv_names, colcmd = 1;
	else if (strcmp(arg, "coltypes") == 0) argv = &argv_types, colcmd = 2;
	else if (strcmp(arg, "colcharlen") == 0) argv = &argv_charlen, colcmd = 3;
	else if (strcmp(arg, "coldblen") == 0) argv = &argv_dblen, colcmd = 4;
	else {
		sprintf(errmsg,
		"Invalid argument %s to sql_sqlcols - need colnames,coltypes", arg);
		strcat(errmsg, ",colcharlen or coldblen");
        debug(fprintf(stderr, "%s\n", errmsg);)
		return NULL;
	}

    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_%s ", fd, arg);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }

    if (in == 1) udesc = ssql[fd].in;
    else if (in == 2) udesc = ssql[fd].exec;
    else {
		udesc = ssql[fd].out;
		use_savedtypes = 1;
	}

	if (!udesc) {
        sprintf(errmsg, "Invalid IN # %d passed to sql_%s ", in, arg);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
	}
	if (udesc->sqld <= 0) {
		sprintf(errmsg, "No %s available to sql_%s (sqld is %d)\n",
			arg, arg, udesc->sqld);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
	}

	if (*argv == NULL || argv_len == 0 || argv_len < udesc->sqld) {
		if (*argv) {
			for (i = 0; i < argv_len; i++)
				if ((*argv)[i]) free((*argv)[i]);
			free(*argv);
		}
		if (argv_len < udesc->sqld) argv_len = udesc->sqld;
        *argv = (char **)calloc(argv_len, sizeof(char *));
        if (!(*argv)) {
            sprintf(errmsg, "Cannot malloc for %d in SQLDA errno %d", 
                argv_len * sizeof(char *), errno);
            debug(fprintf(stderr, "%s\n", errmsg);)
            return NULL;
        }
		for (i = 0; i < argv_len; i++)
			(*argv)[i] = (char *)calloc(30, sizeof(char));
	}

    for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
		switch (colcmd) {
			case 1: 
				strcpy((*argv)[i] , col->sqlname); 
				break;
			case 2: 
				if (use_savedtypes == 1 && i < ssql[fd].arr_sqltype_len) 
					sprintf((*argv)[i],"%s",rtypname(ssql[fd].arr_sqltype[i]));
				else
					sprintf((*argv)[i] , "%s", rtypname(col->sqltype));
				break;
			case 3: 
				sprintf((*argv)[i] , "%d",  col->sqllen);
				break;
			case 4: 
				if (i < ssql[fd].arr_sqltype_len)
					sprintf((*argv)[i] , "%d",  ssql[fd].arr_sqllen[i]);
				else
					sprintf((*argv)[i], "%d", col->sqllen);
				break;
			default:
				sprintf(errmsg, "Invalid argument to sql_%s", arg);
				return NULL;
		}
	}
	if (numvalues) *numvalues = udesc->sqld;
	return *argv;
}

char **sql_sqlda(fd, in, num, numvalues) int *numvalues; {
    struct sqlda *udesc;
    struct sqlvar_struct *col;
    static char **argv;
    static char sqltype[255], sqllen[15], *sqldata, *sqlname, *sqlformat,
        sqlitype[255], sqlilen[15];
	int use_savedtypes = 0;
	static char sqltype_name[255], sqlitype_name[255];
	static char sqllen_num[15];

    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_sqlda", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }

    if (in == 1) udesc = ssql[fd].in;
    else if (in == 2) udesc = ssql[fd].exec;
    else {
		udesc = ssql[fd].out;
		use_savedtypes = 1;
	}

	if (!udesc) {
        sprintf(errmsg, "Invalid IN # %d passed to sql_sqlda", in);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
	}

    if (num < 0 || num >= udesc->sqld) {
        sprintf(errmsg, "Invalid num %d passed to sql_sqlda (>= %d)", num,
            udesc->sqld);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }
    if (!argv) {
        argv = (char **)calloc(11 , sizeof(char *));
        if (!argv) {
            sprintf(errmsg, "Cannot malloc for %d in SQLDA errno %d", 
                11 * sizeof(char *), errno);
            debug(fprintf(stderr, "%s\n", errmsg);)
            return NULL;
        }
    }
    col = udesc->sqlvar + num;
	if (use_savedtypes == 1 && num < ssql[fd].arr_sqltype_len) 
    	sprintf(argv[0] = sqltype, "%d", ssql[fd].arr_sqltype[num]);
	else sprintf(argv[0] = sqltype, "%hd", col->sqltype);
    sprintf(argv[1] = sqllen, "%hd", col->sqllen);
    argv[2] = col->sqldata;
	/* Fix this up with col->sqltype&SQL etc. ! */
    if (!argv[2]) argv[2] = "";
    argv[3] = col->sqlname;
    if (!argv[3]) argv[3] = "";
    argv[4] = col->sqlformat;
    if (!argv[4]) argv[4] = "";
    sprintf(argv[5] = sqlitype, "%hd", col->sqlitype);
    sprintf(argv[6] = sqlilen, "%hd", col->sqlilen);

	if (use_savedtypes == 1 && num < ssql[fd].arr_sqltype_len) 
    	sprintf(argv[7] = sqltype_name, "%s", 
			rtypname(ssql[fd].arr_sqltype[num]));
	else
    	sprintf(argv[7] = sqltype_name, "%s", rtypname(col->sqltype));

    sprintf(argv[8] = sqlitype_name, "%s", rtypname(col->sqlitype));
	if (num < ssql[fd].arr_sqltype_len) 
    	sprintf(argv[9] = sqllen_num, "%d", ssql[fd].arr_sqllen[num]);
	else
    	sprintf(argv[9] = sqllen_num, "%hd", col->sqllen);
    if (numvalues) *numvalues = 10;
    return argv;
}


char *sql_command(fd) {
    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_command", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return NULL;
    }
    return ssql[fd].cmd;
}

int sql_close(fd, argc, argv) 
    int fd;
    int argc;
    char **argv;
{
    struct sqlda *udesc;
    struct sqlvar_struct *col;

    
    if (fd < 0 || fd >= MAXFD || !ssql[fd].cmd) {
        sprintf(errmsg, "Invalid fd %d passed to sql_close", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
    }
    if (ssql[fd].is_select && ssql[fd].opened) {
        switch (fd) {
            case 0:
                $close c0; 
                break;
            case 1:
                $close c1; 
                break;
            case 2:
                $close c2; 
                break;
            case 3:
                $close c3; 
                break;
            case 4:
                $close c4; 
                break;
            case 5:
                $close c5; 
                break;
            case 6:
                $close c6; 
                break;
            case 7:
                $close c7; 
                break;
            case 8:
                $close c8; 
                break;
            case 9:
                $close c9; 
                break;
            case 10:
                $close c10; 
                break;
            case 11:
                $close c11; 
                break;
            case 12:
                $close c12; 
                break;
            case 13:
                $close c13; 
                break;
            case 14:
                $close c14; 
                break;
            case 15:
                $close c15; 
                break;
            case 16:
                $close c16; 
                break;
            case 17:
                $close c17; 
                break;
            case 18:
                $close c18; 
                break;
            case 19:
                $close c19; 
                break;
            case 20:
                $close c20; 
                break;
            default: toomany(fd);
        }
    }
    if (ssql[fd].cmd) free(ssql[fd].cmd); 
    ssql[fd].cmd = NULL;
    udesc = ssql[fd].in;
    if (udesc) {
        int i;
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
            if (col->sqldata) free(col->sqldata), col->sqldata = NULL;
        }
        if (udesc->sqlvar) free(udesc->sqlvar), udesc->sqlvar = NULL;
        free(udesc), udesc = NULL;
    }
    ssql[fd].in = NULL;
    udesc = ssql[fd].out;
    if (udesc) {
        int i;
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
			if (col->sqltype == CLOCATORTYPE) {
				loc_t *loc = (loc_t *)col->sqldata;
				if (loc && loc->loc_buffer) 
					free(loc->loc_buffer), loc->loc_buffer = NULL;
				if (loc && loc->loc_user_env) {
					BLOBENV *benv = (BLOBENV *)loc->loc_user_env;
					if (benv->byte_ptr) free(benv->byte_ptr);
					benv->byte_ptr = NULL;
					free(loc->loc_user_env), loc->loc_user_env = NULL;
				}
			}
            if (col->sqldata) free(col->sqldata), col->sqldata = NULL;
            if (col->sqlind) free(col->sqlind), col->sqlind = NULL;
        }
        /* Should not free udesc->sqlvar and udesc since describe
        allocates space for it */
#ifdef	FIXBUG
		if (udesc->sqlvar) free(udesc->sqlvar), udesc->sqlvar = NULL;
		free(udesc); udesc = NULL;
#endif
    }
	udesc = ssql[fd].out;
    ssql[fd].out = NULL;
	/* If out and exec are the same then no need to the following */
    if (udesc != ssql[fd].exec && ssql[fd].exec) {
        int i;
		udesc = ssql[fd].exec;
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
			if (col->sqltype == CLOCATORTYPE) {
				loc_t *loc = (loc_t *)col->sqldata;
				if (loc && loc->loc_buffer) 
					free(loc->loc_buffer), loc->loc_buffer = NULL;
				if (loc && loc->loc_user_env) {
					BLOBENV *benv = (BLOBENV *)loc->loc_user_env;
					if (benv->byte_ptr) free(benv->byte_ptr);
					benv->byte_ptr = NULL;
					free(loc->loc_user_env), loc->loc_user_env = NULL;
				}
			}
            if (col->sqldata) free(col->sqldata), col->sqldata = NULL;
            if (col->sqlind) free(col->sqlind), col->sqlind = NULL;
        }
        /* Should not free udesc->sqlvar and udesc since describe
        allocates space for it */
#ifdef	FIXBUG
		if (udesc->sqlvar) free(udesc->sqlvar), udesc->sqlvar = NULL;
		free(udesc); udesc = NULL;
#endif
    }
    ssql[fd].exec = NULL;
	if (ssql[fd].arr_sqltype_len > 0) {
		free(ssql[fd].arr_sqltype);
		ssql[fd].arr_sqltype = NULL;
		free(ssql[fd].arr_sqllen);
		ssql[fd].arr_sqllen = NULL;
		ssql[fd].arr_sqltype_len = 0;
	}
    memset(&ssql[fd], 0, sizeof(SSQL));
    return sqlca.sqlcode;
}

int sql_print(fd) {
    struct sqlda *udesc;
    struct sqlvar_struct *col;

    
    if (fd < 0 || fd >= MAXFD) {
        sprintf(errmsg, "Invalid fd %d passed to sql_print", fd);
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
    }
    printf("Command string for fd %d: %s", fd, 
            (ssql[fd].cmd?ssql[fd].cmd:"null"));
    if (!ssql[fd].opened) printf(" not ");
    printf(" opened, ");
    if (!ssql[fd].opened) printf(" not ");
    printf(" selected\n");
    if (ssql[fd].in) {
        int i;
        udesc = ssql[fd].in;
        printf("Input:");
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
            printf("(%s,%hd,%s)\n",col->sqlname, col->sqllen, col->sqldata);
        }
    }
    if (ssql[fd].out) {
        int i;
        udesc = ssql[fd].out;
        printf("Output:\n");
        for (i = 0, col = udesc->sqlvar; i < udesc->sqld; i++, col++) {
            printf("(%s,%hd,%s)\n",col->sqlname, col->sqllen, col->sqldata);
        }
    }
    return 0;
}

int sql_database(dbname, exclusive)
char *dbname;
int exclusive;
{
    $char *p;
    int len;

    if (!dbname || *dbname == '\0') {
        p = getenv("DATABASE");
        if (!p) p = "NODATABASE";
    }
    else p = dbname;
	if (exclusive) {
    	$database $p exclusive;
    	chk_status("DATABASE EXCLUSIVE", p);
	}
	else {
		$database $p;
    	chk_status("DATABASE", p);
	}
    if (database_name) {
		free(database_name);
    	database_name = NULL;
	}
    len = strlen(p) + 1;
    database_name = (char *)calloc(len, 1);
    errmalloc(database_name, "DATABASE", len);
    strcpy(database_name, p);
    return 0;
}

int sql_connect(dbname, uid, pw, cname, with_contrans) 
char *dbname, *uid, *pw, *cname;
int with_contrans;
{
    $char *p;
	$char *username;
	$char *password;
	$char *conn_name; 

    int len;
    if (!dbname || *dbname == '\0') {
        p = getenv("DATABASE");
        if (!p) p = "NODATABASE";
    }
    else p = dbname;
	conn_name = cname;
	username = uid;
	password = pw;
	if (cname && *cname != '\0') {
		if (with_contrans) {
    		$connect to $p as $conn_name user $username using $password 
				with concurrent transaction;
		} else {
    		$connect to $p as $conn_name user $username using $password;
		}
	} else {
		if (with_contrans) {
    		$connect to $p user $username using $password 
				with concurrent transaction;
		} else {
    		$connect to $p user $username using $password;
		}
	}
    chk_status("CONNECT", p);
    len = strlen(p) + 1;
    if (connection_name) {
		free(connection_name);
    	connection_name = NULL;
	}
    connection_name = (char *)calloc(len, 1);
    errmalloc(connection_name, "CONNECT", len);
    strcpy(connection_name, p);
    return 0;
}

int sql_disconnect(char *arg) {
	$char *cname;

	cname = arg;
	if (!arg) {
        sprintf(errmsg, "No argument passed to sql_disconnect");
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
	}
	if (strcmp(arg, "current") == 0) {
		$disconnect current;
	} else if (strcmp(arg, "default") == 0) {
		$disconnect default;
	} else if (strcmp(arg, "all") == 0) {
		$disconnect all;
	} else {
		$disconnect $cname;
	}
    chk_status("DISCONNECT", arg);
	return 0;
}

int sql_sigcmd(arg)
char *arg;
{
	$char *cname;

	cname = arg;
	if (!arg) {
        sprintf(errmsg, 
			"Argument must be one of sqlbreak, sqldetach, sqlexit, sqldone");
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
	}
	if (strcmp(arg, "sqlbreak") == 0) {
		return sqlbreak();
	} else if (strcmp(arg, "sqldetach") == 0) {
		return sqldetach();
	} else if (strcmp(arg, "sqlexit") == 0) {
		return sqlexit();
	} else if (strcmp(arg, "sqldone") == 0) {
		return sqldone();
	} else {
        sprintf(errmsg, 
			"Argument must be one of sqlbreak, sqldetach, sqlexit, sqldone");
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
	}
}

int sql_setconnection(arg, dormant)  
char *arg;
int dormant;
{
	$char *cname;

	cname=arg;
	if (!arg) {
        sprintf(errmsg, "No argument passed to sql_setconnection");
        debug(fprintf(stderr, "%s\n", errmsg);)
        return -1;
	}
	if (strcmp(arg, "current") == 0) {
		if (dormant) 
			$set connection current dormant;
		else
/* NOTE: COREDUMPs occur if dormant is removed and no connection is open !!!!*/
/* HENCE DORMANT IS ALWAYS USED */
			$set connection current dormant;
	} else if (strcmp(arg, "default") == 0) {
		if (dormant) 
			$set connection default dormant;
		else
			$set connection default;
	} else {
		if (dormant) 
			$set connection $cname dormant;
		else
			$set connection $cname;
	}
	if (dormant) {
    	chk_status("SET CONNECTION DORMANT", arg);
	}
	else {
    	chk_status("SET CONNECTION", arg);
	}
	return 0;
}

int sql_finish() {
    if (database_name) {
        free(database_name);
        database_name = NULL;
    }
	$close database;
	chk_status("CLOSE", "DATABASE");
    return 0;
}

int sql_begin() {
	$begin work;
	chk_status("BEGIN", "WORK");
	return 0;
}

int sql_commit() {
	$commit work;
	chk_status("COMMIT", "WORK");
	return 0;
}

int sql_rollback() {
	$rollback work;
	chk_status("ROLLBACK", "WORK");
	return 0;
}

char *sql_getdatabase() {
    return database_name;
}

/*
sql readblob table column "rowid = NUM" intofilename [append]
	if success (0) returns NULL or SIZE of blob written
	else returns ERROR (-1)
sql writeblob table column "rowid = NUM" [fromfilename | null] [size|-1]
	if success (0) returns SIZE of blob written
	else returns ERROR (-1)
*/
int sql_readblob(table, column, rowidclause, intofile, appendmode)
char *table, *column, *rowidclause, *intofile;
int appendmode;
{
	$loc_t sloc;
    $char stmt[BUFSIZ+1];

	if (atoi(rowidclause) > 0)
		sprintf(stmt, "select %s from %s where rowid = %s", 
			column, table, rowidclause);
	else
		sprintf(stmt, "select %s from %s where %s", column, table, rowidclause);
		

	sloc.loc_loctype = LOCFNAME;
	sloc.loc_fname  = intofile;

	if (appendmode)
		sloc.loc_oflags = LOC_APPEND;
	else
		sloc.loc_oflags = LOC_WONLY;

	$prepare tcl_readblob from $stmt;
    chk_status("PREPARE(READBLOB)", stmt);

	$declare tcl_readblob_cur cursor for tcl_readblob;
    chk_status("DECLARE(READBLOB)", stmt);

	$open tcl_readblob_cur;
    chk_status("OPEN(READBLOB)", stmt);

	$fetch tcl_readblob_cur into $sloc;
    chk_status("FETCH(READBLOB)", stmt);

	if (sqlca.sqlcode != 0) {
		sprintf(errmsg, "No record found.\n");
        debug(fprintf(stderr, "%s\n", errmsg);)
		return -1;
	}

	/*
	After getting it
	sloc.loc_size # of bytes, sloc.loc_indicator = -1 for null, 
	sloc.loc_status = 0 for success, -ve for error
	*/
	if (sqlca.sqlcode == 0 && sloc.loc_status == 0) {
		if (sloc.loc_indicator == -1) {
			$close tcl_readblob_cur;
			return -2;
		}
		$close tcl_readblob_cur;
		return sloc.loc_size;
	}
	$close tcl_readblob_cur;

	return -1;

}

int sql_writeblob(table, column, rowidclause, fromfile, fromsize)
char *table, *column, *rowidclause, *fromfile;
int fromsize;
{
	$loc_t uloc;
    $char stmt[BUFSIZ+1];
	$int found;
	$char *colname;

	colname = column;

	if (atoi(rowidclause) > 0)
		sprintf(stmt, "update %s set %s = ? where rowid = %s", 
			table, column, rowidclause);
	else
		sprintf(stmt, "update %s set %s = ? where %s", 
			table, column, rowidclause);

	/*
	sprintf(stmt, "select 1 from %s where %s FOR UPDATE OF %s", 
		table, rowidclause, column);
	*/

	uloc.loc_loctype = LOCFNAME;
	uloc.loc_fname = fromfile;
	uloc.loc_oflags = LOC_RONLY;
	uloc.loc_size  = fromsize;
	uloc.loc_indicator = 0;

	if (fromfile) 
		if (strcmp(fromfile,"null") == 0 || strcmp(fromfile, "NULL") == 0) 
			uloc.loc_indicator = -1;

	$prepare tcl_writeblob from $stmt;
    chk_status("PREPARE(WRITEBLOB)", stmt);

	$execute tcl_writeblob using $uloc;
    chk_status("EXECUTE(WRITEBLOB)", stmt);

	/*
	$declare tcl_writeblob_cur cursor for tcl_writeblob;
    chk_status("DECLARE(WRITEBLOB)", stmt);

	$open tcl_writeblob_cur;
    chk_status("OPEN(WRITEBLOB)", stmt);

	$fetch tcl_writeblob_cur into :found;
    chk_status("FETCH(WRITEBLOB)", stmt);

	sprintf(stmt, "update %s set %s = ? where current of tcl_writeblob_cur",
		table, column);

	$prepare tcl_writeblob_new from $stmt;
    chk_status("PREPARE UPDATE(WRITEBLOB)", stmt);

	$execute tcl_writeblob_new using $uloc;
    chk_status("EXECUTE UPDATE(WRITEBLOB)", stmt);

	*/

	/*
	After updating it
	uloc.loc_size # of bytes transferred
	uloc.loc_status = 0 for success, -ve for error
	*/
	if (sqlca.sqlcode == 0 && uloc.loc_status == 0) 
		return uloc.loc_size;

	return -1;
}

#ifdef TEST
main() {
    int fd, fd2;
    int ret = 0;
    char *argv[] = {
        "A*"};
    char *argv2[] = {
        "19"};
    char **argv3;
    int num;
    $database ni;
    fd = sql_open("select ne_id from com_ne_defn where ne_id matches ?", 
        1, argv);
    while (ret == 0) {
        ret = sql_fetch(fd);
        if (ret == 0) sql_print(fd);
    }
    printf("1st done\n");
    argv3 = sql_values(fd, &num, 0);
    if (!argv3) printf("No values for fd%d\n", fd);
    else {
        int i;
        for (i = 0; i < num; i++)
            printf("Value %d is %s\n", i, argv3[i]);
    }
    fd2 = sql_open("select ne_id from com_ne_defn where ne_id matches ?", 
        1, argv);
    ret = 0;
    while (ret == 0) {
        ret = sql_fetch(fd2);
        if (ret == 0) sql_print(fd2);
    }
    printf("2nd done\n");


    if (sql_exists("com_ne_defn", "ne_id", 0, 0)==0)
        printf("at least 1 ne exists\n");
    if (sql_exists("com_ne_defn", "ne_id", "AUSTT2", 0)==0)
        printf("ne AUSTT2 exists\n");
    if (sql_exists("com_ne_defn", "ne_id", 0, "ne_id matches 'A*'")==0)
        printf("ne matching A* exists\n");
    if (sql_run("set lock mode to wait", 0, 0) == 0)
        printf("successful lock mode\n");
    if (sql_run("update com_expected set xxxx = ?", 1, argv2) == 0)
        printf("successful update \n");
}
#endif
