#include "config.h"

#include <slang.h>
#include <_slang.h>

#include "util.h"

int 
sldxe_pop_doubles (double *a, double *b, double *c, double *d)
{
   if ((d != NULL) && (0 != SLang_pop_double (d, NULL, NULL)))
     return -1;
   if ((c != NULL) && (0 != SLang_pop_double (c, NULL, NULL)))
     return -1;
   if ((b != NULL) && (0 != SLang_pop_double (b, NULL, NULL)))
     return -1;
   if ((a != NULL) && (0 != SLang_pop_double (a, NULL, NULL)))
     return -1;

   return 0;
}

int 
sldxe_pop_ints (int *a, int *b, int *c, int *d)
{
   if ((d != NULL) && (0 != SLang_pop_integer (d)))
     return -1;
   if ((c != NULL) && (0 != SLang_pop_integer (c)))
     return -1;
   if ((b != NULL) && (0 != SLang_pop_integer (b)))
     return -1;
   if ((a != NULL) && (0 != SLang_pop_integer (a)))
     return -1;

   return 0;
}

SLang_Array_Type *
sldxe_pop_double_array (int strict)
{
   SLang_Array_Type *at;
   
   if ((strict == 0)
       && (-1 == _SLclass_typecast (SLANG_DOUBLE_TYPE, 1, 1)))
     return NULL;

   if (-1 == SLang_pop_array (&at, 1))
     return NULL;
   
   if (at->data_type != SLANG_DOUBLE_TYPE)
     {
	SLang_verror (SL_TYPE_MISMATCH, "Double array required, found %s",
		      SLclass_get_datatype_name (at->data_type));
	SLang_free_array (at);
	return NULL;
     }
   return at;
}

int 
sldxe_pop_2_double_arrays (SLang_Array_Type **at_p,
			  SLang_Array_Type **bt_p,
			  int strict)
{
   SLang_Array_Type *x, *y;

   if (NULL == (y = sldxe_pop_double_array (strict)))
     return -1;

   if (NULL == (x = sldxe_pop_double_array (strict)))
     {
	SLang_free_array (y);
	return -1;
     }
   
   if (x->num_elements != y->num_elements)
     {
	SLang_doerror ("Arrays to not match in size.");
	SLang_free_array (x);
	SLang_free_array (y);
	return -1;
     }
   
   *at_p = x;
   *bt_p = y;
   
   return 0;
}


