/* The usual include files */
#include "config.h"

#include <stdio.h>
#include <math.h>
#include <string.h>
#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#include <slang.h>
#include <_slang.h>

#if USE_PLPLOT

#define PL_DOUBLE
#include "plplot.h"
#include "slplplot.h"

#include "util.h"

static void do_plinit (void)
{
   plinit ();
}

static void do_pladv (int *d)
{
   pladv (*d);
}

static void do_plvpor (double *a, double *b, double *c, double *d)
{
   plvpor (*a, *b, *c, *d);
}

static void do_plwind (double *a, double *b, double *c, double *d)
{
   plwind (*a, *b, *c, *d);
}

static void do_plenv (double *a, double *b, double *c, double *d,
		      int *just, int *axis)
{
   plenv (*a, *b, *c, *d, *just, *axis);
}

static void do_plbox (char *s1, double *x1, int *i1,
		      char *s2, double *x2, int *i2)
{
   plbox (s1, *x1, *i1, s2, *x2, *i2);
}

static void do_pllab (char *a, char *b, char *c)
{
   pllab (a, b, c);
}


static void do_plline (void)
{
   SLang_Array_Type *x, *y;
   double *xdat, *ydat;
   unsigned int npts;

   if (-1 == sldxe_pop_2_double_arrays (&x, &y, 0))
     return;
   
   npts = x->num_elements;
   xdat = (double *)x->data;
   ydat = (double *)y->data;
   
   plline (npts, xdat, ydat);
   SLang_free_array (x);
   SLang_free_array (y);
}

static void do_plpoin (int *code)
{
   SLang_Array_Type *x, *y;
   double *xdat, *ydat;
   unsigned int npts;

   if (-1 == sldxe_pop_2_double_arrays (&x, &y, 0))
     return;

   npts = x->num_elements;
   xdat = (double *)x->data;
   ydat = (double *)y->data;

   plpoin (npts, xdat, ydat, *code);

   SLang_free_array (x);
   SLang_free_array (y);
}

static void do_plsym (int *code)
{
   SLang_Array_Type *x, *y;
   double *xdat, *ydat;
   unsigned int npts;

   if (-1 == sldxe_pop_2_double_arrays (&x, &y, 0))
     return;

   npts = x->num_elements;
   xdat = (double *) x->data;
   ydat = (double *) y->data;

   plsym (npts, xdat, ydat, *code);

   SLang_free_array (x);
   SLang_free_array (y);
}

static void do_plvasp (double *aspect)
{
   plvasp (*aspect);
}

static void do_plvpas (double *xmin, double *xmax, double *ymin, double *ymax,
		       double *aspect)
{
   plvpas (*xmin, *xmax, *ymin, *ymax, *aspect);
}

static void do_plhist (double *xmin, double *xmax, int *nbins, int *oldwin)
{
   SLang_Array_Type *x;
   double *xdat;
   int npts;

   if (NULL == (x = sldxe_pop_double_array (0)))
     return;
   
   npts = x->num_elements;
   xdat = (double *)x->data;
   
   plhist (npts, xdat, *xmin, *xmax, *nbins, *oldwin);

   SLang_free_array (x);
}

	
static void do_plspause (int *state)
{
   plspause (*state);
}

static void do_pllsty (int *style)
{
   pllsty (*style);
}

static void do_plssym (int *def, int *scale)
{
   plssym (*def, *scale);
}

static void do_plstar (int *nx, int *ny)
{
   plstar (*nx, *ny);
}

static void do_plstart (char *dev, int *nx, int *ny)
{
   plstart (dev, *nx, *ny);
}

static void do_plpsty (int *style)
{
   plpsty (*style);
}

static void do_plsori (int *style)
{
   plsori (*style);
}

static void do_plsdev (char *s)
{
   plsdev (s);
}

static int do_plgstrm (void)
{
   int d;
   
   plgstrm (&d);
   return d;
}

static int do_plmkstrm (void)
{
   int d;
   
   plmkstrm (&d);
   return d;
}

static void do_plreplot (void)
{
   plreplot ();
   plflush ();
}

static void do_plsstrm (int *d)
{
   plsstrm (*d);
}

static void do_plgpage (void)
{
   double x, y;
   int xlen, ylen, xoff, yoff;
   
   plgpage (&x, &y, &xlen, &ylen, &xoff, &yoff);
   SLang_push_double (x);
   SLang_push_double (y);
   SLang_push_integer (xlen);
   SLang_push_integer (ylen);
   SLang_push_integer (xoff);
   SLang_push_integer (yoff);
}

static void do_plspage (double *x, double *y, 
			int *xlen, int *ylen, int *xoff, int *yoff)
{
   plspage (*x, *y, *xlen, *ylen, *xoff, *yoff);
}

static void do_plprint (char *file, char *dev)
{
   int current_stream, new_stream;
   FILE *fp;
   
   if (strcmp (dev, "ps")
       && strcmp (dev, "xfig")
       && strcmp (dev, "plmeta"))
     {
	SLang_doerror ("plprint: invalid device");
	return;
     }
   
   fp = fopen (file, "w");
   if (fp == NULL)
     {
	SLang_verror (INTRINSIC_ERROR, "Unable to open %s", file);
	return;
     }
   
   plgstrm (&current_stream);
   
   plmkstrm (&new_stream);
   plsdev (dev);
   plsfile (fp);
   plcpstrm (current_stream, 0);
   pladv(0);
   
   do_plreplot ();
   plend1 ();
   
   plsstrm (current_stream);
   
   if (EOF == fclose (fp))
     {
	/* SLang_verror ("Error closing file %s", file); */
     }
}

static void do_plmtex (char *side, double *dist, double *pos, double *just,
		       char *text)
{
   plmtex (side, *dist, *pos, *just, text);
}

static void do_plptex (double *x, double *y, double *dx, double *dy, 
		       double *just, char *text)
{
   plptex (*x, *y, *dx, *dy, *just, text);
}

static void do_plcol (int *color)
{
   plcol (*color);
}

static void do_plfont (int *f)
{
   plfont (*f);
}

extern void plP_esc (int, char *);
static void do_plredraw (void)
{
   plP_esc (PLESC_REDRAW, NULL);
   plflush ();
}

#undef D
#undef I
#undef S
#define D SLANG_DOUBLE_TYPE
#define I SLANG_INT_TYPE
#define S SLANG_STRING_TYPE

static SLang_Intrin_Fun_Type Plplot_Intrinsics [] =
{
   MAKE_INTRINSIC_I("_pladv", do_pladv, VOID_TYPE),
   MAKE_INTRINSIC_6("_plbox", do_plbox, VOID_TYPE, S,D,I,S,D,I),
   MAKE_INTRINSIC_I("_plcol", do_plcol, VOID_TYPE),
   MAKE_INTRINSIC_6("_plenv", do_plenv, VOID_TYPE, D,D,D,D,I,I),
   MAKE_INTRINSIC_I("_plfont", do_plfont, VOID_TYPE),
   MAKE_INTRINSIC("_plgpage", do_plgpage, VOID_TYPE, 0),
   MAKE_INTRINSIC("_plgstrm", do_plgstrm, INT_TYPE, 0),
   MAKE_INTRINSIC_4("_plhist", do_plhist, VOID_TYPE, D,D,I,I),
   MAKE_INTRINSIC("_plinit", do_plinit, VOID_TYPE, 0),
   MAKE_INTRINSIC_SSS("_pllab", do_pllab, VOID_TYPE),
   MAKE_INTRINSIC("_plline", do_plline, VOID_TYPE, 0),
   MAKE_INTRINSIC_I("_pllsty", do_pllsty, VOID_TYPE),
   MAKE_INTRINSIC("_plmkstrm", do_plmkstrm, INT_TYPE, 0),
   MAKE_INTRINSIC_5("_plmtex", do_plmtex, VOID_TYPE, S,D,D,D,S),
   MAKE_INTRINSIC_I("_plpoin", do_plpoin, VOID_TYPE),
   MAKE_INTRINSIC_SS("_plprint", do_plprint, VOID_TYPE),
   MAKE_INTRINSIC_I("_plpsty", do_plpsty, VOID_TYPE),
   MAKE_INTRINSIC_6("_plptex", do_plptex, VOID_TYPE, D,D,D,D,D,S),
   MAKE_INTRINSIC("_plreplot", do_plreplot, VOID_TYPE, 0),
   MAKE_INTRINSIC_S("_plsdev", do_plsdev, VOID_TYPE),
   MAKE_INTRINSIC_I("_plsori", do_plsori, VOID_TYPE),
   MAKE_INTRINSIC_6("_plspage", do_plspage, VOID_TYPE,D,D,I,I,I,I),
   MAKE_INTRINSIC_I("_plspause", do_plspause, VOID_TYPE),
   MAKE_INTRINSIC_I("_plsstrm", do_plsstrm, VOID_TYPE),
   MAKE_INTRINSIC_II("_plssym", do_plssym, VOID_TYPE),
   MAKE_INTRINSIC_II("_plstar", do_plstar, VOID_TYPE),
   MAKE_INTRINSIC_SII("_plstart", do_plstart, VOID_TYPE),
   MAKE_INTRINSIC_I("_plsym", do_plsym, VOID_TYPE),
   MAKE_INTRINSIC_1("_plvasp", do_plvasp, VOID_TYPE, D),
   MAKE_INTRINSIC_5("_plvpas", do_plvpas, VOID_TYPE, D,D,D,D,D),
   MAKE_INTRINSIC_4("_plvpor", do_plvpor, VOID_TYPE, D,D,D,D),
   MAKE_INTRINSIC_4("_plwind", do_plwind, VOID_TYPE, D,D,D,D),
   
   MAKE_INTRINSIC("_plvsta", plvsta, VOID_TYPE, 0),
   MAKE_INTRINSIC("_plflush", plflush, VOID_TYPE, 0),
   MAKE_INTRINSIC("_plclr", plclr, VOID_TYPE, 0),
   MAKE_INTRINSIC("_plend", plend, VOID_TYPE, 0),
   MAKE_INTRINSIC("_plend1", plend1, VOID_TYPE, 0),

   MAKE_INTRINSIC("_plredraw", do_plredraw, VOID_TYPE, 0),
   SLANG_END_TABLE
};
#undef D
#undef I

int sldxe_init_plplot (void)
{
   int stupid_argc;
   char *stupid_argv[2];
   stupid_argv[0] = "stupid";
   stupid_argv[1] = NULL;
   stupid_argc = 1;
   
   (void) plParseOpts (&stupid_argc, stupid_argv, PL_PARSE_FULL);
   
   return SLadd_intrin_fun_table (Plplot_Intrinsics, "__PLPLOT__");
}

#endif				       /* USE_PLPLOT */
