_debug_info = 1;

define _pack_args (n)
{
   variable args = Struct_Type [n];
   variable i, arg, s;
   
   while (n > 0)
     {
	n--;
	s = struct 
	  {
	     value
	  };
	s.value = ();
	args[n] = s;
     }
   args;
}

define _unpack_args (args)
{	
   variable i;
   
   _for (0, length(args) - 1, 1)
     {
	i = ();
	args[i].value;
     }
}


autoload ("marx_read_file", "marx.sl");
autoload ("marx_make_spec", "marx.sl");

define is_complex (x)
{     
   variable ndims;
   variable t = typeof (x);

   if (t == Array_Type)
     (,,t) = array_info (x);
   
   (t == Complex_Type);
}


define fprintf ()
{
   variable str;
   variable fp;
   
   str = Sprintf (_NARGS - 2);	       %  skip fmt and fp
   fp = ();
   () = fputs (str, fp);
   () = fflush (fp);
}

define printf ()
{
   variable str;
   
   str = Sprintf (_NARGS - 1);	       %  skip fmt
   () = fputs (str, stdout);
   () = fflush (stdout);
}

define p (x)
{
   printf ("%s\n", string(x));
}
   

define use_plplot ()
{
#ifdef __PLPLOT__
   () = evalfile ("plplot.sl");
#else
   p ("**** plplot not available");
#endif
}


define verror ()
{
   error (Sprintf (_NARGS - 1));
}

define usage ()
{
   variable s = Sprintf (_NARGS - 1);
   if (_traceback == 1) _traceback = 0;
   else _traceback = -1;
   verror ("Usage: %s\n", s);
}

define sldxe_take_input_hook ()
{
   while (_stkdepth ())
     p ();
}


% an apropos function
define apropos ()
{
   !if (_NARGS)
     {
	usage ("apropos (\"keyword\")");
	return;
     }

   variable what = ();
   variable n = _apropos(what, 0xFF);
   variable i, f1, f2, f3;

   !if (n)
     {
	printf ("No matches\n");
	return;
     }
   
   printf ("Found %d matches:\n", n);

   loop (n / 3) 
     {
	(f3, f2, f1) = ();
	printf ("%-26s %-26s %s\n", f1, f2, f3);
     }
   n = n mod 3;
   loop (n)
     {
	f1 = ();
	printf ("%-26s ", f1);
     }
   
   printf ("\n");
}


define any (x)
{
   % where returns a 2-d integer array of indices
   length (where (x));
}


% Statistical Functions
define mean ()
{
   mean_stddev ();		       %  ==> mean, stddev
   pop ();
}

define stddev ()
{
   mean_stddev ();		       %  ==> mean, stddev
   exch(); pop();
}

define least_sqr_fit ()
{
   variable x,y;
   variable n, a, b;
   variable s1, sx, sy, sxy, sxx, d;
   
   !if (_NARGS == 2)
     usage ("(m,b) = least_sqr_fit (x,y)");

   (x,y) = ();
   n = length(x);
   
   s1 = n;
   sx = sum (x);
   sy = sum (y);
   sxx = sumsq (x);
   sxy = sum (x * y);

   d = s1 * sxx - sx * sx;
   
   a = (sy * sxx - sx * sxy) / d;
   b = (s1 * sxy - sx * sy) / d;
   
   return (a, b);
}


% file functions

define strncat (n)
{
   n--;
   loop (n) strcat ();
}

define dircat (dir, f)
{
   strncat(dir, "/", f, 3);
}

define add_to_library_path (path)
{
   !if (strlen (path))
     return;

   set_library_path (get_library_path () + ":" + path);
}

$1 = getenv ("HOME");

if (NULL != $1)
{
   add_to_library_path ($1);
   $1 = dircat ($1, ".sldxerc");
   if (NULL != stat_file ($1))
     () = evalfile ($1);
}

% () = evalfile ("marx.sl");
% use_plplot ();
