_debug_info = 1;

variable Plot_Inited = 0;

typedef struct
{
   stream,
   color,
   xlabel,
   ylabel,
   title,
   use_lines,
   xmin, xmax, ymin, ymax,
   linestyle,
   pointstyle,
   logx,
   logy,
   axes
}
PLplot_Type;

variable Plot_Device = "xwin";
variable Plot_Max_Windows = 10;
variable PLPlots = PLplot_Type [Plot_Max_Windows];
variable PLPlot_This;

for ($1 = 0; $1 < Plot_Max_Windows; $1++)
{
   PLPlot_This = PLPlots[$1];
   PLPlot_This.xmin = NULL;
   PLPlot_This.xmax = NULL;
   PLPlot_This.ymin = NULL;
   PLPlot_This.ymax = NULL;
   PLPlot_This.stream = -1;
   PLPlot_This.color = 1;
   PLPlot_This.xlabel = "";
   PLPlot_This.ylabel = "";
   PLPlot_This.title = "";
   PLPlot_This.use_lines = 1;
   PLPlot_This.linestyle = 1;
   PLPlot_This.pointstyle = 1;
   PLPlot_This.logx = 0;
   PLPlot_This.logy = 0;
   PLPlot_This.axes = 0;
   % 11 ==> y left, x bot
   % 12 ==> y right, x bot
   % 21 ==> x top, y left
   % 22 ==> x top, y right
}

PLPlot_This = PLPlots[0];


define pset ()
{
   variable xlen = 400, ylen = 300, xoff = 200, yoff = 200;   
   variable x = 0, y = 0;
   variable w, s;

   !if (_NARGS) 0;
   w = ();
   
   if (w >= Plot_Max_Windows)
     error ("pset: argument out of range.");
   
   PLPlot_This = PLPlots [w];
   s = PLPlot_This.stream;

   if (s == -1)
     {
	s = 0;
	if (w != 0) s = _plmkstrm ();
	
	PLPlot_This.stream = s;
	
	_plsdev (Plot_Device);
	_plspage (x, y, xlen, ylen, xoff, yoff);
	_plinit ();
	_pladv (0);
     }
   
   _plsstrm (s);
}

define plplot_init ()
{
   if (Plot_Inited) return;
   Plot_Inited++;
   pset (0);
}

define plprint ()
{
   variable dev = "ps";
   variable file = "out.ps";
   
   if (_NARGS == 2)
     {
	dev = ();
	file = ();
     }
   else if (_NARGS == 1)
     {
	file = ();
     }
   
   _plprint (file, dev);
   fprintf (stdout, "%s created.\n", file);
}


define pset_x (xmin, xmax)
{
   PLPlot_This.xmin = xmin;
   PLPlot_This.xmax = xmax;
}

define pset_y (ymin, ymax)
{
   PLPlot_This.ymin = ymin;
   PLPlot_This.ymax = ymax;
}

define pset_xy (xmin, xmax, ymin, ymax)
{
   pset_x (xmin, xmax);
   pset_y (ymin, ymax);
}

define pset_auto ()
{
   pset_xy (NULL, NULL, NULL, NULL);
}

define pset_title (title)
{
   PLPlot_This.title = title;
}

define pset_xlabel (label)
{
   PLPlot_This.xlabel = label;
}

define pset_ylabel (label)
{
   PLPlot_This.ylabel = label;
}

define pset_lines ()
{
   if (_NARGS)
     PLPlot_This.linestyle = ();
   PLPlot_This.use_lines = 1;
}

define pset_points ()
{
   if (_NARGS)
     PLPlot_This.pointstyle = ();
   PLPlot_This.use_lines = 0;
}

define pset_color ()
{
   !if (_NARGS) 1;
   PLPlot_This.color = ();
}

define pset_logx ()
{
   !if (_NARGS) not(PLPlot_This.logx);
   PLPlot_This.logx = ();
}

define pset_logy ()
{
   !if (_NARGS) not(PLPlot_This.logy);
   PLPlot_This.logy = ();
}

define pset_axes ()
{
   !if (_NARGS) 0;
   PLPlot_This.axes = ();
}

define is_everywhere_finite (x)
{
   not (any (not (isfinite (x))));
}


define _pset_axis_limit (x, val, dolog)
{
   if (x != NULL) 
     {
	!if (dolog)
	  return x;
	
	if (x > 0)
	  return log10 (x);
     }
   
   return val;
}


define plplot_check_xy (x, y)
{
   variable i;
   variable fmt = "***plot2d: not all elements of %c array are finite.\n";

   !if (is_everywhere_finite (x))
     {
	printf (fmt, 'X');
	i = isfinite(x);
	x = x[i];
	y = y[i];
     }
   
  !if (is_everywhere_finite (y))
     {
	printf (fmt, 'Y');
	i = isfinite(y);
	x = x[i];
	y = y[i];
     }

   if (PLPlot_This.logx)
     {
	if (any (x <= 0))
	  {
	     printf ("Ignoring values with log x <= 0\n");
	     i = where (x > 0);
	     x = x[i];
	     y = y[i];
	  }

	x = log10 (x);
     }
   
   if (PLPlot_This.logy)
     {
	if (any (y <= 0))
	  {
	     printf ("Ignoring values with log y <= 0\n");
	     i = where (y > 0);
	     x = x [i];
	     y = y [i];
	  }
	y = log10 (y);
     }

   return (x, y);
}

define plplot_replot2d (x, y)
{
   PLPlot_This.color++;
   _plcol (PLPlot_This.color);
   
   if (PLPlot_This.use_lines) 
     {
	_pllsty (PLPlot_This.linestyle);
	_plline (x, y);
     }
   else 
     {
	_plpsty (PLPlot_This.pointstyle);
	_plpoin(x, y, 1);
     }

   _plflush ();
}

define plot2d ()
{
   variable x, y;
   variable x0, x1, y0, y1;
   variable logx, logy;
   variable xdiff, ydiff;
   variable axes;
   variable xopts, yopts;

   if ((_NARGS > 2) or (_NARGS == 0))
     error ("Usage: plot2d (x [,y]);");

   if (_NARGS == 1)
     {
	y = ();
	[1.0: length (y)];
	y;
     }

   (x, y) = ();

   plplot_init ();
   _plspause (0);
   _pladv(0);
   _plclr ();
   
   PLPlot_This.color = 1;

   % plvpor(0.15, 0.70, 0.5, 0.9);
   _plvasp (1.0);
   
   x0 = PLPlot_This.xmin;
   x1 = PLPlot_This.xmax;
   y0 = PLPlot_This.ymin;
   y1 = PLPlot_This.ymax;

   logx = PLPlot_This.logx;
   logy = PLPlot_This.logy;
     
   (x, y) = plplot_check_xy (x, y);

   x0 = _pset_axis_limit (x0, min(x), logx);
   x1 = _pset_axis_limit (x1, max(x), logx);
   y0 = _pset_axis_limit (y0, min(y), logy);
   y1 = _pset_axis_limit (y1, max(y), logy);
   
   if (x0 == x1)
     {
	x0 = 0.9 * x0;
	x1 = 1.1 * x1; x1++;
     }

   if (y0 == y1)
     {
	y0 = 0.9 * y0;
	y1 = 1.1 * y1; y1++;
     }
	
   xdiff = (x1 - x0) / 20;
   ydiff = (y1 - y0) / 20;
   
   x0 -= xdiff;
   x1 += xdiff;
   y0 -= ydiff;
   y1 += ydiff;

   _plwind(x0, x1, y0, y1);
   axes = PLPlot_This.axes;

   xopts = "st";
   yopts = "stv";

   if (axes == 0)
     {
	xopts = strcat (xopts, "bcn");
	yopts = strcat (yopts, "bcn");
     }
   else
     {
	if ((axes / 10) == 1) xopts = strcat (xopts, "bcn");
	else xopts = strcat (xopts, "cm");
	if ((axes mod 2) == 1) yopts = strcat (yopts, "bn");
	else yopts = strcat (yopts, "cm");
     }
					      
   if (PLPlot_This.logx) xopts = strcat (xopts, "l");
   if (PLPlot_This.logy) yopts = strcat (yopts, "l");
   
   _plcol (1);
   
   _plbox(xopts, 0.0, 0, yopts, 0.0, 0);
   _pllab(PLPlot_This.xlabel, PLPlot_This.ylabel, PLPlot_This.title);
   
   plplot_replot2d (x, y);
}

define replot2d ()
{
   variable x, y;

   if ((_NARGS > 2) or (_NARGS == 0))
     usage ("replot2d (x [,y]);");

   if (_NARGS == 1)
     {
	y = ();
	[1.0: length (y)];
	y;
     }

   plplot_init ();
   plplot_replot2d (plplot_check_xy ((), ()));
}

define plplot_make_histogram ()
{
   variable a, amin, amax;
   variable x, dx;

   switch (_NARGS)
     {
      case 2:
	(a, dx) = ();
	amin = min (a);
	amax = max (a);
     }
     {
      case 4:
	(a, dx, amin, amax) = ();
     }
     {
	pop ();
	_pop_n (_NARGS);
	usage ("plothist (ARRAY, BINSIZE [,MIN, MAX])");
     }
   
   [amin:amax:dx];
   histogram (a, dx, amin, amax);
}

define plothist ()
{
   variable args = _pack_args (_NARGS);
   plot2d (plplot_make_histogram (_unpack_args (args)));
}

define replothist ()
{
   variable args = _pack_args (_NARGS);
   replot2d (plplot_make_histogram (_unpack_args (args)));
}

define plplot_file ()
{
   variable colx, coly, file;

   switch (_NARGS)
     {
      case 1:
	file = ();
	(colx, coly) = readcol (file, 1, 2);
     }
     {
      case 2:
	coly = ();
	file = ();
	coly = readcol (file, coly);
	colx = [1:length(coly)];
     }
     {
      case 3:
	coly = ();
	colx = ();
	file = ();
	(colx, coly) = readcol (file, colx, coly);
     }
     {
	pop ();
	_pop_n (_NARGS);
	usage ("plplot_file (file [,col [,col]]);");
	return;
     }
   
   plot2d (colx, coly);
}

   
   
