define marx_read_file ()
{
   if (_NARGS != 1)
     {
	loop (_NARGS) pop ();
	usage ("x = %s (file)", _function_name ());
     }
   
   variable file = ();

   variable fp = fopen (file, "rb");
   variable colname;
   variable type;
   variable num_rows, num_cols, nread;
   variable data;
   
   ERROR_BLOCK
     {
	() = fclose (fp);
     }
   
   variable magic;
   
   magic = fread_string (fp, 4);
   if (strcmp (magic, "\x83\x13\x89\x8D"))
     error ("File has a bad magic number.");
   
   type = fread_bytes (fp, 1);

   colname = fread_string (fp, 15);
   num_rows = fread_int32 (fp, 1);
   num_cols = fread_int32 (fp, 1);
   !if (num_cols) num_cols = 1;

   () = fread_string (fp, 4);
   
   switch (type)
     {
      case 'A':
	data = fread_bytes (fp, 0);
     }
     {
      case 'I':
	data = fread_int16 (fp, 0);
     }
     {
      case 'J':
	data = fread_int32 (fp, 0);
     }
     {
      case 'E':
	data = fread_float32 (fp, 0);
     }
     {
      case 'D':
	data = fread_float64 (fp, 0);
     }
     {
	pop ();
	error (Sprintf ("file type '%c' not supported.", type, 1));
     }

   () = fclose (fp);
   
   nread = length (data);
   if (nread != num_rows * num_cols)
     {
	fprintf (stdout, "Expected %d elements, got %d\n",
		 num_rows * num_cols, nread);
	return data;
     }

   if (num_cols > 1)
     reshape (data, [num_rows, num_cols]);

   return data;
}

   
	     
define marx_extract_spec ()
{
   variable hml, maxdist, y, z, y0, z0;
   if (_NARGS != 6)
     {
	loop (_NARGS) pop ();
	usage ("(dd, dxd) = %s (hml, maxdist, y, z, y0, z0)", 
	       _function_name ());
     }

   (hml, maxdist, y, z, y0, z0) = ();

   variable alpha, dd, dxd, list_selected, neg_coords;
   
   hml = hml | 0x20;			       %  lowercase
   if (hml == 'h')
     alpha = -5;
   else if (hml == 'm')
     alpha = 5;
   else alpha = 0;
   
   alpha = alpha * PI / 180.0;
   
   y -= y0;
   z -= z0;
   
   dxd = -y * sin(alpha) + z * cos(alpha);
   dd = y * cos (alpha) + z * sin(alpha);

   list_selected = where (abs (dxd) < maxdist);
#iffalse
   neg_coords = where (y < 0.0);
   if (length (neg_coords))
     dd[neg_coords] = -dd[neg_coords];
#endif
   
   dd = dd[list_selected]; 
   dxd = dxd[list_selected];
   
#iftrue
   dd = abs (dd);
#endif
   return (dd, dxd);
}


define marx_make_spec ()
{
   if (_NARGS != 2)
     {
	usage ("(en, counts) = %s (marx_dir, hml);", _function_name ());
	return;
     }
   
   variable dir, hml;
   
   (dir, hml) = ();
   
   variable ypos, zpos, dd, dxd;
   variable spec, num;
   variable rowland_torus = 8634.0;
   variable meg_period = 0.400141;
   variable heg_period = 0.200081;
   variable leg_period = 0.991249;
   variable h = 12.39854;
   variable grid, i;
   variable const, en;
   variable period;
   variable pixel_size;

   switch (hml | 0x20)
     {
      case 'h':
	period = heg_period;
	pixel_size = 0.024;
     }
     {
      case 'm':
	period = meg_period;
	pixel_size = 0.024;
     }
     {
	pop ();
	period = leg_period;
	pixel_size = 0.024;
     }

   const = (h * rowland_torus) / (period * 1e4);

   ypos = marx_read_file (strcat (dir, "/ypos.dat"));
   zpos = marx_read_file (strcat (dir, "/zpos.dat"));
   
   (dd, dxd) = marx_extract_spec (hml, 0.2, ypos, zpos, 0, 0);
   dd = dd[where (dd > 2.0)];
   
   spec = histogram (dd, pixel_size);
   grid = [min(dd): max(dd): pixel_size];

   en = const / grid;
   
   % Sort them in ascending order */
   i = sort (en);
   en = en[i];
   spec = spec[i];

   return (en, spec);
}


typedef struct
{
   name, type, mode, value, min_value, max_value, prompt, next
}
Param_File_Type;

define marx_read_par_file ()
{
   variable file;
   variable fp;
   variable line, len;
   variable linenum, value;
   variable pf, root_pf, last_pf;

   if (_NARGS != 1)
     {
	_pop_n (_NARGS);
	usage ("p = %s (par_file_name);", _function_name ());
	return NULL;
     }
   
   file = ();
   fp = fopen (file, "r");
   if (-1 == fp)
     verror ("Unable to open %s", file);

   linenum = 0;
   root_pf = NULL;
   last_pf = NULL;

   while (len = fgets (fp), len > 0)
     {
	linenum++;
	
	line = strtrim (());
	if (line[0] == '#')
	  continue;

	len = strchop (line, ',', '\\');
	if (len != 7)
	  {
	     printf ("line %d of %s has wrong number of fields\n",
		     linenum, file);
	     _pop_n (len);
	     continue;
	  }
	
	pf = @Param_File_Type;
	pf.prompt = ();
	pf.max_value = ();
	pf.min_value = ();
	value = ();
	pf.mode = ();
	pf.type = ();
	pf.name = ();
	
	switch (pf.type)
	  {
	   case 'r':		       %  real
	     pf.value = double (value);
	  }
	  {
	   case 'i':		       %  integer
	     pf.value = integer (value);
	  }
	  {
	   case 'b':		       %  boolean
	     if (strcmp (value, "no")) pf.value = 0; else pf.value = 1;
	  }
	  {
	     pop ();		       %  default
	     pf.value = value;
	  }
	
	pf.next = NULL;
	if (last_pf == NULL)
	  root_pf = pf;
	else
	  last_pf.next = pf;
	
	last_pf = pf;
     }
   
   () = fclose (fp);
   return root_pf;
}

define marx_get_par_value ()
{
   variable pf, name;

   if (_NARGS != 2)
     {
	_pop_n (_NARGS);
	usage ("VALUE = marx_get_par_value (\"PARM NAME\", ParmList);");
	return NULL;
     }
   
   (name, pf) = ();
   
   while (pf != NULL)
     {
	!if (strcmp (name, pf.name))
	  return pf.value;
	
	pf = pf.next;
     }
   
   return NULL;
}


	
   
   
