variable Grating_Energies = [0.1: 10.0: 10.0/1024];
variable Grating_Orders = [1:11];
variable Grating_Efficiencies = dblarray (length(Grating_Orders),
					  length(Grating_Energies));

define grating_init (opt_file)
{
   variable width = 0.11;
   variable period = 0.20;
   variable height = 0.7;
   variable t_polyimide = 1.0;
   variable t_gold = 0.02;
   variable t_nickel = 0.0;
   variable t_chromium = 0.0;
   
   variable hbar_c = 1.973289e-4;      %  KeV-microns
   
   variable delta, beta, gold, nickel, chromium, polyimide;
   variable energy, order;
   
   (energy, beta, delta, gold, polyimide, chromium, nickel)
     = readcol (opt_file, 1, 2, 3, 4, 5, 6, 7);
   
   % interpolate on our energy grid
   beta = interpol (Grating_Energies, energy, beta);
   delta = interpol (Grating_Energies, energy, delta);
   gold = interpol (Grating_Energies, energy, gold);
   polyimide = interpol (Grating_Energies, energy, polyimide);
   chromium = interpol (Grating_Energies, energy, chromium);
   nickel = interpol (Grating_Energies, energy, nickel);
   energy = 0;
   
   gold = 1000.0 * log (gold);
   polyimide = 1000 * log (polyimide);
   chromium = 1000 * log (chromium);
   nickel = 1000 * log (nickel);
   
   variable k, kh, khb, ekhb, a, b, i, eff, t_factor, amp;
   
   k = Grating_Energies / hbar_c;
   kh = height * k;
   khb = kh * beta;
   ekhb = exp (-khb);
   
   b = width / period;
   a = 1 - b;

   t_factor = exp (t_polyimide * polyimide
		   + t_gold * gold
		   + t_chromium * chromium
		   + t_nickel * nickel);
   
   _for (0, length (Grating_Orders) - 1, 1)
     {
	i = ();
	order = Grating_Orders[i];

	amp = sin (order * PI * a) / (order * PI);
	eff = amp * amp * (1 + ekhb * (ekhb - 2.0 * cos (kh * delta)));
	Grating_Efficiencies [i] =  eff * t_factor;
     }
}

   
   
   
   
   
   
   
