/*
 * Copyright 1990,1991 the Regents of the University of California.  All
 * rights reserved.  Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that this copyright notice appear in all
 * copies.  See the file copyright.h for more information.
 *
 */

#include <stdio.h>
#include <sys/file.h>

#include "debug.h"
#include "global.h"
#include "util.h"         /* SaveTerminal */

#include <sys/param.h>	/* for MAXPATHLEN */
#ifndef MAXPATHLEN
#define	MAXPATHLEN	1024
#endif

MyResourcesType MyResources;

XrmOptionDescRec options[] = {
	{ "-exec", "exec", XrmoptionSepArg, (caddr_t) NULL },
	{ "-file", "file", XrmoptionSepArg, (caddr_t) NULL },
	{ "-setupPath", "setupPath", XrmoptionSepArg, (caddr_t) NULL },
	{ "-tclname", "tclname", XrmoptionSepArg, (caddr_t) NULL },
};

#define offset(field) XtOffset(MyResourcesTypePtr,field)

XtResource resources[] = {
    /* {name, class, type, size, offset, default_type, default_addr}, */
	{ "exec", "Exec", XtRString, sizeof(String),
	  offset(exec), XtRString, NULL },
	{ "file", "File", XtRString, sizeof(String),
	  offset(file), XtRString, NULL },
	{ "setupPath", "SetupPath", XtRString, sizeof(String),
	  offset(SetupPath), XtRString, XCBISETUPPATH },
};

#undef offset

char		*ProgramName;

Widget		TopLevel;
XtAppContext	AppCon;
int		GlobalArgc;
char		**GlobalArgv;

void
main (argc,argv)
	int argc;
	char **argv;
{
	char cmd[MAXLINE];
	int i;

	ProgramName = rindex(argv[0], '/');
	if (ProgramName)
		ProgramName++;
	else
		ProgramName = argv[0];

	entering("main");
	set_debuglevel(0);
	SaveTerminal();
	TopLevel = XtAppInitialize(&AppCon,"XCbi",options,XtNumber(options),
				   &argc,argv,NULL,NULL,ZERO);
	XtGetApplicationResources(TopLevel,(caddr_t)&MyResources,
				  resources,XtNumber(resources),NULL,0);
	if (argv[1] && (strcmp("-help",argv[1]) == 0)) {
		printf(stderr,
		       "Usage: %s [ Xtoolkitoptions... ] [ -file setupfile ]\n",
		       ProgramName);
		exit(1);
	}
	/* setup global argc and argv for use by argc and argv command */
	GlobalArgc = argc;
	GlobalArgv = (char **) XtMalloc((sizeof(char*))*argc);
	for (i = 0; i < argc; i++) {
		GlobalArgv[i] = XtNewString(argv[i]);
	}
	InitializeInterpreters();
	Tcl_SetVar(mainInterp,"setuppath",MyResources.SetupPath,0);
	/* now try to execute any command line xcbi commands */
	InterpretCommand(MyResources.exec);
	if (!MyResources.file) {
		MyResources.file = XtMalloc(strlen(ProgramName)
					    + sizeof(".setup")-1 + 1);
		sprintf(MyResources.file, "%s.setup", ProgramName);
	}
	if (MyResources.file) {
		char *file = LocateFile(MyResources.file,
					MyResources.SetupPath);
		if (!file) {
			fprintf(stderr, "%s: unable to find %s\n",
				ProgramName, MyResources.file);
			exit(1);
		}
		XtFree(MyResources.file);
		MyResources.file = XtNewString(file);
	}
	sprintf(cmd,"source %s", MyResources.file);
	if (Tcl_RecordAndEval(mainInterp,cmd,0) != TCL_OK) {
		printf("Error: %s\n",mainInterp->result);
		sprintf(cmd,"textcreate text");
		Tcl_RecordAndEval(mainInterp,cmd,0);
	}
	XtRealizeWidget(TopLevel);
	/* ResizeOuterPane(); can't call this because text.rows doesn't 
	   exist */
	XtAppMainLoop(AppCon);
}


/*
 * char *LocateFile(char *file, char *dirlist)
 *
 * Returns a pathname for file.  If file doesn't begin with a slash (``/'')
 * it will be searched for in each of the colon (``:'') separated
 * directories listed in dirlist.  If the search fails to find file in any
 * of the directories, NULL will be returned.  The names returned are
 * pointers into a static area that are overwritten on consequtive calls to
 * LocateFile.
 */
char *
LocateFile(file, dirlist)
	char *file, *dirlist;
{
	register char *cp, *dp;
	register int n, flen;
	static char path[MAXPATHLEN];

	if (file[0] == '/') {
		strcpy(path, file);
		return(path);
	}
	flen = strlen(file);
	for (dp = dirlist; ; dp = cp+1) {
		for (cp = dp; *cp && *cp != ':'; cp++)
			continue;
		n = cp - dp;
		if (sizeof(path) < n + 1 + flen + 1) {
			fprintf(stderr, "%s: path too long \"%.*s/%s\"\n",
				ProgramName, n, dp, file);
			continue;
		}
		sprintf(path, "%.*s/%s", n, dp, file);
		if (access(path, R_OK) == 0)
			return(path);
		if (!*cp)
			break;
	}
	return(NULL);
}
