'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /sprite/src/lib/tcl/RCS/Tcl_GetInt.man,v 1.2 90/07/28 10:59:43 ouster Exp $ SPRITE (Berkeley)
'\" 
.so \*(]ltmac.sprite
.HS Tcl_GetInt tcl
.BS
.SH NAME
Tcl_GetInt, Tcl_GetDouble, Tcl_GetBoolean \- convert from string to integer, double, or boolean
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\fBTcl_GetInt\fR(\fIinterp, string, intPtr\fR)
.sp
int
\fBTcl_GetDouble\fR(\fIinterp, string, doublePtr\fR)
.sp
int
\fBTcl_GetBoolean\fR(\fIinterp, string, boolPtr\fR)
.SH ARGUMENTS
.AS Tcl_Interp *interp
.AP Tcl_Interp *interp in
Interpreter to use for error reporting.
.AP char *string in
Textual value to be converted.
.AP int *intPtr out
Points to place to store integer value converted from \fIstring\fR.
.AP double *doublePtr out
Points to place to store double-precision floating-point
value converted from \fIstring\fR.
.AP int *boolPtr out
Points to place to store boolean value (0 or 1) converted from \fIstring\fR.
.BE

.SH DESCRIPTION
.PP
These procedures convert from strings to integers or double-precision
floating-point values or booleans (represented as 0- or 1-valued
integers).  Each of the procedures takes a \fIstring\fR argument,
converts it to an internal form of a particular type, and stores
the converted value at the location indicated by the procedure's
third argument.  If all goes well, each of the procedures returns
TCL_OK.  If \fIstring\fR doesn't have the proper syntax for the
desired type then TCL_ERROR is returned, an error message is left
in \fIinterp->result\fR, and nothing is stored at *\fIintPtr\fR
or *\fIdoublePtr\fR or *\fIboolPtr\fR.
.PP
\fBTcl_GetInt\fR expects \fIstring\fR to consist of a collection
of integer digits, optionally signed and optionally preceded by
white space.  If the first two characters of \fIstring\fR are ``0x''
then \fIstring\fR is expected to be in hexadecimal form;  otherwise,
if the first character of \fIstring\fR is ``0'' then \fIstring\fR
is expected to be in octal form;  otherwise, \fIstring\fR is
expected to be in decimal form.
.PP
\fBTcl_GetDouble\fR expects \fIstring\fR to consist of a floating-point
number, which is:  white space;  a sign; a sequence of digits;  a
decimal point;  a sequence of digits;  the letter ``e'';  and a
signed decimal exponent.  Any of the fields may be omitted, except that
the digits either before or after the decimal point must be present
and if the ``e'' is present then it must be followed by the
exponent number.
.PP
\fBTcl_GetBoolean\fR expects \fIstring\fR to specify a boolean
value.  If \fIstring\fR is any of \fB0\fR, \fBfalse\fR, or
\fBno\fR, then \fBTcl_GetBoolean\fR stores a zero value at
\fI*boolPtr\fR.  If \fIstring\fR is any of \fB1\fR, \fBtrue\fR,
or \fByes\fR, then 1 is stored at \fI*boolPtr\fR.  Any of these
values may be abbreviated, and upper-case spellings are also
acceptable.

.SH KEYWORDS
boolean, conversion, double, floating-point, integer
