/* Global variables and defines */

/*
 * Copyright 1990 the Regents of the University of California.  All
 * rights reserved.  Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that this copyright notice appear in all
 * copies.  See the file copyright.h for more information.
 *
 */

#ifndef _GLOBAL_H
#define _GLOBAL_H
#include "tcl.h"   /* tool command language by Ousterhaut */
#include "xwrap.h"
#include "debug.h"
#include "copyright.h"

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif
#ifndef True
#define True 1
#endif
#ifndef False
#define False 0
#endif

/* global temporary variable for error messages or for any temporary string */
#define MAXLINE 255
/* no char* better be bigger than MAXMAXLINE! */
#define MAXMAXLINE 2000

extern char errmsg[MAXMAXLINE];
extern char tempstring[MAXMAXLINE];
extern char debugmsg[MAXMAXLINE];

/* other global variables */

typedef struct _MyResourcesType {
	String exec;             /* xcbi command to execute before
				    reading in startupfile */
	String file;             /* name of startupfile to read in */
	Boolean nofile;          /* set it to not read in the default file */
	String SetupPath;        /* default directory for setup files */
} MyResourcesType, *MyResourcesTypePtr;

extern MyResourcesType MyResources;

extern Widget TopLevel;
extern XtAppContext AppCon;
extern Tcl_Interp *mainInterp;
extern char currentcommand[MAXLINE];
extern char *callbackdata;      /* place to hold callback data of buttons */
extern Boolean gettingcallback; /* flag to say getting the callback data */
extern int GlobalArgc;
extern char** GlobalArgv;
extern Widget DebugWidget;      /* for use when running dbx. */

extern int InterpretCommand();  /* char* command */
extern char *LocateFile(/* char *name */);
#endif _GLOBAL_H
