/*
 * Copyright 1990 the Regents of the University of California.  All
 * rights reserved.  Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that this copyright notice appear in all
 * copies.  See the file copyright.h for more information.
 *
 */

#include "copyright.h"
/*#include <X11/copyright.h>*/

#ifndef _ScTool_h
#define _ScTool_h

#include <X11/Xaw/AsciiText.h>

/****************************************************************
 *
 * ScTool widget   (a subclass of the AsciiText widget)  -- contains
 *                  buffers and other stuff to make it useful as an
 *                  interactive text widget.  A pseudo tty is connected
 *                  to the tool and a UNIX program (XtNprogram).
 *                  If the program exits or is not specified, then a 
 *                  callback (XtNcommandCallback)is called when the Return 
 *                  key is pressed.
 *                  The XtNexitCallback is called when the program exits
 *                  or is killed.
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------

all those for the AsciiText widget and 
XtNcommandCallback   Callback           Callback         NULL              
XtNexitCallback      Callback           Callback         NULL              
XtNprogram           Program            String           NULL
XtNalwaysCallback    Integer            Integer          0
*/

/* define any special resource names here that are not in <X11/StringDefs.h> */

#define XtNcommandCallback              "commandCallback"
#define XtNexitCallback                 "exitCallback"
#define XtNalwaysCallback               "alwaysCallback"
#define XtNprogram                      "program"
#define XtCProgram                      "Program"

/* declare specific ScToolWidget class and instance datatypes */

typedef struct _ScToolClassRec*	ScToolWidgetClass;
typedef struct _ScToolRec*	ScToolWidget;

/* declare the class constant */

extern WidgetClass scToolWidgetClass;

/* public procedures */

extern void ScWriteText();  /* Widget w -- widget to write to, 
			       char *msg -- message to be written
			       int do_callback -- flag, TRUE means call
			       callback when <CR> is typed.
			       Note: Do not call within the callback proc! */
extern void ScClearText();  /* Clears the text window */
extern void ScAlwaysCallback(); /* Widget w -- widget,
				   boolean flag.
				   Calls the callback on a <CR> from the
				   tool output. */
extern int ScToolStart();   /* Widget w -- widget to start the tool,
			       char *path -- pathname of program,
			       char **argv -- arguments to program,
			       int argc -- number of arguments.
			       Returns the PID if tool started successfully */
extern char** ScToolArgv(); /* returns the arguments to the running program */
extern void ScToolKill();   /* Widget w 
			       kills the running program. */
extern char* ScToolProgramName();  /* Widget w
				      returns the name of the running 
				      program */
/* note: the current line is passed to the command callback in 
   the call_data. */

#endif  _ScTool_h
