#include <stdio.h>
#include <ctype.h>

extern double atof();
extern double fabs();
extern char   *index();
extern char   *getenv();

FILE	*F0,*F1;
double	OKEpsilon = 0.0;
int	Misses = 0;
int	MaxMisses = 10;

/* ------------------------------------------------------------ */
int
ReadFibreCharacter(F)
     FILE	*F;
{
  int		c;
  int		fibrec;

  c = getc(F);

  switch(c) {
   case '\\':
    c = getc(F);
    switch (c) {
     case '0': case '1': case '2': case '3':
     case '4': case '5': case '6': case '7':
      fibrec = c - '0';		/* First digit */

      /* Try for a second digit */
      c = getc(F);
      if ( c >= '0' && c <= '7' ) {
	fibrec = fibrec*8 + (c-'0');
	/* Try for a third digit */
	c = getc(F);
	if ( c >= '0' && c <= '7' ) {
	  fibrec = fibrec*8 + (c-'0');
	} else {
	  ungetc(c,F);
	}
      } else {
	ungetc(c,F);
      }
      break;

     case 'b':
      fibrec = '\010';
      break;

     case 'f':
      fibrec = '\014';
      break;

     case 'n':
      fibrec = '\012';
      break;

     case 'r':
      fibrec = '\015';
      break;

     case 't':
      fibrec = '\011';
      break;

     default:
      fibrec = c;
    }
    break;

   default:
    fibrec = c;
  }

  return	fibrec;
}
/* ------------------------------------------------------------ */
int
GetToken(F,Tok)
     FILE	*F;
     char	*Tok;
{
  int		c;
  int		fibrec;

  /* Skip leading white space to the first non-blank/non-comment char */
  for(c=getc(F); !feof(F);c=getc(F)) {
    if ( c == '#' ) {		/* Skip the rest of the line... comment */
      for(c=getc(F);!feof(F) && c != '\n';c=getc(F));
    } else if ( !isspace(c) ) {
      break;
    }
  }

  /* Quit returning tokens on end of file */
  if ( feof(F) ) {
    return 0;
  }

  /* Classify the last character character read */
  switch( c ) {
    /* These are all single character tokens */
   case '[': case ']':
   case '<': case '>':
   case '(': case ')':
   case '{': case '}':
   case ':':
    *Tok++ = c;
    *Tok = '\0';
    break;

   case 'T': case 't':
    *Tok++ = 'T';
    *Tok = '\0';
    break;

   case 'F': case 'f':
    *Tok++ = 'F';
    *Tok = '\0';
    break;

    /* This must be an error token */
   case 'e': case 'E':
    *Tok++ = 'E';		/* E */

    *Tok++ = 'R'; c = getc(F);	/* R */
    if (!(c == 'r' || c == 'R')) fprintf(stderr,"Warning: Bad error token\n");

    *Tok++ = 'R'; c = getc(F);	/* O */
    if (!(c == 'r' || c == 'R')) fprintf(stderr,"Warning: Bad error token\n");

    *Tok++ = 'O'; c = getc(F);	/* R */
    if (!(c == 'o' || c == 'O')) fprintf(stderr,"Warning: Bad error token\n");

    *Tok++ = 'R'; c = getc(F);	/* R */
    if (!(c == 'r' || c == 'R')) fprintf(stderr,"Warning: Bad error token\n");

    /* Check for error[ error< error( error{ */
    c = getc(F);
    switch (c) {
     case '[': case '<': case '(': case '{':
      *Tok++ = c;
      break;

     default:			/* Its not a grouped error token */
      ungetc(c,F);
    }

    /* Close off the token */
    *Tok = '\0';
    break;
    
    /* This must be a number of some type */
   case '-':
   case '0': case '1': case '2': case '3': case '4':
   case '5': case '6': case '7': case '8': case '9':
    do {
      *Tok++ = c;
      c = getc(F);
    } while ( isdigit(c)
	       || c== '.'
	       || c== '+'
	       || c== '-'
	       || c== 'e'
	       || c== 'E'
	       || c== 'd'
	       || c== 'D'
	       || c== 'E' );
    ungetc(c,F);		/* Put back the last character for next scan */
    *Tok = '\0';
    break;

   case '\'':
    fibrec = ReadFibreCharacter(F);
    if ( fibrec != '\'' && isprint(fibrec) ) {
      sprintf(Tok,"'%c'",fibrec);
    } else {
      sprintf(Tok,"'\\%03o'",fibrec);
    }
    getc(F);			/* Eat the trailing single quote */
    
    break;

   case '\"':
    *Tok++ = c;			/* Save the first " */
    for(c=getc(F); c != '"'; c=getc(F)) {
      ungetc(c,F);		/* Put it back for the character parser */
      fibrec = ReadFibreCharacter(F);
      if ( fibrec != '"' && isprint(fibrec) ) {
	sprintf(Tok,"%c",fibrec);
	Tok += 1;
      } else {
	sprintf(Tok,"\\%03o",fibrec);
	Tok += 4;
      }
    }
    *Tok++ = c;			/* Save the closing " */
    *Tok = '\0';
    break;

   default:
    fprintf(stderr,"Bad character %c\n",c);
  }

  return 1;
}
/* ------------------------------------------------------------ */
int
IsReal(s)
     char	*s;
{
  return index(s,'.')
    || index(s,'e')
    || index(s,'E')
    || index(s,'d')
    || index(s,'D');
}
/* ------------------------------------------------------------ */
double
RealDiff(a,b)
     char	*a,*b;
{
  char		AF[100];
  char		BF[100];
  char		*p;
  double	AV,BV,Diff,RDiff;

  /* Get copies of the floats */
  strcpy(AF,a);
  strcpy(BF,b);

  /* Convert to standard form */
  p = index(AF,'d'); if ( p ) *p = 'e';
  p = index(AF,'D'); if ( p ) *p = 'e';
  p = index(BF,'d'); if ( p ) *p = 'e';
  p = index(BF,'D'); if ( p ) *p = 'e';

  /* Convert to doubles */
  AV = atof(AF);
  BV = atof(BF);

  /* Find the absolute difference */
  Diff = fabs(AV-BV);

  /* If there is no absolute difference, then the relative difference */
  /* is simply 0.0 */
  if ( Diff == 0.0 ) {
    RDiff = 0.0;
  } else {
    /* Divide by the smaller to get a relative difference */
    AV = fabs(AV);
    BV = fabs(BV);
    if ( AV < BV && AV > 0) {
      RDiff = Diff/AV;
    } else if ( BV > 0 ) {
      RDiff = Diff/BV;
    } else {
      RDiff = 0.0;		/* Both must be 0.0 (shouldn't happen) */
    }
  }

  return RDiff;
}
/* ------------------------------------------------------------ */
void
Mismatch(a,b)
     char	*a,*b;
{

  /* Reals only miscompare if their absolute diference is too large */
  if ( IsReal(a) && IsReal(b) && RealDiff(a,b) <= OKEpsilon ) return;

  /* Must have been a miscompare */
  printf(">>> %s\t<>\t%s\n",a,b);

  if ( ++Misses > MaxMisses ) {
    puts("Too many misses");
    exit(1);
  }

}

/* ------------------------------------------------------------ */
void
main(argc,argv)
     int	argc;
     char	*argv[];
{
  char		**p;
  char		*Epsilon;
  char		Buf0[1024];
  char		Buf1[1024];

  /* ------------------------------------------------------------ */
  /* Check for environment overide of OKEpsilon */
  Epsilon = getenv("EPSILON");
  if ( Epsilon ) OKEpsilon = atof(Epsilon);

  if ( argc < 3 ) {
    puts("No comparison");
    exit(1);
  }

  /* Open the files */
  F0 = fopen(argv[1],"r");
  if ( !F0 ) { perror(argv[0]); exit(1); }

  F1 = fopen(argv[2],"r");
  if ( !F1 ) { perror(argv[0]); exit(1); }

  /* See if the defaults are to be changed */
  for(p=argv+3;*p;p++) {
    if ( strcmp(*p,"-eps") == 0 && *(p+1) ) {
      OKEpsilon = atof(*(++p));
    } else if ( strcmp(*p,"-miss") == 0 && *(p+1) ) {
      MaxMisses = atoi(*(++p));
    }
  }

  /* Check all the tokens.  If there is an inexact match, pass it to */
  /* Mismatch() to see if they really do not match (100.0 1e2 actually */
  /* match, 1.000001 and 1.0 might match if the epsilon is large enough) */
  while( GetToken(F0,Buf0) && GetToken(F1,Buf1) ) {
    if ( strcmp(Buf0,Buf1) != 0 ) Mismatch(Buf0,Buf1);
  }

  /* See if there are any misses */
  if ( Misses ) {
    printf("%d mismatched tokens\n",Misses);
    exit(1);
  }

  /* See if one file is longer than the other */
  if (
      (feof(F0) && (!feof(F1)) && GetToken(F1,Buf1)) ||
      (feof(F1) && (!feof(F0)) && GetToken(F0,Buf0)) ) {
    puts("file length error");
    exit(1);
  }

  /* Exit with no error */
  exit(0);
}
