#include <stdio.h>

extern	double	atof();
extern	char	*index();
extern	char	*calloc();

#define MAXNAMES	(100)
#define NAMELEN		(100)
#define MAXVALDEF	(1000)

int	ListSize = MAXVALDEF;
/* ------------------------------------------------------------ */
int
GetNameAndValue(name,value)
     char	*name;
     float	*value;
{
  char		valstring[NAMELEN+1];
  char		*p;
  int		n;

  n = scanf("%s = %s",name,valstring);

  if ( n < 2 ) return n;	/* Didn't read enough */

  /* Convert the FIBRE double type to C type */
  p = index(valstring,'d'); if ( p ) *p = 'e';
  p = index(valstring,'D'); if ( p ) *p = 'e';

  *value = atof(valstring);

  return 2;
}

/* ------------------------------------------------------------ */
void
main(argc,argv)
     int	argc;		/* ARGUSED */
     char	*argv[];
{
  char		**p;
  char		names[MAXNAMES+1][NAMELEN+1];
  float		first[MAXNAMES+1];
  float		*List;
  char		junkname[MAXNAMES+1];
  int		NameCount;
  int		i,j,n;
  int		ValCount;

  /* ------------------------------------------------------------ */
  /* Override the list size parameter (if on the input line) and open */
  /* the appropriate files. */
  for(p=argv+1;*p;p++) {
    if ( strcmp(*p,"-n") == 0 ) {
      /* ------------------------------------------------------------ */
      /* Check for list size */
      if ( !*(++p) ) break;
      ListSize = atoi(*p);
    } else if ( strcmp(*p,"-o") == 0 ) {
      /* ------------------------------------------------------------ */
      /* -o name is for output files */
      if ( !*(++p) ) break;
      if ( !freopen(*p,"w",stdout) ) {
	(void)fprintf(stderr,"%s: Cannot open %s for output!!\n",argv[0],*p);
	perror(argv[0]);
	exit(1);
      }
    } else {
      /* ------------------------------------------------------------ */
      /* Assume anything else is a input file */
      if ( !freopen(*p,"r",stdin) ) {
	(void)fprintf(stderr,"%s: Cannot open %s for input!!\n",argv[0],*p);
	perror(argv[0]);
	exit(1);
      }
    }
  }

  /* ------------------------------------------------------------ */
  /* Get the first name and value */
  NameCount = 0;
  (void)GetNameAndValue(names[NameCount++],first+0);

  /* ------------------------------------------------------------ */
  /* Get the remaining names by checking until a name matches */
  do {
    n = GetNameAndValue(names[NameCount],first+NameCount);
    if ( n < 2 ) exit(1);
    if ( strcmp(names[NameCount],names[0]) == 0 ) break;
    NameCount++;
  } while (1);

  /* ------------------------------------------------------------ */
  /* Make lists to hold the values and put the first (saved) values */
  /* into the list. */
  List = (float*)calloc((unsigned)(ListSize*NameCount+1),sizeof(float));
  for(ValCount=0;ValCount<NameCount+1;ValCount++) {
    List[ValCount] = first[ValCount];
  }

  /* ------------------------------------------------------------ */
  /* Read in more values and fill in the list */
  while(ValCount <= ListSize*NameCount) {
    n = GetNameAndValue(junkname,List+(ValCount++));
    if (n<2) break;
  }
  ValCount--;			/* Remove the last empty value */

  /* ------------------------------------------------------------ */
  /* Walk through the lists one at a time and output the data sets */
  /* headed by the data name. */
  for(n=0;n < NameCount;n++) {
    if (n) putchar('\n');	/* Blank line between sets */
    (void)printf("\"%s\n",names[n]);
    for(j=0,i=n;i<ValCount;i += NameCount) {
      (void)printf("%d %g\n",j++,List[i]);
    }
  }
}
