#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
void
UBuild(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define Val	(0)
#define OutU	(0)

  TypeD		UnionType = OType(info)[OutU];
  IF1OBJECT	*NewUnion,*Element;
  BagPtr	Collection;
  int		Tag;

  NoWorkIfNoOutput();

  UnionType		= OType(info)[OutU];
  NewUnion		= out[OutU];
  Collection		= EmptyBag(1);

  for(Tag=0;1;Tag++) {
    if ( in[Val+Tag] ) {
      Element = PointerIntoBag(Collection,0);
      Copy(Element,in[Val+Tag]);
      break;
    }
  }

  UniErr(NewUnion)	= FALSE;
  UniTag(NewUnion)	= LocalToInteger(Tag);
  UniVal(NewUnion)	= Collection;
  SetDes(NewUnion,	UnionType);

#undef Val
#undef OutU
}
/* ------------------------------------------------------------ */
void
TagCase(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
#define U	(0)

  IF1OBJECT	*UnionObject,*TagObject;
  int		Tag;
  IF1OBJECT	*DefaultInputArray[EntryMax],**NewIn;
  unsigned	i;
  unsigned	INAR,OUTAR;
  NodeStuff	NewInfo;
  NodeInfo	TagGraphInfo;

  UnionObject = in[U];
  INAR	      = INARITY(info);
  OUTAR	      = OUTARITY(info);

  /* If the union object is an error union, the output values are all error */
  if ( UniErr(UnionObject) ) {
    SetToError(out,OType(info),OUTARITY(info));
  } else {

    /* ------------------------------------------------------------ */
    /* Build a new info vector for the call of the graph */
    BuildNodeInfo(&NewInfo,OUTAR,INAR,OType(info),IType(info));

    /* Build a new input vector with the Tag object in position 0 */
    TagObject = PointerIntoBag(UniVal(UnionObject),0);

    if ( INAR > EntryMax ) {
      NewIn = CAllocate(INAR,IF1OBJECT*);
    } else {
      NewIn = DefaultInputArray;
    }
    NewIn[0] = TagObject;
    for(i=1;i<INAR;i++) NewIn[i] = in[i];

    /* ------------------------------------------------------------ */
    /* Find the appropriate Tag graph and execute it*/
    Tag = IntegerToLocal(UniTag(UnionObject));
    TagGraphInfo = ChildrenOf(info)[Tag];
    ExecGraph( GraphCodeOf(TagGraphInfo),
	      GraphNameOf(TagGraphInfo),
	      NewIn,out,&NewInfo);

    /* ------------------------------------------------------------ */
    /* Free the NewIn vector (if appropriate) */
    if ( NewIn != DefaultInputArray ) Free(NewIn);
  }

#undef U
}
