#include "SC.h"
#include "SCLib.h"

/* EXPORTED */ SisalBoolean	ParmFalse = FALSE;
/* EXPORTED */ SisalBoolean	ParmTrue  = TRUE;
/* EXPORTED */ int		ParmZero = 0;
/* EXPORTED */ char		*ParmEmptyString = "";

extern int	atoi();
extern double	atof();

void
InsertParmList(A,B)
     Parameter	A[];
     Parameter	B[];
{
  int		i,ACount,BCount;

  /* Count elements in A and B */
  for(ACount=0;A[ACount].Option;ACount++);
  for(BCount=0;B[BCount].Option;BCount++);

  /* Move elements of B down by ACount positions*/
  for(i=0;i<=BCount;i++) {
    B[ACount+BCount-i] = B[BCount-i];
  }

  /* Insert the elements of A */
  for(i=0;i<ACount;i++) {
    B[i] = A[i];
  }
}

static Parameter*
MatchingParm(PL,s)
     Parameter	PL[];
     char	*s;
{
  Parameter	*p;
  int		i;

  p = NULL;
  for(i=0;PL[i].Option;i++) {
    if (PL[i].Kind == WildParm ||
	(PL[i].Kind == ToggleParm &&
	 (PL[i].Option[0] == '-' || PL[i].Option[0] == '+') &&
	 (s[0] == '-' || s[0] == '+') &&
	 strcmp(s+1,PL[i].Option+1) == 0
	 ) ||
	strcmp(s,PL[i].Option) == 0
	) {
      p = PL+i;
      break;
    }
  }

  return p;
}

static char*
DefaultParmValue(P,Val)
     Parameter		P;
     char		*Val;
{
  /* ------------------------------------------------------------ */
  /* If the address field is set, then make the copy.  Otherwise, just */
  /* leave the value alone. */
  if (P.Addr) {
    switch( P.Kind ) {
      case BoolParm: case ToggleParm:
      (void)strcpy(Val,(*((int*)P.Addr))?"T":"F");
      break;

      case IntParm:
      (void)sprintf(Val,"%d",*((int*)P.Addr));
      break;

      case DoubleParm:
      (void)sprintf(Val,"%lf",*((int*)P.Addr));
      break;

      case StringParm: case WildParm:
      (void)strcpy(Val,*((char**)P.Addr));
      break;

      default:
      (void)strcpy(Val,"");
    }
  }
  return Val;
}

static void
Usage(PL)
     Parameter	PL[];
{
  int		i;
  char		msg[1024];
  char		Value[1024];

  IO_ErrorString("Usage:\n");
  IO_ErrorString("Option\t\tDefault\n");
  for(i=0;PL[i].Option;i++) {
    (void)sprintf(msg,"%s\t%s\t%s\t\"%s\"\n",
	    PL[i].Option,
	    (PL[i].Kind != BoolParm && PL[i].Kind != ToggleParm)?"arg":"",
	    DefaultParmValue(PL[i],Value),
	    PL[i].Usage);
    IO_ErrorString(msg);
  }
}

static void
SetDefaults(PL)
     Parameter	PL[];
{
  int		i;

  for(i=0;PL[i].Option;i++) {
    if (PL[i].Addr && PL[i].Default) {
      switch(PL[i].Kind) {
	case BoolParm: case IntParm: case ToggleParm:
	*((int*)(PL[i].Addr)) = *((int*)(PL[i].Default));
	break;

	case DoubleParm:
	*((double*)(PL[i].Addr)) = *((double*)(PL[i].Default));
	break;

	case StringParm: case WildParm:
	*((char**)(PL[i].Addr)) = *((char**)(PL[i].Default));
	break;
      }
    }
  }
}

void
ProcessOptions(PL,argc,argv)
     Parameter	PL[];
     int	argc;
     char	*argv[];
{
  int		i;
  Parameter	*p;

  SetDefaults(PL);

  for(i=1;i<argc;) {
    p = MatchingParm(PL,argv[i]);
    if (p) {
      switch(p->Kind) {
	case BoolParm:
	if (p->Addr) {
	  *((int*)(p->Addr)) = (argv[i][0] == '+');
	}
	if (p->OptionAction) {
	  (p->OptionAction)(argv[i],"");
	}
	i++;
	break;

	case ToggleParm:
	if (p->Addr) {
	  *((int*)(p->Addr)) = !(*((int*)(p->Addr)));
	}
	if (p->OptionAction) {
	  (p->OptionAction)(argv[i],"");
	}
	i++;
	break;

	case IntParm:
	if (p->Addr) {
	  *((int*)(p->Addr)) = atoi((((i+1)<argc)?(argv[i+1]):""));
	}
	if (p->OptionAction) {
	  (p->OptionAction)(argv[i],(((i+1)<argc)?(argv[i+1]):""));
	}
	i += 2;
	break;
	
	case DoubleParm:
	if (p->Addr) {
	  *((double*)(p->Addr)) = atof((((i+1)<argc)?(argv[i+1]):""));
	}
	if (p->OptionAction) {
	  (p->OptionAction)(argv[i],(((i+1)<argc)?(argv[i+1]):""));
	}
	i += 2;
	break;
	
	case StringParm:
	if (p->Addr) {
	  *((char**)(p->Addr)) = ((i+1)<argc)?(argv[i+1]):"";
	}
	if (p->OptionAction) {
	  (p->OptionAction)(argv[i],(((i+1)<argc)?(argv[i+1]):""));
	}
	i += 2;
	break;

	case WildParm:
	if (p->Addr) {
	  *((char**)(p->Addr)) = argv[i];
	}
	if (p->OptionAction) {
	  (p->OptionAction)(argv[i],argv[i]);
	}
	i++;
	break;
      }
    } else {
      Usage(PL);
      exit(1);
    }
  }
}
