#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
void
GetFromMult(M,n,obj)
     IF1OBJECT	*M;
     unsigned	n;
     IF1OBJECT	*obj;
{
  if (MultTag(M) == BagMult) {
    if (n >= MultSize(M)) {
      MakeError(obj,ElementTypeOfMultiple(TypeOf(M)));
    } else {
      Copy(obj,PointerIntoBag(MultBag(M),MultView(M)+n));
    }
  } else {
    SetDes(obj,		IntegerTypeD);
    if (n >= MultSize(M) || MultLow(M).aINTEGER.Error) {
      BasErr(obj)	= TRUE;
    } else {
      BasErr(obj)	= FALSE;
      IVal(obj)		= LocalToInteger(IntegerToLocal(MultLow(M).aINTEGER.aINTEGER)+n);
    }
  }
}

/* ------------------------------------------------------------ */
IF1OBJECT*
MakeMultipleFromBag(T,B,size,obj)
     TypeD		T;
     BagPtr		B;
     unsigned		size;
     IF1OBJECT		*obj;
{
  SetDes(obj		, T);
  MultTag(obj)		= BagMult;
  MultError(obj)	= FALSE; /* Fix later??? */
  MultSize(obj)		= size;
  MultTrueSize(obj)	= size;
  MultBag(obj)		= B;
  MultView(obj)		= 0;

  return obj;
}

/* ------------------------------------------------------------ */
void
MakeEmptyMultiple(T,obj)
     TypeD      T;
     IF1OBJECT	*obj;
{
  BagPtr	B;

  B = EmptyBag(ArrayInitialSize);
  (void) MakeMultipleFromBag(T,B,0,obj);
}

/* ------------------------------------------------------------ */
void
AppendToMultiple(M,obj)
     IF1OBJECT	*M,*obj;
{
  BagPtr	B;
  unsigned	Size;
  IF1OBJECT	*Element;

  B = MultBag(M);

  Size = MultSize(M);
  Element = GetPointerIntoBag(B,MultView(M)+Size,TRUE);

  Size++;
  MultSize(M) = Size;
  MultTrueSize(M) = Size;


  Copy(Element,obj);
}

/* ------------------------------------------------------------ */
void
GetMultiples(PG,Generator,in,InAr,ITypes)
     IF1OBJECT		*PG[];
     NodeInfo		Generator;
     IF1OBJECT		*in[];
     unsigned		InAr;
     TypeD		*ITypes;
{
  NodeStuff	GeneratorInfo;

  /* Note: The inputs and outputs are reversed because we are */
  /* executing a graph node!!!!! */
  BuildNodeInfo(&GeneratorInfo,
		InAr,
		INARITY(Generator),
		ITypes,
		IType(Generator));

  ExecGraph(GraphCodeOf(Generator),GraphNameOf(Generator),
	    in,PG,&GeneratorInfo);
}

/* ------------------------------------------------------------ */
unsigned
JustifyMultiples(PG,N)
     IF1OBJECT		*PG[];
     unsigned		N;
{
  unsigned	i,Biggest,ThisSize;

  /* Find the largest size */
  Biggest = 0;
  for(i=0;i<N;i++) {
    if ( IsMultipleObject(PG[i]) ) {
      ThisSize = MultTrueSize(PG[i]);
      if (ThisSize > Biggest) Biggest = ThisSize;
    }
  }

  /* Set all multiples to that size */
  for(i=0;i<N;i++) {
    if ( IsMultipleObject(PG[i]) ) MultTrueSize(PG[i]) = Biggest;
  }

  return Biggest;
}

/* ------------------------------------------------------------ */
void
UnPackMultiples(Dest,Src,DestN,SrcN,Iteration)
     IF1OBJECT	*Dest[],*Src[];
     unsigned	DestN,SrcN;
     unsigned	Iteration;
{
  unsigned	i;

  for(i=0;i < SrcN && i < DestN; i++) {
    if ((!Src[i]) || IsEmptyObject(Src[i])) {
      FCopy(Dest[i],EmptyObject,aEMPTY);
    } else {
      GetFromMult(Src[i],Iteration,Dest[i]);
    }
  }

  for(;i < DestN;i++) Copy(Dest[i],EmptyObject);
}

/* ------------------------------------------------------------ */
/* Modification History:  W. Cedeno - Added Check for non-null  */
/*   DTypes[i] before creating the multiple object.             */
void
CollectResultsIntoMultiple(Dest,Src,DestN,SrcN,DTypes)
     IF1OBJECT	*Dest[],*Src[];
     unsigned	DestN,SrcN;
     TypeD	*DTypes;
{
  unsigned	i;

  for(i=0;i < SrcN && i < DestN; i++) {
    if ( DTypes[i] && Src[i] && !IsEmptyObject(Src[i]) ) {
      if ( IsEmptyObject(Dest[i]) ) { 
	/* Should only be true the first time */
	MakeEmptyMultiple(DTypes[i],Dest[i]);
      }
      AppendToMultiple(Dest[i],Src[i]);
    }
  }
}








