#include <stdio.h>
#include <ctype.h>

#define FixName(s)	(((s)[0])?(s):DefaultName)
#define NAMESIZE	(65)

typedef char	Name[NAMESIZE];

char	*TableName = "Op";
char	*FunctionPrefix = "";
char	*DefaultName = "NULL";

int Count = 0;

void
main(argc,argv)
     int	argc;
     char	*argv[];
{
  Name		*NameList;
  Name		*OpList;
  int		i,n,lineno;
  char		line[1024];
  Name		OpName;
  Name		CallName;
  char		*p,*HasInfo;

  /* Override table name stuff? */
  if ( argv[1] ) {
    TableName = argv[1];
    if ( argv[2] ) {
      FunctionPrefix = argv[2];

      if ( argv[3] ) {
	DefaultName= argv[3];
      }
    }
  }

  /* Initialize some holding arrays.. */
  scanf(" %d",&Count);
  (void)gets(line); lineno = 1;	/* Consume \n */

  NameList = (Name*)calloc(Count+1,sizeof(Name));
  OpList = (Name*)calloc(Count+1,sizeof(Name));

  for(i=0;i<=Count;i++) {
    NameList[i][0] = NULL;
    OpList[i][0] = NULL;
  }

  /* Need the header of course... */
  puts("#include \"SC.h\"");
  puts("#include \"SCLib.h\"");

  /* Read in lines, saving in the proper offset */
  while(gets(line)) {
    lineno++;
    HasInfo = NULL;
    for(p=line;*p;p++) {
      if (!isspace(*p)) {
	HasInfo = p;
	break;
      }
    }

    if (HasInfo && *HasInfo != '#') {
      sscanf(line,"%d %s %s",&n,OpName,CallName);
      if (n < 0 || n > Count) {
	fprintf(stderr,"Out of range op on line %d\n",lineno);
	exit(1);
      } else {
	if (OpList[n][0] != NULL) {
	  fprintf(stderr,"Clash at offset %d\n",n);
	  exit(1);
	}
	(void)strcpy(NameList[n],OpName);
	(void)strcpy(OpList[n],CallName);
      }
    }
  }

  /* Dump the name/op table */
  printf("/* EXPORTED */ int\t%sListSize = %d;\n",TableName,Count);
  printf("/* EXPORTED */ %sName\t%sList[] = {\n",TableName,TableName);
  for(i=0;i<=Count;i++) {
    printf("  %sEntry(\"%s\",%s%s)%s\t/* %d */\n",
	   TableName,
	   FixName(NameList[i]),
	   FunctionPrefix,
	   FixName(OpList[i]),
	   (i==Count)?"":",",
	   i);
  }
  puts("};");
  exit(0);
}
    
