#include "SC.h"
#include "SCLib.h"

extern char		*DefaultEntry;
/* EXPORTED */ char		*EntryName	= NULL;
/* EXPORTED */ char		*EntryString	= NULL;
/* EXPORTED */ int		PrintMax	= 0;

/* This is a list of parameters and usages for the program.  The basic */
 /* form is option string, option type, address for value, address for */
 /* initial value, callback, usage string */
/* EXPORTED */ Parameter	ParmList[MaxParms] = {
  {"-nostrings",ToggleParm,ParmAddr(PrintStrings),ParmAddr(ParmTrue),NULL,
     "Print character strings in array form"},

  {"-stdio",ToggleParm,ParmAddr(UseStdio),ParmAddr(ParmFalse),SetupStdio,
     "Use direct input and ouput for streams of character"},

  {"-nocomments",ToggleParm,ParmAddr(PrintComments),ParmAddr(ParmTrue),NULL,
     "Suppress comments in the output"},

  {"-garbage",IntParm,ParmAddr(PeriodicGarbage),NULL,NULL,
     "Change how often the heap is compacted"},

  {"-infinity",IntParm,ParmAddr(InfiniteLoopCount),NULL,NULL,
     "Report an infinite loop error on any loops with this many iterations"},

  {"-ps",ToggleParm,ParmAddr(PrintSize),ParmAddr(ParmFalse),NULL,
     "Display the number of elements in arrays and streams"},

  {"-pack",ToggleParm,ParmAddr(PackFibre),ParmAddr(ParmFalse),NULL,
     "Compress printed information"},

  {"-entry",StringParm,ParmAddr(EntryName),ParmAddr(DefaultEntry),NULL,
     "Function or graph to execute" },

  {"-args",StringParm,ParmAddr(EntryString),ParmAddr(ParmEmptyString),
     SetupStringInput,"Arguments for entry" },

  {"-i",StringParm,ParmAddr(InputFileName),ParmAddr(ParmEmptyString),
     OpenInputFile,"Input file name" },

  {"-o",StringParm,ParmAddr(OutputFileName),ParmAddr(ParmEmptyString),
     OpenOutputFile,"Output file name" },

  {NULL, StringParm, NULL, NULL, NULL}
};

void
SetupStringInput(argopt,args)	/* ARGSUSED */
     char	*argopt;
     char	*args;
{
  OpenStringInput(args);
}

void
SetupStdio(argopt,args)	/* ARGSUSED */
     char	*argopt;
     char	*args;
{
  /* If using stdio style i/o, then no comments */
  PrintComments = FALSE;
}

void
main(argc,argv)
     int	argc;
     char	*argv[];
{
  NodeInfo	EntryNode;
  char		EntryError[MaxCommentSize];

  /* Initialize runtime values */
  Init();

  /* Let the hook package do whatever */
  HOOK(PreStartHook());

  /* Process the input arguments */
  ProcessOptions(ParmList,argc,argv);

  /* And allow the hook package to do the same */
  HOOK(StartHook(ParmList,argc,argv));

  /* Try to find the name entry */
  EntryNode = FindGraph(EntryName,(NodeInfo)NULL,TRUE);
  if (!EntryNode) Oops("Main entry not found, use -entry FUNCTION");

  /* Enter at the appropriate section */
  GraphEntry(EntryNode,EntryError);

  /* Report any errors on the entry and exit */
  if ( EntryError[0] ) IO_ErrorString(EntryError);
  HOOK(CompleteHook());

  exit(0);
}
