#include "SC.h"
#include "SCLib.h"

#ifdef SUN3
/*
 *	 SSSS	U	U  N	  N
 *	S    S	U	U  NN	  N
 *	 S	U	U  N N	  N
 *	  S	U	U  N  N	  N
 *	   S	U	U  N   N  N
 *	    S	U	U  N    N N
 *	S    S	 U     U   N	 NN
 *	 SSSS	  UUUUU	   N	  N
*/
#define IsFloatError(x,f) {double zzz; zzz = x; (f) = (SisalBoolean)(((*((unsigned*)(&(zzz)))) & 0x7ff00000) == 0x7ff00000);}

/* ------------------------------------------------------------ */
void
MachineInit()
{
  /* Nothing to initialize */
}

asm("# ------------------------------------------------------------");
asm(".text");
asm("# void");
asm("# IntegerPlus(a,b,result,IsError)");
asm("# 	SisalInteger	a,b;");
asm("# 	SisalInteger	*result;");
asm("#	SisalBoolean	*IsError;");
asm(".even");
asm(".globl _IntegerPlus");
asm("_IntegerPlus:");
asm("	link	a6,#0");
asm("");
asm("# Add (a+b)");
asm("	movel	a6@(8),d0");
asm("	addl	a6@(12),d0");
asm("	bvc	AddOK");
asm("");
asm("# If there was an overflow, set IsError");
asm("	moveq	#1,d0");
asm("	movel	a6@(20),a0");
asm("	movel	d0,a0@");
asm("	jmp	AddDone");
asm("");
asm("# If there was no overflow, set the result and clear IsError");
asm("AddOK:	movel	a6@(16),a0");
asm("	movel	d0,a0@");
asm("	movel	a6@(20),a0");
asm("	clrl	a0@");
asm("");
asm("AddDone:	unlk	a6");
asm("	rts");
asm("");
asm("# ------------------------------------------------------------");
asm("# void");
asm("# IntegerMinus(a,b,result,IsError)");
asm("# 	SisalInteger	a,b;");
asm("# 	SisalInteger	*result;");
asm("#	SisalBoolean	*IsError;");
asm(".even");
asm(".globl _IntegerMinus");
asm("_IntegerMinus:");
asm("	link	a6,#0");
asm("");
asm("# Sub (a-b)");
asm("	movel	a6@(8),d0");
asm("	subl	a6@(12),d0");
asm("	bvc	SubOK");
asm("");
asm("# If there was an overflow, set IsError");
asm("	moveq	#1,d0");
asm("	movel	a6@(20),a0");
asm("	movel	d0,a0@");
asm("	jmp	SubDone");
asm("");
asm("# If there was no overflow, set the result and clear IsError");
asm("SubOK:	movel	a6@(16),a0");
asm("	movel	d0,a0@");
asm("	movel	a6@(20),a0");
asm("	clrl	a0@");
asm("");
asm("SubDone:	unlk	a6");
asm("	rts");
asm("# ------------------------------------------------------------");
      
#endif
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */

#ifdef SPARC
/*
 *	 SSSS	PPPPPP      AA     RRRRRR     CCCCCC
 *	S    S	P     P    A  A    R     R   C      C
 *	 S	P     P   A    A   R     R   C
 *	  S	PPPPPP   AAAAAAAA  RRRRRR    C
 *	   S	P        A      A  R  R      C
 *	    S	P        A      A  R   R     C
 *	S    S	P        A      A  R    R    C      C
 *	 SSSS	P        A      A  R     R    CCCCCC
*/
#define IsFloatError(x,f) {double zzz; zzz = x; f = (SisalBoolean)(((*((unsigned*)(&(zzz)))) & 0x7ff00000) == 0x7ff00000);}

/* ------------------------------------------------------------ */
void
MachineInit()
{
  /* Nothing to initialize */
}

asm("! ------------------------------------------------------------");
asm("	.seg	\"text\"");
asm("! void");
asm("! IntegerPlus(a,b,result,IsError)");
asm("! 	SisalInteger	a,b;");
asm("! 	SisalInteger	*result;");
asm("!	SisalBoolean	*IsError;");
asm("	.global	_IntegerPlus");
asm("_IntegerPlus:");
asm("! Add (a+b)");
asm("	addcc	%o0,%o1,%o0");
asm("	bvc,a	LAddOK");
asm("	st	%o0,[%o2]");
asm("");
asm("! If there was an overflow, set IsError");
asm("	mov	1,%o4");
asm("	b	LAddDone");
asm("	st	%o4,[%o3]");
asm("");
asm("! If there was no overflow, set the result and clear IsError");
asm("LAddOK:");
asm("	st	%g0,[%o3]");
asm("");
asm("LAddDone:");
asm("	retl");
asm("	nop");
asm("");
asm("! ------------------------------------------------------------");
asm("! void");
asm("! IntegerMinus(a,b,result,IsError)");
asm("! 	SisalInteger	a,b;");
asm("! 	SisalInteger	*result;");
asm("!	SisalBoolean	*IsError;");
asm("	.global	_IntegerMinus");
asm("_IntegerMinus:");
asm("! Sub (a-b)");
asm("	subcc	%o0,%o1,%o0");
asm("	bvc,a	LSubOK");
asm("	st	%o0,[%o2]");
asm("");
asm("! If there was an overflow, set IsError");
asm("	mov	1,%o4");
asm("	b	LSubDone");
asm("	st	%o4,[%o3]");
asm("");
asm("! If there was no overflow, set the result and clear IsError");
asm("LSubOK:");
asm("	st	%g0,[%o3]");
asm("");
asm("LSubDone:");
asm("	retl");
asm("	nop");
asm("");
asm("! ------------------------------------------------------------");
/* CAB will count the active bits in a signed integer greater than 1 */
asm("	.global	_CAB");
asm("_CAB:");
asm("	srl	%o0,2,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	2,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	3,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	4,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	5,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	6,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	7,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	8,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	9,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	10,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	11,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	12,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	13,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	14,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	15,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	16,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	17,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	18,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	19,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	20,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	21,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	22,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	23,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	24,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	25,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	26,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	27,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	28,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	29,%o0");
asm("	srl	%o0,1,%o0");
asm("	tst	%o0");
asm("	be	LCABDone");
asm("	mov	30,%o0");
asm("	mov	31,%o0");
asm("LCABDone:");
asm("	retl");
asm("	nop");
      
#endif
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */

#if defined(SUN3) || defined(SPARC)
void
IntegerTimes(a,b,result,iserror)
     int	a,b;
     int	*result;
     int	*iserror;
{
    int		sign,bits,min,max;
    
  *iserror = 0;
  if ( a == 0 || b == 0 ) {
    *result = 0;
  } else if ( a == 1 ) {
    *result = b;
  } else if ( b == 1 ) {
    *result = a;
  } else if ( a == -2147483648 || b == -2147483648 ) {
    *iserror = 1;
  } else {
    if ( a < 0 ) {sign = -1; a = -a;} else sign = 1;
    if ( b < 0 ) {sign *= -1; b = -b;}
    if ( a < b ) {min = a; max = b;} else {min = b; max = a;}
    *result = 0;
    while ( min ) {
      if ( min & 1 ) *result += max;
      min = min >> 1;
      if ( max < 0 && (min || *result != -2147483648 || sign != -1 )) 
        { *iserror = 1; break; }
      max = max << 1;
    }
    if ( *result > 0 ) *result *= sign;
  }
}

/* ------------------------------------------------------------ */
void
RealPlus(a,b,result,IsError)
     SisalReal		a,b;
     SisalReal		*result;
     SisalBoolean	*IsError;
{
  *result = a+b;
  IsFloatError(*result,*IsError);
}
void
RealMinus(a,b,result,IsError)
     SisalReal		a,b;
     SisalReal		*result;
     SisalBoolean	*IsError;
{
  *result = a-b;
  IsFloatError(*result,*IsError);
}
void
RealTimes(a,b,result,IsError)
     SisalReal		a,b;
     SisalReal		*result;
     SisalBoolean	*IsError;
{
  *result = a*b;
  IsFloatError(*result,*IsError);
}
void
RealDiv(a,b,result,IsError)
     SisalReal		a,b;
     SisalReal		*result;
     SisalBoolean	*IsError;
{
  *result = a/b;
  IsFloatError(*result,*IsError);
}
/* ------------------------------------------------------------ */
void
DoublePlus(a,b,result,IsError)
     SisalDouble	a,b;
     SisalDouble	*result;
     SisalBoolean	*IsError;
{
  *result = a+b;
  IsFloatError(*result,*IsError);
}
void
DoubleMinus(a,b,result,IsError)
     SisalDouble	a,b;
     SisalDouble	*result;
     SisalBoolean	*IsError;
{
  *result = a-b;
  IsFloatError(*result,*IsError);
}
void
DoubleTimes(a,b,result,IsError)
     SisalDouble	a,b;
     SisalDouble	*result;
     SisalBoolean	*IsError;
{
  *result = a*b;
  IsFloatError(*result,*IsError);
}
void
DoubleDiv(a,b,result,IsError)
     SisalDouble	a,b;
     SisalDouble	*result;
     SisalBoolean	*IsError;
{
  *result = a/b;
  IsFloatError(*result,*IsError);
}
#endif
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */


#ifdef SGI
/*
 *       SSSS     GGGGG    IIIII
 *      S    S   G     G     I
 *       S      G       G    I
 *        S     G            I
 *         S    G     GGG    I
 *          S   G       G    I
 *      S    S   G     G     I
 *       SSSS     GGGGG    IIIII
*/

#ifndef asm
#define asm(x)			/* Nothing */
#else
static NoAsm;
#endif

SisalBoolean SGIFlag;

#define ErrorOccurred(res,flag) { (flag) = SGIFlag; SGIFlag = FALSE; }
#define IsFloatError(x,f) {double zzz; zzz = x; f = (SisalBoolean)(((*((unsigned*)(&(zzz)))) & 0x7ff00000) == 0x7ff00000);}

static void
handler(sig, code, sc)
	 int sig;
	 int code;
	 struct sigcontext *sc;
{
  unsigned char		op;

  SGIFlag = TRUE;				/* Set the error flag */

  /* Decode the op and skip the right number of bytes for the operation */
  op = *((unsigned int*)sc->sc_pc) & 0xff;
  switch( op ) {
   case 0x20:					/* Add */
	sc->sc_pc += 4;				/* 4 bytes long */
	break;

   case 0x22:					/* Sub */
	sc->sc_pc += 4;				/* 4 bytes long */
	break;

   case 0x70:					/* Mul */
	sc->sc_pc += 8;				/* 8 bytes long */
	break;

   case 0x0d:					/* Divide (break) */
	sc->sc_pc += 4;				/* 4 bytes long */
	break;

   default:						/* ???? */
	printf("Unresolvable floating error at 0x%x [0x%02x]\n",sc->sc_pc,op);
	printf("Please contact wcedeno@llnl.gov immediately\n");
	exit(1);
  }

  /* Restore handler for next call */
  signal(sig,handler);
}

/* ------------------------------------------------------------ */
void
MachineInit()
{
  (void)signal(SIGFPE,handler);
  (void)signal(SIGTRAP,handler);
}

asm("	.extern SGIFlag 4")
asm("	.text")
asm("	.align	2")
asm("	.globl	IntegerPlus")
asm("	.ent	IntegerPlus 2")
asm("IntegerPlus:")
asm("	.option	O1")
asm("	.frame	$sp, 0, $31")
asm("	add	$14, $4, $5")
asm("	sw	$14, 0($6)")
asm("	lw	$14, SGIFlag")
asm("	sw	$14, 0($7)")
asm("	sw	$0, SGIFlag")
asm("	j	$31")
asm("	.end	IntegerPlus")

asm("# ------------------------------------------------------------")
asm("# void")
asm("# IntegerMinus(a,b,result,IsError)")
asm("#  SisalInteger    a,b;")
asm("#  SisalInteger    *result;")
asm("#  SisalBoolean    *IsError;")
asm("	.text")
asm("	.align	2")
asm("	.globl	IntegerMinus")
asm("	.ent	IntegerMinus 2")
asm("IntegerMinus:")
asm("	.option	O1")
asm("	.frame	$sp, 0, $31")
asm("	sub	$14, $4, $5")
asm("	sw	$14, 0($6)")
asm("	lw	$14, SGIFlag")
asm("	sw	$14, 0($7)")
asm("	sw	$0, SGIFlag")
asm("	j	$31")
asm("	.end	IntegerMinus")

asm("# ------------------------------------------------------------")
asm("# void")
asm("# IntegerTimes(a,b,result,IsError)")
asm("#  SisalInteger    a,b;")
asm("#  SisalInteger    *result;")
asm("#  SisalBoolean    *IsError;")
asm("	.text")
asm("	.align	2")
asm("	.globl	IntegerTimes")
asm("	.ent	IntegerTimes 2")
asm("IntegerTimes:")
asm("	.option	O1")
asm("	.frame	$sp, 0, $31")
asm("	mulo	$14, $4, $5")
asm("	sw	$14, 0($6)")
asm("	lw	$14, SGIFlag")
asm("	sw	$14, 0($7)")
asm("	sw	$0, SGIFlag")
asm("	j	$31")
asm("	.end	IntegerTimes")

void
IntegerDiv(a,b,result,IsError)
     int	a,b;
     int	*result;
     SisalBoolean *IsError;
{
  *result = a / b;
  ErrorOccurred(*result,*IsError);
}
/* ------------------------------------------------------------ */
void
RealPlus(a,b,result,IsError)
     SisalReal		a,b;
     SisalReal		*result;
     SisalBoolean	*IsError;
{
  *result = a+b;
  IsFloatError(*result,*IsError);
}
void
RealMinus(a,b,result,IsError)
     SisalReal		a,b;
     SisalReal		*result;
     SisalBoolean	*IsError;
{
  *result = a-b;
  IsFloatError(*result,*IsError);
}
void
RealTimes(a,b,result,IsError)
     SisalReal		a,b;
     SisalReal		*result;
     SisalBoolean	*IsError;
{
  *result = a*b;
  IsFloatError(*result,*IsError);
}
void
RealDiv(a,b,result,IsError)
     SisalReal		a,b;
     SisalReal		*result;
     SisalBoolean	*IsError;
{
  *result = a/b;
  IsFloatError(*result,*IsError);
}
/* ------------------------------------------------------------ */
void
DoublePlus(a,b,result,IsError)
     SisalDouble	a,b;
     SisalDouble	*result;
     SisalBoolean	*IsError;
{
  *result = a+b;
  IsFloatError(*result,*IsError);
}
void
DoubleMinus(a,b,result,IsError)
     SisalDouble	a,b;
     SisalDouble	*result;
     SisalBoolean	*IsError;
{
  *result = a-b;
  IsFloatError(*result,*IsError);
}
void
DoubleTimes(a,b,result,IsError)
     SisalDouble	a,b;
     SisalDouble	*result;
     SisalBoolean	*IsError;
{
  *result = a*b;
  IsFloatError(*result,*IsError);
}
void
DoubleDiv(a,b,result,IsError)
     SisalDouble	a,b;
     SisalDouble	*result;
     SisalBoolean	*IsError;
{
  *result = a/b;
  IsFloatError(*result,*IsError);
}
#endif SGI

/* ------------------------------------------------------------ */
#ifdef GENERIC
/*
 *          Generic Machine
 * NOTE: In some systems the call signal( sig, SIG_IGN) does not
 *       work as sold. The software goes into an infinite loop at
 *       the instruction causing the exception. 
*/

/* ------------------------------------------------------------ */
SisalBoolean ErrorFlag;

void
FPEHandler(sig, code, sc)
	 int sig;
	 int code;
	 struct sigcontext *sc;
{
  ErrorFlag = TRUE;				/* Set the error flag */
  signal(sig, SIG_IGN);    /* Ignore until flag is reset by arith func */
}

/* ------------------------------------------------------------ */
void
MachineInit()
{
  ErrorFlag = FALSE;				/* Set the error flag */
  (void)signal(SIGFPE,FPEHandler);
}

/* All the operations are define in ARITH directory */

#endif
/* ------------------------------------------------------------ */
