#include "SC.h"
#include "SCLib.h"

#ifdef ALLDEBUG
#  define LOCALDEBUG	(1)
#else
#  define LOCALDEBUG	(0)
#endif

void
LoopAorB(in,out,info,zeroTrip)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
  SisalBoolean  zeroTrip;
{
  NodeInfo	BodyInfo, InitInfo, TestInfo, ReturnsInfo;
  NodeStuff	BodyStuff, InitStuff, TestStuff, ReturnsStuff;
  unsigned	GraphArity;
  IF1OBJECT	**TIN,**TOUT,**THold, **TTemp, **Flag;
  unsigned	InAr, BodyIn, ReturnsIn;
  unsigned	OutAr;
  Function	BodyCode, InitCode, TestCode, ReturnsCode;
  TypeD         *ReturnsType;
  char		*BodyName, *InitName, *TestName, *ReturnsName;
  int		Iteration;

  /* Declare space for the returns graph input */
  HeapGroup( PointerVector, ValueVector, LocalPointers, LocalValues );
  
  /* ------------------------------------------------------------ */
  /* For a LoopA (LoopB) graph, the execution is as follows. */
  /*   1: Increment the inputs to save values across executions. */
  /*   2: Execute the init graph using the inputs to LoopA into a */
  /*      temporary set of outputs.  Collect init outputs with merged in */
  /*      LoopA inputs for returns graph. */
  /*   3: Increment the iter count by 1 (execute test for loopB) for the new */
  /*      iteration and execute the body using previous outputs with merged in */
  /*      LoopA inputs and init outputs into the body outputs. */
  /*   4: Execute test graph with body outputs with merged in LoopA inputs. */
  /*      If the FLAG is an error, mark the LoopA outputs as errors */
  /*      and exit.  Collect body outputs. */
  /*      If FLAG is true  return to step 3. */
  /*   5: Execute return graph with collected outputs to make LoopA outputs. */
  /*   6: Clean up temporary variables.  */
  /* ------------------------------------------------------------ */

  /* 0. Build up some temporary structures */
  InitInfo    = ChildrenOf(info)[0];
  InitCode    = GraphCodeOf(InitInfo);
  InitName    = GraphNameOf(InitInfo);
  
  TestInfo    = ChildrenOf(info)[1];
  TestCode    = GraphCodeOf(TestInfo);
  TestName    = GraphNameOf(TestInfo);
  
  BodyInfo    = ChildrenOf(info)[2];
  BodyCode    = GraphCodeOf(BodyInfo);
  BodyName    = GraphNameOf(BodyInfo);
  
  ReturnsInfo    = ChildrenOf(info)[3];
  ReturnsCode    = GraphCodeOf(ReturnsInfo);
  ReturnsName    = GraphNameOf(ReturnsInfo);
  ReturnsType    = OType(ReturnsInfo);
    
  InAr  = INARITY(info);
  OutAr = OUTARITY(info);
  BodyIn = OUTARITY(BodyInfo);
  ReturnsIn = OUTARITY(ReturnsInfo);
    
  GraphArity = INARITY(BodyInfo);
  
  /* 1: Build vectors to hold temporary LoopA values */
  MapToLocalOrHeap( PointerVector, ValueVector, LocalPointers, LocalValues,
		   GraphArity*3+1 );
  
  TIN	= PointerVector;
  TOUT	= TIN + GraphArity;
  THold = TOUT + GraphArity;
  Flag = THold + GraphArity;
  
  PushEnv("LoopAorB",info,in,out,ValueVector,(unsigned)(GraphArity*3+1),0);
  
  /* ------------------------------------------------------------ */
  /* 2. Execute init graph ... */
  BuildNodeInfo(&InitStuff,OUTARITY(InitInfo),INARITY(InitInfo),
		OType(InitInfo),IType(InitInfo));
  ExecGraph(InitCode, InitName, in, TIN, &InitStuff);
  MergeVector( TIN, in, GraphArity, InAr );
  CollectResultsIntoMultiple(THold, TIN, ReturnsIn, GraphArity, ReturnsType);

  /* ------------------------------------------------------------ */
  /* 3. Increment iter count ... */
  Iteration = 0;
  BuildNodeInfo(&BodyStuff,BodyIn,INARITY(BodyInfo),OType(BodyInfo),
		IType(BodyInfo));
  BuildNodeInfo(&TestStuff,OUTARITY(TestInfo),INARITY(TestInfo),
		OType(TestInfo),IType(TestInfo));
  if ( zeroTrip ) {
    ExecGraph(TestCode, TestName, TIN, Flag, &TestStuff);
    if (BasErr(Flag[0])) goto done;
  } else {
    BVal(Flag[0]) = TRUE;
  }
    
  while( BVal(Flag[0]) ) {
    if ( InfiniteLoopCount && Iteration > InfiniteLoopCount ) {
#if Debugger
      InfiniteLoopFlag = TRUE;
#else
      Oops("In an infinite loop");
#endif
    }
  
    ExecGraph(BodyCode,BodyName,TIN,TOUT,&BodyStuff);
    MergeVector(TOUT,TIN,GraphArity,BodyIn);
    CollectResultsIntoMultiple(THold,TOUT,ReturnsIn,GraphArity,ReturnsType);

    /* 4. Execute Test with body outputs .. */
    ExecGraph(TestCode, TestName, TOUT, Flag, &TestStuff);
    if (BasErr(Flag[0])) break;
 
    /* Move outputs to inputs */
    TTemp = TIN; TIN = TOUT; TOUT = TTemp;
    Iteration++;
    
  }
  
  /* ------------------------------------------------------------ */
  /* 4. Mark the outputs as errors if FLAG=error[boolean] */
 done:
  if ( BasErr(Flag[0]) ) {
    SetToError(out,OType(info),OutAr);
  } else {
  /* ------------------------------------------------------------ */
  /* 5. Execute return graph ... */
    BuildNodeInfo(&ReturnsStuff,ReturnsIn,INARITY(ReturnsInfo),
		OType(ReturnsInfo),IType(ReturnsInfo));
    ExecGraph(ReturnsCode, ReturnsName, THold, out, &ReturnsStuff);
  }

  /*------------------------------------------------ */
  /* 6. Clean up allocated values */
  PopEnv();
  UnMapFromHeap( PointerVector, ValueVector, LocalPointers, LocalValues );
  
}

void
LoopA(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
    LoopAorB(in,out,info,FALSE);
}

void
LoopB(in,out,info)
  IF1OBJECT	*in[],*out[];
  NodeInfo	info;
{
    LoopAorB(in,out,info,TRUE);
}
