#include "SC.h"
#include "SCLib.h"

/* EXPORTED */ NodeInfo		CurrentTable ;

extern void MachineInit();

void
InitializeTables()
{
  int		NT;
  int		i;
  int		GraphCount;
  NodeInfo	N;

  /* We need to set up the expanded table with full information for */
  /* each of the modules that has been compiled for debugging.  Each */
  /* module entry starts out with only the graph entries.  The */
  /* expanded table is built executing the graph setup code which will */
  /* shove new entries into the current table */
  for(NT=0;Linkage[NT];NT++) {
    if ( ModuleDebugOf(Linkage[NT]) ) {
      CurrentTable = Linkage[NT];
      /* ------------------------------------------------------------ */
      /* For each original entry (graph), execute the setup to shove */
      /* all the node entries into the node table at the proper place */
      /* */
      GraphCount = ModuleSizeOf(CurrentTable);
      for(i=1;i<=GraphCount;i++) {
	N = CurrentTable+i;
	if (SetupCodeOf(N)) {
	  N->EdgeNames = CAllocate(INARITY(N)+OUTARITY(N),char*);
	  SetupCodeOf(N)(N);
	}
      }
    }
  }
}

void
Init()
{

  InitializeTables();

  InitializeLiteralPools();

  MachineInit();
}

void
NameExecuteNode(in,out,N)
     char	*in[];
     char	*out[];
     NodeInfo	N;
{
  int		i,j;
  char		**NodeNameList;


  /* Copy the node information to the table and repoint N at the */
  /* permanent copy. */
  CurrentTable[NodeIDOf(N)] = *N;
  N = CurrentTable+NodeIDOf(N);

  /* Build a list of input and output edge names */
  NodeNameList = CAllocate(INARITY(N)+OUTARITY(N),char*);
  for(i=0,j=0;i<INARITY(N);i++)	NodeNameList[j++] = in[i];
  for(i=0;i<OUTARITY(N);i++)	NodeNameList[j++] = out[i];
  N->EdgeNames = NodeNameList;
}
