#include "SC.h"
#include "SCLib.h"

#ifdef ALLDEBUG
#  define LOCALDEBUG	(1)
#else
#  define LOCALDEBUG	(0)
#endif

/* ------------------------------------------------------------ */
void
Forall(in,out,info)
     IF1OBJECT	*in[],*out[];
     NodeInfo	info;
{
  NodeInfo	*GraphList;
  NodeInfo	Generator,Body,Returns;
  NodeStuff	BodyInfo,ReturnsInfo;
  Function	BodyF,ReturnsF;
  char		*BodyN,*ReturnsN;
  unsigned	GeneratorOut,BodyIn,BodyOut,ReturnsIn,ReturnsOut,SentToBody;
  unsigned	Iterations,Iteration;
  unsigned	InAr,OutAr;
  IF1OBJECT	**PG,**PB,**PBout,**PR;
  unsigned	LocalCount;

  /* ------------------------------------------------------------ */
  /* This ``Heap Group'' is really just a declaration.  Keep it here */
  HeapGroup(LP,LV,LocalPtrs,LocalValues);
  /* ------------------------------------------------------------ */

  InAr		= INARITY(info);
  OutAr		= OUTARITY(info);

  GraphList	= ChildrenOf(info);

  Generator	= GraphList[0];
  GeneratorOut	= INARITY(Generator);

  Body		= GraphList[1];
  BodyF		= GraphCodeOf(Body);
  BodyN		= GraphNameOf(Body);
  BodyIn	= OUTARITY(Body);
  BodyOut	= INARITY(Body);

  Returns	= GraphList[2];
  ReturnsF	= GraphCodeOf(Returns);
  ReturnsN	= GraphNameOf(Returns);
  ReturnsOut	= INARITY(Returns);
  ReturnsIn     = OUTARITY(Returns);
  
  SentToBody = (BodyIn>GeneratorOut)?BodyIn:GeneratorOut;

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* Make some local vectors long enough to hold the results... */
  LocalCount = GeneratorOut+SentToBody+BodyOut+ReturnsIn;
  MapToLocalOrHeap(LP,LV,LocalPtrs,LocalValues,LocalCount);
  PushEnv("Forall",info,in,out,LV,LocalCount,0);
  PG = LP;
  PB = PG+GeneratorOut;
  PBout = PB+SentToBody;
  PR = PBout+BodyOut;

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* Pass the inputs to the generator and get back the multiples */
  GetMultiples(PG,Generator,in,InAr,IType(info));

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* Find the largest length of the multiples */
  Iterations = JustifyMultiples(PG,GeneratorOut);

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* For each iteration, Execute the body */


  BuildNodeInfo(&BodyInfo,BodyIn,BodyOut,OType(Body),IType(Body));

  for(Iteration=0;Iteration<Iterations;Iteration++) {
    /* Technically, this isn't really an infinite loop since it will */
    /* eventually terminate.  This just allows some symetry with the */
    /* iterative loop form. */
    if ( InfiniteLoopCount && Iteration > InfiniteLoopCount ) {
#if Debugger
      InfiniteLoopFlag = TRUE;
#else
      Oops("In an infinite loop");
#endif
    }

    /* Prepare the input to the body */
    UnPackMultiples(PB,PG,BodyIn,GeneratorOut,Iteration);
    MergeVector(PB,in,SentToBody,InAr);

    /* Execute the body */
    ExecGraph(BodyF,BodyN,PB,PBout,&BodyInfo);

    /* Collect the results */
    CollectResultsIntoMultiple(PR,PBout,ReturnsIn,BodyOut,OType(Returns));
  }

  MergeVector(PR,in,ReturnsIn,InAr);
  MergeVector(PR,PG,ReturnsIn,GeneratorOut);

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */

  BuildNodeInfo(&ReturnsInfo,ReturnsIn,ReturnsOut,OType(Returns),IType(Returns));

  ExecGraph(ReturnsF,ReturnsN,PR,out,&ReturnsInfo);

  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* ------------------------------------------------------------ */
  /* Clean up allocated values */
  UnMapFromHeap(LP,LV,LocalPtrs,LocalValues);
  PopEnv();
}
