#include "SC.h"
#include "SCLib.h"

void
ExecGraph(code,name,in,out,info) /* ARGSUSED */
     Function	code;
     char	*name;
     IF1OBJECT	*in[],*out[];
     NodeInfo	info;
{
#ifdef INSANITY
  SanityHook(in,IType(info),INARITY(info));
#endif

  code(in,out,info);

#ifdef INSANITY
  SanityHook(out,OType(info),OUTARITY(info));
#endif
}

void
ExecuteNode(in,out,info)
     IF1OBJECT	*in[];
     IF1OBJECT	*out[];
     NodeInfo	info;
{
  char		msg[128];
  int   error;
  
  if ( UNSAFE
#ifdef INSANITY
      || (OpCodeOf(info) >= 0 &&
	  OpCodeOf(info) < OpListSize  &&
	  OpList[OpCodeOf(info)].Code)
#else
      || 1
#endif      
      ) {

  /* Push the environment information for the node */
    PushEnv( OpList[OpCodeOf(info)].Name, info, in, out, (IF1OBJECT *) NULL,
	    0, 0 );
    HOOK(PreNodeHook(NodeIDOf(info),OpCodeOf(info),in,out,info));

#ifdef INSANITY
    SanityHook(in,IType(info),INARITY(info));
#endif
    (OpList[OpCodeOf(info)].Code)(in,out,info);

#ifdef INSANITY
    SanityHook(out,OType(info),OUTARITY(info));
#endif

    HOOK(PostNodeHook(NodeIDOf(info),OpCodeOf(info),in,out,info));
    PopEnv();
    } else {
    (void)sprintf(msg,"Operation %d not implemented",OpCodeOf(info));
    Oops(msg);
  }
}

void
FixupName(s)
     char	*s;
{
  for(;*s;s++) {
    if (islower(*s)) {
      *s = toupper(*s);
    } else if (*s == '.') {
      *s = 'x';
    }
  }
  *s++ = '_';
  *s = '\0';
}

void
UnFixupName(fixed,unfixed)
     char	*fixed,*unfixed;
{
  char		*p;

  /* Remove the trailing underscore */
  (void)strcpy(unfixed,fixed);
  unfixed[strlen(unfixed)-1] = '\0';

  /* Change the 'x' back to dots... */
  for(p=index(unfixed,'x');p;p=index(p+1,'x')) *p = '.';
}

/* ------------------------------------------------------------ */
/* Try to find an entry in the linkage of modules that matches Name. */
 /* If Name is is a number, enter at the first module at that graph */
 /* number. */
NodeInfo
FindGraph(Name,Mod,ExportedOnly)
     char	*Name;
     NodeInfo	Mod;
     int        ExportedOnly;
{
  int		GraphNum;
  int		NT;
  int		Entry;
  NodeInfo	Table;
  int		TableSize;
  char		FixedName[NameSize];
  char		*ColonPtr,*ModuleName,*FunctionName;

  /* Fix the name to reflect internal naming scheme */
  (void)strcpy(FixedName,Name);
  FixupName(FixedName);

  /* Break it into module name and function name unless we have */
  /* specified a module name on the call. */
  if ( Mod ) {
    FunctionName = FixedName;
  } else {
    Mod = NULL;
    ColonPtr = index(FixedName,':');
    if (ColonPtr) {
      ModuleName = FixedName;
      /* Try to find a module that matches the name */
      for(NT=0;Linkage[NT];NT++) {
	if ( StringEq(ModuleName,ModuleNameOf(Linkage[NT]))) {
	  Mod = Linkage[NT];
	  break;
	}
      }
      *ColonPtr = '\0';
      FunctionName = ColonPtr+1;
    } else {
      /* Just a name, no special module */
      FunctionName = FixedName;
    }
  }

  /* ------------------------------------------------------------ */
  /* Search for name */
  if (FunctionName) {
    GraphNum = atoi(FixedName);
    if (GraphNum) {
      Table = Linkage[0];
      TableSize = ModuleSizeOf(Table);
      if (GraphNum > 0 && GraphNum <= TableSize) {
	return Linkage[0]+GraphNum;
      }
    } else {
      /* First look in the requested module */
      if ( Mod ) {
	TableSize = ModuleSizeOf(Mod);
	for(Entry=1;Entry<=TableSize;Entry++) {
	  if (IsGraph(Mod+Entry) && (!ExportedOnly || IsExported(Table+Entry)) &&
	      strcmp(GraphNameOf(Mod+Entry),FunctionName)==0) {
	    return Mod+Entry;
	  }
	}
      }
      
      /* Now check everybody.  Here, however it must be a global function */
      for(NT=0;Linkage[NT];NT++) {
	Table = Linkage[NT];
	TableSize = ModuleSizeOf(Table);
	if ( Table == Mod ) continue; /* Already did this one */

	for(Entry=1;Entry<=TableSize;Entry++) {
	  if (IsGraph(Table+Entry) && (!ExportedOnly || IsExported(Table+Entry)) &&
	      strcmp(GraphNameOf(Table+Entry),FunctionName)==0) {
	    return Table+Entry;
	  }
	}
      }
    }
  }
  return (NodeInfo)(NULL);
}
/* Find the first node that meets the source line criteria in the */
 /* given module.  If no module is given, then don't return anything */
NodeInfo
FindNode(module,line,start)
     NodeInfo	module;
     int	line;
     int	start;
{
  int		i,Diff,ThisDiff;
  NodeInfo	N;
  int		SL;

  N = NULL;
  Diff = -1;
  if ( module ) {
    for(i=start;i<=ModuleSizeOf(module);i++) {
      SL = module[i].DebugInfo.SL;

      ThisDiff = (SL>line)?(SL-line):(line-SL);

      if ( ThisDiff < Diff || Diff == -1 ) {
	N = module+i;
	Diff = ThisDiff;
      }

      if ( Diff == 0 ) break;
    }
  }
  return N;
}

/* ------------------------------------------------------------ */
void
GraphEntry(EntryNode,Error)
     NodeInfo	EntryNode;
     char	*Error;
{
  NodeStuff	Info;
  int		i;
  IF1OBJECT	Locals[2*EntryMax];
  IF1OBJECT	*LocalPtr;
  IF1OBJECT	*in[EntryMax];
  IF1OBJECT	*out[EntryMax];
  int		mask;

  /* Clear out the error reporting variable */
  *Error = NULL;

  /* Make sure we have room for inputs and outputs */
  if (INARITY(EntryNode) > EntryMax || OUTARITY(EntryNode) > EntryMax) {
    Warning("Exceeded Maximum Entry inputs or outputs");
  }

  /* Set the input pointers for pass by reference and read inputs */
  mask = BlockSignals();
  FlushFibre();
  for(LocalPtr = Locals,i=0;i<OUTARITY(EntryNode);i++) {
    FibreRead(OType(EntryNode)[i],LocalPtr,Error);
    CheckWarning({AllowSignals(mask);});
    in[i] = LocalPtr++;
  }
  AllowSignals(mask);

  /* Set up return pointers for the outputs */
  for(i=0;i<INARITY(EntryNode);i++) {
    FCopy(LocalPtr,EmptyObject,aEMPTY);
    out[i] = LocalPtr++;
  }

  /* Forge a node information structure for initial entry and execute */
  /* the graph */
  BuildNodeInfo(&Info,
		/* Note in and out reversal */
		OUTARITY(EntryNode),INARITY(EntryNode),
		OType(EntryNode),IType(EntryNode));

  PushEnv("*entry",&Info,(IF1OBJECT**)NULL,(IF1OBJECT**)NULL,Locals,
	  (unsigned)(OUTARITY(EntryNode)+INARITY(EntryNode)),0);

  ExecGraph(GraphCodeOf(EntryNode),GraphNameOf(EntryNode),in,out,&Info);

  /* Report the outputs */
  OutputComment("----------------------------------------");
  for(i=0;i<INARITY(EntryNode);i++) {
    FibrePrint(Locals+OUTARITY(EntryNode)+i);
    if ( PackFibre ) IO_BlankLine();
  }
  OutputComment("----------------------------------------");

  PopEnv();
}
