#include "SC.h"
#include "SCLib.h"

void
MakeError(obj,T)
     IF1OBJECT	*obj;
     TypeD	T;
{
  SetDes(obj,T);

  switch(T->CODE) {
  case IF1ARRAY:
    CreateArray(obj,T,FALSE,TRUE,IntegerZero,0,0,NULL,0);
    break;
  case IF1BASIC:
    BasErr(obj) = TRUE;
    break;
  case IF1FIELD:
    Oops("No error yet");
    break;
  case IF1FUNCTION:
    Oops("No error yet");
    break;
  case IF1MULTIPLE:
    Oops("No error yet");
    break;
  case IF1RECORD:
    CreateRecord(obj,T,TRUE,NULL);
    break;
  case IF1STREAM:
    if (StrictStreams) {
      CreateArray(obj,T,FALSE,FALSE,IntegerOne,0,0,NULL,0);
    } else {
      Oops("No error for non-strict streams yet");
    }
    break;
  case IF1TAG:
    Oops("No error yet");
    break;
  case IF1TUPLE:
    Oops("No error yet");
    break;
  case IF1UNION:
    CreateUnion(obj,T,TRUE,IntegerZero,NULL);
    break;
  default:
    Oops("Bad type in MakeError");
  }
}
/* ------------------------------------------------------------ */
void
SetToError(out,TList,n)
     IF1OBJECT	*out[];
     TypeD	*TList;
     unsigned	n;
{
  int		i;
  for(i=0;i<n;i++) if (out[i]) MakeError(out[i],TList[i]);
}

/* ------------------------------------------------------------ */
void
CopyVector(dest,src,DESTN,SRCN)
     IF1OBJECT	*dest[],*src[];
     unsigned	DESTN,SRCN;
{
  unsigned	i;

  for(i=0;i<SRCN && i<DESTN;i++) Copy(dest[i],src[i]);

  for(;i<DESTN;i++) FCopy(dest[i],EmptyObject,aEMPTY);
}


/* ------------------------------------------------------------ */
void
EmptyVector(v,size)
     IF1OBJECT	*v[];
     unsigned	size;
{
  unsigned	i;

  for(i=0;i<size;i++) FCopy(v[i],EmptyObject,aEMPTY);
}

/* ------------------------------------------------------------ */
void
MergeVector(dest,src,DESTN,SRCN)
     IF1OBJECT	*dest[],*src[];
     unsigned	DESTN,SRCN;
{
  unsigned	i;

  for(i=0;i<SRCN && i<DESTN;i++) {
    if ( IsEmptyObject(dest[i]) ) Copy(dest[i],src[i]);
  }
}

/* ------------------------------------------------------------ */
int
AnyErrorValues(v,n)
     IF1OBJECT	*v[];
     unsigned	n;
{
  unsigned	i;

  for(i=0;i<n;i++) {
    if (IsAnErrorValue(v[i])) return 1;
  }

  return 0;
}

int
IsAnErrorValue(obj)
     IF1OBJECT		*obj;
{
  TypeD		T;

  if (obj) {
    T = TypeOf(obj);

    switch(T->CODE) {
     case IF1ARRAY:
      return (!ArrIsOK(obj)) || IsArrLBErr(obj);
      break;

     case IF1BASIC:
      return (int)(BasErr(obj));
      break;

     case IF1FIELD:
      Oops("No error yet");
      break;

     case IF1FUNCTION:
      return (int)(FALSE);	/* No error values defined for FUNCTIONS */
      break;

     case IF1MULTIPLE:
#ifdef MultErr
      Oops("Add error here");
#else
      return (int)(FALSE);
#endif
      break;

     case IF1RECORD:
      return (int)(RecErr(obj));
      break;

     case IF1STREAM:
      if (StrictStreams) {
	return (!ArrIsOK(obj)) || IsArrLBErr(obj);
      } else {
	Oops("No error for non-strict streams yet");
      }
      break;

     case IF1TAG:
      Oops("No error yet");
      break;

     case IF1TUPLE:
      Oops("No error yet");
      break;

     case IF1UNION:
      return (int)(UniErr(obj));
      break;

    case IF1EMPTY:
      return (int)(FALSE);
      break;

     default:
      Oops("Bad type in IsAnErrorValue");
      break;
    }
  }

  return (int)(FALSE);		/* Non-values are not errors */
}
/* ------------------------------------------------------------ */

int
AnyErroneousValues(v,n)
     IF1OBJECT	*v[];
     unsigned	n;
{
  unsigned	i;

  for(i=0;i<n;i++) {
    if (IsAnErroneousValue(v[i])) return 1;
  }

  return 0;
}

int
AnyErroneousValuesInBag(B,view,n)
     BagPtr	B;
     unsigned	view;
     unsigned	n;
{
  unsigned	i;

  for(i=0;i<n;i++) {
    if (IsAnErroneousValue(PointerIntoBag(B,i+view))) return 1;
  }

  return 0;
}

int
IsAnErroneousValue(obj)
     IF1OBJECT		*obj;
{
  TypeD		T;

  if (obj) {
    T = TypeOf(obj);

    switch(T->CODE) {
     case IF1ARRAY:
      return (!ArrIsOK(obj)) || IsArrLBErr(obj)
	|| AnyErroneousValuesInBag(ArrCol(obj),ArrView(obj),ArrPS(obj));
      break;

     case IF1BASIC:
      return (int)(BasErr(obj));
      break;

     case IF1FIELD:
      Oops("No error yet");
      break;

     case IF1FUNCTION:
      Oops("No error yet");
      break;

     case IF1MULTIPLE:
#ifdef MultErr
      Oops("Add error here");
#else
      return (int)(FALSE);
#endif
      break;

     case IF1RECORD:
      return (int)(RecErr(obj))
	|| AnyErroneousValuesInBag(RecCol(obj), 0,
				   FieldCountOfRecord(TypeOf(obj)));
      break;

     case IF1STREAM:
      if (StrictStreams) {
	return (!ArrIsOK(obj)) || IsArrLBErr(obj)
	  || AnyErroneousValuesInBag(ArrCol(obj),ArrView(obj),ArrPS(obj));
      } else {
	Oops("No error for non-strict streams yet");
      }
      break;

     case IF1TAG:
      Oops("No error yet");
      break;

     case IF1TUPLE:
      Oops("No error yet");
      break;

     case IF1UNION:
      return (int)(UniErr(obj)) || 
	IsAnErroneousValue(PointerIntoBag(UniVal(obj),0));
      break;

     default:
      Oops("Bad type in IsAnErrorValue");
      break;
    }
  }

  /* Should never get here, but do this for LINT */
  Oops("Impossible");
  return (int)(TRUE);
}

void
ArrayCopy(List,Offsets,N)
     IF1OBJECT	List[];
     unsigned	Offsets[];
     int	N;
{
  /* Copy down the elements of the array, making straight copies for */
  /* elements not in the List, but making array copies for elements in */
  /* the List.*/

  IF1OBJECT	NewArray,*New,*Old;
  BagPtr	NewCollection;
  unsigned	i,OldPos;

  /* Copy over information from the head of the list */
  NewCollection = EmptyBag(ArrPS(List+0));
  CreateArray(&NewArray,
	      TypeOf(List+0),
	      ArrIsOK(List+0),IsArrLBErr(List+0),
	      ArrLB(List+0),
	      ArrTS(List+0),ArrPS(List+0),
	      NewCollection,0);

  /* Walk through the array making straight copies exect where it */
  /* intersects the list */
  for(i=0; i<ArrPS(List+0); i++) {
    New = PointerIntoBag(NewCollection,i);
    OldPos = ArrView(List+0)+i;
    if ( N > 1 && OldPos == Offsets[0] ) {
      ArrayCopy(List+1,Offsets+1,N-1);
      Copy(New,List+1);
    } else {
      Old = PointerIntoBag(ArrCol(List+0),OldPos);
      Copy(New,Old);
    }
  }

  /* Copy back into the list */
  List[0] = NewArray;
}
