#include "SC.h"
#include "SCLib.h"

/* ------------------------------------------------------------ */
BagPtr
EmptyBag(SizeOfBag)
     unsigned	SizeOfBag;
{
  BagPtr	New;
  IF1OBJECT	*Items;
  int		i;

  /* ------------------------------------------------------------ */
  /* Allocate a bag of the proper size and fill it with empty values */
  SizeOfBag = (SizeOfBag) ? SizeOfBag : 10;
  New = Allocate(Bag);
  Items = CAllocate(SizeOfBag,IF1OBJECT);
  for(i=0;i<SizeOfBag;i++) {
    FCopy(Items+i,EmptyObject,aEMPTY);
  }

  New->Size		= SizeOfBag;
  New->Ref              = 0;
  for(i=0;i<BagFanout;i++) New->Fanout[i] = NULL;
  New->Items		= Items;

  /* ------------------------------------------------------------ */
  /* Link it into the active bag chain */
  New->NextInChain = BagList;
  BagList = New;

  return New;
}

/* ------------------------------------------------------------ */
IF1OBJECT*
GetPointerIntoBag(B,n,extend)
     BagPtr		B;
     unsigned		n;
     SisalBoolean	extend;
{
  unsigned	Size;
  int		segment;
  int		offset;
  int		ChainSeg;

  Size = B->Size;
  if (Size==0) Oops("Zero sized bag!!!");
  
  segment = n / Size;
  offset = n % Size;
  while( segment ) {
    ChainSeg = (segment-1) % BagFanout;
    if (!B->Fanout[ChainSeg]) {
      if (extend) {
	B->Fanout[ChainSeg] = EmptyBag(Size);
      } else {
	return NULL;
      }
    }

    B = B->Fanout[ChainSeg];
    segment = segment / BagFanout;
  }

  return B->Items+offset;
}

/* ------------------------------------------------------------ */
IF1OBJECT*
PointerIntoBag(B,offset)
     BagPtr	B;
     unsigned	offset;
{
  return (B->Size)?GetPointerIntoBag(B,offset,FALSE):NULL;
}

/* ------------------------------------------------------------ */
void
DumpBag(B)
     BagPtr	B;
{
  unsigned	i;
  IF1OBJECT	*ObjPtr;

  for(i=0; ObjPtr=PointerIntoBag(B,i); i++) {
    FibrePrint(ObjPtr);
  }
}

/* ------------------------------------------------------------ */
void
DestroyBag(B)
     BagPtr	B;
{
  unsigned	i;

  /* First, destroy all sub-bags 
*  for(i=0;i<BagFanout;i++) {
*   if ( B->Fanout[i] ) DestroyBag(B->Fanout[i]);
*  }
*  There is no need to destroy all the Fanout bags recursively because
   all of them are in the BagList.  Deleting them causes the BagList to
   get corrupted.  Walter Cedeno, 3/17/92.    */ 

  /* Now destroy the item list and the bag */
  Free(B->Items);
  Free(B);
}

/* ------------------------------------------------------------ */
BagPtr
FillBag(in,step,n,size)
     IF1OBJECT	*in[];
     int	step;
     int	n;
     int	size;
{
  BagPtr	B;
  IF1OBJECT	*Element;
  unsigned	i;
  int		Pos;

  B = EmptyBag((unsigned)size);

  for(i=0;i<n;i++) {
    Pos = i*step;
    Element = GetPointerIntoBag(B,i,TRUE);
    Copy(Element,in[Pos]);
  }

  return B;
}

/* ------------------------------------------------------------ */
void
FillFromBag(Old,New,OldView,NewView,n)
     BagPtr	Old,New;
     unsigned	OldView,NewView;
     unsigned	n;
{
  IF1OBJECT	*OldElement,*NewElement;
  unsigned	i;

  for(i=0;i<n;i++) {
    NewElement = GetPointerIntoBag(New,NewView+i,TRUE);
    OldElement = GetPointerIntoBag(Old,OldView+i,FALSE);
    Copy(NewElement,OldElement);
  }
}

/* ------------------------------------------------------------ */
BagPtr
CopyOfBag(B,GrowthFactor,First,Count,View)
     BagPtr	B;
     unsigned	GrowthFactor,First,Count,View;
{
  BagPtr	New;
  int		i;

  HOOK(CopyHook(Count));

  if ( !B ) {
    New = NULL;
  } else {
    New = EmptyBag(Count+View+GrowthFactor);
    for(i=0;i<Count;i++) {
      Copy(New->Items+i+View,PointerIntoBag(B,First+i));
    }
  }

  return New;
}
/* ------------------------------------------------------------ */
void
AppendBags(A,AView,B,BView,N)
     BagPtr	A;
     unsigned	AView;
     BagPtr	B;
     unsigned	BView;
     unsigned	N;
{
  unsigned	i;
  IF1OBJECT	*APtr,*BPtr;

  for(i=0;i<N;i++) {
    APtr = GetPointerIntoBag(A,AView+i,TRUE);
    BPtr = PointerIntoBag(B,BView+i);
    Copy(APtr,BPtr);
  }
}
