#include "SC.h"
#include "SCLib.h"

extern char	*malloc();
extern char	*calloc();

/* ------------------------------------------------------------ */
/* Provide a means for garbage collecting before the heap grows out of */
/* site.  After a periodic number of allocations, a garbage collection */
/* is done to compact the heap. */
static int AllocationCount = 0;

char*
SafeAllocate(size)
     unsigned	size;
{
  char		*new;

  /* ------------------------------------------------------------ */
  /* Check for garbage collection */
  if ( ++AllocationCount > PeriodicGarbage ) {
    GarbageCollect();
    AllocationCount = 0;
  }

  new = malloc(size);

  if (!new) {
    GarbageCollect();
    new = malloc(size);
    if (!new) Oops("Out of memory");
  }

#ifdef MEMORYCHECK
  if ( !malloc_verify() ) Oops("Memory Error");
#endif

  return new;
}

char*
SafeCAllocate(nelem,elsize)
     unsigned	nelem,elsize;
{
  char		*new;
  /* ------------------------------------------------------------ */
  /* Check for garbage collection */
  if ( ++AllocationCount > PeriodicGarbage ) {
    GarbageCollect();
    AllocationCount = 0;
  }

  new = calloc(nelem,elsize);

  if (!new) {
    GarbageCollect();
    new = calloc(nelem,elsize);
    if (!new) Oops("Out of memory");
  }

#ifdef MEMORYCHECK
  if ( !malloc_verify() ) Oops("Memory Error");
#endif

  return new;
}

void
SafeFree(ptr)
     char	*ptr;
{
  free(ptr);

#ifdef MEMORYCHECK
  if ( !malloc_verify() ) Oops("Memory Error");
#endif
}
