#ifndef SYSV
#define CHARSTARSTAR   (char**)
extern char	*sprintf();
#else
#define CHARSTARSTAR
#endif

#ifndef SCLIB_LOADED
#define SCLIB_LOADED

#define Warning(msg)		{ (void)strcpy(Error,msg); return; }
#define CheckWarning(code)	{ if ( Error[0] ) {code;return;}}
#define CheckWarningV(code,V)	{ if ( Error[0] ) {code;return V;}}

#ifndef UNSAFE
#  define UNSAFE		(0)
#endif

#ifdef NOHOOKS
# define HOOK(a)		/* Nothing */
#else
# define HOOK(a)		a
#endif

/* ------------------------------------------------------------ */
#ifdef GENERIC
# define CheckError( flag ) \
{ extern SisalBoolean ErrorFlag; \
  extern void FPEHandler(); \
  if ( ErrorFlag ) { \
    (flag) = TRUE; \
    ErrorFlag = FALSE; \
    (void) signal(SIGFPE, FPEHandler); \
  } \
  else (flag) = FALSE; \
}
#else
#define CheckError( flag )  (flag) = FALSE
#endif

/* ------------------------------------------------------------ */
#define DigitValueOf(c)	((c)-'0')
/* ------------------------------------------------------------ */
/* W.C. replaced kill(getpid(),SIGSEGV) */
#define Oops(msg) \
{\
  (void)fputs("# ",stderr);\
  (void)fputs(msg,stderr);\
  (void)fprintf(stderr,"\n# ERROR OCCURRED at %s[%d]\n",__FILE__,__LINE__);\
  (void)fflush(stdout);\
  (void)fflush(stderr);\
  (void)exit(0);\
}

/* ------------------------------------------------------------ */
/* Memory Allocation */
#define Allocate(type)	    ((type*)SafeAllocate(sizeof(type)))
#define CAllocate(n,type)   ((type*)SafeCAllocate((unsigned)(n),sizeof(type)))
#define Free(ptr)	    SafeFree((char*)(ptr))
  
/* ------------------------------------------------------------ */
/* Object and Type Creators/Accessors */
#define SetDes(optr,type)	{ (optr)->GenericValue.Description = (type); }
#define TypeOf(obj)		((obj)->GenericValue.Description)

#define TypeEntryOf(T)			((T)->CODE)
#define ElementTypeOfArray(T)		((T)->MoreInfo.ArrayELEMENT_TYPE)
#define KindOfBasic(T)			((T)->MoreInfo.BasicCODE)
#define ElementTypeOfMultiple(T)	((T)->MoreInfo.MultipleELEMENT_TYPE)
#define FieldCountOfRecord(T)		((T)->MoreInfo.RecordINFO.FieldCount)
#define FieldTypesOfRecord(T)		((T)->MoreInfo.RecordINFO.FieldTypes)
#define ElementTypeOfStream(T)		((T)->MoreInfo.StreamELEMENT_TYPE)
#define TagCountOfUnion(T)		((T)->MoreInfo.UnionINFO.TagCount)
#define TagTypesOfUnion(T)		((T)->MoreInfo.UnionINFO.TagTypes)

#define ARRAYLIKE(T) \
  (TypeEntryOf(T)==IF1ARRAY || (StrictStreams && TypeEntryOf(T)==IF1STREAM))
#define STREAMLIKE(T) (TypeEntryOf(T) == IF1STREAM)
#define UNIONTYPE(T) (TypeEntryOf(T) == IF1UNION)
/* ------------------------------------------------------------ */
/* ARRAYS */
#define CreateArray(a,type,isok,lbe,lbv,ts,ps,col,view)\
{\
  SetIsOK(a,isok);\
  SetLB(a,lbe,lbv);\
  SetTS(a,ts);\
  SetPS(a,ps);\
  SetCol(a,col);\
  SetView(a,view);\
  SetDes(a,type);\
}

#define SetIsOK(optr,val) \
{ (optr)->aARRAY.IsOK = (SisalBoolean)(val); }

#define SetLB(optr,err,val) \
{ \
  (optr)->aARRAY.LowerBound.aINTEGER.Error = err;\
  (optr)->aARRAY.LowerBound.aINTEGER.aINTEGER = val;\
}

#define SetPS(optr,val) \
{ (optr)->aARRAY.PrefixSize = val; }

#define SetTS(optr,val) \
{ (optr)->aARRAY.TotalSize = val; }

#define SetCol(optr,val) \
{ (optr)->aARRAY.Collection = val; }

#define SetView(optr,val) \
{ (optr)->aARRAY.View = val; }

#define ArrIsOK(optr)	((optr)->aARRAY.IsOK)
#define IsArrLBErr(optr) ((optr)->aARRAY.LowerBound.aINTEGER.Error)
#define ArrLB(optr)	((optr)->aARRAY.LowerBound.aINTEGER.aINTEGER)
#define ArrPS(optr)	((optr)->aARRAY.PrefixSize)
#define ArrTS(optr)	((optr)->aARRAY.TotalSize)
#define ArrCol(optr)	((optr)->aARRAY.Collection)
#define ArrView(optr)	((optr)->aARRAY.View)
#define ArrBaseElement(optr) (ArrCol(optr)+ArrView(optr))
#define BagPos(n,arr)	((unsigned)(LocalSub((n)+ArrView(arr),(ArrLB(arr)))))

/* ------------------------------------------------------------ */
/* BASIC */
#define BasErr(optr)	((optr)->GenericBasic.Error)
#define BVal(optr)	((optr)->aBOOLEAN.aBOOLEAN)
#define CVal(optr)	((optr)->aCHARACTER.aCHARACTER)
#define DVal(optr)	((optr)->aDOUBLE.aDOUBLE)
#define IVal(optr)	((optr)->aINTEGER.aINTEGER)
#define RVal(optr)	((optr)->aREAL.aREAL)

#define sBasErr(s)	((s).aINTEGER.Error)
#define sBVal(s)	((s).aBOOLEAN.aBOOLEAN)
#define sCVal(s)	((s).aCHARACTER.aCHARACTER)
#define sDVal(s)	((s).aDOUBLE.aDOUBLE)
#define sIVal(s)	((s).aINTEGER.aINTEGER)
#define sRVal(s)	((s).aREAL.aREAL)

/* ------------------------------------------------------------ */
/* FUNCTION */
#define FunName(f)	((f)->aFUNCTION.Name)
#define FunCode(f)	((f)->aFUNCTION.Code)

/* ------------------------------------------------------------ */
/* MULTIPLE */
#define MultTag(optr)	((optr)->aMULTIPLE.Tag)
#define MultError(optr)	((optr)->aMULTIPLE.IsError)
#define MultSize(optr)	((optr)->aMULTIPLE.Size)
#define MultTrueSize(optr) ((optr)->aMULTIPLE.TrueSize)
#define MultView(optr)	((optr)->aMULTIPLE.VALUE.BagMult.View)
#define MultBag(optr)	((optr)->aMULTIPLE.VALUE.BagMult.Collection)
#define MultLow(optr)	((optr)->aMULTIPLE.VALUE.Low)

/* ------------------------------------------------------------ */
/* RECORD */
#define RecErr(optr)	((optr)->aRECORD.IsError)
#define RecCol(optr)	((optr)->aRECORD.Fields)

/* ------------------------------------------------------------ */
/* UNION */
#define UniErr(optr)	((optr)->aUNION.IsError)
#define UniTag(optr)	((optr)->aUNION.Tag)
#define UniVal(optr)	((optr)->aUNION.Value)
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* Node info stuff */
#define BuildNodeInfo(info,_InArity,_OutArity,_InTypes,_OutTypes) {\
  (info)->InArity	= _InArity;\
  (info)->OutArity	= _OutArity;\
  (info)->InTypes	= _InTypes;\
  (info)->OutTypes	= _OutTypes;\
  (info)->EdgeNames	= (char**)(NULL);\
  (info)->Parent	= (NodeInfo)(NULL);\
  (info)->KindOfNode	= Constructed;\
}
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* REFERENCE COUNTING and STRUCTURE INFO */
#define IType(info)	((info)->InTypes)
#define OType(info)	((info)->OutTypes)
#define InfoKind(info)	((info)->KindOfNode)
#define IsFunctionName(name) (!islower((name)[1]))

#define NodeIDOf(N)	((N)->NodeID)
#define LocalEdgeNames(N)  ((char**)((N)->DebugInfo.DP1))
#define LHSLocalEdgeNames(N)  (CHARSTARSTAR((N)->DebugInfo.DP1))
#define GlobalNames(N)  ((char**)((N)->DebugInfo.DP2))
#define LHSGlobalNames(N)  (CHARSTARSTAR((N)->DebugInfo.DP2))
#define GlobalNameCount(N)  ((N)->DebugInfo.DI1)
#define ParentOf(N)	((N)->Parent)
#define OpCodeOf(N)	((N)->StructureInfo.INT1)
#define ChildCountOf(N)	((N)->StructureInfo.INT2)
#define ChildrenOf(N)	((NodeInfo*)((N)->StructureInfo.PTR1))
#define LocalCountOf(N)	((N)->StructureInfo.INT1)
#define SubNodeCountOf(N) ((N)->StructureInfo.INT2)
#define LocalNameOf(N)	((char**)((N)->StructureInfo.PTR1))
#define LHSLocalNameOf(N) (CHARSTARSTAR((N)->StructureInfo.PTR1))
#define SubNodeOf(N)	((NodeInfo*)((N)->StructureInfo.PTR2))
#define GraphNameOf(N)	((char*)((N)->StructureInfo.PTR3))
#define GraphCodeOf(N)	((Function)((N)->StructureInfo.PTR4))
#define SetupCodeOf(N)	((Function)((N)->StructureInfo.PTR5))

#define ModuleLiteralCountOf(N)	((N)->StructureInfo.INT2)
#define ModuleLiterals(N) ((LiteralPoolElement*)((N)->StructureInfo.PTR1))
#define ModuleNameOf(N)	((char*)((N)->StructureInfo.PTR2))
#define ModuleDebugOf(N) ((int)((N)->StructureInfo.PTR3))

#define IsSimple(N)	((N)->KindOfNode == Simple)
#define IsCompound(N)	((N)->KindOfNode == Compound)
#define IsGraph(N)	((N)->KindOfNode == Graph)
#define IsExported(N)	((N)->Exported)

#define IsEmptyObject(optr) (TypeEntryOf(TypeOf(optr)) == IF1EMPTY)
#define IsMultipleObject(optr) (TypeEntryOf(TypeOf(optr)) == IF1MULTIPLE)

#define CreateInteger(i,err,val) {\
  BasErr(i)	= err;\
  IVal(i)	= val;\
  SetDes(i,	IntegerTypeD);\
}
/* ------------------------------------------------------------ */
/* RECORDS */
#define CreateRecord(r,type,iserr,col)\
{\
  RecErr(r) = iserr;\
  RecCol(r) = col;\
  SetDes(r,type);\
}
/* ------------------------------------------------------------ */
/* UNIONS */
#define CreateUnion(u,type,iserr,tag,val)\
{\
  UniErr(u) = iserr;\
  UniTag(u) = tag;\
  UniVal(u) = val;\
  SetDes(u,type);\
}
/* ------------------------------------------------------------ */
/* BAGS */
typedef struct Bag {
  int		Size;
  unsigned	Ref;
  struct Bag	*Fanout[BagFanout];
  IF1OBJECT	*Items;
  struct Bag	*NextInChain;
} Bag,*BagPtr;
/* ------------------------------------------------------------ */
typedef struct {
  char		*Option;
  enum {BoolParm,IntParm,DoubleParm,StringParm,WildParm,ToggleParm} Kind;
  char		*Addr;
  char		*Default;
  void		((*OptionAction)());
  char		*Usage;
} Parameter;
/* ------------------------------------------------------------ */
#define OutputCommentF(args) \
{ char  msg[MaxCommentSize];\
  (void)(sprintf args);\
  OutputComment(msg);\
}
/* ------------------------------------------------------------ */
typedef struct Environment {
  char		*NAME;
  NodeInfo	INFO;
  IF1OBJECT	**IN;
  IF1OBJECT	**OUT;
  IF1OBJECT	*VARS;
  int		VARCOUNT;
  struct Environment *Next;
  int		Shadow;
} Environment;
/* ------------------------------------------------------------ */
#define HeapGroup(P,V,LP,LV) IF1OBJECT	**P,*V,*LP[EntryMax],LV[EntryMax]

#define MapToLocalOrHeap(_P,_V,_LP,_LV,n) {\
  int	VectorInitializeI;\
\
  if ( (n) < EntryMax ) {\
    _P = _LP;\
    _V = _LV;\
  } else {\
    _P = CAllocate((n),IF1OBJECT*);\
    _V = CAllocate((n),IF1OBJECT);\
  }\
\
  for(VectorInitializeI=0;VectorInitializeI<(n);VectorInitializeI++) {\
    _P[VectorInitializeI] = _V+VectorInitializeI;\
  }\
  EmptyVector(_P,(unsigned)n);\
}

#define UnMapFromHeap(P,V,LP,LV) {\
  if (P != LP) {\
    Free(P);\
    Free(V);\
  }\
}

/* ------------------------------------------------------------ */
#define NoWorkIfNoOutput()	if ( out[0] == NULL ) return

/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* ------------------------------------------------------------ */
/* Reduction */
typedef enum { TREE,LEFT,RIGHT } ReduceDir;
/* ------------------------------------------------------------ */

#include "extern.h"
extern	 	NodeInfo Linkage[];
/* ------------------------------------------------------------ */
/* Linkable PACKAGE stuff */
#ifdef PACKAGES
  extern void PACKAGE_HOOK();
  typedef enum { PackagePreStart, PackagePreNode, PackagePostNode,
		   PackageGraph, PackageStart, PackageError,
		   PackageForall, PackageFunction, PackageComplete,
		   PackageEndGraph
		   } PackageHookType;
#else
#  define PACKAGE_HOOK(a)	/* Nothing */
#endif

/* ------------------------------------------------------------ */
/* Output package */
extern int	 PrintStringCurrentLength[];
extern int	 PrintStringLength[];
extern char	 *PrintStringBuffers[];
extern int	 StringPrintLevel;

#define OutputString(s)	{\
  if ( StringPrintLevel ) {\
    int slen = strlen(s);\
    if ( (PrintStringCurrentLength[StringPrintLevel-1] + slen) <\
	PrintStringLength[StringPrintLevel-1] ) {\
      (void)strcat(PrintStringBuffers[StringPrintLevel-1],s);\
      PrintStringCurrentLength[StringPrintLevel-1] += slen;\
    } else {\
      if ( PrintStringCurrentLength[StringPrintLevel-1] != PrintStringLength[StringPrintLevel-1] ) \
        PrintStringCurrentLength[StringPrintLevel-1] = \
            PrintStringLength[StringPrintLevel-1];\
    }\
  } else {\
    IO_OutputString(s);\
  }\
}

#define OutputChar(c) {\
  if ( StringPrintLevel ) {\
    if ( (PrintStringCurrentLength[StringPrintLevel-1] + 1) <\
	PrintStringLength[StringPrintLevel-1] ) {\
      PrintStringBuffers[StringPrintLevel-1][PrintStringCurrentLength[StringPrintLevel-1]] = c;\
      PrintStringBuffers[StringPrintLevel-1][PrintStringCurrentLength[StringPrintLevel-1]+1] = NULL;\
      PrintStringCurrentLength[StringPrintLevel-1]++;\
    } else {\
      if ( PrintStringCurrentLength[StringPrintLevel-1] != PrintStringLength[StringPrintLevel-1] ) \
        PrintStringCurrentLength[StringPrintLevel-1] = \
            PrintStringLength[StringPrintLevel-1];\
    }\
  } else {\
    IO_OutputChar(c);\
  }\
}
#define OutputComment(s)	{if ( !StringPrintLevel ) IO_OutputComment(s);}
#define BlankLine()    {\
  if ( StringPrintLevel ) {\
    OutputChar(' ');\
  } else {\
    IO_BlankLine();\
  }\
}
#define Separator()		{if ( StringPrintLevel ) OutputChar(' ');}
#define	StartComment(s)		{if ( !StringPrintLevel ) IO_StartComment(s);}
#define	AddComment(s)		{if ( !StringPrintLevel ) IO_AddComment(s);}
#define	ReleaseComment()	{if ( !StringPrintLevel ) IO_ReleaseComment();}

#endif
