#ifndef SC_LOADED
#define SC_LOADED

#include "SCTwiddle.h"

#ifndef Debugger
# define Debugger	(0)
#endif

#include <stdio.h>
#include <string.h>
#include <signal.h>
#include <ctype.h>
#include <math.h>

/* ------------------------------------------------------------ 
   The boolean and null types are the same for all representations
   ------------------------------------------------------------ */
   /* BOOLEAN */
	typedef enum {FALSE=0,TRUE=1,UNDEF=2}	SisalBoolean;
#	define BooleanMaxVal			(TRUE)
#	define BooleanMinVal			(FALSE)
   /* NULL */
	typedef enum {NIL=0}			SisalNull;

#include "macdep.h"		/* Define types for this machine */

/* ------------------------------------------------------------ */
typedef void	((*Function)());

typedef struct {
  char		*Name;
  Function	Code;
} OpName;
#define OpEntry(name,f)	{ name,f }

typedef struct {
  char		*Name;
  Function	Graph;
  int		Offset;
} NameCode;

/* ------------------------------------------------------------ */
#define NONE			(1) /* Must use at least one entry in array */

/* ------------------------------------------------------------
   Define the types. We need ? type classes where the basic type has
   seven subtypes.  Additionally, we define an empty type for use in
   to clarify when a port has no value assigned.

   IF1ARRAY
   IF1BASIC
       IF1Boolean
       IF1Character
       IF1Double
       IF1Integer
       IF1Null
       IF1Real
   IF1FIELD
   IF1FUNCTION
   IF1MULTIPLE
   IF1RECORD
   IF1STREAM
   IF1TUPLE
   IF1UNION
   IF1EMPTY
*/
typedef enum {
  IF1ARRAY	= 0,
  IF1BASIC	= 1,
  IF1FIELD	= 2,
  IF1FUNCTION	= 3,
  IF1MULTIPLE  	= 4,
  IF1RECORD	= 5,
  IF1STREAM	= 6,
  IF1TAG	= 7,
  IF1TUPLE	= 8,
  IF1UNION	= 9,
  IF1EMPTY	= 99
} EntryType;

typedef enum {
  IF1Boolean	= 0,
  IF1Character	= 1,
  IF1Double	= 2,
  IF1Integer	= 3,
  IF1Null	= 4,
  IF1Real	= 5,
  IF1WILD	= 6
} BasicType;

typedef struct {
  char	       *Name;
} TypeStuff;

#define StandardStuff	EntryType CODE; 	TypeStuff INFO

#define ArrayStuff	struct TypeStructure	*ArrayELEMENT_TYPE;
#define BasicStuff	BasicType		BasicCODE;
#define FieldStuff
#define FunctionStuff
#define MultipleStuff	struct TypeStructure	*MultipleELEMENT_TYPE;
#define	RecordStuff	struct { \
				unsigned		FieldCount;\
				struct TypeStructure	**FieldTypes;\
			} RecordINFO;
#define StreamStuff	struct TypeStructure	*StreamELEMENT_TYPE;
#define TagStuff
#define TupleStuff
#define	UnionStuff	struct { \
				unsigned		TagCount;\
				struct TypeStructure	**TagTypes;\
			} UnionINFO;
#define EmptyStuff

/* ARRAY */
typedef struct {
  StandardStuff;
  ArrayStuff
} ArrayTypeStructure;

/* BASIC */
typedef struct {
  StandardStuff;
  BasicStuff
} BasicTypeStructure;

/* FIELD */
typedef struct {
  StandardStuff;
  FieldStuff
} FieldTypeStructure;

/* FUNCTION */
typedef struct {
  StandardStuff;
  FunctionStuff
} FunctionTypeStructure;

/* MULTIPLE */
typedef struct {
  StandardStuff;
  MultipleStuff
} MultipleTypeStructure;

/* RECORD */
typedef struct {
  StandardStuff;
  RecordStuff
} RecordTypeStructure;

/* STREAM */
typedef struct {
  StandardStuff;
  StreamStuff
} StreamTypeStructure;

/* TUPLE */
typedef struct {
  StandardStuff;
  TupleStuff
} TupleTypeStructure;

/* UNION */
typedef struct {
  StandardStuff;
  UnionStuff
} UnionTypeStructure;

/* EMPTY */
typedef struct {
  StandardStuff;
  EmptyStuff
} EmptyTypeStructure;

typedef struct TypeStructure {
  StandardStuff;
  union {
    ArrayStuff
    BasicStuff
    FieldStuff
    FunctionStuff
    MultipleStuff
    RecordStuff
    StreamStuff
    TupleStuff
    UnionStuff
    EmptyStuff
  } MoreInfo;
} TypeStructure,*TypeD;
/* ------------------------------------------------------------ */
#define TP(x)				((TypeD)(&(x)))
/* ------------------------------------------------------------ */
#define DefineArray(Type,Info,ElementType) \
  static ArrayTypeStructure Type = { IF1ARRAY,Info,TP(ElementType) }

#define DefineBasic(Type,Info,Code) \
  static BasicTypeStructure Type = { IF1BASIC,Info,Code }

#define DefineField(Type,Info) \
  static FieldTypeStructure Type = { IF1FIELD,Info }

#define DefineFunction(Type,Info) \
  static FunctionTypeStructure Type = { IF1FUNCTION,Info }

#define DefineMultiple(Type,Info,ElementType) \
  static MultipleTypeStructure Type = { IF1MULTIPLE,Info,TP(ElementType) }

#define DefineRecord(Type,Info,Count,FieldTypes) \
  static RecordTypeStructure Type = { IF1RECORD,Info,{Count,FieldTypes}}

#define DefineStream(Type,Info,ElementType) \
  static StreamTypeStructure Type = { IF1STREAM,Info,TP(ElementType) }

#define DefineTuple(Type,Info) \
  static TupleTypeStructure Type = { IF1TUPLE,Info }

#define DefineUnion(Type,Info,Count,TagTypes) \
  static UnionTypeStructure Type = { IF1UNION,Info,{Count,TagTypes}}

#define DefineEmpty(Type,Info,) \
  static EmptyTypeStructure Type = { IF1EMPTY,Info }


#define ForwardArray(Type)	extern ArrayTypeStructure Type
#define ForwardBasic(Type)	extern BasicTypeStructure Type
#define ForwardField(Type)	extern FieldTypeStructure Type
#define ForwardFunction(Type)	extern FunctionTypeStructure Type
#define ForwardMultiple(Type)	extern MultipleTypeStructure Type
#define ForwardRecord(Type)	extern RecordTypeStructure Type
#define ForwardStream(Type)	extern StreamTypeStructure Type
#define ForwardTuple(Type)	extern TupleTypeStructure Type
#define ForwardUnion(Type)	extern UnionTypeStructure Type
#define ForwardEmpty(Type)	extern EmptyTypeStructure Type

/* ------------------------------------------------------------ */
#define StandardValueStructure TypeD Description

#define BasicValueStructure(Type,Name)\
  struct {\
    StandardValueStructure;\
    SisalBoolean		Error;\
    Type			Name;\
  } Name

#define BasicShortValStructure(Type,Name)\
  struct {\
    SisalBoolean		Error;\
    Type			Name;\
  } Name

#define GenericBasicValueStructure BasicValueStructure(long,GenericBasic)
#define BooleanValueStructure BasicValueStructure(SisalBoolean,aBOOLEAN)
#define CharacterValueStructure BasicValueStructure(SisalCharacter,aCHARACTER)
#define DoubleValueStructure BasicValueStructure(SisalDouble,aDOUBLE)
#define IntegerValueStructure BasicValueStructure(SisalInteger,aINTEGER)
#define NullValueStructure BasicValueStructure(SisalNull,aNULL)
#define RealValueStructure BasicValueStructure(SisalReal,aREAL)

#define BooleanShortValStructure BasicShortValStructure(SisalBoolean,aBOOLEAN)
#define CharacterShortValStructure BasicShortValStructure(SisalCharacter,aCHARACTER)
#define DoubleShortValStructure BasicShortValStructure(SisalDouble,aDOUBLE)
#define IntegerShortValStructure BasicShortValStructure(SisalInteger,aINTEGER)
#define NullShortValStructure BasicShortValStructure(SisalNull,aNULL)
#define RealShortValStructure BasicShortValStructure(SisalReal,aREAL)

typedef struct { GenericBasicValueStructure; } SisalBasicObject;
typedef struct { BooleanValueStructure;	  } SisalBooleanObject;
typedef struct { CharacterValueStructure; } SisalCharacterObject;
typedef struct { DoubleValueStructure;	  } SisalDoubleObject;
typedef struct { IntegerValueStructure;	  } SisalIntegerObject;
typedef struct { NullValueStructure;	  } SisalNullObject;
typedef struct { RealValueStructure;	  } SisalRealObject;

typedef struct { BooleanShortValStructure;   } ShortSisalBooleanObject;
typedef struct { CharacterShortValStructure; } ShortSisalCharacterObject;
typedef struct { DoubleShortValStructure;    } ShortSisalDoubleObject;
typedef struct { IntegerShortValStructure;   } ShortSisalIntegerObject;
typedef struct { NullShortValStructure;	     } ShortSisalNullObject;
typedef struct { RealShortValStructure;	     } ShortSisalRealObject;
/* ------------------------------------------------------------ */
#define ArraylikeValueStructure(Tag)\
  struct {\
    StandardValueStructure;\
    SisalBoolean		IsOK;\
    ShortSisalIntegerObject	LowerBound;\
    unsigned			TotalSize;\
    unsigned			PrefixSize;\
    struct Bag			*Collection;\
    unsigned			View;\
  } Tag
#define ArrayValueStructure	ArraylikeValueStructure(aARRAY)

typedef struct { ArrayValueStructure; } SisalArrayObject;
/* ------------------------------------------------------------ */
#define FunctionValueStructure\
  struct {\
    StandardValueStructure;\
    char 		*Name;\
    Function		Code;\
  } aFUNCTION
typedef struct { FunctionValueStructure; } SisalFunctionObject;
/* ------------------------------------------------------------ */
typedef enum {BagMult,GenMult,ConstMult} KindOfBag;
#define MultipleValueStructure\
  struct {\
    StandardValueStructure;\
    KindOfBag			Tag;\
    SisalBoolean		IsError;\
    unsigned			Size;\
    unsigned			TrueSize;\
    union {\
      struct {\
        unsigned		View;\
	struct Bag		*Collection;\
      }				BagMult;\
      ShortSisalIntegerObject	Low;\
    } VALUE;\
  } aMULTIPLE

typedef struct { MultipleValueStructure; } SisalMultipleObject;
/* ------------------------------------------------------------ */
#define RecordValueStructure\
  struct {\
    StandardValueStructure;\
    SisalBoolean		IsError;\
    struct Bag			*Fields;\
  } aRECORD

typedef struct { RecordValueStructure; } SisalRecordObject;
/* ------------------------------------------------------------ */
#if StrictStreams
#  define StreamValueStructure ArraylikeValueStructure(aSTREAM)
#endif

typedef struct { StreamValueStructure; } SisalStreamObject;
/* ------------------------------------------------------------ */
#define UnionValueStructure\
  struct {\
    StandardValueStructure;\
    SisalBoolean		IsError;\
    SisalInteger		Tag;\
    struct Bag			*Value;\
  } aUNION

typedef struct { UnionValueStructure; } SisalUnionObject;
/* ------------------------------------------------------------ */
#define EmptyValueStructure\
  struct {\
    StandardValueStructure;\
  } aEMPTY

typedef struct { EmptyValueStructure;	  } SisalEmptyObject;
/* ------------------------------------------------------------ */
#define GenericValueStructure\
  struct {\
    StandardValueStructure;\
  } GenericValue
/* ------------------------------------------------------------ */

typedef union {
    GenericValueStructure;
    GenericBasicValueStructure;

    ArrayValueStructure;

    BooleanValueStructure;
    CharacterValueStructure;
    DoubleValueStructure;
    IntegerValueStructure;
    NullValueStructure;
    RealValueStructure;

    FunctionValueStructure;

    MultipleValueStructure;

    RecordValueStructure;

    StreamValueStructure;

    UnionValueStructure;

    EmptyValueStructure;
} IF1OBJECT;

/* ------------------------------------------------------------ */
typedef enum {Simple,Compound,Graph,Constructed,Module}	NodeKind;
typedef struct {
  int			SL;
  struct Generic	*DP1;
  int			DI1;
  struct Generic	*DP2;
} DebugInfoStruct;

typedef struct NodeStuff {
  int			NodeID;
  unsigned		InArity;
  unsigned		OutArity;
  TypeD			*InTypes;
  TypeD			*OutTypes;
  char			**EdgeNames;
  struct NodeStuff	*Parent;
  NodeKind		KindOfNode;
  SisalBoolean		Exported;
  struct {
    int		INT1;
    int		INT2;
    char	*PTR1;
    char	*PTR2;
    char	*PTR3;
    char	*PTR4;
    char	*PTR5;
  }			StructureInfo;
  DebugInfoStruct	DebugInfo;
} NodeStuff,*NodeInfo;
/* ------------------------------------------------------------ */
#define GP(x)		((char*)(x))
#define CP(x)		((char*)(x))
/* ------------------------------------------------------------ */
/* LITERAL GENERATORSS */
#if 0
extern BasicTypeStructure BooleanStructure;
extern BasicTypeStructure CharacterStructure;
extern BasicTypeStructure DoubleStructure;
extern BasicTypeStructure IntegerStructure;
extern BasicTypeStructure NullStructure;
extern BasicTypeStructure RealStructure;
extern ArrayTypeStructure StringStructure;
extern EmptyTypeStructure EmptyStructure;
extern SisalEmptyObject	  EmptyObjectShell;
#endif

typedef struct {
  TypeD		LiteralType;
  char		*LiteralValue;
  IF1OBJECT	Value;
} LiteralPoolElement;

#define LiteralPool		static LiteralPoolElement Pool[] =
#define Literal(type,val)	{ TP(type),(char*)(val) }
#define NoLiterals		static LiteralPoolElement Pool[1];
#define EntryInformation(NodeCount,PoolCount,ModuleName) \
	{ 0,0,0,NULL,NULL,NULL,NULL,Module,FALSE, \
	    {NodeCount,PoolCount,GP(Pool),GP(ModuleName),GP(Debugger),\
	       NULL,NULL}}
#define SystemRoutine(offset,name,addr) \
{offset,0,0,NULL,NULL,NULL,NodeTable+offset,Graph,TRUE,\
   {0,0,NULL,NULL,GP(name),GP(addr),NULL},{0}}


/* ------------------------------------------------------------ */
#define BasicErrorLit(name,Type) \
	static SisalBasicObject name = { TP(Type),TRUE }

#define ArrayErrorLit(name,Type) \
	static SisalArrayObject name = { TP(Type),FALSE,{TRUE,1},0,0,NULL,0}

/* ------------------------------------------------------------ */
#define BooleanTypeD	((TypeD)(&BooleanStructure))
#define CharacterTypeD	((TypeD)(&CharacterStructure))
#define DoubleTypeD	((TypeD)(&DoubleStructure))
#define IntegerTypeD	((TypeD)(&IntegerStructure))
#define NullTypeD	((TypeD)(&NullStructure))
#define RealTypeD	((TypeD)(&RealStructure))
#define StringTypeD	((TypeD)(&StringStructure))
#define EmptyTypeD	((TypeD)(&EmptyStructure))
#define EmptyObject	((IF1OBJECT*)(&EmptyObjectShell))
/* ------------------------------------------------------------ */
/* GRAPH Entry/Exit */
#define GlobalFunction(Func) \
  void Func(in,out,info)\
        IF1OBJECT       *in[];\
        IF1OBJECT       *out[];\
        NodeInfo        info;

#define LocalFunction(Func) \
  static void Func(in,out,info)\
        IF1OBJECT       *in[];\
        IF1OBJECT       *out[];\
        NodeInfo        info;

#define EnterGraph(Graph,LocalCount,MaxIn,MaxOut) \
	  IF1OBJECT	locals[((LocalCount)==0)?(1):(LocalCount)];\
	  IF1OBJECT	*nodein[((MaxIn)==0)?(1):(MaxIn)];\
	  IF1OBJECT	*nodeout[((MaxOut)==0)?(1):(MaxOut)];\
	  InitializeLocals(in,out,locals,LocalCount,info,NodeTable+Graph);\
	  ImportStuff(in,out,info,NodeTable+Graph)

#define ExitGraph(Graph) ExportStuff(in,out,info,NodeTable+Graph)
/* ------------------------------------------------------------ */
#if Debugger
#define NodeExecute(id,inar,outar,typein,typeout,edgenames,parent,kind,exp,op,debug) \
  ExecuteNode(nodein,nodeout,NodeTable+id)

#define CNodeExecute(id,inar,outar,typein,typeout,edgenames,parent,kind,exp,kidcount,kids,op,debug) \
  ExecuteNode(nodein,nodeout,NodeTable+id)
#else
/* ------------------------------------------------------------ */
#define NodeExecute(id,inar,outar,typein,typeout,edgenames,parent,kind,exp,op,debug) \
  { static NodeStuff ninfo = { id,inar,outar,typein,typeout,edgenames, \
			       parent,kind,exp,op,debug}; \
  ExecuteNode(nodein,nodeout,&ninfo);}
    
#define CNodeExecute(id,inar,outar,typein,typeout,edgenames,parent,kind,exp,op,kidcount,kids,debug) \
  { static NodeStuff ninfo = { id,inar,outar,typein,typeout,edgenames, \
			       parent,kind,exp,op,kidcount,kids,debug }; \
  ExecuteNode(nodein,nodeout,&ninfo);}
#endif
/* ------------------------------------------------------------ */
#define INARITY(info)	((info)->InArity)
#define OUTARITY(info)	((info)->OutArity)
#define HasNames(N)	((N)->EdgeNames)
#define InputEdgeNames(N) ((N)->EdgeNames)
#define OutputEdgeNames(N) (((N)->EdgeNames)+INARITY(N))
#define ModuleSizeOf(N)	((N)->StructureInfo.INT1)
/* Other accessors defined in SCLib.h */
/* ------------------------------------------------------------ */

#define ArgInput(P,port,nm)	nodein[(P)-1] = in[(port)-1]
#define ArgOutput(P,port,nm)	nodeout[(P)-1] = (port>OUTARITY(info))\
					     ?(IF1OBJECT*)NULL\
					     :(out[(port)-1])

#define LiteralInput(P,val)	nodein[(P)-1] = (&Pool[(val)-1].Value)

#define LocalInput(P,offset,nm)	nodein[(P)-1] = (&locals[(offset)-1])
#define LocalOutput(P,offset,nm)	nodeout[(P)-1] = (&locals[(offset)-1])

#define NullInput(P)		nodein[(P)-1] = (IF1OBJECT*)NULL;
#define NullOutput(P)		nodeout[(P)-1] = (IF1OBJECT*)NULL;
/* ------------------------------------------------------------ */
#define Copy(a,b) if (a) *(a) = *(b)
#define FCopy(a,b,type) if (a) (a)->type = (b)->type

#define CopyLiteral(val,P) \
	    if((P)<=OUTARITY(info)) Copy(out[P-1],(IF1OBJECT*)(&Pool[(val)-1].Value))

#define CopyForward(from,to) \
	    if ((to)<=OUTARITY(info)) Copy(out[(to)-1],in[(from)-1])

#define CopyToGraph(offset,GPort) \
  if (out[GPort-1]) Copy(out[GPort-1],&locals[(offset)-1])
/* ------------------------------------------------------------ */
#define MINBOOLEAN	BooleanMinVal
#define MAXBOOLEAN	BooleanMaxVal

#define MINCHAR		CharMinVal
#define MAXCHAR		CharMaxVal

#define MINDOUBLE	DoubleMinVal
#define MAXDOUBLE	DoubleMaxVal
#define MINEOUBLE	DoubleMinVal
#define MAXEOUBLE	DoubleMaxVal

#define MININTEGER	IntegerMinVal
#define MAXINTEGER	IntegerMaxVal

#define MINREAL		RealMinVal
#define MAXREAL		RealMaxVal
/* ------------------------------------------------------------ */

extern void	InitializeLocals();
extern void	ImportStuff();
extern void	ExecuteNode();
extern void	ExportStuff();
extern void	SUM_();
extern void	PRODUCT_();
extern void	LEAST_();
extern void	GREATEST_();
extern void	CATENATE_();
extern char	*index();
extern NodeInfo	CurrentTable;

#define DEBUG(flag,code) {if (flag || LOCALDEBUG) { code }}

#endif
