#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

/* ------------------------------------------------------------ */
/* Set up a structure to hold the variables being viewed */
int	ViewCount = 0;
ViewVar	ViewList[MaxNamesToList];

void
ViewVars(args)
     char	*args;
{
  static int	ViewIDCount = 0;
  char		*parse[2];
  char		*Filename;
  FileEntry	*File;
  int		BP;
  char		*String;

  /* Set up the default entry for files and breakpoints*/
  File = &FileDefault;		/* Output to screen */
  BP   = 0;			/* Output at any breakpoint */
  String = NULL;		/* No comment string */

  /* Break out the names/args one by one */
  for(ParseList(args,parse,1);*parse[0];ParseList(parse[1],parse,1)) {
    /* Each argument is either a name, a redirection (>), a breakpoint */
    /* specifier (@), or a string (%) */
    switch ( *parse[0] ) {
     case '>':			/* REDIRECTION */
      Filename = parse[0]+1;	/* Try for a form of >name first */
      if ( !(*Filename) && *parse[1] ) { /* Try next arg for the name */
	ParseList(parse[1],parse,1);
	Filename = parse[0];
      }

      if (Filename) File = FindFile(Filename);
      break;

     case '@':			/* BREAKPOINT SPECIFIER */
      BP = atoi(parse[0]+1);
      break;

     case '%':			/* COMMENT STRING */
      String = NewString(parse[0]+1);
      break;

     default:			/* NAME */
      if ( ViewCount >= MaxNamesToList ) {
	DebugMessage("Too many views active at once\n");
      } else {
	ViewList[ViewCount].ID		= ++ViewIDCount;
	ViewList[ViewCount].Name	= NewString(parse[0]);
	ViewList[ViewCount].File	= File;
	ViewList[ViewCount].Break	= BP;
	ViewList[ViewCount].Comment	= String;
	String = NULL;		/* Clear the string, its a one-shot */
	ViewCount++;
      }
    }
  }
}

void
DisplayViewVars()
{
  int		i;

  for(i=0;i<ViewCount;i++) {
    if ( !ViewList[i].Break || BreakpointApplies(ViewList[i].Break) ) {
      PrintName(ViewList[i].Name,ViewList[i].File,ViewList[i].Comment);
    }
  }
}

void
ListViews()
{
  int		i;
  char		message[MaxCommentSize];
  char		buf0[MaxCommentSize];
  char		buf1[MaxCommentSize];
  ViewVar	V;
  FileEntry	*F;
  char		*BPString;	/* Breakpoint description string */
  char		*ComString;	/* User comment */

  if ( ViewCount ) DebugMessage("View Variables...\n");

  for(i=0;i<ViewCount;i++) {
    V = ViewList[i];
    F = V.File;

    /* Prepare the breakpoint specifier */
    BPString = (V.Break)?(sprintf(buf0,"@%d",V.Break),buf0):"";
    ComString = (V.Comment)?(sprintf(buf1,"\"%s\"",V.Comment),buf1):"";

    if ( V.File && F->name ) {
      (void)sprintf(message,"[%d] %s --> %s %s %s\n",
	      V.ID,V.Name,F->name,BPString,ComString);
    } else {
      (void)sprintf(message,"[%d] %s %s %s\n",
	      V.ID,V.Name,BPString,ComString);
    }

    DebugMessage(message);
  }
}

void
DeleteView(args)
     char	*args;
{
  int		ID;
  char		*parse[2];
  char		message[MaxCommentSize];
  int		i;

  for(ParseList(args,parse,1);*parse[0];ParseList(parse[1],parse,1)) {
    /* Translate the arg into an ID number */
    ID = atoi(parse[0]);
    if ( ID > 0 ) {
      /* Locate the ID */
      for(i=0;i<ViewCount;i++) if ( ViewList[i].ID == ID ) break;

      /* Move the rest of the ID's down one spot and decrement the */
      /* count */
      for(i++;i<ViewCount;i++) ViewList[i-1] = ViewList[i];
      ViewCount--;
    } else {
      (void)sprintf(message,"Illegal view: %s\n",parse[0]);
      DebugMessage(message);
    }
  }
}
