#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

SysVar	SystemVariables[] = {
  {"PRINTMAX",GP(&PrintMax),SysInteger},
  {"DISPLAYBYNAME",GP(&DisplayByName),SysBool},
  {"NODESTEP",GP(&NodeStep),SysBool},
  {"LINESTEP",GP(&LineStep),SysBool},
  {"INFINITY",GP(&InfiniteLoopCount),SysInteger},
  {NULL}
};

SysVar*
FindVar(name)
     char	*name;
{
  int		i;

  /* Make upper case for comparisons */
  MakeUpper(name);

  /* Check each entry and return the first match */
  for(i=0;SystemVariables[i].Name;i++) {
    if ( strcmp(SystemVariables[i].Name,name) == 0 ) return SystemVariables+i;
  }

  /* If not found, return a NULL pointer */

  return NULL;
}

void
SetVar(name,value)
     char	*name;
     char	*value;
{
  SysVar	*Entry;
  int		ival;

  Entry = FindVar(name);

  if ( Entry ) {
    switch ( Entry->Type ) {
      /* If the entry is an integer, convert the value to integer and */
      /* stuff it where it belongs. */
     case SysInteger:
      ival = atoi(value);
      *((int*)(Entry->Value)) = ival;
      break;

     case SysBool:
      if ( value[0] == 't' || value[0] == 'T' ) {
	*((SisalBoolean*)(Entry->Value)) = TRUE;
      } else {
	*((SisalBoolean*)(Entry->Value)) = FALSE;
      }
      break;

     default:;
    }
  } else {
    DebugMessage("No such variable\n");
  }
}
