#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

typedef struct HT {
  NodeInfo	Addr;
  int		ID;
  struct HT	*Next;
} HashTableEntry;

HashTableEntry	*HashTable[HASHTABLESIZE];

int
HashOf(n)
     NodeInfo	n;
{
  return ((int)n) % HASHTABLESIZE;
}

void
InitHash()
{
  int		i;

  for(i=0;i<HASHTABLESIZE;i++) {
    HashTable[i] = NULL;
  }
}

void
AddHash(addr,id)
     NodeInfo	addr;
     int	id;
{
  HashTableEntry	*new;
  int			HPos;

  new = Allocate(HashTableEntry);

  new->Addr		= addr;
  new->ID		= id;

  HPos			= HashOf(addr);
  new->Next		= HashTable[HPos];
  HashTable[HPos]	= new;
}

void
DeleteID(id)
     int	id;
{
  HashTableEntry	*E,*Prev;
  int			i;

  for(i=0;i<HASHTABLESIZE;i++) {

    for((E=HashTable[i],Prev=NULL);E;) {
      if ( E->ID == id ) {
	if ( Prev ) {
	  Prev->Next = E->Next;
	  Free(E);
	  E = Prev->Next;
	} else {
	  HashTable[i] = E->Next;
	  Free(E);
	  E = HashTable[i];
	}
      } else {
	Prev = E;
	E = Prev->Next;
      }
    }
  }
}

int
NodalBreakPointList(addr,IDList,maxn)
     NodeInfo	addr;
     int	*IDList;
     int	maxn;
{
  int		HPos,n = 0;
  HashTableEntry *E;

  HPos = HashOf(addr);
  for(E=HashTable[HPos];E;E = E->Next) {
    if (E->Addr == addr) {
      if ( n++ > maxn ) break;
      *IDList++ = E->ID;
    }
  }

  return n;
}
