#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

/* ------------------------------------------------------------ */
char	*FileKeywords[] = {
  /* a */	"ascii",
  /* b */	"binary",
  /* c */	NULL,
  /* d */	NULL,
  /* e */	NULL,
  /* f */	NULL,
  /* g */	NULL,
  /* h */	NULL,
  /* i */	"init",
  /* j */	NULL,
  /* k */	NULL,
  /* l */	NULL,
  /* m */	NULL,
  /* n */	"names",
  /* o */	NULL,
  /* p */	NULL,
  /* q */	NULL,
  /* r */	"reset",
  /* s */	NULL,
  /* t */	NULL,
  /* u */	NULL,
  /* v */	NULL,
  /* w */	NULL,
  /* x */	NULL,
  /* y */	NULL,
  /* z */	NULL};
/* ------------------------------------------------------------ */

FileEntry FileDefault = {NULL,0,1,NULL,NULL};

static int		FileCount = 0;
static FileEntry	FileTable[MaxFiles];

/* ------------------------------------------------------------ */
FileEntry*
FindFile(name)
     char	*name;
{
  int		i;

  /* Return the file if its already there */
  for(i=0;i<FileCount;i++) {
    if ( strcmp(name,FileTable[i].name) == 0 ) return FileTable+i;
  }

  /* See if there's room in the table */
  if ( FileCount >= MaxFiles ) return (FileEntry*)NULL;

  /* Fix the location, set to the default, and open the file */
  FileTable[FileCount] = FileDefault;
  FileTable[FileCount].name = strcpy(CAllocate(strlen(name)+1,char),name);
  FileTable[FileCount].FP = fopen(name,"w");
  if ( !FileTable[FileCount].FP ) return (FileEntry*)NULL;

  /* Return the location */
  return FileTable+(FileCount++);
}

/* ------------------------------------------------------------ */
void
EnterFile(args)
     char	*args;
{
  FileEntry	*Entry;
  char		*parse[2];
  char		*name;
  FileEntry	WorkEntry;
  int		Flag;

  /* Break out the name */
  ParseList(args,parse,1);
  name = parse[0];

  /* Find the  entry or get a new one */
  Entry = FindFile(name);
  if ( !Entry ) {
    DebugMessage("Could not open or Too many open files\n");
    return;
  }

  /* For each remaining keyword, change the appropriate entry */
  WorkEntry = *Entry;
  while(*parse[1]) {
    ParseList(parse[1],parse,1); /* Get the next keyword */

    /* Fix the flag if its been NOT'ed */
    if ( *parse[0] == '!' ) { Flag = 0; parse[0]++; } else { Flag = 1; }

    /* Decode the keyword */
    switch( KeywordTablePosition(FileKeywords,parse[0]) ) {
     case 'a':			/* ASCII */
      WorkEntry.binary = !Flag; break;

     case 'b':			/* BINARY */
      WorkEntry.binary = Flag; break;

     case 'n':			/* NAMES */
      WorkEntry.header = Flag; break;

     case 'i':			/* INIT */
      WorkEntry.Setupstring = strcpy(CAllocate(strlen(parse[1])+1,char),
				     parse[1]);
      parse[1] = "";		/* Skip the rest of the line */
      break;

     case 'r':			/* RESET */
      WorkEntry.FP = fopen(WorkEntry.name,"w");
      if ( WorkEntry.FP ) {
	(void)fclose(Entry->FP); /* Close old entry */
      } else {
	DebugMessage("Warning: Could not reset file\n");
	WorkEntry.FP = Entry->FP;
      }
      break;

     default:
      DebugMessage("Warning: Invalid keyword ignored\n");
    }
  }
  *Entry = WorkEntry;
}

/* ------------------------------------------------------------ */
void
ListFiles()
{
  int		i;
  char		message[MaxCommentSize];

  for(i=0;i<FileCount;i++) {
    (void)sprintf(message,"%s : %sascii %snames init \"%s\"\n",
	   FileTable[i].name,
	   !FileTable[i].binary?"":"!",
	   FileTable[i].header?"":"!",
	   FileTable[i].Setupstring?FileTable[i].Setupstring:"");
    DebugMessage(message);
  }
}
