#include "SC.h"
#include "SCLib.h"
#include "Debug.h"

void
MakeUpper(name)
     char	*name;
{
  char		*p;

  for(p=name;*p;p++) if (islower(*p)) *p = toupper(*p);
}

int
FindModule(name)
     char	*name;
{
  int		NT;

  for(NT=0;Linkage[NT];NT++) {
    if ( StringEq(name,ModuleNameOf(Linkage[NT])) ) break;
  }
  return NT;
}


Environment*
TopLevelGraphEnv()
{
  Environment	*Env;

  Env = TopOfEnvironmentStack();

  while (Env && InfoKind(Env->INFO) != Graph) Env = Env->Next;

  return Env;
}

NodeInfo
TopLevelFunction()
{
  Environment	*Env;
  NodeInfo	F;

  for(Env = TopLevelGraphEnv();
      Env && !IsFunctionName(Env->NAME);
      Env = Env->Next);

  F = (Env)?(Env->INFO):NULL;

  return F;
}

char*
ReadFileIntoAString(file)
     char	*file;
{
  FILE		*FP;
  char		*string;
  char		*newstring;
  int		size;
  int		truesize;
  int		c;

  FP = fopen(file,"r");

  if ( FP ) {
    /* Get a guess at a big enough string */
    size = RunInputGuessSize;
    string = CAllocate(size+1,char);

    /* Read it into the string */
    truesize = 0;
    while((c=getc(FP),c != EOF)) {
      /* Make sure there's room for the current character */
      if ( truesize > size ) {
	size = truesize*2;
	newstring = CAllocate(size+1,char);
	(void)strncpy(newstring,string,truesize);
	Free(string);
	string = newstring;
      }
      
      /* Pack it into the array */
      string[truesize++] = c;
    }

    string[truesize] = '\0';	/* NULL terminated */

    (void)(fclose(FP));
  } else {
    /* Nothing to read */
    string = '\0';
  }

  return string;
}
/* ------------------------------------------------------------ */
/* ParseList(com,bufs,n)					*/
/*   This function breaks out n tokens from the input line,	*/
/*   them into the array of pointers, bufs.  the n+1'th		*/
/*   bufs will contain whatever is left of the command		*/
/*   string.  Tokens may be quoted with double quotes.		*/
void
ParseList(com,bufs,n)
     char	*com;
     char	*bufs[];
     int	n;
{
  int		count;
  char		QuoteChar;

  /* Skip to the first nonblank character */
  while(*com && isspace(*com)) com++;

  /* Do this for the n tokens that were requested. */
  for(count=0;count<n && *com;count++) {
    /* If this is a quoted string, continue to the close */
    /* quote.  If it isn't, just pick up every non-blank, */
    /* printing character. */
    if ( *com == '"' || *com == '\'' ) {
      /* This buffer starts past the quote */
      QuoteChar = *com;
      bufs[count] = ++com;

      /* Pick up characters until the matching endquote */
      while(*com && *com != QuoteChar) com++;

    } else {
      /* This buffer starts with the first character */
      bufs[count] = com;

      /* Pick up all the printable characters */
      while(*com && isgraph(*com)) com++;

    }

    /* Null terminate the string */
    if ( *com ) *com++ = '\0';

    /* Skip over the trailing whitespace */
    while(*com && isspace(*com)) com++;
  }

  /* Place the remainder in the n+1'th token buffer */
  for(;count <= n; bufs[count++] = com );
}

void
GrabLine(path,file,n,line,linesize)
     char	*path[];
     char	*file;
     int	n;
     char	*line;
     int	linesize;
{
  FILE		*FP;
  char		pathname[1024];
  int		i;
  
  /* Default to an empty line in case we can't find it */
  line[0] = '\0';

  /* Must add extension .sis to file name */
  (void) strcat( strcpy( pathname, file), ".sis");
  
  /* Initially try just the file name.  Also try the pathnames */
  /* concatenated with the filename */
  for(FP = fopen(pathname,"r"); !FP && path && *path; path++ ) {
    (void)strcat(strcat(strcat(strcpy(pathname,*path),"/"),file),".sis");
    FP = fopen(pathname,"r");
  }

  /* If we managed to open the file, then try to read down to the n'th */
  /* line. */
  if ( FP ) {
    for(i=1;fgets(line,linesize,FP) && i<n;i++);
    (void)(fclose(FP));
  }
}
