#include <stdio.h>
#include <signal.h>

#ifndef RS6000
extern char *malloc();
#endif


#define TRUE     1
#define FALSE    0
#define ERROR    1
#define OK       0
#define SAME     0

/* ABSOLUTE DIRECTORY PATHS TO SISAL COMPILER EXECUTABLES */

#ifndef BIN_PATH
#define BIN_PATH   "/usr/local/bin"
#endif

#define StrCat( r, s1, s2 ) strcat( strcpy( (r), (s1) ), (s2) )
#define Warning(x,y )       fprintf( stderr, "OSC WARNING: %s %s\n", x, y )

#define MAXARGS  500
#define NAMESIZE 1000

#define SIS      1  /* file.sis  */            /* LEGAL FILE SUFFIX CODES */
#define IF1      4  /* file.if1  */
#define MONO     3  /* file.mono */
#define OPT      2  /* file.opt  */
#define MEM      5  /* file.mem  */
#define UP       6  /* file.up   */
#define PART     7  /* file.part */
#define COSTS    8  /* file.costs*/
#define C        9  /* file.c    */
#define S        10 /* file.s, file.o, or file.a */
#define O        11 /* file.o    */
#define A        12 /* file.a    */
#define F        13 /* file.f    */
#define I        14 /* file.i    */

#define LD       14

char  *file;              /* INPUT FILE NAME OF CURRENT COMPILATION PHASE */
char  *root;              /* ROOT OF file                                 */
char  *cfile = "";                                    /* GENERATED C FILE */

int    start;             /* FIRST PHASE OF COMPILATION SUBMIT SEQUENCE   */

char  *av [MAXARGS];      /* COMMAND LINE OF CURRENT COMPILATION PHASE    */

char  *sis [MAXARGS];     /* file.sis */        /* OSC COMMAND LINE FILES */
char  *sisi[MAXARGS];     /* file.sis -> file.i */
char  *i   [MAXARGS];     /* file.i   */
char  *if1 [MAXARGS];     /* file.if1 */
char  *f   [MAXARGS];     /* file.f */
char  *c   [MAXARGS];     /* file.c */

char  *ld [MAXARGS];      /* file.c, file.s, file.o, file.a */
char  *opt[MAXARGS];      /* file.mono, file.if1, file.mem, file.up,      */
                          /* file.part                                    */


char   sisalpt  [NAMESIZE]; /* ABSOLUTE PATHS TO EXECUTABLES: SISAL       */
char   sisal    [NAMESIZE]; /* PARSE TABLES, sisal, if1opt,               */
char   if1opt   [NAMESIZE]; /* if1ld, if2mem, if2up, if2part, if2gen,     */
char   if1ld    [NAMESIZE]; /* sisal includes, libs.a, spp[12]            */
char   if2mem   [NAMESIZE];
char   if2up    [NAMESIZE];
char   if2part  [NAMESIZE];
char   if2gen   [NAMESIZE];
char   incl     [NAMESIZE];
char   libs     [NAMESIZE];
char   srt0     [NAMESIZE];
char   buf1     [NAMESIZE]; /* COST FILE DIRECTORY PATH                   */
char   spprun   [NAMESIZE];
char   spp2     [NAMESIZE];

char   cmdline1 [1024*4];
char   cmdline2 [1024*4];

char  *ff  = "FF_HELP";
char  *cc  = "CC_HELP";

int    avcnt   = -1;        /* INDEXES TO av, sis, if1, opt, ld, etc.     */
int    siscnt  = -1;
int    icnt    = -1;
int    if1cnt  = -1;
int    optcnt  = -1;
int    ldcnt   = -1;
int    ccnt    = -1;
int    fcnt    = -1;

int    list    = FALSE;

int    nocpp   = FALSE;

int    newcc   = FALSE;
int    newff   = FALSE;

int    intrinsics = TRUE;
int    smodule = FALSE;

int    nobrec = FALSE;

int    prof = FALSE;
int    Prof = FALSE;

int    avector = FALSE;
int    cvector = FALSE;

int    useORTS = TRUE;

int    cppoptioncnt = -1;
char   *cppoptions[MAXARGS];

int    ffoptionscnt = -1;
char   *ffoptions[MAXARGS];

int    ccoptionscnt = -1;
char   *ccoptions[MAXARGS];

int    coptioncnt = -1;
char   *coptions[MAXARGS];

int    eoptioncnt = -1;
char   *eoptions[MAXARGS];

int    foptioncnt = -1;
char   *foptions[MAXARGS];

int    flopoptioncnt = -1;
char   *flopoptions[MAXARGS];

int    timeoptioncnt = -1;
char   *timeoptions[MAXARGS];

int    calloptioncnt = -1;
char   *calloptions[MAXARGS];

int    stopIF1    = FALSE;               /* OSC COMMAND LINE OPTION FLAGS */
int    stopCPP    = FALSE;
int    stopMONO   = FALSE;
int    stopOPT    = FALSE;
int    stopDI     = FALSE;
int    stopMEM    = FALSE;
int    stopUP     = FALSE;
int    stopPART   = FALSE;
int    stopC      = FALSE;
int    stopS      = FALSE;
int    stopc      = FALSE;

int    forC       = FALSE;
int    forF       = FALSE;
int    bind       = FALSE;

int    dead       = TRUE;

int    debug      = FALSE;
int    DeBuG      = FALSE;

int    freeall    = FALSE;

int    verbose    = FALSE;

int    bounds     = FALSE;
int    SISglue    = FALSE;
int    sdbx       = FALSE;


char  *unroll     = "-U2";

int    noinvert   = FALSE;
int    nostrip    = FALSE;
int    nosplit    = FALSE;
int    nodope     = FALSE;
int    noamove    = FALSE;

char  *preb       = "-Y3";


int    norag      = FALSE;
int    nobip      = FALSE;
int    bipmv      = TRUE;

char   hybridOPTION[NAMESIZE];
char   hybridFILE[NAMESIZE];
char   hybridROOT[NAMESIZE];
char   hybridDOT[NAMESIZE];

int    hybrid     = FALSE;
int    dohybrid   = FALSE;

int    noopt      = FALSE;
int    noimp      = FALSE;
int    noaimp     = FALSE;

int    nltss      = FALSE;

#ifdef ALLIANT
int    alliantfx  = TRUE;
int    cRay       = FALSE;
#else
#ifdef CRAY
int    alliantfx  = FALSE;
int    cRay       = TRUE;
#else
int    alliantfx  = FALSE;
int    cRay       = FALSE;
#endif
#endif

#ifdef ALLIANT
int    novec      = FALSE;
#else
#ifdef CRAY
int    novec      = FALSE;
#else
int    novec      = TRUE;
#endif
#endif

int    noif1opt   = FALSE;
int    noif2mem   = FALSE;
int    noif2up    = FALSE;

int    noinline   = FALSE;
int    noscalar   = FALSE;
int    norecf     = FALSE;


int    noOinvar   = FALSE;
int    noinvar    = FALSE;
int    nocse      = FALSE;

int    nonormidx  = FALSE;

#ifdef CRAY
int    newchains  = TRUE;
int    movereads  = TRUE;
int    chains     = TRUE;
#else
int    movereads  = FALSE;
int    newchains  = FALSE;
int    chains     = FALSE;
#endif

int    notgcse    = TRUE;

int    noifuse    = FALSE;
int    nodfuse    = FALSE;
int    nosfuse    = FALSE;
int    nogcse     = FALSE;
int    noaggressive = TRUE;
int    nofold     = FALSE;
int    inter      = FALSE;
int    inlineall  = FALSE;

int    explode    = FALSE;
int    explodeI   = FALSE;

int    prog       = FALSE;

#ifdef ENCORE
int    nocagg     = TRUE;
int    nogshared  = TRUE; 
#else
int    nocagg     = FALSE;
int    nogshared  = FALSE; 
#endif

int    nomig      = FALSE;
int    nocom      = FALSE;
int    nostr      = FALSE;

int    dbl        = FALSE;
int    flt        = FALSE;
int    noregs     = FALSE;

int    nofcopy    = FALSE;

#if SUNIX || SUN || RS6000
int  concur = FALSE;
#else
int  concur = TRUE;
#endif

char  *level      = NULL;

char  *atlevel    = NULL;
char  *procs      = NULL;

int   noassoc     = FALSE;

char  *huge       = NULL;
char  *iter       = NULL;
char  *costs      = NULL;
char  *aabs       = NULL;
char  *mdb        = NULL;

int     info      = FALSE;
int    vinfo      = FALSE;
int    cinfo      = FALSE;

int    cpyinfo    = FALSE;
int    flpinfo    = FALSE;


static int IsDigit( c )
char c;
{
  if ( (c >= '0') && (c <= '9') )
    return( TRUE );
  else
    return( FALSE );
}


/**************************************************************************/
/* LOCAL  **************           Error2          ************************/
/**************************************************************************/
/* PURPOSE: PRINT m1 AND m2 TO stderr AND ABORT EXECUTION; RETURNING AN   */
/*          ERROR STATUS OF 1.                                            */
/**************************************************************************/

static void Error2( m1, m2 )
char *m1;
char *m2;
{
    fprintf( stderr, "OSC ERROR: %s %s\n", m1, m2 );
    exit( ERROR );
}


/**************************************************************************/
/* LOCAL  **************       GetFileSuffix       ************************/
/**************************************************************************/
/* PURPOSE: RETURN A POINTER TO THE SUFFIX OF FILE nm.  IF A SUFFIX DOES  */
/*          NOT EXIST, AN ERROR MESSAGE IS PRINTED.  A LEGAL SUFFIX       */
/*          BEGINS WITH A ".", DOES NOT CONTAIN WHITE CHARACTERS, PERIODS,*/
/*          OR BACKSLASHES, AND TERMINATES WITH A NULL CHARACTER.         */
/**************************************************************************/

static char *GetFileSuffix( nm )
char *nm;
{
    register char *p;
    register char *s;
    register char  c;

    for ( p = nm, s = NULL; c = *p; p++ )
        switch ( c ) {
            case '/': 
                s = NULL;
                break;

            case '.':
                s = p;
                break;

            default:
                break;
            }

    if ( s == NULL )
        Error2( "illegal file name:", nm );

    return( s );
}


/**************************************************************************/
/* LOCAL  **************         RemoveFile        ************************/
/**************************************************************************/
/* PURPOSE: UNLINK FILE nm FROM THE CURRENT WORKING DIRECTORY.            */
/**************************************************************************/

static void RemoveFile( nm )
char *nm;
{
  if ( GetFileType( nm ) == start )
    return;

  if ( debug || verbose )
    fprintf( stderr, "unlink %s\n", nm );

  if ( !debug ) 
    unlink( nm );
}


/**************************************************************************/
/* LOCAL  **************           Submit          ************************/
/**************************************************************************/
/* PURPOSE: SUBMIT COMMAND cmd TO UNIX USING av AS THE COMMAND LINE.      */
/*          A CHILD PROCESS IS CREATED USING fork THAT DOES AN execvp     */
/*          TO DO cmd. THE PARENT PROCESS WAITS FOR THE CHILD TO COMPLETE,*/
/*          RETURNING ERROR IF THE CHILD'S TERMINATION STATUS IS NOT EQUAL*/
/*          TO 0. IN DEBUG OR VERBOSE MODE THE ARGUMENT LIST TO THE       */
/*          SUBMITTED COMMAND IS PRINTED TO stderr. THE COMMAND IS ONLY   */
/*          SUBMITTED IF debug ISN'T ENABLED.                             */
/**************************************************************************/

static int Submit( cmd )
char *cmd;
{
    register int idx;
             int s;
    register int id;

    if ( Prof || prof ) {
      strcpy(cmdline1, "time " );
      strcat(cmdline1, cmd);
      for (idx = 1; av[idx] != NULL; idx++) {
	strcat(cmdline1," ");
	strcat(cmdline1,av[idx]);
        }

      if ( debug || verbose )
	fprintf(stderr, "\n*** %s ***\n",cmdline1);

      if ( debug )
	  return ( OK );

      s = system(cmdline1);

      if (s > 0)
	return ( ERROR );

      return( OK );
      }

    if ( debug || verbose ) {
        for ( idx = 0; av[idx] != NULL; idx++) {
	    if ( DeBuG && idx == 0 ) {
              fprintf( stderr, "%s ", cmd );
	      continue;
	      }

            fprintf( stderr, "%s ", av[idx] );
	    }

        fprintf( stderr, "\n" );
        }

    if ( debug )
        return( OK );

    id = fork();

    if ( id == -1)
        Error2( "submit failed:", "no more processes allowed" );

    if ( id == 0 ) {
        execvp( cmd, av );
        Error2( "Can't find Command:", cmd );
        }

    while ( id != wait( &s ) ) ;

    if ( s > 0 ) /* CANN */
        return( ERROR );

    return( OK );
}


/**************************************************************************/
/* LOCAL  **************       SetFileSuffix       ************************/
/**************************************************************************/
/* PURPOSE: RETURN A POINTER TO THE FILE NAME WHOSE ROOT IS r AND SUFFIX  */
/*          IS s.                                                         */
/**************************************************************************/

static char *SetFileSuffix( r, s )
char *r;
char *s;
{
    register char *nm;

    nm = (char *) malloc( sizeof(char) * NAMESIZE );

    sprintf( nm, "%s%s", r, s );

    return( nm );
}


/**************************************************************************/
/* LOCAL  **************        GetFileType        ************************/
/**************************************************************************/
/* PURPOSE: RETURN A CODE IDENTIFYING THE SUFFIX OF FILE nm. ENCOUNTERING */
/*          AN ILLEGAL SUFFIX RESULTS IN AN ERROR MESSAGE.                */
/**************************************************************************/

static int GetFileType( nm )
char *nm;
{
    register char *s;

    s = GetFileSuffix( nm );

    if ( strcmp( s, ".sis"  ) == SAME ) return(SIS);
    if ( strcmp( s, ".if1"  ) == SAME ) return(IF1);
    if ( strcmp( s, ".mono" ) == SAME ) return(MONO);
    if ( strcmp( s, ".opt"  ) == SAME ) return(OPT);
    if ( strcmp( s, ".mem"  ) == SAME ) return(MEM);
    if ( strcmp( s, ".up"   ) == SAME ) return(UP);
    if ( strcmp( s, ".part" ) == SAME ) return(PART);
    if ( strcmp( s, ".costs") == SAME ) return(COSTS);
    if ( strcmp( s, ".a")     == SAME ) return(A);
    if ( strcmp( s, ".c")     == SAME ) return(C);
    if ( strcmp( s, ".s")     == SAME ) return(S);
    if ( strcmp( s, ".o")     == SAME ) return(O);
    if ( strcmp( s, ".f")     == SAME ) return(F);
    if ( strcmp( s, ".i")     == SAME ) return(I);

    Error2( "illegal file name:", nm );
}


/**************************************************************************/
/* LOCAL  **************        GetFileRoot        ************************/
/**************************************************************************/
/* PURPOSE: RETURN A COPY OF FILE nm'S ROOT.                              */
/**************************************************************************/

static char *GetFileRoot( nm )
char *nm;
{
    register char *s;
    register char *r;

    strcpy( r = (char *) malloc( sizeof(char) * NAMESIZE ), nm );

    s  = GetFileSuffix( r );
    *s = '\0';

    return( r );
}


/**************************************************************************/
/* LOCAL  **************      ParseCommandLine     ************************/
/**************************************************************************/
/* PURPOSE: PARSE THE OSC COMMAND LINE GATHERING FILE NAMES INTO THEIR    */
/*          APPROPRIATE GROUPS AND ENABLING COMPILATION OPTIONS.  OPTION  */
/*          AND FILE NAME AMBIGUITIES RESULT IN ERROR MESSAGES.           */
/**************************************************************************/

static void ParseCommandLine( argc, argv )
int    argc;
char **argv;
{
  register int idx;

  for ( idx = 1; idx < argc; idx++ ) {
    if ( *argv[idx] != '-') {
      switch ( GetFileType( argv[idx] ) ) {
	case I:
	  i[++icnt] = argv[idx];
	  break;

        case SIS:
	  sisi[++siscnt] = SetFileSuffix( GetFileRoot( argv[idx] ), ".i" );
          sis[siscnt]    = argv[idx];
          break;

        case IF1:
          if1[++if1cnt] = argv[idx];
          break;

        case OPT:
        case MONO:
        case MEM:
        case UP:
        case PART:
          opt[++optcnt] = argv[idx];
          break;

        case C:
          c[++ccnt] = argv[idx];
          break;

        case F:
          f[++fcnt] = argv[idx];
          break;

        case COSTS:
          costs = argv[idx];
          break;

        case A:
        case O:
        case S:
          ld[++ldcnt] = argv[idx];
          break;

        default:
          goto OptionError;
          break;
        }

      continue;
      }

    switch ( argv[idx][1] ) {
      case 'a':
        if ( strcmp( &argv[idx][1], "alliantfx" ) == SAME ) {
	  novec = FALSE;
	  avector = TRUE;
	  alliantfx = TRUE;
	  continue;
	  }
        else if ( strcmp( &argv[idx][1], "avector" ) == SAME ) {
          novec = FALSE;
          avector =TRUE;
          continue;
          }
        else
          goto OptionError;

        break;

      case 't':
        if ( strcmp( &argv[idx][1], "tgcse" ) == SAME )
	  notgcse = FALSE;
        else if ( strcmp( &argv[idx][1], "time" ) == SAME ) {
          if ( ++idx >= argc )
            Error2( "usage:", "-time funct" );

          calloptions[++calloptioncnt] = argv[idx];
          timeoptions[++timeoptioncnt] = argv[idx];
	  continue;
	  }
	else
	  goto OptionError;
        
	break;

      case 'n': 
        if ( strcmp( &argv[idx][1], "nobrec" ) == SAME )
	  nobrec = TRUE;
        else if ( strcmp( &argv[idx][1], "noload" ) == SAME )
	  stopc = TRUE;
        else if ( strcmp( &argv[idx][1], "nocpp" ) == SAME )
	  nocpp = TRUE;
        else if ( strcmp( &argv[idx][1], "norag" ) == SAME )
	  norag = TRUE;
        else if ( strcmp( &argv[idx][1], "nobipmv" ) == SAME )
	  bipmv = FALSE;
        else if ( strcmp( &argv[idx][1], "newchains" ) == SAME )
	  newchains = TRUE;
        else if ( strcmp( &argv[idx][1], "nancy" ) == SAME )
	  useORTS = FALSE;
        else if ( strcmp( &argv[idx][1], "nltss" ) == SAME )
	  nltss = TRUE;
        else if ( strcmp( &argv[idx][1], "nodead" ) == SAME )
	  dead = FALSE;
        else if ( strcmp( &argv[idx][1], "nobip" ) == SAME )
	  nobip = TRUE;
        else if ( strcmp( &argv[idx][1], "nopreb" ) == SAME )
          preb = "-Y0";
        else if ( strcmp( &argv[idx][1], "nochains" ) == SAME ) {
	  chains    = FALSE;
	  newchains = FALSE;
	  }
        else if ( strcmp( &argv[idx][1], "nomovereads" ) == SAME )
          movereads = FALSE;
        else if ( strcmp( &argv[idx][1], "notgcse" ) == SAME )
	  notgcse = TRUE;
        else if ( strcmp( &argv[idx][1], "noamove" ) == SAME )
	  noamove = TRUE;
        else if ( strcmp( &argv[idx][1], "nodope" ) == SAME )
	  nodope = TRUE;
        else if ( strcmp( &argv[idx][1], "noscalar" ) == SAME )
          noscalar = TRUE;
        else if ( strcmp( &argv[idx][1], "noinvert" ) == SAME )
          noinvert = TRUE;
        else if ( strcmp( &argv[idx][1], "nostrip" ) == SAME )
          nostrip = TRUE;
        else if ( strcmp( &argv[idx][1], "nosplit" ) == SAME )
          nosplit = TRUE;
        else if ( strcmp( &argv[idx][1], "nounroll" ) == SAME )
          unroll = "-U0";
        else if ( strcmp( &argv[idx][1], "noconcur" ) == SAME )
          concur = FALSE;
        else if ( strcmp( &argv[idx][1], "novector" ) == SAME )
          novec = TRUE;
        else if ( strcmp( &argv[idx][1], "noassoc" ) == SAME )
          noassoc = TRUE;
        else if ( strcmp( &argv[idx][1], "noopt" ) == SAME )
          noopt = TRUE;
        else if ( strcmp( &argv[idx][1], "noif1opt" ) == SAME )
          noif1opt = TRUE;
        else if ( strcmp( &argv[idx][1], "nomem" ) == SAME ) {
          noif2mem = TRUE;
          preb  = "-Y0";
	  }
        else if ( strcmp( &argv[idx][1], "noup" ) == SAME ) {
          noif2up = TRUE;
          preb  = "-Y0";
	  }
        else if ( strcmp( &argv[idx][1], "noinline" ) == SAME )
          noinline = TRUE;
        else if ( strcmp( &argv[idx][1], "nofiss" ) == SAME )
          norecf = TRUE;
        else if ( strcmp( &argv[idx][1], "noOinvar" ) == SAME )
          noOinvar = TRUE;
        else if ( strcmp( &argv[idx][1], "noinvar" ) == SAME )
          noinvar = TRUE;
        else if ( strcmp( &argv[idx][1], "nonormidx" ) == SAME )
	  nonormidx = TRUE;
        else if ( strcmp( &argv[idx][1], "nocse" ) == SAME )
          nocse = TRUE;
        else if ( strcmp( &argv[idx][1], "nodfuse" ) == SAME )
          nodfuse = TRUE;
        else if ( strcmp( &argv[idx][1], "nofuse" ) == SAME ) {
	  noifuse = TRUE;
	  nodfuse = TRUE;
	  }
        else if ( strcmp( &argv[idx][1], "noifuse" ) == SAME )
          noifuse = TRUE;
        else if ( strcmp( &argv[idx][1], "nosfuse" ) == SAME )
          nosfuse = TRUE;
        else if ( strcmp( &argv[idx][1], "nogcse" ) == SAME )
          nogcse = TRUE;
        else if ( strcmp( &argv[idx][1], "nofold" ) == SAME )
          nofold = TRUE;
        else if ( strcmp( &argv[idx][1], "nocom" ) == SAME )
          nocom = TRUE;
        else if ( strcmp( &argv[idx][1], "nomig" ) == SAME )
          nomig = TRUE;
        else if ( strcmp( &argv[idx][1], "nocagg" ) == SAME )
          nocagg = TRUE;
        else if ( strcmp( &argv[idx][1], "nostr" ) == SAME )
          nostr = TRUE;
        else if ( strcmp( &argv[idx][1], "noaimp" ) == SAME )
          noaimp = TRUE;
        else if ( strcmp( &argv[idx][1], "noimp" ) == SAME )
          noimp = TRUE;
        else if ( strcmp( &argv[idx][1], "nofcopy" ) == SAME )
          nofcopy = TRUE;
        else if ( strcmp( &argv[idx][1], "noregs" ) == SAME )
          noregs = TRUE;
        else if ( IsDigit( argv[idx][2] ) ) {
          level = argv[idx];
          level[1] = 'L';
          }
        else 
          goto OptionError;

        continue;

      case 'l':
        if ( strcmp( &argv[idx][1], "listing" ) == SAME ) {
	  list = TRUE;
	  continue;
	  }

        ld[++ldcnt] = argv[idx];
        continue;

      case 'L':
      case 'N':
        if ( IsDigit( argv[idx][2] ) ) {
          level = argv[idx];
          level[1] = 'L';
          }
        else
          goto OptionError;

        continue;

      case 'g':
        if ( strcmp( &argv[idx][1], "glue" ) == SAME )
	  SISglue = TRUE;
        else
	  goto OptionError;

	continue;

      case 'b':
        if ( strcmp( &argv[idx][1], "bind" ) == SAME )
	  bind = TRUE;
        else if ( strcmp( &argv[idx][1], "bounds" ) == SAME )
          bounds = TRUE;
        else
          goto OptionError;

        continue;

      case 's':
        if ( strcmp( &argv[idx][1], "sdbx" ) == SAME )
	  sdbx = TRUE;
        else if ( strcmp( &argv[idx][1], "seq" ) == SAME ) {
          concur = FALSE;
          novec = TRUE;
          }
        else
          goto OptionError;

        continue;

      case 'h':
        if ( strcmp( &argv[idx][1], "hybrid" ) == SAME ) {
	  hybrid = TRUE;
	  continue;
	  }

        if ( IsDigit( argv[idx][2] ) ) {
          huge = argv[idx];
          huge[1] = 'H';
          }
        else
          goto OptionError;

        continue;

      case 'p':
        if ( strcmp( &argv[idx][1], "prof" ) == SAME ) {
	  prof = TRUE;
	  verbose = TRUE;
	  continue;
	  }

	if ( argv[idx][2] == 'b' ) {
	  if ( IsDigit( argv[idx][3] ) ) {
            preb = &(argv[idx][1]);
            preb[0] = '-';
	    preb[1] = 'Y';
	    continue;
	    }
          }

        if ( strcmp( &argv[idx][1], "progress" ) == SAME )
          prog = TRUE;
        else if ( IsDigit( argv[idx][2] ) ) {
          procs = argv[idx];
          procs[1] = 'P';
          }
        else
          goto OptionError;

        continue;

      case 'A':
        atlevel = argv[idx];
        continue;

      case 'd':
	if ( strcmp( &argv[idx][1], "db" ) == SAME ) {
          if ( (++idx) >= argc )
            goto OptionError;

          mdb = argv[idx];
	  continue;
	  }
        if ( strcmp( &argv[idx][1], "double_real" ) == SAME )
          dbl = TRUE;
        else if ( strcmp( &argv[idx][1], "dfuse" ) == SAME )
	  nodfuse = FALSE;
        else if ( argv[idx][2] != '\0' )
          goto OptionError;
        else
          debug = TRUE;

        continue;

      case 'e':
	if ( strcmp( &argv[idx][1], "explode" ) == SAME ) {
	  explode = TRUE;
	  continue;
	  }
	else if ( strcmp( &argv[idx][1], "explodeI" ) == SAME ) {
	  explode  = TRUE;
	  explodeI = TRUE;
	  continue;
	  }

	if ( argv[idx][2] != '\0' )
          Error2( "usage:", "-e funct" );

        if ( ++idx >= argc )
          Error2( "usage:", "-e funct" );

        eoptions[++eoptioncnt] = argv[idx];
        continue;

      case 'f':
        if ( strcmp( &argv[idx][1], "fflopinfo" ) == SAME ) {
          if ( ++idx >= argc )
            Error2( "usage:", "-fflopinfo funct" );

          calloptions[++calloptioncnt] = argv[idx];
          flopoptions[++flopoptioncnt] = argv[idx];
	  flpinfo = TRUE;
	  continue;
	  }
        else if ( strcmp( &argv[idx][1], "flopinfo" ) == SAME ) { 
	  flpinfo = TRUE;
	  continue;
	  }
        else if ( strcmp( &argv[idx][1], "freeall" ) == SAME ) { 
	  freeall = TRUE;
	  continue;
	  }
        else if ( strcmp( &argv[idx][1], "fuse" ) == SAME ) {
	  noifuse  = FALSE;
	  nodfuse = FALSE;
	  continue;
	  }
        else if ( strcmp( &argv[idx][1], "forC" ) == SAME ) {
          forC = TRUE;
          continue;
          }
        else if ( strcmp( &argv[idx][1], "forFORTRAN" ) == SAME ) {
          forF = TRUE;
          continue;
          }
        else if ( argv[idx][2] == 'f' ) {
          if ( argv[idx][3] == '=' )
            if ( argv[idx][4] != '\0' ) {
              ffoptions[++ffoptionscnt] = &argv[idx][4];
              continue;
              }

	  goto OptionError;
	  }
        else if ( argv[idx][2] != '\0' )
          goto OptionError;

        if ( ++idx >= argc )
          Error2( "usage:", "-f funct" );

        foptions[++foptioncnt] = argv[idx];
        continue;

      case 'v':
        if ( strcmp( &argv[idx][1], "vector" ) == SAME ) {
          novec = FALSE;
#ifndef CRAY
#ifndef ALLIANT
          cvector   = TRUE; /* RIGHT NOW, THE CRAY IS THE DEFAULT */
          movereads = TRUE;
          chains    = TRUE;
	  newchains = TRUE;
#endif
#endif
          continue;
          }
        else if ( strcmp( &argv[idx][1], "vinfo" ) == SAME ) {
          vinfo = TRUE;
          continue;
          }

        verbose = TRUE; 
        continue;

      case 'i': 
        if ( strcmp( &argv[idx][1], "icse" ) == SAME ) {
	  noaggressive = FALSE;
	  continue;
	  }
        else if ( strcmp( &argv[idx][1], "inlineall" ) == SAME ) {
	  inlineall = TRUE;
	  continue;
	  }
        else if ( strcmp( &argv[idx][1], "info" ) == SAME )
          info = TRUE;
        else if ( strcmp( &argv[idx][1], "inter" ) == SAME )
          inter = TRUE;
        else if ( IsDigit( argv[idx][2] ) ) {
          iter = argv[idx];
          iter[1] = '@';
          }                
        else
          goto OptionError;

        continue;

      case 'D':
        if ( strcmp( &argv[idx][1], "DI" ) == SAME )
          stopDI = TRUE;
        else if ( strcmp( &argv[idx][1], "D" ) == SAME ) {
	  debug = TRUE;
	  DeBuG = TRUE;
          }
	else
	  cppoptions[++cppoptioncnt] = argv[idx];

        continue;

      case 'I':
        if ( strcmp( &argv[idx][1], "IF1" ) == SAME )
          stopIF1 = TRUE;
        else if ( IsDigit( argv[idx][2] ) ) {
          iter = argv[idx];
          iter[1] = '@';
          }                
	else if ( argv[idx][2] != '\0' )
	  cppoptions[++cppoptioncnt] = argv[idx];
        else
          goto OptionError;

        continue;

      case 'O':
        if ( strcmp( &argv[idx][1], "OPT" ) == SAME )
          stopOPT = TRUE;
        else
          goto OptionError;

        continue;

      case 'M':
        if ( strcmp( &argv[idx][1], "MONO" ) == SAME )
          stopMONO = TRUE;
        else if ( strcmp( &argv[idx][1], "MEM" ) == SAME )
          stopMEM = TRUE;
        else
          goto OptionError;

        continue;

      case 'U':
        if ( strcmp( &argv[idx][1], "UP" ) == SAME )
          stopUP = TRUE;
        else if ( argv[idx][2] != '\0' )
	  cppoptions[++cppoptioncnt] = argv[idx];
        else
	  goto OptionError;

	continue;

      case 'u':
        if ( IsDigit( argv[idx][2] ) ) {
          unroll = argv[idx];
          unroll[1] = 'U';
          }
	else
          goto OptionError;

        continue;

      case 'F':
        if ( argv[idx][2] == 'F' ) {
          if ( argv[idx][3] == '=' )
            if ( argv[idx][4] != '\0' ) {
              ff = &argv[idx][4];
              newff = TRUE;
              continue;
              }
          }

        goto OptionError;

      case 'C':
        if ( strcmp( &argv[idx][1], "CPP" ) == SAME )
	  stopCPP = TRUE;
        else if ( strcmp( &argv[idx][1], "C" ) == SAME )
          stopC = TRUE;
        else if ( argv[idx][2] == 'C' ) {
          if ( argv[idx][3] == '=' )
            if ( argv[idx][4] != '\0' ) {
              cc = &argv[idx][4];
              newcc = TRUE;
              continue;
              }

          goto OptionError;
	  }
        else
          goto OptionError;

        break;

      case 'o':
        if ( argv[idx][2] != '\0' )
          goto OptionError;

        if ( (++idx) >= argc )
          goto OptionError;

        aabs = argv[idx];
        continue;

      case 'S':
        if ( argv[idx][2] != '\0' )
          goto OptionError;

        stopS = TRUE;
        continue;

      case 'x':
        if ( strcmp( &argv[idx][1], "xchains" ) == SAME )
	  chains = TRUE;
        else
          goto OptionError;
	
	continue;

      case 'm':
        if ( strcmp( &argv[idx][1], "module" ) == SAME )
	  smodule = TRUE;
        else if ( strcmp( &argv[idx][1], "movereads" ) == SAME )
          movereads = TRUE;
        else if ( strcmp( &argv[idx][1], "maxconcur" ) == SAME ) {
          concur = TRUE;
          huge  = "-H1.0";
          procs = "-P4000000";
	  continue;
          }
        else
	  goto OptionError;

        continue;

      case 'c':
        if ( strcmp( &argv[idx][1], "cray" ) == SAME ) {
	  novec = FALSE;
	  cvector = TRUE;
	  cRay = TRUE;
          movereads = TRUE;
          chains = TRUE;
	  newchains = TRUE;
	  stopC = TRUE;
	  continue;
	  }
        else if ( strcmp( &argv[idx][1], "cvector" ) == SAME ) {
          novec = FALSE;
          cvector = TRUE;
          movereads = TRUE;
          chains = TRUE;
	  newchains = TRUE;
          continue;
          }
        else if ( strcmp( &argv[idx][1], "cinfo" ) == SAME ) {
          cinfo = TRUE;
          continue;
          }
        else if ( strcmp( &argv[idx][1], "cvinfo" ) == SAME ) {
          cinfo = TRUE;
          vinfo = TRUE;
          continue;
          }
        else if ( strcmp( &argv[idx][1], "concur" ) == SAME ) {
          concur = TRUE;
          continue;
          }
        else if ( strcmp( &argv[idx][1], "copyinfo" ) == SAME ) {
          cpyinfo = TRUE;
          continue;
          }
        else if ( argv[idx][2] == 'c' ) {
          if ( argv[idx][3] == '=' )
            if ( argv[idx][4] != '\0' ) {
              ccoptions[++ccoptionscnt] = &argv[idx][4];
              continue;
              }

	  goto OptionError;
	  }
        else if ( strcmp( &argv[idx][1], "call" ) == SAME ) {
          if ( ++idx >= argc )
            Error2( "usage:", "-call funct" );

          calloptions[++calloptioncnt] = argv[idx];
	  continue;
	  }

	/* XXX -c funct XXX */
	if ( argv[idx][2] != '\0' )
          Error2( "usage:", "-c funct" );

        if ( ++idx >= argc )
          Error2( "usage:", "-c funct" );

        coptions[++coptioncnt] = argv[idx];
        continue;

      case 'P':
        if ( strcmp( &argv[idx][1], "Prof" ) == SAME ) {
	  Prof = TRUE;
	  verbose = TRUE;
	  }
        else if ( strcmp( &argv[idx][1], "PART" ) == SAME )
          stopPART = TRUE;
        else if ( IsDigit( argv[idx][2] ) ) {
          procs = argv[idx];
          procs[1] = 'P';
          }
        else
          goto OptionError;

        continue;

      case 'r':
        if ( strcmp( &argv[idx][1], "real" ) == SAME )
          flt = TRUE;
        else
          goto OptionError;

        continue;

      default:
        goto OptionError;
	break;
      }
    }

  /* if ( novec && !noaggressive )
    Warning( "-aggressive given with -novector, so ignored", "" ); */

  if ( noopt && explode ) {
    Warning( "-noopt disables -explode and -explodeI", "" );
    explode  = FALSE;
    explodeI = FALSE;
    }

  if ( inlineall && (inter || noinline || noopt) )
    Warning( "-inlineall conflicts with -inter, -noinline, and -noopt", "" );

  if ( alliantfx && cRay )
    Error2( "-alliantfx and -cray conflict", "" );

#ifdef CRAY
  /* if ( dbl ) */
    /* Warning( "-double_real ignored, -real assumed", "" ); */

  /* flt = TRUE; */
  /* dbl = FALSE; */
#endif

  if ( timeoptioncnt > -1 && (inlineall || inter) )
    Error2( "-time and -inlineall or -inter conflict", "" );

  if ( forC && forF )
    Error2( "-forC and -forFORTRAN conflict", "" );

  if ( (forC || forF) && smodule )
    Error2( "-forC and -forFORTRAN conflict with -smodule", "" );

  if ( !(forC || forF || smodule) )
   if ( eoptioncnt > 0 )
    Error2( "only one entry point allowed in a stand-alone program module", "");
      
  if ( cpyinfo )
    nocagg = TRUE;

  if ( bounds && sdbx )
    Error2( "-bounds and -sdbx conflict", "" );

  if ( bind && freeall )
    Error2( "-bind and -freeall conflict", "" );

  if ( flt && dbl )
    Error2( "-double_real and -real conflict", "" );

  if ( sdbx || bounds ) {
    novec = TRUE;

    if ( sdbx ) {
      concur   = FALSE;
      noif2up  = TRUE;
      noif2mem = TRUE;
      noimp    = TRUE;
      }

    SISglue = TRUE;
    inlineall = FALSE;
    }

  if ( noopt ) {
    noscalar = TRUE;
    noinline = TRUE;
    noif2mem = TRUE;
    noif2up  = TRUE;
    novec    = TRUE;
    avector  = FALSE;
    cvector  = FALSE;
    concur   = FALSE;
    preb   = "-Y0";
    nobip    = TRUE;
    explode = FALSE;
  } else {
    if ( nocse )
      noifuse = nodfuse = nosfuse = TRUE;
    }

  if ( !concur )
    level = "-L0";

  return;

OptionError:
  Error2( "illegal option:", argv[idx] );
}

/**************************************************************************/
/* LOCAL  **************   SubmitFrontendRequest   ************************/
/**************************************************************************/
/* PURPOSE: SUBMIT A REQUEST TO THE FRONTEND TO COMPILE file.             */
/**************************************************************************/

static int SubmitFrontendRequest( file, farg )
char *file;
int   farg;
{
  char fopt[200];

  av[0] = "sisal"; 
  av[1] = "-dir";
  av[2] = sisalpt;
  av[3] = file;

  avcnt = 4;

  if ( farg ) {
    sprintf( fopt, "-F%s", SetFileSuffix( GetFileRoot( file ), ".sis" ) );
    av[avcnt++] = fopt;
    }
    
  if ( list )
    av[avcnt++] = "-xref"; 

  if ( SISglue )
    av[avcnt++] = "-SISglue";

  av[avcnt] = NULL;

  return( Submit( sisal ) );
}


/**************************************************************************/
/* LOCAL  **************       SubmitCommands      ************************/
/**************************************************************************/
/* PURPOSE: DETERMINE THE COMPILATION STARTING POINT, SUBMIT COMPILATION  */
/*          PHASES TO UNIX, AND RETURN THE TERMINATION STATUS.            */
/**************************************************************************/

static int SubmitCommands()
{
  register int   idx, cnt, k, j;
  register char *tmp0, *tmp1, *tmp2, *tmp3, *tmp4;
  register char  top;
	   char  module[200];


  if ( icnt >= 0 || siscnt >= 0 ) {
    if ( optcnt >= 0 )
      Error2( "USAGE:", "conflicting file types" );
    
    if ( siscnt < 0 )
      root = GetFileRoot( i[0] );
    else
      root = GetFileRoot( sis[0] );

    file  = SetFileSuffix( root, ".mono" );
    start = SIS;
    }

  else if ( if1cnt >= 0 ) {
    if ( optcnt >= 0 )
      Error2( "USAGE:", "conflicting file types" );
    
    root  = GetFileRoot( if1[0] );
    file  = SetFileSuffix( root, ".mono" );
    start = IF1;
    }

  else if ( optcnt >= 0 ) {
    if ( (optcnt > 0) )
      Error2( "USAGE:", "conflicting file types" );

    root  = GetFileRoot( opt[0] );
    file  = opt[0];
    start = GetFileType( file );
    }

  else if ( ccnt >= 0 ) {
    root  = NULL;
    file  = NULL;
    start = C;
    }

  else if ( ldcnt >= 0 ) {
    root  = NULL;
    file  = NULL;
    start = LD;
    }

  else if ( fcnt >= 0 ) {
    root  = NULL;
    file  = NULL;
    start = F;
    }

  else
    return( OK );

  if ( root != NULL ) {
    tmp0 = SetFileSuffix( root, ".opt"  );
    tmp1 = SetFileSuffix( root, ".mem"  );
    tmp2 = SetFileSuffix( root, ".up"   );
    tmp3 = SetFileSuffix( root, ".part" );
    tmp4 = SetFileSuffix( root, ".c"    );
    }

  switch ( start ) {
/****************************************************************************/
    case SIS:
      for ( idx = 0; idx <= siscnt; idx++ ) {
	if ( !nocpp ) {
          sprintf( cmdline1, "%s%s %s %s %s",
		   (Prof || prof)? "time " : "", spprun, spp2, cc, 
                   GetFileRoot( sis[idx] )                      );

          for ( cnt = 0; cnt <= cppoptioncnt; cnt++ ) {
	    strcat( cmdline1, " " );
	    strcat( cmdline1, cppoptions[cnt] );
	    }

          if ( Prof || prof )
	    fprintf( stderr, "\n*** %s ***\n", cmdline1 );
          else if ( debug || verbose )
	    fprintf( stderr, "%s\n", cmdline1 );

	  if ( !debug )
	    if ( system(cmdline1) != 0 )
	      return( ERROR );
	  }

        if ( stopCPP )
	  continue;

	if ( !nocpp ) {
          if ( SubmitFrontendRequest( sisi[idx], TRUE ) != OK )
	    return( ERROR );
	  }
        else if ( SubmitFrontendRequest( sis[idx], FALSE ) != OK )
	  return( ERROR );
 
        /* CLEAN UP file.i FILES */
        if ( !nocpp ) {
          RemoveFile( sisi[idx] );
	  }
        }

      if ( stopCPP )
	return( OK );

      for ( idx = 0; idx <= icnt; idx++ )
        if ( SubmitFrontendRequest( i[idx], FALSE ) != OK )
	  return( ERROR );
/****************************************************************************/
    case IF1:
      if ( stopCPP || stopIF1 )
        return( OK );

      av[0] = "if1ld";
      av[1] = "-o";
      av[2] = file;

      avcnt = 3;

      if ( smodule ) av[avcnt++] = "-S";

      if ( Prof ) av[avcnt++] = "-W";
      if ( forF ) av[avcnt++] = "-F";
      if ( forC ) av[avcnt++] = "-C";


      for ( idx = 0; idx <= eoptioncnt; idx++ ) {
         av[avcnt++] = "-e";
         av[avcnt++] = eoptions[idx];
         }

      for ( idx = 0; idx <= coptioncnt; idx++ ) {
         av[avcnt++] = "-c";
         av[avcnt++] = coptions[idx];
         }

      for ( idx = 0; idx <= foptioncnt; idx++ ) {
         av[avcnt++] = "-f";
         av[avcnt++] = foptions[idx];
         }

      if ( cRay )
        av[avcnt++] = "-FU";
      else
#ifdef RS6000
        av[avcnt++] = "-FUN";
#else
        av[avcnt++] = "-FUR";
#endif

      for ( idx = 0; idx <= siscnt; idx++ )
         av[avcnt++] = SetFileSuffix( GetFileRoot( sisi[idx] ), ".if1" );

      for ( idx = 0; idx <= icnt; idx++ )
         av[avcnt++] = SetFileSuffix( GetFileRoot( i[idx] ), ".if1" );

      for ( idx = 0; idx <= if1cnt; idx++ )
         av[avcnt++] = if1[idx];

      av[avcnt] = NULL;

      if ( Submit( if1ld ) == ERROR )
        return( ERROR );
/****************************************************************************/
    case MONO:
      if ( stopMONO )
        return( OK );

      av[0] = "if1opt"; 
      av[1] = file;
      av[2] = tmp0;

      avcnt = 3;

      for ( idx = 0; idx <= calloptioncnt; idx++ ) {
         av[avcnt++] = "-#";
         av[avcnt++] = calloptions[idx];
         }

      if ( Prof ) av[avcnt++] = "-W";

      if ( !dead ) av[avcnt++] = "-d";
      if ( SISglue ) av[avcnt++] = "-8";

      if ( sdbx ) av[avcnt++] = "-3";
      if ( noassoc ) av[avcnt++] = "-Y";

      if ( !noaggressive ) av[avcnt++] = "-G";

      if ( nostrip ) av[avcnt++] = "-6";

      if ( concur ) av[avcnt++] = "-R";

      if ( noinline ) av[avcnt++] = "-x";

      if ( nonormidx ) av[avcnt++] = "-N";

      if ( cvector ) {
        if ( !novec )  av[avcnt++] = "-X";
        av[avcnt++] = "-C5";
        }
#ifdef CRAY
      if ( !novec )  av[avcnt++] = "-X";
      av[avcnt++] = "-C5";
#endif

      if ( avector ) {
        if ( !novec )  av[avcnt++] = "-X";
        av[avcnt++] = "-A";
        }
#ifdef ALLIANT
      if ( !novec )  av[avcnt++] = "-X";
      av[avcnt++] = "-A";
#endif

      if ( norecf )   av[avcnt++] = "-r";
      if ( noinvar )  av[avcnt++] = "-v";
      if ( nocse )    av[avcnt++] = "-c";
      if ( noifuse )  av[avcnt++] = "-u";
      if ( nosfuse )  av[avcnt++] = "-j";
      if ( nosplit )  av[avcnt++] = "-S";
      if ( noinvert)  av[avcnt++] = "-Z";
      if ( nodfuse )  av[avcnt++] = "-z";
      if ( nodope )   av[avcnt++] = "-D";
      if ( noamove )  av[avcnt++] = "-9";
      if ( nogcse )   av[avcnt++] = "-g";
      if ( nofold )   av[avcnt++] = "-f";
      if ( inter )    av[avcnt++] = "-t";

      if ( explode ) {
	if ( explodeI )
	  av[avcnt++] = "-+";
	else
	  av[avcnt++] = "-T";
	}

      if ( inlineall ) av[avcnt++] = "-$";

      if ( noOinvar ) av[avcnt++] = "-V";

      if ( noscalar ) av[avcnt++] = "-a";

      if ( notgcse )  av[avcnt++] = "-1";

      if ( info )
        av[avcnt++] = "-i";
      else if ( vinfo || cinfo )
        av[avcnt++] = "-I";

      if ( !stopDI ) {
        av[avcnt++] = "-l";
        av[avcnt++] = "-e";
        }
      else 
        av[avcnt++] = "-s";

      if ( iter != NULL )
        av[avcnt++] = iter;

      av[avcnt++] = unroll;

      av[avcnt] = NULL;

      if ( Submit( if1opt ) == ERROR )
        return( ERROR );

      RemoveFile( file );
      file = tmp0;
/****************************************************************************/
      if ( stopDI )
        return( OK );
/****************************************************************************/
    case OPT:
      if ( stopOPT )
        return( OK );

      av[0] = "if2mem";
      av[1] = file;
      av[2] = tmp1;

      avcnt = 3;

      if ( Prof ) av[avcnt++] = "-W";

      if ( !noscalar ) {
        if ( noinvar )  av[avcnt++] = "-v";
        if ( noOinvar ) av[avcnt++] = "-V";
        if ( nocse )    av[avcnt++] = "-c";
        if ( nogcse )   av[avcnt++] = "-g";
        if ( nofold )   av[avcnt++] = "-f";
        }
      else
        av[avcnt++] = "-a";

      if ( sdbx ) av[avcnt++] = "-^";

      if ( SISglue ) av[avcnt++] = "-8";

      if ( sdbx ) av[avcnt++] = "-a";

      if ( info ) av[avcnt++] = "-i";

      if ( noif2mem )
        av[avcnt++] = "-m";

      av[avcnt] = NULL;

      if ( Submit( if2mem ) == ERROR )
        return( ERROR );

      RemoveFile( file );
      file = tmp1;
/****************************************************************************/
    case MEM:
      if ( stopMEM )
        return( OK );

      av[0] = "if2up";
      av[1] = file;
      av[2] = tmp2;

      avcnt = 3;

      if ( info )  av[avcnt++] = "-i";

      if ( Prof ) av[avcnt++] = "-W";

      if ( noif2up )
        av[avcnt++] = "-m";

      if ( noif2up || nostr )
        av[avcnt++] = "-t";

      if ( nocagg )
        av[avcnt++] = "-c";

      if ( noif2up || nomig )
        av[avcnt++] = "-l";

      if ( sdbx ) av[avcnt++] = "-^";

      if ( !nocom )
        av[avcnt++] = "-I";

      av[avcnt] = NULL;

      if ( Submit( if2up ) == ERROR )
        return( ERROR );

      RemoveFile( file );
      file = tmp2;
/****************************************************************************/
    case UP:
      if ( stopUP )
        return( OK );

      av[0] = "if2part";
      av[1] = costs;
      av[2] = file;
      av[3] = tmp3;

      avcnt = 4;

      if ( Prof ) av[avcnt++] = "-W";

      if ( mdb != NULL ) {
	sprintf( module, "-X%s", mdb );
	av[avcnt++] = module;
	}

      if ( info )
        av[avcnt++] = "-i";

      if ( noassoc ) av[avcnt++] = "-R";

      if ( atlevel != NULL )
        av[avcnt++] = atlevel;

      if ( level != NULL )
        av[avcnt++] = level;

      if ( !novec ) av[avcnt++] = "-v";

      av[avcnt++] = procs;

      if ( cvector )
        av[avcnt++] = "-C5";
#ifdef CRAY
      av[avcnt++] = "-C5";
#endif

      if ( huge != NULL )
        av[avcnt++] = huge;

      if ( iter != NULL )
        av[avcnt++] = iter;

      av[avcnt] = NULL;

      if ( Submit( if2part ) == ERROR )
        return( ERROR );

      RemoveFile( file );
      file = tmp3;
/****************************************************************************/
    case PART:
      if ( stopPART )
        return( OK );

      av[0] = "if2gen";
      av[1] = file;
      av[2] = tmp4;

      avcnt = 3;

      if ( Prof ) av[avcnt++] = "-W";

      for ( idx = 0; idx <= flopoptioncnt; idx++ ) {
         av[avcnt++] = "-@";
         av[avcnt++] = flopoptions[idx];
         }

      for ( idx = 0; idx <= timeoptioncnt; idx++ ) {
         av[avcnt++] = "-&";
         av[avcnt++] = timeoptions[idx];
         }

      if ( norag ) av[avcnt++] = "-1";

      if ( bind ) av[avcnt++] = "-4";

      if ( nobrec ) av[avcnt++] = "-#";

      if ( noassoc ) av[avcnt++] = "-y";

      if ( !bipmv ) av[avcnt++] = "-0";

      if ( hybrid ) {
	sprintf( hybridDOT, "%sF.o", root );
	sprintf( hybridROOT, "%sF", root );
	sprintf( hybridFILE, "%s.f", hybridROOT );
	sprintf( hybridOPTION, "-K%s", hybridROOT );

	av[avcnt++] = hybridOPTION;
	dohybrid = TRUE;
	}

      if ( freeall ) av[avcnt++] = "-9";

      if ( intrinsics ) av[avcnt++] = "-U";

      if ( alliantfx ) av[avcnt++] = "-5";
      if ( cRay )   av[avcnt++] = "-6";
      if ( nltss )     av[avcnt++] = "-7";

/* #ifdef SGI */
      /* av[avcnt++] = "-x"; */
/* #endif */

      if ( SISglue ) av[avcnt++] = "-8";

      if ( !nogshared ) av[avcnt++] = "-G";
      if ( movereads ) av[avcnt++] = "-2";

      if ( newchains ) av[avcnt++] = "-3N";
      else if ( chains ) av[avcnt++] = "-3";

      if ( useORTS )
        av[avcnt++] = "-O";

      if ( cvector )
              av[avcnt++] = "-C5";
#ifdef CRAY
      av[avcnt++] = "-C5";
#endif

      if ( avector ) av[avcnt++] = "-A";
#ifdef ALLIANT
      av[avcnt++] = "-A";
#endif

      if ( !novec )  av[avcnt++] = "-X";

      if ( prog )    av[avcnt++] = "-P";

      if ( info )    
        av[avcnt++] = "-i";
      else if ( cinfo || vinfo )
        av[avcnt++] = "-V";

      if ( noregs )  av[avcnt++] = "-r";
      if ( nofcopy ) av[avcnt++] = "-F";
      if ( flt )     av[avcnt++] = "-f";
      if ( dbl )     av[avcnt++] = "-d";
      if ( noaimp )  av[avcnt++] = "-a";

      /* if ( forC )    av[avcnt++] = "-L"; */
      /* if ( forF )    av[avcnt++] = "-l"; */

      if ( nobip )
	av[avcnt++] = "-P";

      av[avcnt++] = preb;

      if ( noif2up )
        av[avcnt++] = "-u";

      if ( sdbx ) {
	av[avcnt++] = "-a";  /* -sdbx implies -noaimp */
	av[avcnt++] = "-{";
	}

      if ( bounds ) {
        av[avcnt++] = "-B";
        av[avcnt++] = "-a";  /* -bounds implies -noaimp */
        }

      av[avcnt] = NULL;

      if ( Submit( if2gen ) == ERROR )
        return( ERROR );

      RemoveFile( file );
      file = tmp4;

      c[++ccnt] = cfile = file;
/****************************************************************************/
    case C:
      if ( stopC )
        return( OK );
/****************************************************************************/
    case LD:
/****************************************************************************/
      if ( dohybrid ) {
        av[0] = ff;
        av[1] = "-c";

        avcnt = 2;

#ifdef CRAY
        av[avcnt++] = "-Wf-astack";
#endif
#ifdef ALLIANT
        av[avcnt++] = "-recursive";
#endif

        for ( cnt = 0; cnt <= ffoptionscnt; cnt++ )
          av[avcnt++] = ffoptions[cnt];

	av[avcnt++] = hybridFILE;

        av[avcnt] = NULL;

        if ( Submit( ff ) == ERROR )
          return( ERROR );

        ld[++ldcnt] = hybridDOT;
	}
/****************************************************************************/
      if ( forF && ccnt < 0 )
	goto ProcessFORTRAN;

      av[0] = cc;
      avcnt = 1;

#ifdef CRAY
      if ( info || vinfo ) {
        av[avcnt++] = "-hvreport";
	}

      if ( noimp )
        av[avcnt++] = "-hnoopt";

      if ( novec )
        av[avcnt++] = "-hnovector";

      if ( !novec )
	av[avcnt++] = "-haggress";
#endif

      av[avcnt++] = incl;

      if ( flpinfo )
	av[avcnt++] = "-DFInfo=1";

      if ( cpyinfo )
	av[avcnt++] = "-DCInfo=1";

#ifdef SUN
      av[avcnt++] = "-DSUN";
#endif

#ifdef SGI
      av[avcnt++] = "-DSGI";
#endif

#ifdef RS6000
      av[avcnt++] = "-DRS6000";
#endif

#ifdef SUNIX
      av[avcnt++] = "-DSUNIX";
#endif

#ifdef GANGD
      av[avcnt++] = "-DGANGD";
#endif

#ifdef SYMMETRY
      av[avcnt++] = "-DSYMMETRY";
#endif

#ifdef BALANCE
      av[avcnt++] = "-DBALANCE";
#endif

#ifdef ENCORE
      av[avcnt++] = "-DENCORE";
#endif

#ifdef CRAY
      av[avcnt++] = "-DCRAY";
#ifdef CRAYXY
      av[avcnt++] = "-DCRAYXY";
#endif
#ifdef CRAY2
      av[avcnt++] = "-DCRAY2";
#endif
#endif

#ifdef ALLIANT
      av[avcnt++] = "-DALLIANT";
      av[avcnt++] = "-ce";

      if ( info || vinfo ) {
        av[avcnt++] = "-l";
        av[avcnt++] = "-OMip";
        }
      else
        av[avcnt++] = "-OMipsl";
#endif

      if ( !noimp ) {
#ifdef  ALLIANT
        if ( !noassoc )
          av[avcnt++] = "-AS";

        if ( !novec )
          av[avcnt++] = "-Oigv";
        else
          av[avcnt++] = "-Oig";

#else
#ifndef CRAY
        av[avcnt++] = "-O";
#endif
#endif

#if BALANCE || SYMMETRY
        av[avcnt++] = "-i";
#endif
        }

#ifdef w1167
      av[avcnt++] = "-f1167";
#endif

#ifdef F68881
      av[avcnt++] = "-f68881";
#endif

      if ( stopS )
        av[avcnt++] = "-S";

      if ( forF || stopc )
        av[avcnt++] = "-c";

#if SYMMETRY || BALANCE
      av[avcnt++] = "-w";
#endif

#ifdef ENCORE
      av[avcnt++] = "-q";
      av[avcnt++] = "long_jump";
#endif

#ifdef SGI
      av[avcnt++] = "-float";
#endif

      for ( cnt = 0; cnt <= ccoptionscnt; cnt++ )
        av[avcnt++] = ccoptions[cnt];

      if ( !forF && (forC || !(stopc || stopS)) ) {
        av[avcnt++] = "-o";

	if ( aabs == NULL ) {
          if ( forC )
            av[avcnt++] = "c.out";
          else 
            av[avcnt++] = "s.out";
	  }
        else
          av[avcnt++] = aabs;
        }

      for ( idx = 0; idx <= ccnt; idx++ )
        av[avcnt++] = c[idx];

      if ( !forF && (forC || !(stopc || stopS)) ) {
        if ( !forF && !forC )
	  av[avcnt++] = srt0;

#ifndef ALLIANT
#ifndef SYMMETRY
#ifndef BALANCE
        av[avcnt++] = libs;
#endif
#endif
#endif

        for ( idx = 0; idx <= ldcnt; idx++ )
           av[avcnt++] = ld[idx];

#if ALLIANT || SYMMETRY || BALANCE
        av[avcnt++] = libs;
#else
        av[avcnt++] = "-lsisal";
#endif

#ifdef ALLIANT
        av[avcnt++] = "-lcvec";
        av[avcnt++] = "-lcommon";
#endif

#ifdef CRAY
        av[avcnt++] = "-lu";
        av[avcnt++] = "-lsci";
#endif

#if SGI
        av[avcnt++] = "-lmpc";
#endif

#if BALANCE || SYMMETRY
#ifdef GANGD
        av[avcnt++] = "-lppp";
#endif
        av[avcnt++] = "-lpps";
#endif 

#ifdef ENCORE
        /* av[avcnt++] = "-lu"; */
        av[avcnt++] = "-lpp";
#endif

        av[avcnt++] = "-lm";

#ifndef CRAY
#ifndef SGI
        av[avcnt++] = "-lc";
#endif
#endif
        }

      av[avcnt] = NULL;

      if ( Submit( cc ) == ERROR )
        return( ERROR );

      for ( idx = 0; idx <= ccnt; idx++ )
	if ( strcmp( cfile, c[idx] ) == SAME )
          RemoveFile( c[idx] );

/****************************************************************************/
ProcessFORTRAN:
      if ( !forF || stopc )
	break;

    case F:

      av[0] = ff;
      av[1] = "-o";

      if ( aabs == NULL )
        av[2] = "f.out";
      else
        av[2] = aabs;

      avcnt = 3;

#ifdef F68881
      av[avcnt++] = "-f68881";
#endif

#ifdef CRAY
      av[avcnt++] = "-Wf-astack";
#endif

      for ( cnt = 0; cnt <= ffoptionscnt; cnt++ )
        av[avcnt++] = ffoptions[cnt];

      for ( idx = 0; idx <= fcnt; idx++ )
        av[avcnt++] = f[idx];

      for ( idx = 0; idx <= ccnt; idx++ )
        av[avcnt++] = SetFileSuffix( GetFileRoot( c[idx] ), ".o" );


#ifndef ALLIANT
#ifndef SYMMETRY
#ifndef BALANCE
#ifndef SUNIX
#ifndef RS6000
      av[avcnt++] = libs;
#endif
#endif
#endif
#endif
#endif

      for ( idx = 0; idx <= ldcnt; idx++ )
         av[avcnt++] = ld[idx];

#if ALLIANT || SYMMETRY || BALANCE || SUNIX || RS6000
      av[avcnt++] = libs;
#if SUNIX || RS6000
      av[avcnt++] = "-lsisal";
#endif
#else
      av[avcnt++] = "-lsisal";
#endif

#ifdef ALLIANT
      av[avcnt++] = "-lcvec";
      av[avcnt++] = "-lcommon";
#endif

#ifdef CRAY
      av[avcnt++] = "-lu";
      av[avcnt++] = "-lsci";
#endif

#if SGI
        av[avcnt++] = "-lmpc";
#endif

#if BALANCE || SYMMETRY
#ifdef GANGD
      av[avcnt++] = "-lppp";
#endif
      av[avcnt++] = "-lpps";
#endif 

#ifdef ENCORE
      /* av[avcnt++] = "-lu"; */
      av[avcnt++] = "-lpp";
#endif

      av[avcnt++] = "-lm";

#ifndef CRAY
#ifndef ENCORE
#ifndef SGI
      av[avcnt++] = "-lc";
#endif
#endif
#endif

      av[avcnt] = NULL;

      if ( Submit( ff ) == ERROR )
        return( ERROR );

      break;

/****************************************************************************/
    default:
      break;
    }

  return( OK );
}


/**************************************************************************/
/* GLOBAL **************            main           ************************/
/**************************************************************************/
/* PURPOSE: PARSE THE OSC COMMAND LINE, BUILD EXECUTABLE DIRECTORY PATHS, */
/*          AND CALL SubmitCommands TO REALIZE COMPILATION.               */
/**************************************************************************/

main( argc, argv )
int    argc;
char **argv;
{
    sprintf( procs = (char *) malloc(100), "-P%d", MAX_PROCS ); 

    ParseCommandLine( argc, argv );

    StrCat( sisal,     BIN_PATH,  "/sisal"     );
    StrCat( sisalpt,   BIN_PATH,  ""           );
    StrCat( if1ld,     BIN_PATH,  "/if1ld"     );
    StrCat( if1opt,    BIN_PATH,  "/if1opt"    );
    StrCat( if2mem,    BIN_PATH,  "/if2mem"    );
    StrCat( if2up,     BIN_PATH,  "/if2up"     );
    StrCat( if2part,   BIN_PATH,  "/if2part"   );
    StrCat( if2gen,    BIN_PATH,  "/if2gen"    );
    StrCat( spprun,    BIN_PATH,  "/spprun"    );
    StrCat( spp2,      BIN_PATH,  "/spp2"      );

    if ( !newff ) {
#if ALLIANT || BALANCE || SYMMETRY
      ff = "fortran";
#else
#ifdef CRAY
      ff = "cf77";
#else
      ff = "f77";
#endif
#endif
      }

    if ( !newcc ) {
#ifdef ALLIANT
      cc = "fxc";
#else
#ifdef CRAY
      cc = "cc";
#else
      cc = "cc";
#endif
#endif
      }

    StrCat( incl,      "-I",          BIN_PATH );

#if ALLIANT || SYMMETRY || BALANCE
    StrCat( libs,      BIN_PATH,      "/libsisal.a" );
#else
    StrCat( libs,      "-L",          BIN_PATH );
#endif

    StrCat( srt0,      BIN_PATH,  "/p-srt0.o"    );

    if ( costs == NULL ) {
        costs = buf1;
        StrCat( costs,   BIN_PATH,  "/s.costs"   );
        }

    if ( SubmitCommands() == ERROR ) {
        fprintf( stderr, "\n ** COMPILATION ABORTED ** \n\n" );
        exit( ERROR );
        }
        
    exit( OK );
}
