#include "world.h"


#define BASE10        10
#define BASE8         8

#define TEXT_SIZE     251
#define MAX_CHAR      0x7f

static  char    Buffer    = '\0';
        char    LookAhead = FALSE;
        int     LookAheadToken;

char    FibreChar;
char    FibreBool;
char    FibreNil;
int     FibreInt;
float   FibreFlt;
double  FibreDbl;

int     Indent = 0;

static char    Text[TEXT_SIZE];
static int     Length;
static int     Token;
static int     CharMode = FALSE;

#define    GET_NEXT_TOKEN    Buffer = getc( FibreInFd );
#define    ISDIGIT(X)        (((X) >= '0') && ((X) <= '9'))
#define    LENGTH_OK         (Length < TEXT_SIZE)
#define    ADD_TO_TEXT       if (LENGTH_OK) Text[Length++] = Buffer

#define    GET_DIGITS        while (ISDIGIT(Buffer)) {           \
                               ADD_TO_TEXT;                      \
                               GET_NEXT_TOKEN;                   \
                               }

static long GetLong( Base )
register int Base;
{
  register long Value;

  Value = 0;

  for ( ;; ) {
    if ( ISDIGIT( Buffer ) ) {
      if ( (Buffer - '0') >= Base )
        SisalError( "FIBRE", "ILLEGAL DIGIT" );

      Value = (Value * Base) + (Buffer - '0');
      }
    else
      break;

    GET_NEXT_TOKEN;
    }

  ungetc( Buffer, FibreInFd );
  return( Value );
}


static void GetExponent()
{
  Buffer = 'e';

  ADD_TO_TEXT;
  GET_NEXT_TOKEN;

  if ((Buffer == '-') || (Buffer == '+')) {
    ADD_TO_TEXT;
    GET_NEXT_TOKEN;
    }

  if ( ISDIGIT( Buffer ) )
    { GET_DIGITS; }
  else    
    SisalError( "FIBRE", "ILLEGAl EXPONENT" );

  ungetc( Buffer ,FibreInFd );
}


static void GetFraction( FractionOptional )
int FractionOptional;
{
  ADD_TO_TEXT;
  GET_NEXT_TOKEN;

  if ( !FractionOptional && !ISDIGIT( Buffer ) )
    SisalError( "FIBRE", "ILLEGAL FLOATING POINT NUMBER" );

  GET_DIGITS;

  switch ( Buffer ) {
    case 'D' :
    case 'd' :
    case 'e' :
    case 'E' :
      GetExponent();
      break;

    default:
      ungetc( Buffer, FibreInFd );
      break;
    }
}


static int PackageNumber()
{

  Text[Length] = '\0';

  switch ( Token ) {
    case INT_ :
      FibreInt = (int) atol( Text );
      break;

    case DOUBLE_ :
      FibreDbl = atof( Text ); 
      break;
    }

  return( Token );
}


static char GetChar()
{
  register char Value;

  if ( Buffer == '\\' ) {
    GET_NEXT_TOKEN;

    if ( ISDIGIT( Buffer ) ) {
      Value = (char) GetLong( BASE8 );

      if ((Value < 0) || (Value > MAX_CHAR)) 
        SisalError( "FIBRE", "ILLEGAL CHARACTER " );
      }
    else
      switch ( Buffer ) {
        case 'n' :
        case 'N' :
          Value = '\n';
          break;

        case 'f' :
        case 'F' :
          Value = '\f';
          break;

        case 'b' :
        case 'B' :
          Value = '\b';
          break;

        case 'r' :
        case 'R' :
          Value = '\r';
          break;

        case 't' :
        case 'T' :
          Value = '\t';
          break;

        default  :
          Value = Buffer;
          break;
        }
    } else  {
      if ( (Buffer < ' ') || (Buffer > '~') )
        SisalError( "FIBRE", "PRINTABLE CHARACTER EXPECTED" );

      Value = (long) Buffer;
      }

  return( Value );
}


static int GetNil()
{
  GET_NEXT_TOKEN;

  switch ( Buffer ) {
    case 'I' :
    case 'i' :
      break;

    default  :
      SisalError( "FIBRE", "ILLEGAL CHARACTER" );
    }

  GET_NEXT_TOKEN;

  switch ( Buffer ) {
    case 'L' :
    case 'l' :
      break;

    default  :
      SisalError( "FIBRE", "ILLEGAL CHARACTER" );
    }

  return( 0 );
}


static int FibreLex()
{
  Length = 0;

  GET_NEXT_TOKEN;


  if ( CharMode ) {
    if ( Buffer == '"' ) {
      CharMode = FALSE;
      return( STRING_TERM_ );
      }

    FibreChar = GetChar();
    return( STRING_CHAR_ );
    }

TopOfWorld:

  Token = DOUBLE_;

  if ( ISDIGIT( Buffer ) ) {
    GET_DIGITS;

    switch ( Buffer ) {
      case '.' :
        GetFraction( TRUE );
        break;

      case 'D' :
      case 'd' :
      case 'e' :
      case 'E' :
        GetExponent();
        break;

      default  :
        Token = INT_;
        ungetc( Buffer, FibreInFd );
	break;
      }

    return( PackageNumber() );
    }

  switch ( Buffer ) {
    case '.':
      GetFraction( FALSE );
      return( PackageNumber() );

    case '-':
    case '+':
      ADD_TO_TEXT;
      GET_NEXT_TOKEN;

      if ( ISDIGIT( Buffer ) || Buffer == '.' ) 
        goto TopOfWorld;

      SisalError( "FIBRE", "ILLEGAL NUMBER" );
      
    case 't' :
    case 'T' :
      FibreBool = TRUE;
      return( BOOL_ );

    case 'f' :
    case 'F' :
      FibreBool = FALSE;
      return( BOOL_ );

    case 'N' :
    case 'n' :
      FibreNil = GetNil();
      return( NIL_ );

    case '"' :
      CharMode = TRUE;
      return( STRING_START_ );

    case '#' :
      while ( Buffer != '\n' )
        GET_NEXT_TOKEN;

      goto TopOfWorld;

    case '\'':
      GET_NEXT_TOKEN;

      FibreChar = GetChar();

      GET_NEXT_TOKEN;

      if ( Buffer != '\'' )
        SisalError( "FIBRE", "CHARACTER DELIMITER EXPECTED: (')" );

      return( CHAR_ );

    case ',' :
      return( COMMA_ );

    case '>' :
      return( RECORDE_ );

    case '<' :
      return( RECORDB_ );

    case '}' :
      return( STREAME_ );

    case '{' :
      return( STREAMB_ );

    case ')' :
      return( UNIONE_ );

    case '(' :
      return( UNIONB_ );

    case ':' :
      return( COLON_ );

    case '[' :
      return( ARRAYB_ );

    case ']' :
      return( ARRAYE_ );

    case ';' :
      return( SEMI_COLON_ );


    case ' ' :
    case '\t' :
    case '\b' :
    case '\r' :
    case 013 : /* VT */
    case 014 : /* FF */
      GET_NEXT_TOKEN;

      goto TopOfWorld;

    case '\n' :
      GET_NEXT_TOKEN;

      goto TopOfWorld;

    case EOF :
      return( EOF_ );

    default  :
      SisalError( "FIBRE", "ILLEGAL CHARACTER" );
    }
}


static char *Messages[] = {
      "STRING TERMINATOR EXPECTED: (\")",
      "STRING INITIATOR EXPECTED: (\")",
      "STRING CHARACTER EXPECTED",
      "INTEGER EXPECTED",
      "CHARACTER CONSTANT EXPECTED",
      "DOUBLE EXPECTED",
      "NIL EXPECTED",
      "BOOLEAN EXPECTED",
      "EOF EXPECTED",
      "> EXPECTED",
      "< EXPECTED",
      "} EXPECTED",
      "{ EXPECTED",
      ") EXPECTED",
      "( EXPECTED",
      ": EXPECTED",
      "[ EXPECTED",
      "] EXPECTED",
      "; EXPECTED",
      "FLOAT EXPECTED",
      ", EXPECTED"};


int FibreParse( Expected ) 
int Expected;
{
  int Token;

  if ( LookAhead ) {
    Token     = LookAheadToken;
    LookAhead = FALSE;
    }
  else 
    Token = FibreLex();

  if ( Expected == ANY_ ) {
    if ( Token == EOF_ )
      SisalError( "FIBRE", "UNEXPECTED EOF" );

    return( Token );
    }

  if ( Expected != Token ) {
    if ( Expected == FLOAT_ && Token == DOUBLE_ )
      FibreFlt  = FibreDbl;
    else
      SisalError( "FIBRE",  Messages[ Expected - BASE_ ] );
    }

  return( Expected );
}
