#include "world.h"


PNODE nohead = NULL;            /* NoOp NODE LIST HEAD                    */
PNODE notail = NULL;            /* NoOp NODE LIST TAIL                    */
PNODE chead  = NULL;            /* COMPOUND NODE LIST HEAD                */
PNODE ctail  = NULL;            /* COMPOUND NODE LIST TAIL                */
PSET  gshead = NULL;            /* GLOBAL READ/WRITE SET LIST HEAD        */
PSET  gstail = NULL;            /* GLOBAL READ/WRITE SET LIST TAIL        */
PCALL cghead = NULL;            /* CALL GRAPH TRUNK HEAD                  */
PCALL cgtail = NULL;            /* CALL GRAPH TRUNK TAIL                  */
PNODE fhead  = NULL;            /* HEAD OF SORTED FUNCTION GRAPH LIST     */
PNODE ftail  = NULL;            /* TAIL OF SORTED FUNCTION GRAPH LIST     */
PEDGE dghead = NULL;            /* DATA GROUND EDGE LIST HEAD             */
PEDGE dgtail = NULL;            /* DATA GROUND EDGE LIST TAIL             */
PNODE cohead = NULL;            /* CONSTANT AGGREGATE GENERATOR LIST HEAD */
PNODE cotail = NULL;            /* CONSTANT AGGREGATE GENERATOR LIST TAIL */

int   univao = FALSE;           /* UNIVERSAL STREAM OWNERSHIP?            */
int   univso = FALSE;           /* UNIVERSAL ARRAY  OWNERSHIP?            */
int   cycle  = 0;               /* COUNT OF CYCLE CAUSING ADEs            */
int   cmig   = 0;               /* COUNT OF MIGRATED NODES                */


/**************************************************************************/
/* GLOBAL **************           If2Up           ************************/
/**************************************************************************/
/* PURPOSE: DRIVER FOR THE UPDATE-IN-PLACE ANALYSIS.  MINIMALLY A CALL    */
/*          GRAPH IS BUILT AND SORTED, NoOp NODES ARE INSERTED, AND       */ 
/*          UNOPTIMIZED REFERENCE COUNT VALUES ARE ASSIGNED. IF FULL      */
/*          OPTIMIZATION IS DESIRED, AGGREGATE EDGES ARE CLASSIFIED AS    */
/*          READ OR WRITE, Replace NODES ARE REORDERED TO ELIMINATE       */
/*          POSSIBLE PHYSICAL SPACE COPYING, READ/WRITE SETS ARE BUILT,   */
/*          ADES ARE INSERTED, CONSTANT AGGREGATE CONSTRUCTORS  ARE       */
/*          IDENTIFIED, REFERENCE COUNT VALUES ARE OPTIMIZED, MARKS       */
/*          ARE ASSIGNED, UNIVERSAL ARRAY AND STREAM OWNERSHIP IS         */
/*          DETERMINED, GROUND EDGES ARE REFINED, AND UNNECESSARY ADES    */
/*          ARE REMOVED. IF mig IS TRUE, MIGRATE NODES TOWARD THEIR       */
/*          DEPENDENTS.                                                   */
/**************************************************************************/

void If2Up( sdbx )
int sdbx;
{
    If2CallGraph();
    If2NoOp();
    If2ReferenceCount();

    if ( cagg )
      If2ConstGenerators();

    if ( info )
      If2Count( FALSE, "BEFORE ANALYSIS" );

    if ( minopt )
      return;

    If2Classify();
    If2Replace();
    If2ReadWriteSets();
    If2Ade();

    If2ReferenceCountOpt();
    If2PropagateMarks();

    If2Ownership();
    OptimizeSwaps();
    If2RefineGrounds();
    CleanNoOpImports();

    if ( mig )
      If2Migrate();

    if ( info )
      If2Count( TRUE, "AFTER ANALYSIS" );

    if ( !sdbx )
      WriteIf2upWarnings();
}

