#include "world.h"


extern int nopp;                       /* ONLY PERFORM DFORDER CHECKS?    */
PNODE fhead;                           /* DEFINED FOR if2util.c           */


/**************************************************************************/
/* LOCAL  **************     CheckDataFlowOrder    ************************/
/**************************************************************************/
/* PURPOSE: CHECK IF THE NODES IN THE NODE LIST OF GRAPH g ARE DFOrdered: */
/*          IF NODE b DEPENDS ON A VALUE GENERATED BY NODE a THEN THE     */
/*          LABEL(b) > LABEL(a).                                          */
/**************************************************************************/

static void CheckDataFlowOrder( g )
PNODE g;
{
    register PNODE n;
    register PEDGE i;
    register PADE  a;

    for ( n = g->G_NODES; n != NULL; n = n->nsucc )
	if ( n->nsucc != NULL )
	    if ( n->nsucc->label <= n->label ) {
                fprintf( stderr, "%s: E - NODE NOT DFOrdered: line %d\n", 
			 program, n->nsucc->if1line  );

                Stop( ERROR );
		}

    for ( n = g->G_NODES; n != NULL; n = n->nsucc )
	for ( i = n->imp; i != NULL; i = i->isucc )
	    if ( !IsConst( i ) )
		if ( i->src->label >= n->label ) {
                    fprintf( stderr, "%s: E - NODE NOT DFOrdered: line %d\n", 
			     program, i->src->if1line                      );

                    Stop( ERROR );
		    }

    for ( n = g->G_NODES; n != NULL; n = n->nsucc )
	for ( a = n->aimp; a != NULL; a = a->isucc )
            if ( a->src->label >= n->label ) {
                fprintf( stderr, "%s: E - NODE NOT DFOrdered(ADE): line %d\n", 
			         program, a->src->if1line                   );

                Stop( ERROR );
		}
}


/**************************************************************************/
/* LOCAL  **************      PPrintNodeMarks      ************************/
/**************************************************************************/
/* PURPOSE: PRINT NODE n'S MARKS TO output.                               */
/**************************************************************************/

static void PPrintNodeMarks( n )
PNODE n;
{
    fprintf( output, "(" );

    if ( n->ccost > 0.0 )
	fprintf( output, "[cc=%4.3e]", n->ccost );

    if ( n->pmark )
	fprintf( output, "P" );

    if ( n->smark )
	fprintf( output, "S" );

    if ( n->imark )
	fprintf( output, "I" );

    if ( n->mark != ' ' )
       fprintf( output, "%c", n->mark );

    if ( n->emark )
	fprintf( output, "E" );

    if ( n->lmark )
	fprintf( output, "L" );

    if ( n->cmark )
	fprintf( output, "C" );

    if ( n->nmark )
	fprintf( output, "N" );

    if ( n->bmark )
	fprintf( output, "B" );

    if ( n->wmark )
	fprintf( output, "W" );

    fprintf( output, ")" );
}


/**************************************************************************/
/* STATIC **************        PPrintConst        ************************/
/**************************************************************************/
/* PURPOSE: PRINT CONSTANT c TO output.                                   */
/**************************************************************************/

static void PPrintConst( c )
PEDGE c;
{
    if ( c->CoNsT == NULL ) {
        fprintf( output, "\"%s\"", ERROR_CONSTANT );
	return;
	}

    if ( IsDefArrayBuf( c->dst ) && (c->isucc == NULL) ) {
	fprintf( output, "\"%s\"", c->CoNsT );          /* BUFFER LITERAL */
	return;
	}

    switch ( c->info->type ) {
        case IF_CHAR:
            fprintf( output, "\"\'%s\'\"", c->CoNsT );
            break;

        case IF_ARRAY:
        case IF_STREAM:
            fprintf( output, "\"\"%s\"\"", c->CoNsT );
            break;

        default:
            fprintf( output, "\"%s\"", c->CoNsT );
            break;
        }
}


/**************************************************************************/
/* STATIC **************     PPrintIndentation     ************************/
/**************************************************************************/
/* PURPOSE: PRINT ln FOLLOWED BY indent BLANKS AND indent TO output.      */
/**************************************************************************/

static void PPrintIndentation( indent, ln )
int indent;
int ln;
{
    register int i;

    fprintf( output, "%4.4d", ln );

    for ( i = 0; i <= indent; i++ )
	fprintf( output, " " );

    fprintf( output, "%d: ", indent );
}


/**************************************************************************/
/* LOCAL  **************     PPrintEdgePragmas     ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE PRAGMAS OF EDGE e TO output.                        */
/**************************************************************************/

static void PPrintEdgePragmas( e )
PEDGE e;
{
    if ( !IsAggregate( e->info ) )
	return;

    fprintf( output, "(" );

    if ( e->pm != -2 )
	fprintf( output, "[pm=%d]", e->pm );

    if ( e->sr != -2 )
	fprintf( output, "[sr=%d]", e->sr );

    if ( e->pl != -2 )
	fprintf( output, "[pl=%d]", e->pl );

    if ( e->pmark )
	fprintf( output, "P" );

    if ( e->smark )
	fprintf( output, "S" );

    if ( e->rmark1 == RMARK )
	fprintf( output, "R" );

    if ( e->rmark1 == rMARK )
	fprintf( output, "r" );

    if ( e->omark1 )
	fprintf( output, "O" );

    if ( e->dmark )
	fprintf( output, "D" );

    if ( e->wmark )
	fprintf( output, "W" );

    if ( e->cm != 0 )
	fprintf( output, "[cm=%d]", e->cm );

    fprintf( output, ")" );
}


/**************************************************************************/
/* STATIC **************      PPrintImports        ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE NAME AND PRAGMAS OF NODE n'S IMPORTS TO output.     */
/**************************************************************************/

static void PPrintImports( n, indent )
PNODE n;
int   indent;
{
    register PADE  a;
    register PEDGE i;

    fprintf( output, "(" );

    for ( i = n->imp; i != NULL; i = i->isucc ) {
	if ( IsConst( i ) ) {
	    fprintf( output, " %d:[", i->iport );
	    PPrintConst( i );
	    fprintf( output, "]" );
	    continue;
	    }

	fprintf( output, " %d:[%d-%d", i->iport, i->src->label, i->eport );
	PPrintEdgePragmas( i );
	fprintf( output, "]" );
        }

    fprintf( output, " )\n" );

    if ( n->aimp != NULL ) {
        PPrintIndentation( indent, n->if1line );
	fprintf( output, " ** ADES:" );
	}

    for ( a = n->aimp; a != NULL; a = a->isucc )
	fprintf( output, " %d->%d", a->src->label, n->label );

    if ( n->aimp != NULL )
	fprintf( output, "\n" );
}


/**************************************************************************/
/* LOCAL  **************         PPrintNode        ************************/
/**************************************************************************/
/* PURPOSE: PRINT GRAPH g IN A READABLE FORMAT; indent DEFINES THE        */
/*          NESTING LEVEL.  TYPE INFORMATION IS NOT PRINTED. A DFOrder    */
/*          CHECK IS MADE.                                                */
/**************************************************************************/

static void PPrintNode( g, indent )
PNODE g;
{
    register PNODE n;

    if ( !nopp ) {
        PPrintIndentation( indent, g->if1line );

        switch ( g->type ) {
	    case IFIGraph:
	        fprintf( output, "(0)IMPORT FUNCTION %s(...)\n", g->G_NAME );
	        return;

	    case IFLGraph:
	        fprintf( output, "(0)LOCAL FUNCTION %s", g->G_NAME );
	        break;

	    case IFXGraph:
	        fprintf( output, "(0)EXPORT FUNCTION %s", g->G_NAME );
	        break;

	    case IFSGraph:
	        fprintf( output, "(0)SGrph" );
	        break;
	    }

        PPrintNodeMarks( g );
        PPrintImports( g, indent ); indent++;
	}

    CheckDataFlowOrder( g );

    for ( n = g->G_NODES; n != NULL; n = n->nsucc ) {
	if ( n->exp == NULL ) {
          fprintf( stderr, "%s: E - NODE WITHOUT EXPORTS: line %d\n", 
			   program, n->if1line  );

          Stop( ERROR );
          }

	if ( !nopp ) {
	    PPrintIndentation( indent, n->if1line );

	    fprintf( output, "(%d)", n->label );

	    if ( IsOther( n ) )
	        fprintf( output, "Other[%d]", n->type );
	    if ( IsSimple( n ) )
	        fprintf( output, "%s", snames[ n->type - IFAAddH ] );
            else if ( IsCompound( n ) )
	        fprintf( output, "%s", cnames[ n->type ] );
            else
	        fprintf( output, "%s", atnames[ n->type - IFAAddLAT ] );

            PPrintNodeMarks( n );
            PPrintImports( n, indent );
	    }

	if ( IsCompound( n ) )
	    for ( g = n->C_SUBS; g != NULL; g = g->gsucc )
		PPrintNode( g, indent + 1 );
	}
}


/**************************************************************************/
/* GLOBAL **************         If2PPrint         ************************/
/**************************************************************************/
/* PURPOSE: PRINT ALL FUNCTION GRAPHS TO output IN A READABLE FORM.       */
/**************************************************************************/

void If2PPrint()
{
    register PNODE f;

    for ( f = glstop->gsucc; f != NULL; f = f->gsucc ) {
	if ( !nopp )
	   fprintf( output, "\n" );

	PPrintNode( f, 0 );
	}
}
