#define IFForall           0           /* IF1 NODE TYPES --- COMPOUND         */
#define IFSelect           1
#define IFTagCase          2
#define IFLoopA            3
#define IFLoopB            4
#define IFIfThenElse       5           /* IF1 Version 1.1                     */
#define IFIterate          6           /* IF1 Version 1.1                     */

#define IFAAddH            100         /* IF1 NODE TYPES --- SIMPLE           */
#define IFAAddL            101
#define IFAAdjust          102
#define IFABuild           103
#define IFACatenate        104
#define IFAElement         105
#define IFAFill            106
#define IFAGather          107
#define IFAIsEmpty         108
#define IFALimH            109
#define IFALimL            110
#define IFARemH            111
#define IFARemL            112
#define IFAReplace         113
#define IFAScatter         114
#define IFASetL            115
#define IFASize            116
#define IFAbs              117
#define IFBindArguments    118
#define IFBool             119
#define IFCall             120
#define IFChar             121
#define IFDiv              122
#define IFDouble           123
#define IFEqual            124
#define IFExp              125
#define IFFirstValue       126
#define IFFinalValue       127
#define IFFloor            128
#define IFInt              129
#define IFIsError          130
#define IFLess             131
#define IFLessEqual        132
#define IFMax              133
#define IFMin              134
#define IFMinus            135
#define IFMod              136
#define IFNeg              137
#define IFNoOp             138
#define IFNot              139
#define IFNotEqual         140
#define IFPlus             141
#define IFRangeGenerate    142
#define IFRBuild           143
#define IFRElements        144
#define IFRReplace         145
#define IFRedLeft          146
#define IFRedRight         147
#define IFRedTree          148
#define IFReduce           149
#define IFRestValues       150
#define IFSingle           151
#define IFTimes            152
#define IFTrunc            153
#define IFReplaceMulti     160         /* IF1 Version 1.1                     */

#define IFAAddLAT              170         /* IF2 Version 1.1                 */
#define IFAAddHAT              171
#define IFABufPartition        172
#define IFABuildAT             173
#define IFABufScatter          174
#define IFACatenateAT          175
#define IFAElementAT           176
#define IFAExtractAT           177
#define IFAFillAT              178
#define IFAGatherAT            179
#define IFARemHAT              180
#define IFARemLAT              181
#define IFAReplaceAT           182
#define IFArrayToBuf           183
#define IFASetLAT              184
#define IFDefArrayBuf          185
#define IFDefRecordBuf         186
#define IFFinalValueAT         187
#define IFMemAlloc             188
#define IFBufElements          189
#define IFRBuildAT             190
#define IFRecordToBuf          191
#define IFRElementsAT          192
#define IFReduceAT             193
#define IFShiftBuffer          194

#define IFScatterBufPartitions 195        /* NEW AT-NODES NOT IN IF2 MANUAL  */
#define IFRedLeftAT            196
#define IFRedRightAT           197
#define IFRedTreeAT            198

#define IFPeek                 314

#define IFSGraph               1000    /* IF1 GRAPH NODE TYPES (NONSTANDARD)  */
#define IFLGraph               1001
#define IFIGraph               1002
#define IFXGraph               1003

#define IFUndefined            9999

#define IF1SimpleNodes         55                              /* NODE COUNTS */
#define IF1CompoundNodes       7
#define IF1GraphNodes          4
#define IF2AtNodes             29

#define IsUndefined(x) ( (x)->type == IFUndefined )

#define IsOther(x)     ( (x)->type >= IFPeek && (x)->type <= IFPeek )
#define IsSimple(x)    ( (((x)->type >= IFAAddH)&&((x)->type < IFAAddLAT)) || \
			  ((x)->type == IFPeek ) )

#define IsAtNode(x)    ( ((x)->type >= IFAAddLAT) && ((x)->type <= IFRedTreeAT))
#define IsGraph(x)     ( ((x)->type >= IFSGraph)  && ((x)->type <= IFXGraph) )
#define IsABuildAT(x)  ( (x)->type == IFABuildAT )
#define IsAFillAT(x)   ( (x)->type == IFAFillAT  )
#define IsIGraph(x)    ( (x)->type == IFIGraph )
#define IsSGraph(x)    ( (x)->type == IFSGraph )
#define IsXGraph(x)    ( (x)->type == IFXGraph )
#define IsSelect(x)    ( (x)->type == IFSelect )
#define IsCompound(x)  ( (x)->type <  IFAAddH  )
#define IsNoOp(x)      ( (x)->type == IFNoOp )
#define IsMemAlloc(x)  ( (x)->type == IFMemAlloc )
#define IsForall(x)    ( (x)->type == IFForall )
#define IsPlus(x)      ( (x)->type == IFPlus   )
#define IsMax(x)       ( (x)->type == IFMax    )
#define IsLoopA(x)     ( (x)->type == IFLoopA  )
#define IsLoopB(x)     ( (x)->type == IFLoopB  )
#define IsALimL(x)     ( (x)->type == IFALimL  )
#define IsABuild(x)    ( (x)->type == IFABuild )
#define IsNot(x)       ( (x)->type == IFNot  )
#define IsCall(x)      ( (x)->type == IFCall )
#define IsMinus(x)     ( (x)->type == IFMinus )
#define IsNeg(x)       ( (x)->type == IFNeg )
#define IsASize(x)     ( (x)->type == IFASize )
#define IsASetL(x)     ( (x)->type == IFASetL )
#define IsAGather(x)   ( (x)->type == IFAGather )
#define IsAScatter(x)  ( (x)->type == IFAScatter )
#define IsAElement(x)  ( (x)->type == IFAElement )
#define IsRElements(x) ( (x)->type == IFRElements )
#define IsTagCase(x)   ( (x)->type == IFTagCase )
#define IsRBuild(x)    ( (x)->type == IFRBuild )
#define IsLoop(x)      ( ((x)->type == IFLoopA) || ((x)->type == IFLoopB) )

#define IsFinalValue(x)   ((x)->type == IFFinalValue  )
#define IsFinalValueAT(x) ((x)->type == IFFinalValueAT)
#define IsDefArrayBuf(x)  ((x)->type == IFDefArrayBuf )

#define REDUCE_SUM        'S'      /* FIRST CHARACTER OF REDUCTION FUNCTIONS  */
#define REDUCE_PRODUCT    'P'
#define REDUCE_LEAST      'L'
#define REDUCE_GREATEST   'G'
#define REDUCE_CATENATE   'C'

#define IF_ARRAY          0            /* IF SYMBOL TABLE TYPES               */
#define IF_BASIC          1
#define IF_FIELD          2
#define IF_FUNCTION       3
#define IF_MULTPLE        4
#define IF_RECORD         5
#define IF_STREAM         6
#define IF_TAG            7
#define IF_TUPLE          8
#define IF_UNION          9
#define IF_UNKNOWN        10
#define IF_BUFFER         11

#define BASIC_TYPE_START  12
#define IF_BOOL           0 + BASIC_TYPE_START
#define IF_CHAR           1 + BASIC_TYPE_START
#define IF_DOUBLE         2 + BASIC_TYPE_START
#define IF_INTEGER        3 + BASIC_TYPE_START
#define IF_NULL           4 + BASIC_TYPE_START
#define IF_REAL           5 + BASIC_TYPE_START
#define IF_NONTYPE        6 + BASIC_TYPE_START

#define IsBasic(x)          ( (x)->type >= BASIC_TYPE_START )
#define IsMultiple(x)       ( (x)->type == IF_MULTPLE )
#define IsBoolean(x)        ( (x)->type == IF_BOOL  )
#define IsArray(x)          ( (x)->type == IF_ARRAY )
#define IsStream(x)         ( (x)->type == IF_STREAM )
#define IsInteger(x)        ( (x)->type == IF_INTEGER )
#define IsReal(x)           ( (x)->type == IF_REAL    )
#define IsDouble(x)         ( (x)->type == IF_DOUBLE  )
#define IsUnion(x)          ( (x)->type == IF_UNION )

#define IsArithmetic(x)     ( ((x)->type == IF_INTEGER) ||    \
			      ((x)->type == IF_DOUBLE)  ||    \
			      ((x)->type == IF_REAL)     )

#define ERROR_CONSTANT    "error"
#define GRAPH_LABEL       0
#define CONST_PORT        -1

#define DFORDERED         'D'          /* LLNL STAMPS                         */
#define IF1CHECK          'C'
#define FRONTEND          'F'
#define OFFSETS           'O'
#define LOOPINVARS        'L'
#define COMMONSUBS        'C'
#define CONSTANT          'G'

#define IF1OPTIMIZED      'I'          /* CSU STAMPS                          */
#define MONOLITH          'M'
#define NORMALIZED        'N'
#define BUILDINPLACE      'B'
#define UPDATEINPLACE     'U'
#define UNIVSTROWNER      'S'


#define NOMARK             0                         /* THE MARK IS DISABLED  */
#define RMARK              1                         /* THE R MARK IS ENABLED */
#define rMARK              2                         /* THE r MARK IS ENABLED */

#define PRAGMAS unsigned pmark   : 1;  /* %mk=PRrODLMCNBW */                  \
                unsigned rmark1  : 2;                                         \
		unsigned omark1  : 1;                                         \
		unsigned rmark2  : 2;                                         \
		unsigned omark2  : 1;                                         \
		unsigned dmark   : 1;                                         \
		unsigned lmark   : 1;                                         \
		unsigned emark   : 1;                                         \
		unsigned imark   : 1;                                         \
		unsigned cmark   : 1;                                         \
		unsigned fmark   : 1;                                         \
		unsigned nmark   : 1;                                         \
		unsigned bmark   : 1;                                         \
		unsigned wmark   : 1;                                         \
		unsigned umark   : 1;                                         \
		unsigned smark   : 1;                                         \
                                                                              \
		unsigned rstable : 1;  /* ARE THE R AND O MARKS STABLE?   */  \
		unsigned ostable : 1;                                         \
                                                                              \
		short    sr;           /* PRODUCER REFERENCE COUNT VALUES */  \
		short    pm;                                                  \
		short    pl;                                                  \
                                                                              \
		short    cm;           /* CONSUMER REFERENCE COUNT VALUE  */  \
                                                                              \
		double   ccost;        /* CALCULATED EXECUTION COST       */  \
		char     mark;                                                \
                                                                              \
		char     *name;        /* %na=source_data_name            */  \
		char     *file;        /* %fn=source_file_name            */  \
		char     *funct;       /* %sf=source_function_name        */  \
		int       line         /* %sl=source_line_number          */

#define InitPragmas(x)   (x)->pmark   = FALSE;     (x)->rmark1  = NOMARK;     \
                         (x)->omark1  = FALSE;     (x)->rmark2  = NOMARK;     \
                         (x)->omark2  = FALSE;     (x)->dmark   = FALSE;      \
                         (x)->lmark   = FALSE;     (x)->emark   = FALSE;      \
                         (x)->cmark   = FALSE;     (x)->nmark   = FALSE;      \
			 (x)->fmark   = FALSE;     (x)->imark   = FALSE;      \
                         (x)->bmark   = FALSE;     (x)->rstable = TRUE;       \
                         (x)->ostable = TRUE;      (x)->wmark   = FALSE;      \
                         (x)->umark   = FALSE;                                \
                         (x)->name    = NULL;      (x)->file    = NULL;       \
                         (x)->funct   = NULL;      (x)->line    = 0;          \
			 (x)->sr      = -2;        (x)->pm      = -2;         \
			 (x)->pl      = -2;        (x)->cm      = 0;          \
			 (x)->mark    = ' ';                                  \
			 (x)->smark   = FALSE;     (x)->ccost   = 0.0

#define AssignPragmas(x) (x)->pmark   = pragmas.pmark;                        \
                         (x)->rmark1  = pragmas.rmark1;                       \
                         (x)->omark1  = pragmas.omark1;                       \
                         (x)->rmark2  = pragmas.rmark2;                       \
                         (x)->omark2  = pragmas.omark2;                       \
                         (x)->dmark   = pragmas.dmark;                        \
                         (x)->lmark   = pragmas.lmark;                        \
                         (x)->emark   = pragmas.emark;                        \
                         (x)->imark   = pragmas.imark;                        \
                         (x)->mark    = pragmas.mark;                         \
                         (x)->cmark   = pragmas.cmark;                        \
                         (x)->fmark   = pragmas.fmark;                        \
                         (x)->nmark   = pragmas.nmark;                        \
                         (x)->bmark   = pragmas.bmark;                        \
			 (x)->wmark   = pragmas.wmark;                        \
			 (x)->umark   = pragmas.umark;                        \
                         (x)->rstable = pragmas.rstable;                      \
                         (x)->ostable = pragmas.ostable;                      \
                         (x)->name    = pragmas.name;                         \
                         (x)->line    = pragmas.line;                         \
			 (x)->sr      = pragmas.sr;                           \
			 (x)->pm      = pragmas.pm;                           \
			 (x)->pl      = pragmas.pl;                           \
			 (x)->cm      = pragmas.cm;                           \
			 (x)->smark   = pragmas.smark;                        \
			 (x)->ccost   = pragmas.ccost;                        \
			 if ( pragmas.file != NULL )                          \
			     (x)->file = pragmas.file;                        \
			 else                                                 \
			     (x)->file = sfile;                               \
			 if ( pragmas.funct != NULL )                         \
			     (x)->funct = pragmas.funct;                      \
			 else if ( cfunct == NULL )                           \
			     (x)->funct = "?";                                \
                         else                                                 \
			     (x)->funct = cfunct->G_NAME

#define CopyPragmas(y,x) (x)->pmark   = (y)->pmark;                           \
                         (x)->rmark1  = (y)->rmark1;                          \
                         (x)->omark1  = (y)->omark1;                          \
                         (x)->rmark2  = (y)->rmark2;                          \
                         (x)->omark2  = (y)->omark2;                          \
                         (x)->dmark   = (y)->dmark;                           \
                         (x)->lmark   = (y)->lmark;                           \
                         (x)->emark   = (y)->emark;                           \
                         (x)->imark   = (y)->imark;                           \
                         (x)->mark    = (y)->mark;                            \
                         (x)->cmark   = (y)->cmark;                           \
                         (x)->fmark   = (y)->fmark;                           \
                         (x)->nmark   = (y)->nmark;                           \
                         (x)->bmark   = (y)->bmark;                           \
			 (x)->wmark   = (y)->wmark;                           \
			 (x)->umark   = (y)->umark;                           \
                         (x)->rstable = (y)->rstable;                         \
                         (x)->ostable = (y)->ostable;                         \
                         (x)->smark   = (y)->smark;                           \
			 (x)->sr      = (y)->sr;                              \
			 (x)->pm      = (y)->pm;                              \
			 (x)->pl      = (y)->pl;                              \
			 (x)->cm      = (y)->cm;                              \
                         (x)->name    = (y)->name;                            \
                         (x)->file    = (y)->file;                            \
                         (x)->funct   = (y)->funct;                           \
                         (x)->ccost   = (y)->ccost;                           \
                         (x)->line    = (y)->line



typedef struct node       NODE,  *PNODE, **PPNODE;
typedef struct edge       EDGE,  *PEDGE;
typedef struct ade        ADE,   *PADE;
typedef struct info       INFO,  *PINFO;
typedef struct alist      ALIST, *PALIST;
typedef struct prags      PRAGS;
typedef struct call       CALL,  *PCALL;
typedef struct set        SET,   *PSET;

#define WHITE             0

#define IsEmptySet(x)     ( (x)->last < 0 )
#define SET_INC           2

struct set {
    int   last;                 /* INDEX OF LAST SET ENTRY                */
    PEDGE *set;                 /* SET CONTENTS                           */
    int   ssize;                /* CURRENT SET SIZE                       */
    PEDGE gen;                  /* EXPORT OF SET ORIGIN (IF A GENERATOR!) */
    PNODE graph;                /* GRAPH NODE DEFINING CURRENT SCOPE EXIT */
    PSET  ssucc;                /* NEXT SET IN GLOBAL READ/WRITE SET LIST */
    };

struct call {
    PCALL    caller;                             /* CALLEE REFERENCE LIST */
    PCALL    callee;        /* REFERENCED CALLEE OR NEXT GRAPH TRUNK NODE */

    PNODE    graph;                             /* IF1 GRAPH OR CALL NODE */
    int      color;                             /* CYCLE DETECTION COLOR  */
    int      checked;                     /* ALREADY EXAMINED FOR CYCLES? */
    };

struct prags {
    PRAGMAS;
    };

#define BOUND 2
#define HIGH  1
#define LOW   0

struct ade {
    int   if1line;                     /* LINE NUMBER OF INFO IN IF1 FILE     */

    PNODE dst;                         /* DESTINATION NODE                    */
    PNODE src;                         /* SOURCE NODE                         */

    PADE  ipred;                       /* ADE IMPORT PREDECESSOR              */
    PADE  isucc;                       /* ADE IMPORT SUCCESSOR                */
    PADE  epred;                       /* ADE EXPORT PREDECESSOR              */
    PADE  esucc;                       /* ADE EXPORT SUCCESSOR                */

    int   priority;                    /* ADE REMOVAL PRIORITY                */
    };


#define AppendToUtilityList( h, t, n )  if ( (h) == NULL ) (h) = (n);      \
                                        else (t)->usucc = (n); (t) = (n)

struct node {
    int    if1line;                    /* LINE NUMBER OF NODE IN IF1 FILE     */

    int    type;                       /* IF NODE TYPE                        */
    int    label;                      /* UNIQUE (IN SCOPE) NODE IDENTIFIER   */

    PEDGE  exp;                        /* EXPORTED (GENERATED) VALUES         */
    PEDGE  imp;                        /* IMPORTED (ARGUMENT)  VALUES         */

    PADE   aexp;                       /* EXPORTED ADES                       */
    PADE   aimp;                       /* IMPORTED ADES                       */

    PNODE  gpred;                      /* DOUBLE LINK LIST POINTERS (2 SETS)  */
    PNODE  gsucc;                      /* n FOR NODE LIST, g FOR GRAPH LIST   */
    PNODE  npred;
    PNODE  nsucc;

    PNODE  usucc;                      /* UTILITY NODE LIST NODE SUCCESSOR    */

    unsigned checked  : 1;           /* HAS THIS NODE BEEN CHECKED DURING     */
				     /* CYCLE DETECTION?                      */

    unsigned visited  : 1;           /* HAS THIS FUNCTION BEEN VISITED DURING */
    unsigned sorted   : 1;           /* MARK PROPAGATION, AND IS IT IN THE    */
                                     /* SORTED FUNCTION LIST?                 */

    unsigned executed : 1;           /* HAS THE NODE BEEN EXECUTED?           */

    PRAGMAS;

    int     color;                   /* EXPRESSION NODE'S JERSEY COLOR        */

    PINFO   info;                    /* UTILITY FIELDS                        */
    char   *gname;
    PALIST  alst;
    int     scnt;
    };

#define G_DAD   npred                  /* POINTER FROM SUBGRPAPH TO CMP NODE  */
#define G_NODES nsucc                  /* NODES OF GRAPH                      */
#define G_INFO  info                   /* FUNCTION GRAPH ARGUMENT TYPE INFO   */
#define G_NAME  gname                  /* FUNCTION GRAPH NAME                 */
#define G_TAGS  alst                   /* SUBGRAPH TAG LIST                   */

#define C_SUBS  gsucc                  /* SUBGRAPHS OF COMPOUND NODE          */
#define C_SCNT  scnt                   /* # OF SUBGRAPHS IN COMPOUND NODE     */
#define C_ALST  alst                   /* ASSOCIATION LIST OF COMPOUND NODE   */

#define L_INIT  gsucc     /* LOOPA AND LOOPB SUBGRAPH POSITIONS IN GRAPH LIST */
#define L_TEST  gsucc->gsucc                
#define L_BODY  gsucc->gsucc->gsucc         
#define L_RET   gsucc->gsucc->gsucc->gsucc  

#define F_GEN   gsucc              /* FORALL SUBGRAPH POSITIONS IN GRAPH LIST */
#define F_BODY  gsucc->gsucc
#define F_RET   gsucc->gsucc->gsucc

#define S_TEST  gsucc              /* SELECT SUBGRAPH POSITIONS IN GRAPH LIST */
#define S_ALT   gsucc->gsucc
#define S_CONS  gsucc->gsucc->gsucc


struct edge {
    int    if1line;                    /* LINE NUMBER OF EDGE IN IF1 FILE     */

    int   iport;                       /* IMPORT PORT IDENTIFIER              */
    int   eport;                       /* EXPORT PORT IDENTIFIER              */

    PNODE dst;                         /* DESTINATION NODE                    */
    PNODE src;                         /* SOURCE NODE                         */

    PRAGMAS;

    PEDGE ipred;                       /* IMPORT PREDECESSOR                  */
    PEDGE isucc;                       /* IMPORT SUCCESSOR                    */
    PEDGE epred;                       /* EXPORT PREDECESSOR                  */
    PEDGE esucc;                       /* EXPORT SUCCESSOR                    */
    PEDGE usucc;                       /* UTILITY EDGE LIST EDGE SUCCESSOR    */

    PSET  grset;                       /* GLOBAL READ SET                     */
    PSET  gwset;                       /* GLOBAL WRITE SET                    */

    PSET  lrset;                       /* LOCAL READ SET                      */
    PSET  lwset;                       /* LOCAL WRITE SET                     */

    char  *CoNsT;                      /* CONSTANT STRING (IF SRC IS NULL)    */
    PINFO  info;                       /* DATA VALUE TYPE                     */
    };


struct info {
    int    if1line;                    /* LINE NUMBER OF INFO IN IF1 FILE     */

    int   type;                        /* IF SYMBOL TABLE TYPE                */
    int   label;                       /* UNIQUE SYMBOL IDENTIFIER            */

    PRAGMAS;

    PINFO info1;                       /* UTILITY POINTERS                    */
    PINFO info2;

    PINFO next;                        /* NEXT TYPE IN SYMBOL TABLE           */
    };

#define A_ELEM      info1              /* ARRAY-STREAM-MULTIPLE SUBCOMPONENT  */
#define R_FIRST     info1              /* FIRST RECORD-UNION MEMBER           */
#define F_IN        info1              /* FUNCTION IMPORT TYPES               */
#define F_OUT       info2              /* FUNCTION EXPORT TYPES               */
#define L_NEXT      info1              /* NEXT LIST ENTRY                     */
#define L_SUB       info2              /* LIST COMPONENT TYPE                 */


struct alist {
    int    datum;                      /* INTEGER LIST DATUM                  */
    PALIST next;                       /* NEXT DATUM                          */
    };


#define IsNodeListEmpty(x) ( (x)->G_NODES == NULL )
#define IsOneExport(x)     ( (x)->exp->esucc == NULL )

#define IsImport(x,y)      ( FindImport((x),(y)) != NULL )
#define IsExport(x,y)      ( FindExport((x),(y)) != NULL )

#define IsConst(x)         ( ((x)->src == NULL) && ((x)->eport == CONST_PORT) )
#define IsNonErrorConst(x) ( IsConst(x) && ((x)->CoNsT != NULL) )

#define Max(a,b)           (((a) > (b)) ? (a) : (b))
#define SetSize(x)         ((x)->last + 1)
