#include "world.h"


char *cnames[] = {                                     /* COMPOUND NODE NAMES */
    "For", "If", "TagC", "LoopA", "LoopB", "IfTE", "Iter" 
    };

char *snames[] = {                                       /* SIMPLE NODE NAMES */
    "AAddH", "AAddL", "AAdj",  "ABld",  "ACat",  "AElm",  "AFill",
    "AGath", "AEpty", "ALimH", "ALimL", "ARemH", "ARemL", "ARepl",
    "AScat", "ASetL", "ASize", "Abs",   "BindA", "Bool",  "Call",
    "Char",  "Div",   "Dbl",   "Equal", "Exp",   "FstV",  "FnlV",
    "Floor", "Int",   "IsErr", "Less",  "LessE", "Max",   "Min",
    "Minus", "Mod",   "Neg",   "NoOp",  "Not",   "NotE",  "Plus",
    "RgGen", "RBld",  "RElm",  "RRepl", "RedL",  "RedR",  "RedT",
    "Red",   "RestV", "Sngle", "Times", "Trunc", "ReplM"
    };

char *atnames[] = {                                       /* IF2 ATNODE NAMES */
    "AddLAT", "AddHAT",  "BPart",  "BldAT",  "BScat",  "CatAT",  "ElmAT",
    "AdjAT",  "FillAT",  "GathAT", "RemHAT", "RemLAT", "ReplAT", "AToB",
    "SetAT",  "DefAB",   "DefRB",  "FnlVAT", "MAlloc", "BElm",   "RBldAT",
    "RToB",   "RElmAT",  "RedAT",  "ShiftB", "SBpart", "RedLAT", "RedRAT",
    "RedTAT"
    };

char *gnames[] = {                                        /* GRAPH NODE NAMES */
    "SGrph", "LGrph", "IGrph", "XGrph"
    };


/**************************************************************************/
/* GLOBAL **************        GetNodeName        ************************/
/**************************************************************************/
/* PURPOSE: RETURN THE SYMBOLIC NAME OF NODE n.                           */
/**************************************************************************/

char *GetNodeName( n )
PNODE n;
{
    if ( IsCompound( n ) )
	return( cnames[ n->type - IFForall ] );
    else if ( IsSimple( n ) )
	return( snames[ n->type - IFAAddH ] );
    else if ( IsAtNode( n ) )
	return( atnames[ n->type - IFAAddLAT ] );
    else
        return( gnames[ n->type - IFSGraph ] );
}
