#include "world.h"


static char *rfun[] = {                                  /* READ ROUTINES */
    "Compiler_Error", "Compiler_Error", "Compiler_Error", "Compiler_Error",
    "Compiler_Error", "Compiler_Error", "Compiler_Error", "Compiler_Error",
    "Compiler_Error", "Compiler_Error", "Unknown_Error",  "Compiler_Error",
    "ReadBool",       "ReadChar",       "ReadDbl",        "ReadInt",
    "ReadNil",        "ReadFlt",        "CompilerError",  "CompilerError"
    };

static char *wfun[] = {                                 /* WRITE ROUTINES */
    "Compiler_Error", "Compiler_Error", "Compiler_Error", "Compiler_Error",
    "Compiler_Error", "Compiler_Error", "Compiler_Error", "Compiler_Error",
    "Compiler_Error", "Compiler_Error", "Compiler_Error", "Compiler_Error",
    "WriteBool",      "WriteChar",      "WriteDbl",       "WriteInt",
    "WriteNil",       "WriteFlt",       "Compiler_Error", "Compiler_Error"
    };


/**************************************************************************/
/* LOCAL  **************      PrintReadRoutine     ************************/
/**************************************************************************/
/* PURPOSE: PRINT READ ROUTINE FOR i TO output.                           */
/**************************************************************************/

static void PrintReadRoutine( i )
PINFO i;
{
  extern void PrintReadOp();

  fprintf( output, "\nstatic %s %s()\n", i->tname, i->rname );
  fprintf( output, "{\n" );

  if ( IsBasic( i ) && !IsBRecord( i ) )
    fprintf( output, "  register %s val0;\n", i->tname ); 
  else
    fprintf( output, "  %s val0;\n", i->tname ); 

  PrintReadOp( 2, "val0", i );

  fprintf( output, "  return( val0 );\n" );
  fprintf( output, "}\n" );
}


/**************************************************************************/
/* LOCAL  **************      PrintWriteRoutine    ************************/
/**************************************************************************/
/* PURPOSE: PRINT WRITE ROUTINE FOR i TO output.                          */
/**************************************************************************/

static void PrintWriteRoutine( i )
PINFO i;
{
  extern void PrintWriteOp();

  fprintf( output, "\nstatic void %s( val )\n", i->wname );
  fprintf( output, "%s val;\n", i->tname );
  fprintf( output, "{\n" );

  PrintWriteOp( 2, "val", i );

  fprintf( output, "}\n" );
}


/**************************************************************************/
/* LOCAL  **************      PrintWriteUnion      ************************/
/**************************************************************************/
/* PURPOSE: PRINT UNION u'S WRITE ROUTINE TO output.                      */
/**************************************************************************/

static void PrintWriteUnion( indent, src, u )
int    indent;
char  *src;
PINFO  u;
{
  register PINFO i;
  register int   c;
	   char  buf[100];
  extern void PrintWriteOp();

  PrintIndentation( indent );
  fprintf( output, "{\n" );

  PrintIndentation( indent+2 );
  fprintf( output, "register %s *un%d = (%s*) %s;\n", 
	   u->sname, indent, u->sname, src         );

  PrintIndentation( indent+2 );
  fprintf( output, "fprintf( FibreOutFd, \" %%d:\\n\", un%d->Tag);\n", indent );

  PrintIndentation( indent+2 );
  fprintf( output, "switch ( un%d->Tag ) {\n", indent );

  for ( c = 0, i = u->R_FIRST; i != NULL; i = i->L_NEXT, c++ ) {
    sprintf( buf, "(un%d->Data.Fld%d)", indent, c );

    PrintIndentation( indent+4 );
    fprintf( output, "case %d:\n", c );

    /* WAS THE ROUTINE PRINTED? */
    if ( i->L_SUB->touch1 || i->L_SUB->touch2 ) {
      PrintIndentation( indent+6 );
      fprintf( output, "%s( %s );\n", i->L_SUB->wname, buf );
      }
    else
      PrintWriteOp( indent+6, buf, i->L_SUB );

    PrintIndentation( indent+6 );
    fprintf( output, "break;\n" );
    }

  PrintIndentation( indent+4 );
  fprintf( output, "}\n" );

  PrintIndentation( indent );
  fprintf( output, "}\n" );
}


/**************************************************************************/
/* LOCAL  **************     PrintWriteArray       ************************/
/**************************************************************************/
/* PURPOSE: PRINT ARRAY i'S WRITE ROUTINE TO output.                      */
/**************************************************************************/

static void PrintWriteArray( indent, src, i )
int    indent;
char  *src;
PINFO  i;
{
  char buf[100];
  extern void PrintWriteOp();

  PrintIndentation( indent );
  fprintf( output, "{\n" );

  PrintIndentation( indent );
  fprintf( output, "  register POINTER Base%d;\n", indent );

  PrintIndentation( indent );
  fprintf( output, "  register int     HiBound;\n" );

  PrintIndentation( indent );
  fprintf( output, "  register int     Lo%d;\n", indent );

  PrintIndentation( indent );
  fprintf( output, "  register ARRAYP arr = (ARRAYP) %s;\n", src );

  PrintIndentation( indent );
  fprintf( output, "  PrintIndent;\n" );

  PrintIndentation( indent );
  fprintf( output, "Lo%d = arr->LoBound;\n", indent );

  PrintIndentation( indent );
  fprintf( output, 
     "  fprintf( FibreOutFd, \"[ %%d,%%d:\", Lo%d, Lo%d+(arr->Size)-1 );\n", 
     indent, indent );

/* PRINT REFERENCE COUNTS FOR DEBUG */
PrintIndentation( indent );
fprintf( output, "  fprintf( FibreOutFd, \" # DRC=%%d PRC=%%d\\n\", arr->RefCount, arr->Phys->RefCount );\n" );


  PrintIndentation( indent );
  fprintf( output, "  Indent++;\n" );

  PrintIndentation( indent );
  fprintf( output, "  Base%d = arr->Base;\n", indent );

  PrintIndentation( indent );
  fprintf( output, "  HiBound = Lo%d + arr->Size - 1;\n", indent );
  
  sprintf( buf, "(((%s*)Base%d)[Lo%d])", i->A_ELEM->tname, indent, indent );

  PrintIndentation( indent );
  fprintf( output, "  for ( /* NOTHING */; Lo%d <= HiBound; Lo%d++ ) {\n", 
	   indent, indent                                               );

  /* WAS THE ROUTINE PRINTED? */
  if ( i->A_ELEM->touch1 || i->A_ELEM->touch2 ) {
    PrintIndentation( indent+4 );
    fprintf( output, "%s( %s );\n", i->A_ELEM->wname, buf );
    }
  else
    PrintWriteOp( indent+4, buf, i->A_ELEM );

  PrintIndentation( indent );
  fprintf( output, "    }\n" );

  PrintIndentation( indent );
  fprintf( output, "  Indent--;\n" );

  PrintIndentation( indent );
  fprintf( output, "  PrintIndent;\n" );

  PrintIndentation( indent );

  fprintf( output, "  fprintf( FibreOutFd, \"]\\n\" );\n" );

  PrintIndentation( indent );
  fprintf( output, "}\n" );
}


/**************************************************************************/
/* LOCAL  **************     PrintWriteRecord      ************************/
/**************************************************************************/
/* PURPOSE: PRINT RECORD r's WRITE ROUTINE TO output. NOTE, r MAY BE A    */
/*          BRECORD.                                                      */
/**************************************************************************/

static void PrintWriteRecord( indent, src, r )
int    indent;
char  *src;
PINFO  r;
{
  register PINFO i;
  register int   c;
	   char  buf[100];
  extern void PrintWriteOp();

  PrintIndentation( indent );
  fprintf( output, "{\n" );

  PrintIndentation( indent+2 );
  if ( IsBRecord( r ) )
    fprintf( output, "register %s *rec%d = (%s*) &(%s);\n", 
	     r->sname, indent, r->sname, src             );
  else
    fprintf( output, "register %s *rec%d = (%s*) %s;\n", 
	     r->sname, indent, r->sname, src          );

  for ( c = 1, i = r->R_FIRST; i != NULL; i = i->L_NEXT, c++ ) {
    sprintf( buf, "(rec%d->Fld%d)", indent, c );

    /* WAS THE ROUTINE PRINTED? */
    if ( i->L_SUB->touch1 || i->L_SUB->touch2 ) {
      PrintIndentation( indent+2 );
      fprintf( output, "%s( %s );\n", i->L_SUB->wname, buf );
      }
    else
      PrintWriteOp( indent+2, buf, i->L_SUB );
    }

  PrintIndentation( indent );
  fprintf( output, "}\n" );
}


/**************************************************************************/
/* LOCAL  **************       PrintReadUnion      ************************/
/**************************************************************************/
/* PURPOSE: PRINT UNION u's READ ROUTINE TO output.                       */
/**************************************************************************/

static void PrintReadUnion( indent, dst, u )
int    indent;
char  *dst;
PINFO  u;
{
  register PINFO i;
  register int   c;
	   char  buf[100];
  extern void PrintReadOp();

  PrintIndentation( indent );
  fprintf( output, "{\n" );

  PrintIndentation( indent+2 );
  fprintf( output, "register %s un%d;\n", u->tname, indent );

  PrintIndentation( indent+2 );
  fprintf( output, "UBld( un%d, %s, 1, FibreInt );\n", indent, u->sname );

  PrintIndentation( indent+2 );
  fprintf( output, "switch ( FibreInt ) {\n" );

  for ( c = 0, i = u->R_FIRST; i != NULL; i = i->L_NEXT, c++ ) {
    PrintIndentation( indent+4 );
    fprintf( output, "case %d:\n", c );
    sprintf( buf, "((%s*)un%d)->Data.Fld%d", u->sname, indent, c );

    /* WAS THE ROUTINE PRINTED? */
    if ( i->L_SUB->touch1 || i->L_SUB->touch2 ) {
      PrintIndentation( indent+6 );
      fprintf( output, "%s = %s();\n", buf, i->L_SUB->rname );
      }
    else
      PrintReadOp( indent+6, buf, i->L_SUB );

    PrintIndentation( indent+6 );
    fprintf( output, "break;\n" );
    }

  PrintIndentation( indent+4 );
  fprintf( output, "default:\n" );

  PrintIndentation( indent+6 );
  fprintf( output, "Error( \"FIBRE\", \"ILLEGAL UNION TAG\" );\n" );

  PrintIndentation( indent+4 );
  fprintf( output, "}\n" );

  PrintIndentation( indent+2 );
  fprintf( output, "%s = un%d;\n", dst, indent );

  PrintIndentation( indent );
  fprintf( output, "}\n" );
}


/**************************************************************************/
/* LOCAL  **************      PrintReadRecord      ************************/
/**************************************************************************/
/* PURPOSE: PRINT RECORD r's READ ROUTINE TO output. NOTE, r MAY BE A     */
/*          BASIC RECORD.                                                 */
/**************************************************************************/

static void PrintReadRecord( indent, dst, r )
int    indent;
char  *dst;
PINFO  r;
{
  register PINFO i;
  register int   c;
	   char  buf[100];
  extern void PrintReadOp();

  PrintIndentation( indent );
  fprintf( output, "{\n" );

  PrintIndentation( indent+2 );
  fprintf( output, "%s rec%d;\n", r->tname, indent );

  if ( !IsBRecord( r ) ) {
    PrintIndentation( indent+2 );
    fprintf( output, "RBld( rec%d, %s, 1 );\n", indent, r->sname );
    }

  for ( c = 1, i = r->R_FIRST; i != NULL; i = i->L_NEXT, c++ ) {
    if ( IsBRecord( r ) )
      sprintf( buf, "rec%d.Fld%d", indent, c );
    else
      sprintf( buf, "((%s*)rec%d)->Fld%d", r->sname, indent, c );

    /* WAS THE ROUTINE PRINTED? */
    if ( i->L_SUB->touch1 || i->L_SUB->touch2 ) {
      PrintIndentation( indent+2 );
      fprintf( output, "%s = %s();\n", buf, i->L_SUB->rname );
      }
    else
      PrintReadOp( indent+2, buf, i->L_SUB );
    }

  PrintIndentation( indent+2 );
  fprintf( output, "%s = rec%d;\n", dst, indent );

  PrintIndentation( indent );
  fprintf( output, "}\n" );
}


static void PrintGetArray( indent, dst, del, i )
int    indent;
char  *dst;
char  *del;
PINFO  i;
{
  char buf[100];
  extern void PrintReadOp();

  PrintIndentation( indent );
  fprintf( output, "{\n" );

  PrintIndentation( indent );
  if ( IsBasic( i->A_ELEM ) && !IsBRecord( i->A_ELEM ) )
    fprintf( output, "  register %s val%d;\n", i->A_ELEM->tname, indent );
  else
    fprintf( output, "  %s val%d;\n", i->A_ELEM->tname, indent );

  PrintIndentation( indent );
  fprintf( output, "  FibreParse( INT_ );\n" );

  PrintIndentation( indent );
  fprintf( output, "{\n" );
  PrintIndentation( indent );
  fprintf( output, "register int lob;\n" );
  PrintIndentation( indent );
  fprintf( output, "lob = FibreInt;\n" );
  PrintIndentation( indent );
  fprintf( output, "GET_LOOKAHEAD;\n" );
  PrintIndentation( indent );
  fprintf( output, "if ( LookAheadToken == COMMA_ ) {\n" );
  PrintIndentation( indent );
  fprintf( output, "  FibreParse( COMMA_ );\n" );
  PrintIndentation( indent );
  fprintf( output, "  FibreParse( INT_ );\n" );

  PrintIndentation( indent );
  fprintf( output, "  OptABld( %s, lob, 1, FibreInt, %s );\n", dst, 
	   i->A_ELEM->tname );

  /* 12/12/91 CANN OptABld SETS Phys->Size TO THE ALLOCATED SIZE */
  /*               SO CLEAR IT, ALLOWING AGather TO INCREMENT IT */
  PrintIndentation( indent );
  fprintf( output,   "  ((ARRAYP)%s)->Phys->Size = 0;\n", dst ); 

  PrintIndentation( indent );
  fprintf( output, "} else {\n" );
  PrintIndentation( indent );
  fprintf( output, "  ABld( %s, lob, 1 );\n", dst );
  PrintIndentation( indent );
  fprintf( output, " }\n" );
  PrintIndentation( indent );
  fprintf( output, "FibreParse( COLON_ );\n" );
  PrintIndentation( indent );
  fprintf( output, "}\n" );

  PrintIndentation( indent );
  fprintf( output, "  GET_LOOKAHEAD;\n" );

  PrintIndentation( indent );
  fprintf( output, "  while ( LookAheadToken != %s ) {\n", del );

  PrintIndentation( indent );
  fprintf( output, "    if ( LookAheadToken == SEMI_COLON_ )\n" );

  PrintIndentation( indent );
  fprintf( output, 
    "      Error( \"FIBRE\", \"REPETITION FACILITY NOT IMPLEMENTED\" );\n" );

  sprintf( buf, "val%d", indent );

  /* WAS THE ROUTINE PRINTED? */
  if ( i->A_ELEM->touch1 || i->A_ELEM->touch2 ) {
    PrintIndentation( indent+4 );
    fprintf( output, "%s = %s();\n", buf, i->A_ELEM->rname );
    }
  else
    PrintReadOp( indent+4, buf, i->A_ELEM );

  PrintIndentation( indent );
  fprintf( output,  "    AGather( %s, %s, %s );\n",
	   dst, buf, i->A_ELEM->tname                );
 
  PrintIndentation( indent );
  fprintf( output, "    GET_LOOKAHEAD;\n" );

  PrintIndentation( indent );
  fprintf( output, "    }\n" );

  PrintIndentation( indent );
  fprintf( output, "}\n" );
}


static void PrintGetString( indent, dst, i )
int    indent;
char  *dst;
PINFO  i;
{
  PrintIndentation( indent );
  fprintf( output, "ABld( %s, 1, 1 );\n", dst );

  PrintIndentation( indent );
  fprintf( output, "while ( FibreParse( ANY_ ) != STRING_TERM_ ) {\n" );

  PrintIndentation( indent );
  fprintf( output, "  AGather( %s, FibreChar, char );\n", dst );

  PrintIndentation( indent );
  fprintf( output, "  }\n" );
}


/**************************************************************************/
/* LOCAL  **************       PrintWriteOp        ************************/
/**************************************************************************/
/* PURPOSE: PRINT WRITE OPERATION FOR i TO output.                        */
/**************************************************************************/

static void PrintWriteOp( indent, src, i )
int    indent;
char  *src;
PINFO  i;
{
  switch ( i->type ) {
    case IF_UNION:
      PrintIndentation( indent );
      fprintf( output, "PrintIndent;\n" );

      PrintIndentation( indent );
      fprintf( output, "fprintf( FibreOutFd, \"(\" );\n" );

      PrintIndentation( indent );
      fprintf( output, "Indent++;\n" );

      PrintWriteUnion( indent, src, i );

      PrintIndentation( indent );
      fprintf( output, "Indent--;\n" );

      PrintIndentation( indent );
      fprintf( output, "PrintIndent;\n" );
      PrintIndentation( indent );

      fprintf( output, "fprintf( FibreOutFd, \")\\n\" );\n" );
      break;

    case IF_BRECORD:
    case IF_RECORD:
      PrintIndentation( indent );
      fprintf( output, "PrintIndent;\n" );

      PrintIndentation( indent );

      if ( IsBRecord( i ) )
        fprintf( output, "fprintf( FibreOutFd, \"<\\n\" );\n" );
      else
        fprintf( output, "fprintf( FibreOutFd, \"< # PRC=%%d\\n\", ((%s *)%s)->RefCount );\n", i->sname, src );

      PrintIndentation( indent );
      fprintf( output, "Indent++;\n" );

      PrintWriteRecord( indent, src, i );

      PrintIndentation( indent );
      fprintf( output, "Indent--;\n" );

      PrintIndentation( indent );
      fprintf( output, "PrintIndent;\n" );
      PrintIndentation( indent );

      fprintf( output, "fprintf( FibreOutFd, \">\\n\" );\n" );
      break;

    case IF_ARRAY:
      PrintWriteArray( indent, src, i );
      break;

    default:
      PrintIndentation( indent );
      fprintf( output, "%s( %s );\n", wfun[i->type], src );
      break;
    }
}


/**************************************************************************/
/* LOCAL  **************       PrintReadOp         ************************/
/**************************************************************************/
/* PURPOSE: PRINT READ OPERATION FOR i TO output.                         */
/**************************************************************************/

static void PrintReadOp( indent, dst, i )
int    indent;
char  *dst;
PINFO  i;
{
  char buf[100];

  switch ( i->type ) {
    case IF_UNION:
      PrintIndentation( indent );
      fprintf( output, "FibreParse( UNIONB_ ); FibreParse( INT_ );\n" );
      PrintIndentation( indent );
      fprintf( output, "FibreParse( COLON_ );\n" );

      PrintReadUnion( indent, dst, i );

      PrintIndentation( indent );
      fprintf( output, "FibreParse( UNIONE_ );\n" );
      break;

    case IF_BRECORD:
    case IF_RECORD:
      PrintIndentation( indent );
      fprintf( output, "FibreParse( RECORDB_ );\n" );

      PrintReadRecord( indent, dst, i );

      PrintIndentation( indent );
      fprintf( output, "FibreParse( RECORDE_ );\n" );
      break;

    case IF_ARRAY:
      PrintIndentation( indent );
      fprintf( output, "switch ( FibreParse( ANY_ ) ) {\n" );

      PrintIndentation( indent );
      fprintf( output, "  case ARRAYB_:\n" );

      PrintGetArray( indent+4, dst, "ARRAYE_", i );

      PrintIndentation( indent );
      fprintf( output, "    break;\n" );

      PrintIndentation( indent );
      fprintf( output, "  case STRING_START_:\n" );

      if ( i->A_ELEM->type == IF_CHAR )
        PrintGetString( indent+4, dst, i );
      else {
        PrintIndentation( indent );
        fprintf( output,
	 "    Error( \"FIBRE\", \"STRING DELIMITER WAS NOT EXPECTED\" );\n" );
        }

      PrintIndentation( indent );
      fprintf( output, "    break;\n" );

      PrintIndentation( indent );
      fprintf( output, "  default:\n" );

      PrintIndentation( indent );
      fprintf( output, 
	       "    Error( \"FIBRE\", \"ARRAY DELIMITER EXPECTED\" );\n" );

      PrintIndentation( indent );
      fprintf( output, "  }\n" );
      break;

    default:
      PrintIndentation( indent );
      fprintf( output, "%s( %s );\n", rfun[i->type], dst );
      break;
    }
}


/**************************************************************************/
/* LOCAL  **************   PrintReadFibreInputs    ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE FIBRE INPUT ROUTINES FOR FUNCTION f TO output. MOST */
/*          OF THE ROUTINES ARE INLINED.  ALL UNIONS ARE ASSUMED TO BE    */
/*          RECURSIVE.                                                    */
/**************************************************************************/

void PrintReadFibreInputs( f )
PNODE f;
{
  register PINFO i;
  register PINFO mi;
  register int   c;
	   char  buf[100];

  fprintf( output, "\n#undef GatherCopyInfo\n" );

  mi = f->info;

  ClearTouchFlags();

  /* DUMP OUTERMOST FIBRE AGGREAGATE READ ROUTINES */
  for ( i = mi->F_IN; i != NULL; i = i->L_NEXT ) {
    if ( i->L_SUB->rname == NULL || i->L_SUB->touch1 )
      continue;

    TouchTheUnions( i->L_SUB );   /* UNIONS CAN BE RECURSIVE */
    PrintReadRoutine( i->L_SUB );

    i->L_SUB->touch1 = TRUE;
    }

  /* DUMP THE TOUCHED UNION READ ROUTINES: UNIONS CAN BE RECURSIVE!!! */
  for ( i = ihead; i != NULL; i = i->next ) {
    if ( !(i->touch2) )
      continue;

    if ( i->touch1 )
      continue;

    PrintReadRoutine( i );
    }

  /* DUMP THE INPUT DRIVER */
  fprintf( output, "\n%s ReadFibreInputs()\n", mi->tname );
  fprintf( output, "{\n" );
  fprintf( output, "  register %s *args = ", mi->sname );
  fprintf( output, "(%s*) Alloc( sizeof( %s ) );\n", mi->sname, mi->sname );

  for ( c = 1, i = mi->F_IN; i != NULL; i = i->L_NEXT, c++ ) {
    sprintf( buf, "args->In%d", c );

    if ( i->L_SUB->touch1 )
      fprintf( output, "  %s = %s();\n", buf, i->L_SUB->rname );
    else
      PrintReadOp( 2, buf, i->L_SUB );
    }

  fprintf( output, "  return( (%s) args );\n}\n", mi->tname );

  ClearTouchFlags();

  fprintf( output, "\n#ifdef CInfo" );
  fprintf( output, "\n#define GatherCopyInfo 1" );
  fprintf( output, "\n#endif\n" );
}


/**************************************************************************/
/* LOCAL  **************  PrintWriteFibreOutputs   ************************/
/**************************************************************************/
/* PURPOSE: PRINT THE FIBRE OUTPUT ROUTINES FOR FUNCTION f TO output.     */
/*          MOST OF THE ROUTINES ARE INLINED. ALL UNIONS ARE ASSUMED TO   */
/*          BE RECURSIVE.                                                 */
/**************************************************************************/

void PrintWriteFibreOutputs( f )
PNODE f;
{
  register PINFO i;
  register PINFO mi;
  register int   c;
	   char  buf[100];


  ClearTouchFlags(); /* 1-3 */

  if ( f == NULL ) goto MoveOn1;

  mi = f->info;

  /* DUMP OUTERMOST FIBRE WRITE ROUTINES */
  for ( i = mi->F_OUT; i != NULL; i = i->L_NEXT ) {
    if ( i->L_SUB->rname == NULL || i->L_SUB->touch1 )
      continue;

    TouchTheUnions( i->L_SUB );    /* UNIONS CAN BE RECURSIVE */
    PrintWriteRoutine( i->L_SUB );

    i->L_SUB->touch1 = TRUE;
    }

MoveOn1:

  /* PROCESS PEEK ROUTINES!!! */
  for ( i = ihead; i != NULL; i = i->next ) {
    if ( i->rname == NULL || i->touch1 )
      continue;

    /* RECURSIVE UNION: ALREADY TOUCHED */
    if ( i->touch2 )
      continue;

    if ( !(i->touch6) )
      continue;

    TouchTheUnions( i );    /* UNIONS CAN BE RECURSIVE */
    PrintWriteRoutine( i );

    i->touch1 = TRUE;
    }

  /* DUMP THE TOUCHED UNION WRITE ROUTINES: UNIONS CAN BE RECURSIVE!!! */
  for ( i = ihead; i != NULL; i = i->next ) {
    if ( !(i->touch2) )
      continue;

    if ( i->touch1 )
      continue;

    PrintWriteRoutine( i );
    }

  if ( f == NULL ) goto MoveOn2;

  /* DUMP THE OUTPUT DRIVER */
  fprintf( output, "\nvoid WriteFibreOutputs( args )\n" );
  fprintf( output, "%s args;\n{\n", mi->tname );
  fprintf( output, "  register %s *p = (%s*) args;\n", mi->sname, mi->sname );

  for ( c = 1, i = mi->F_OUT; i != NULL; i = i->L_NEXT, c++ ) {
    sprintf( buf, "(p->Out%d)", c );

    if ( i->L_SUB->touch1 )
      fprintf( output, "  %s( %s );\n", i->L_SUB->wname, buf );
    else
      PrintWriteOp( 2, buf, i->L_SUB );
    }

  fprintf( output, "}\n" );

MoveOn2:

  ClearTouchFlags();
}


/**************************************************************************/
/* GLOBAL **************          PrintPeek        ************************/
/**************************************************************************/
/* PURPOSE: PRINT PEEK NODE n TO OUTPUT.                                  */
/**************************************************************************/

void PrintPeek( indent, n )
int   indent;
PNODE n;
{
  register PEDGE i;

  fprintf( output, "{\n" );

  fprintf( output, "  FILE *tmpfd;\n" );
  fprintf( output, "  SLockParent;\n" );
  fprintf( output, "  tmpfd = FibreOutFd;\n" );
  fprintf( output, "  FibreOutFd = stderr;\n" );

  fprintf( output, 
	   "  fprintf( FibreOutFd, \"\\n# ****** BEGIN PEEK ******\\n\" );\n");

  for ( i = n->imp; i != NULL; i = i->isucc ) {
    fprintf( output, "  fprintf( FibreOutFd, \"# *** %s\\n\" );\n", 
	     (i->name == NULL)? "unknown" : i->name              );

    if ( i->info->rname == NULL ) {
      fprintf( output, "  %s( ", wfun[i->info->type] );
      PrintTemp( i );
      fprintf( output, " );\n" );
      continue;
      }

    fprintf( output, "  %s( ", i->info->wname );
    PrintTemp( i );
    fprintf( output, " );\n" );

    i->info->touch6 = TRUE;
    }

  if ( n->exp != NULL ) {
    fprintf( output, "  " );
    PrintTemp( n->exp );
    fprintf( output, " = 1; " );
    }

  fprintf( output, 
	   "  fprintf( FibreOutFd, \"# ******  END PEEK  ******\\n\" );\n");

  fprintf( output, "  FibreOutFd = tmpfd;\n" );
  fprintf( output, "  SUnlockParent;\n" );

  fprintf( output, "}\n" );

  PrintConsumerModifiers( indent, n );
}
